/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import android.util.Patterns;
import com.netacom.base.chat.R;
import com.netacom.base.chat.android_utils.StringUtils;
import com.netacom.base.chat.type.ValidationResult;
import com.netacom.base.chat.type.ValidationType;
import java.util.Locale;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/netacom/base/chat/util/ValidationUtil;", "", "()V", "Companion", "netacom-base-chat_NetAloProdRelease"})
public final class ValidationUtil {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    @NotNull
    public static final String getMessageRes(@NotNull ValidationType validationType, @NotNull ValidationResult validation) {
        return Companion.getMessageRes(validationType, validation);
    }

    @JvmStatic
    public static final boolean isValid(@NotNull ValidationResult result) {
        return Companion.isValid(result);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateEmail(@Nullable String email) {
        return Companion.validateEmail(email);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateOrg(@Nullable String org) {
        return Companion.validateOrg(org);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateName(@Nullable String name) {
        return Companion.validateName(name);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateUserName(@Nullable String name) {
        return Companion.validateUserName(name);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validatePhone(@Nullable String phone) {
        return Companion.validatePhone(phone);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validatePassword(@Nullable String password) {
        return Companion.validatePassword(password);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validatePasswordNormal(@Nullable String password) {
        return Companion.validatePasswordNormal(password);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateConfirmPassword(@Nullable String password, @Nullable String confirmPassword) {
        return Companion.validateConfirmPassword(password, confirmPassword);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateOTP(@Nullable String otp) {
        return Companion.validateOTP(otp);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateIMEI(@Nullable String imei) {
        return Companion.validateIMEI(imei);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validateIdCardNumber(@Nullable String id) {
        return Companion.validateIdCardNumber(id);
    }

    @JvmStatic
    @NotNull
    public static final ValidationResult validatePassport(@Nullable String passport) {
        return Companion.validatePassport(passport);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0018\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\bH\u0007J\u0010\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u0004H\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u001c\u0010\u0011\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0014\u001a\u00020\b2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u0018\u001a\u00020\b2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001a\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001c\u001a\u00020\b2\b\u0010\u001d\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\u001e\u001a\u00020\b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010 \u001a\u00020\b2\b\u0010!\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010\"\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010#\u001a\u00020\b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010$\u001a\u00020\b2\b\u0010%\u001a\u0004\u0018\u00010\u0004H\u0007J\u0012\u0010&\u001a\u00020\b2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006'"}, d2={"Lcom/netacom/base/chat/util/ValidationUtil$Companion;", "", "()V", "getMessageRes", "", "validationType", "Lcom/netacom/base/chat/type/ValidationType;", "validation", "Lcom/netacom/base/chat/type/ValidationResult;", "isValid", "", "result", "isValidIMEI", "imeiStr", "sumDig", "", "num", "validateConfirmPassword", "password", "confirmPassword", "validateEmail", "email", "validateIMEI", "imei", "validateIdCardNumber", "id", "validateName", "name", "validateOTP", "otp", "validateOrg", "org", "validatePassport", "passport", "validatePassword", "validatePasswordNormal", "validatePhone", "phone", "validateUserName", "netacom-base-chat_NetAloProdRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final String getMessageRes(@NotNull ValidationType validationType, @NotNull ValidationResult validation) {
            int n;
            Intrinsics.checkNotNullParameter((Object)((Object)validationType), (String)"validationType");
            Intrinsics.checkNotNullParameter((Object)((Object)validation), (String)"validation");
            block0 : switch (WhenMappings.$EnumSwitchMapping$0[validationType.ordinal()]) {
                case 1: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_email_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_email_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_email_wrong_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_email_existed_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_email_email_not_exist_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 2: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_phone_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_phone_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_phone_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_phone_not_exist_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_phone_existed_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 3: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_name_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_name_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_name_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_name_not_exist_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_name_existed_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 4: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_name_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_name_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_name_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_name_not_exist_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_name_existed_msg;
                            break block0;
                        }
                        case 7: {
                            n = R.string.validate_name_invalid_length_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 5: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_code_invalid_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_code_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_code_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_code_not_exist_msg;
                            break block0;
                        }
                        case 5: {
                            n = R.string.validate_code_existed_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 6: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_confirm_password_empty_msg;
                            break block0;
                        }
                        case 8: {
                            n = R.string.validate_confirm_password_not_match_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 7: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_password_invalid_format_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_password_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_password_wrong_msg;
                            break block0;
                        }
                        case 7: {
                            n = R.string.validate_password_invalid_length_msg;
                            break block0;
                        }
                        case 9: {
                            n = R.string.validate_password_invalid_digit_msg;
                            break block0;
                        }
                        case 10: {
                            n = R.string.validate_password_invalid_special_character_msg;
                            break block0;
                        }
                        case 11: {
                            n = R.string.validate_password_invalid_lower_case_msg;
                            break block0;
                        }
                        case 12: {
                            n = R.string.validate_password_invalid_upper_case_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 8: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_imei_invalid_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_imei_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_imei_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_imei_not_exist_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 9: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_id_card_invalid_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_id_card_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_id_card_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_id_card_not_exist_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 10: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 2: {
                            n = R.string.validate_passport_invalid_msg;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_passport_empty_msg;
                            break block0;
                        }
                        case 4: {
                            n = R.string.validate_passport_wrong_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_passport_not_exist_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                case 11: {
                    switch (WhenMappings.$EnumSwitchMapping$1[validation.ordinal()]) {
                        case 1: {
                            n = R.string.validate_valid;
                            break block0;
                        }
                        case 3: {
                            n = R.string.validate_confirm_org_empty_msg;
                            break block0;
                        }
                        case 6: {
                            n = R.string.validate_confirm_org_wrong_msg;
                            break block0;
                        }
                    }
                    n = R.string.validate_valid;
                    break;
                }
                default: {
                    n = R.string.validate_valid;
                }
            }
            return StringUtils.INSTANCE.getString(n);
        }

        @JvmStatic
        public final boolean isValid(@NotNull ValidationResult result) {
            Intrinsics.checkNotNullParameter((Object)((Object)result), (String)"result");
            return result == ValidationResult.VALID;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateEmail(@Nullable String email) {
            CharSequence charSequence = email;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (Patterns.EMAIL_ADDRESS.matcher(email).matches() ? ValidationResult.VALID : ValidationResult.INVALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateOrg(@Nullable String org) {
            CharSequence charSequence = org;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : ValidationResult.VALID;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateName(@Nullable String name) {
            CharSequence charSequence = name;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (!Pattern.matches("^[\\p{L} .'-]+$", name) ? ValidationResult.INVALID : ValidationResult.VALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateUserName(@Nullable String name) {
            CharSequence charSequence = name;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (name.length() < 3 ? ValidationResult.INVALID_LENGTH : (Pattern.matches("[a-zA-Z0-9_]+", name) ? ValidationResult.VALID : ValidationResult.INVALID));
        }

        /*
         * Enabled aggressive block sorting
         */
        @JvmStatic
        @NotNull
        public final ValidationResult validatePhone(@Nullable String phone) {
            ValidationResult validationResult;
            CharSequence charSequence = phone;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                validationResult = ValidationResult.EMPTY;
                return validationResult;
            }
            if (Patterns.PHONE.matcher(phone).matches()) {
                int n = phone.length();
                boolean bl = 8 <= n ? n < 16 : false;
                if (bl) {
                    validationResult = ValidationResult.VALID;
                    return validationResult;
                }
            }
            validationResult = ValidationResult.INVALID;
            return validationResult;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validatePassword(@Nullable String password) {
            ValidationResult validationResult;
            CharSequence charSequence = password;
            if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
                validationResult = ValidationResult.EMPTY;
            } else if (password.length() < 6) {
                validationResult = ValidationResult.INVALID_LENGTH;
            } else {
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                String string2 = password.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(locale)");
                if (Intrinsics.areEqual((Object)password, (Object)string2)) {
                    validationResult = ValidationResult.MISSING_UPPER_CASE_CHARACTER;
                } else {
                    locale = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                    string2 = password.toUpperCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
                    validationResult = Intrinsics.areEqual((Object)password, (Object)string2) ? ValidationResult.MISSING_LOWER_CASE_CHARACTER : (!Pattern.compile(".*\\d+.*").matcher(password).matches() ? ValidationResult.MISSING_DIGIT : ValidationResult.VALID);
                }
            }
            return validationResult;
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validatePasswordNormal(@Nullable String password) {
            CharSequence charSequence = password;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (password.length() < 6 ? ValidationResult.INVALID_LENGTH : ValidationResult.VALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateConfirmPassword(@Nullable String password, @Nullable String confirmPassword) {
            CharSequence charSequence = confirmPassword;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (Intrinsics.areEqual((Object)confirmPassword, (Object)password) ? ValidationResult.VALID : ValidationResult.NOT_MATCH);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateOTP(@Nullable String otp) {
            CharSequence charSequence = otp;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (otp.length() == 6 && new Regex("\\d+").matches(charSequence = (CharSequence)otp) ? ValidationResult.VALID : ValidationResult.INVALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateIMEI(@Nullable String imei) {
            CharSequence charSequence = imei;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (imei.length() > 20 ? ValidationResult.INVALID_LENGTH : ValidationResult.VALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validateIdCardNumber(@Nullable String id) {
            CharSequence charSequence = id;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : ((id.length() == 9 || id.length() == 12) && new Regex("\\d+").matches(charSequence = (CharSequence)id) ? ValidationResult.VALID : ValidationResult.INVALID);
        }

        @JvmStatic
        @NotNull
        public final ValidationResult validatePassport(@Nullable String passport) {
            CharSequence charSequence = passport;
            return charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? ValidationResult.EMPTY : (passport.length() < 6 || passport.length() > 20 ? ValidationResult.INVALID : (!new Regex("[a-zA-Z0-9]+").matches(charSequence = (CharSequence)passport) ? ValidationResult.INVALID : ValidationResult.VALID));
        }

        private final boolean isValidIMEI(String imeiStr) {
            if (!Pattern.compile("\\d+").matcher(imeiStr).matches() || imeiStr.length() != 15) {
                return false;
            }
            long imeiNumber = Long.parseLong(imeiStr);
            int d = 0;
            int sum = 0;
            int n = 15;
            do {
                int i = n--;
                d = (int)(imeiNumber % (long)10);
                if (i % 2 == 0) {
                    d *= 2;
                }
                sum += this.sumDig(d);
                imeiNumber /= (long)10;
            } while (1 <= n);
            return sum % 10 == 0 && sum != 0;
        }

        private final int sumDig(int num) {
            int a = 0;
            for (int n = num; n > 0; n /= 10) {
                a += n % 10;
            }
            return a;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;
            public static final /* synthetic */ int[] $EnumSwitchMapping$1;

            static {
                int[] nArray = new int[ValidationType.values().length];
                nArray[ValidationType.EMAIL.ordinal()] = 1;
                nArray[ValidationType.PHONE_NUMBER.ordinal()] = 2;
                nArray[ValidationType.FULL_NAME.ordinal()] = 3;
                nArray[ValidationType.USER_NAME.ordinal()] = 4;
                nArray[ValidationType.OTP.ordinal()] = 5;
                nArray[ValidationType.CONFIRM_PASSWORD.ordinal()] = 6;
                nArray[ValidationType.PASSWORD.ordinal()] = 7;
                nArray[ValidationType.IMEI.ordinal()] = 8;
                nArray[ValidationType.ID_CARD_NUMBER.ordinal()] = 9;
                nArray[ValidationType.PASSPORT_NUMBER.ordinal()] = 10;
                nArray[ValidationType.ORGANIZATION_CODE.ordinal()] = 11;
                $EnumSwitchMapping$0 = nArray;
                nArray = new int[ValidationResult.values().length];
                nArray[ValidationResult.VALID.ordinal()] = 1;
                nArray[ValidationResult.INVALID.ordinal()] = 2;
                nArray[ValidationResult.EMPTY.ordinal()] = 3;
                nArray[ValidationResult.WRONG.ordinal()] = 4;
                nArray[ValidationResult.EXISTED.ordinal()] = 5;
                nArray[ValidationResult.NOT_EXIST.ordinal()] = 6;
                nArray[ValidationResult.INVALID_LENGTH.ordinal()] = 7;
                nArray[ValidationResult.NOT_MATCH.ordinal()] = 8;
                nArray[ValidationResult.MISSING_DIGIT.ordinal()] = 9;
                nArray[ValidationResult.MISSING_SPECIAL_CHARACTER.ordinal()] = 10;
                nArray[ValidationResult.MISSING_LOWER_CASE_CHARACTER.ordinal()] = 11;
                nArray[ValidationResult.MISSING_UPPER_CASE_CHARACTER.ordinal()] = 12;
                $EnumSwitchMapping$1 = nArray;
            }
        }
    }
}

