/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.content.Context;
import android.os.Build;
import android.os.Environment;
import android.os.storage.StorageManager;
import android.os.storage.StorageVolume;
import android.text.format.Formatter;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.android_utils.UtilsBridge;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class SDCardUtils {
    private SDCardUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static boolean isSDCardEnableByEnvironment() {
        return "mounted".equals(Environment.getExternalStorageState());
    }

    public static String getSDCardPathByEnvironment() {
        if (SDCardUtils.isSDCardEnableByEnvironment()) {
            return Environment.getExternalStorageDirectory().getAbsolutePath();
        }
        return "";
    }

    public static List<SDCardInfo> getSDCardInfo() {
        ArrayList<SDCardInfo> paths = new ArrayList<SDCardInfo>();
        StorageManager sm = (StorageManager)Utils.getApp().getSystemService("storage");
        if (sm == null) {
            return paths;
        }
        if (Build.VERSION.SDK_INT >= 24) {
            List storageVolumes = sm.getStorageVolumes();
            try {
                Method getPathMethod = StorageVolume.class.getMethod("getPath", new Class[0]);
                for (StorageVolume storageVolume : storageVolumes) {
                    boolean isRemovable = storageVolume.isRemovable();
                    String state = storageVolume.getState();
                    String path = (String)getPathMethod.invoke((Object)storageVolume, new Object[0]);
                    paths.add(new SDCardInfo(path, state, isRemovable));
                }
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        } else {
            try {
                Class<?> storageVolumeClazz = Class.forName("android.os.storage.StorageVolume");
                Method getPathMethod = storageVolumeClazz.getMethod("getPath", new Class[0]);
                Method isRemovableMethod = storageVolumeClazz.getMethod("isRemovable", new Class[0]);
                Method getVolumeStateMethod = StorageManager.class.getMethod("getVolumeState", String.class);
                Method getVolumeListMethod = StorageManager.class.getMethod("getVolumeList", new Class[0]);
                Object result = getVolumeListMethod.invoke((Object)sm, new Object[0]);
                int length = Array.getLength(result);
                for (int i = 0; i < length; ++i) {
                    Object storageVolumeElement = Array.get(result, i);
                    String path = (String)getPathMethod.invoke(storageVolumeElement, new Object[0]);
                    boolean isRemovable = (Boolean)isRemovableMethod.invoke(storageVolumeElement, new Object[0]);
                    String state = (String)getVolumeStateMethod.invoke((Object)sm, path);
                    paths.add(new SDCardInfo(path, state, isRemovable));
                }
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        return paths;
    }

    public static List<String> getMountedSDCardPath() {
        ArrayList<String> path = new ArrayList<String>();
        List<SDCardInfo> sdCardInfo = SDCardUtils.getSDCardInfo();
        if (sdCardInfo == null || sdCardInfo.isEmpty()) {
            return path;
        }
        for (SDCardInfo cardInfo : sdCardInfo) {
            String state = cardInfo.state;
            if (state == null || !"mounted".equals(state.toLowerCase())) continue;
            path.add(cardInfo.path);
        }
        return path;
    }

    public static long getExternalTotalSize() {
        return UtilsBridge.getFsTotalSize(SDCardUtils.getSDCardPathByEnvironment());
    }

    public static long getExternalAvailableSize() {
        return UtilsBridge.getFsAvailableSize(SDCardUtils.getSDCardPathByEnvironment());
    }

    public static long getInternalTotalSize() {
        return UtilsBridge.getFsTotalSize(Environment.getDataDirectory().getAbsolutePath());
    }

    public static long getInternalAvailableSize() {
        return UtilsBridge.getFsAvailableSize(Environment.getDataDirectory().getAbsolutePath());
    }

    public static class SDCardInfo {
        private String path;
        private String state;
        private boolean isRemovable;
        private long totalSize;
        private long availableSize;

        SDCardInfo(String path, String state, boolean isRemovable) {
            this.path = path;
            this.state = state;
            this.isRemovable = isRemovable;
            this.totalSize = UtilsBridge.getFsTotalSize(path);
            this.availableSize = UtilsBridge.getFsAvailableSize(path);
        }

        public String getPath() {
            return this.path;
        }

        public String getState() {
            return this.state;
        }

        public boolean isRemovable() {
            return this.isRemovable;
        }

        public long getTotalSize() {
            return this.totalSize;
        }

        public long getAvailableSize() {
            return this.availableSize;
        }

        public String toString() {
            return "SDCardInfo {path = " + this.path + ", state = " + this.state + ", isRemovable = " + this.isRemovable + ", totalSize = " + Formatter.formatFileSize((Context)Utils.getApp(), (long)this.totalSize) + ", availableSize = " + Formatter.formatFileSize((Context)Utils.getApp(), (long)this.availableSize) + '}';
        }
    }
}

