/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.imageloader;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.view.ViewGroup;
import android.widget.ImageView;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.CircleCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.bumptech.glide.request.FutureTarget;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.target.ViewTarget;
import com.bumptech.glide.request.transition.Transition;
import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.jackandphantom.blurimage.BlurImage;
import com.netacom.base.chat.R;
import com.netacom.base.chat.android_utils.SizeUtils;
import com.netacom.base.chat.imageloader.CircleProgress;
import com.netacom.base.chat.imageloader.GlideApp;
import com.netacom.base.chat.imageloader.GlideRequest;
import com.netacom.base.chat.util.CoreUtilsKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, xi=48, d1={"\u0000P\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001aC\u0010\u0004\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u0001H\u00062\u0014\u0010\n\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0001\u0012\u0004\u0012\u00020\u00050\u000b2\b\b\u0002\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000e\u001a\u001f\u0010\u000f\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u0001H\u0006\u00a2\u0006\u0002\u0010\u0012\u001a[\u0010\u0013\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u0001H\u00062\b\b\u0002\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0010\b\u0002\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\u001b\u001a/\u0010\u0013\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006*\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u0001H\u00062\u0006\u0010\u001c\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\r\u00a2\u0006\u0002\u0010\u001e\u001a)\u0010\u001f\u001a\u00020\u0005\"\u0004\b\u0000\u0010\u0006*\u00020 2\b\u0010\u0011\u001a\u0004\u0018\u0001H\u00062\b\b\u0002\u0010!\u001a\u00020\u0019\u00a2\u0006\u0002\u0010\"\u00a8\u0006#"}, d2={"drawableToBitmap", "Landroid/graphics/Bitmap;", "drawable", "Landroid/graphics/drawable/Drawable;", "loadBitmapSync", "", "T", "context", "Landroid/content/Context;", "t", "callback", "Lkotlin/Function1;", "drawableError", "", "(Landroid/content/Context;Ljava/lang/Object;Lkotlin/jvm/functions/Function1;I)V", "loadAvatar", "Landroid/widget/ImageView;", "imgUrl", "(Landroid/widget/ImageView;Ljava/lang/Object;)V", "loadImage", "corner", "", "transformation", "Lcom/bumptech/glide/load/Transformation;", "allowFitCenter", "", "allowCenterCrop", "(Landroid/widget/ImageView;Ljava/lang/Object;ILjava/lang/Float;Lcom/bumptech/glide/load/Transformation;ZZ)V", "imgWidth", "imgHeight", "(Landroid/widget/ImageView;Ljava/lang/Object;II)V", "loadImageBackground", "Landroid/view/ViewGroup;", "isBlur", "(Landroid/view/ViewGroup;Ljava/lang/Object;Z)V", "netacom-base-chat_NetAloDevRelease"})
public final class ImageUtilsKt {
    public static final <T> void loadAvatar(@NotNull ImageView $this$loadAvatar, @Nullable T imgUrl) {
        block2: {
            ViewTarget viewTarget;
            Intrinsics.checkNotNullParameter((Object)$this$loadAvatar, (String)"<this>");
            T t = imgUrl;
            if (t == null) {
                viewTarget = null;
            } else {
                T t2 = t;
                boolean bl = false;
                boolean bl2 = false;
                T url = t2;
                boolean bl3 = false;
                GlideRequest glideRequest = GlideApp.with($this$loadAvatar.getContext()).load(url).centerInside();
                Transformation[] transformationArray = $this$loadAvatar.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)transformationArray, (String)"this.context");
                CircleProgress circleProgress = new CircleProgress((Context)transformationArray);
                transformationArray = new Transformation[]{(Transformation)new CircleCrop()};
                viewTarget = glideRequest.placeholder((Drawable)circleProgress).error(R.drawable.ic_avatar_default).diskCacheStrategy(DiskCacheStrategy.ALL).transform((Transformation<Bitmap>)((Transformation)new MultiTransformation(transformationArray))).into($this$loadAvatar);
            }
            ViewTarget viewTarget2 = viewTarget;
            if (viewTarget2 != null) break block2;
            $this$loadAvatar.setImageResource(R.drawable.ic_avatar_default);
        }
    }

    public static final <T> void loadImage(@NotNull ImageView $this$loadImage, @Nullable T imgUrl, int drawableError, @Nullable Float corner, @Nullable Transformation<Bitmap> transformation, boolean allowFitCenter, boolean allowCenterCrop) {
        Intrinsics.checkNotNullParameter((Object)$this$loadImage, (String)"<this>");
        T t = imgUrl;
        if (t != null) {
            int n;
            T t2 = t;
            boolean bl = false;
            boolean bl2 = false;
            T url = t2;
            boolean bl3 = false;
            RequestBuilder requestBuilder = GlideApp.with($this$loadImage.getContext()).load(url);
            Object object = $this$loadImage.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this.context");
            Object object2 = requestBuilder.placeholder((Drawable)new CircleProgress((Context)object)).error(drawableError).diskCacheStrategy(DiskCacheStrategy.ALL).thumbnail(0.1f);
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"with(this.context)\n            .load(url)\n            .placeholder(CircleProgress(this.context))\n            .error(drawableError)\n            .diskCacheStrategy(DiskCacheStrategy.ALL)\n            .thumbnail(0.1f)");
            RequestBuilder options = object2;
            object2 = corner;
            float f = object2 == null ? 0.0f : ((Float)object2).floatValue();
            if (f > 0.0f) {
                object = corner;
                object2 = new Transformation[]{(Transformation)new CenterCrop(), (Transformation)new RoundedCorners(object == null ? 1 : (n = (int)((Float)object).floatValue()))};
                options.transform((Transformation<Bitmap>)((Transformation)new MultiTransformation((Transformation[])object2)));
            }
            if (allowFitCenter && !allowCenterCrop) {
                options.fitCenter();
            }
            if (allowCenterCrop) {
                options.centerCrop();
            }
            if ((object2 = transformation) != null) {
                object = object2;
                n = 0;
                boolean bl4 = false;
                Object $this$loadImage_u24lambda_u2d2_u24lambda_u2d1 = object;
                boolean bl5 = false;
                options.transform((Transformation<Bitmap>)$this$loadImage_u24lambda_u2d2_u24lambda_u2d1);
            }
            options.into($this$loadImage);
        }
    }

    public static /* synthetic */ void loadImage$default(ImageView imageView, Object object, int n, Float f, Transformation transformation, boolean bl, boolean bl2, int n2, Object object2) {
        if ((n2 & 2) != 0) {
            n = R.drawable.ic_no_image;
        }
        if ((n2 & 4) != 0) {
            f = Float.valueOf(0.0f);
        }
        if ((n2 & 8) != 0) {
            transformation = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            bl2 = false;
        }
        ImageUtilsKt.loadImage(imageView, object, n, f, (Transformation<Bitmap>)transformation, bl, bl2);
    }

    public static final <T> void loadImage(@NotNull ImageView $this$loadImage, @Nullable T imgUrl, int imgWidth, int imgHeight) {
        Intrinsics.checkNotNullParameter((Object)$this$loadImage, (String)"<this>");
        if (imgUrl == null) {
            $this$loadImage.setImageResource(R.drawable.ic_no_image);
        } else {
            int size = imgWidth > imgHeight ? imgWidth : imgHeight;
            float scale = size >= 1200 ? 5.0f : (size >= 1000 ? 4.0f : (size >= 720 ? 3.0f : (size >= 500 ? 3.5f : (size >= 300 ? 2.0f : 1.0f))));
            int width = SizeUtils.dp2px((float)imgWidth / scale);
            int height = SizeUtils.dp2px((float)imgHeight / scale);
            Context context = $this$loadImage.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
            int screenWidth = CoreUtilsKt.getScreenWidth(context);
            if (width > screenWidth) {
                width = screenWidth - 200;
            } else if (width < screenWidth && width > screenWidth - 100) {
                width -= 100;
            }
            RequestBuilder requestBuilder = GlideApp.with($this$loadImage.getContext()).load(imgUrl);
            context = $this$loadImage.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
            requestBuilder.placeholder((Drawable)new CircleProgress(context)).error(R.drawable.ic_no_image).centerInside().override(width, height).diskCacheStrategy(DiskCacheStrategy.ALL).into($this$loadImage);
        }
    }

    public static final <T> void loadBitmapSync(@NotNull Context context, @Nullable T t, @NotNull Function1<? super Bitmap, Unit> callback2, int drawableError) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(callback2, (String)"callback");
        try {
            if (t != null) {
                FutureTarget futureTarget = GlideApp.with(context).asBitmap().load(t).centerInside().error(drawableError).submit(Integer.MIN_VALUE, Integer.MIN_VALUE);
                Intrinsics.checkNotNullExpressionValue((Object)futureTarget, (String)"with(context)\n                .asBitmap()\n                .load(t)\n                .centerInside()\n                .error(drawableError)\n                .submit(Target.SIZE_ORIGINAL, Target.SIZE_ORIGINAL)");
                FutureTarget futureTarget2 = futureTarget;
                callback2.invoke(futureTarget2.get());
                GlideApp.with(context).clear((Target)futureTarget2);
            } else {
                callback2.invoke(null);
            }
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            e.printStackTrace();
            callback2.invoke(null);
        }
    }

    public static /* synthetic */ void loadBitmapSync$default(Context context, Object object, Function1 function1, int n, int n2, Object object2) {
        if ((n2 & 8) != 0) {
            n = R.drawable.ic_no_image;
        }
        ImageUtilsKt.loadBitmapSync(context, object, (Function1<? super Bitmap, Unit>)function1, n);
    }

    public static final <T> void loadImageBackground(@NotNull ViewGroup $this$loadImageBackground, @Nullable T imgUrl, boolean isBlur) {
        Intrinsics.checkNotNullParameter((Object)$this$loadImageBackground, (String)"<this>");
        if (imgUrl == null) {
            $this$loadImageBackground.setBackgroundResource(R.drawable.ic_no_image);
        } else {
            RequestBuilder requestBuilder = GlideApp.with($this$loadImageBackground.getContext()).load(imgUrl);
            Context context = $this$loadImageBackground.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"this.context");
            GlideRequest glideRequest = requestBuilder.placeholder((Drawable)new CircleProgress(context)).error(R.drawable.ic_no_image);
            Intrinsics.checkNotNullExpressionValue(glideRequest, (String)"with(this.context)\n            .load(imgUrl)\n            .placeholder(CircleProgress(this.context))\n            .error(R.drawable.ic_no_image)");
            GlideRequest option = glideRequest;
            option.into((Target)new CustomTarget<Drawable>(isBlur, $this$loadImageBackground){
                final /* synthetic */ boolean $isBlur;
                final /* synthetic */ ViewGroup $this_loadImageBackground;
                {
                    this.$isBlur = $isBlur;
                    this.$this_loadImageBackground = $receiver;
                }

                public void onResourceReady(@NotNull Drawable resource, @Nullable Transition<? super Drawable> transition) {
                    Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
                    if (this.$isBlur) {
                        this.$this_loadImageBackground.post(new Runnable(this.$this_loadImageBackground, resource){
                            final /* synthetic */ ViewGroup $this_loadImageBackground;
                            final /* synthetic */ Drawable $resource;
                            {
                                this.$this_loadImageBackground = $receiver;
                                this.$resource = $resource;
                            }

                            public final void run() {
                                Bitmap bitmap = BlurImage.with((Context)this.$this_loadImageBackground.getContext()).load(ImageUtilsKt.access$drawableToBitmap(this.$resource)).intensity(20.0f).Async(false).getImageBlur();
                                this.$this_loadImageBackground.setBackground((Drawable)new BitmapDrawable(this.$this_loadImageBackground.getResources(), bitmap));
                            }
                        });
                    } else {
                        this.$this_loadImageBackground.setBackground(resource);
                    }
                }

                public void onLoadCleared(@Nullable Drawable placeholder) {
                }
            });
        }
    }

    public static /* synthetic */ void loadImageBackground$default(ViewGroup viewGroup, Object object, boolean bl, int n, Object object2) {
        if ((n & 2) != 0) {
            bl = true;
        }
        ImageUtilsKt.loadImageBackground(viewGroup, object, bl);
    }

    private static final Bitmap drawableToBitmap(Drawable drawable2) {
        Bitmap bitmap;
        Bitmap bitmap2;
        if (drawable2 instanceof BitmapDrawable && ((BitmapDrawable)drawable2).getBitmap() != null) {
            return ((BitmapDrawable)drawable2).getBitmap();
        }
        if (drawable2.getIntrinsicWidth() <= 0 || drawable2.getIntrinsicHeight() <= 0) {
            bitmap2 = Bitmap.createBitmap((int)1, (int)1, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n        Bitmap.createBitmap(1, 1, Bitmap.Config.ARGB_8888) // Single color bitmap will be created of 1x1 pixel\n    }");
            bitmap = bitmap2;
        } else {
            bitmap2 = Bitmap.createBitmap((int)drawable2.getIntrinsicWidth(), (int)drawable2.getIntrinsicHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Intrinsics.checkNotNullExpressionValue((Object)bitmap2, (String)"{\n        Bitmap.createBitmap(drawable.intrinsicWidth, drawable.intrinsicHeight, Bitmap.Config.ARGB_8888)\n    }");
            bitmap = bitmap2;
        }
        Bitmap bitmap3 = bitmap;
        Canvas canvas = new Canvas(bitmap3);
        drawable2.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
        drawable2.draw(canvas);
        return bitmap3;
    }

    public static final /* synthetic */ Bitmap access$drawableToBitmap(Drawable drawable2) {
        return ImageUtilsKt.drawableToBitmap(drawable2);
    }
}

