/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.android_utils;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.Build;
import android.os.LocaleList;
import android.text.TextUtils;
import android.util.Log;
import com.netacom.base.chat.android_utils.Utils;
import com.netacom.base.chat.android_utils.UtilsBridge;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lcom/netacom/base/chat/android_utils/LanguageUtils;", "", "()V", "Companion", "netacom-base-chat_NetAloDevRelease"})
public final class LanguageUtils {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String KEY_LOCALE = "KEY_LOCALE";
    @NotNull
    private static final String VALUE_FOLLOW_SYSTEM = "VALUE_FOLLOW_SYSTEM";

    private LanguageUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00072\b\b\u0002\u0010\u0012\u001a\u00020\u000bH\u0007J\u001a\u0010\u0013\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0012\u0010\u0014\u001a\u00020\u00102\b\b\u0002\u0010\u0012\u001a\u00020\u000bH\u0007J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0017J\b\u0010\u0018\u001a\u0004\u0018\u00010\u0007J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0006\u0010\u001c\u001a\u00020\u0004J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u0007J\u0010\u0010 \u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\u0004H\u0002J\u0018\u0010\"\u001a\u00020\u000b2\u0006\u0010#\u001a\u00020\u00072\u0006\u0010$\u001a\u00020\u0007H\u0002J\u0010\u0010%\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J*\u0010&\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00072\u0006\u0010(\u001a\u00020)2\u0010\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010+H\u0002J\u0010\u0010,\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010-\u001a\u00020\u00102\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0011\u001a\u00020\u0007H\u0003J\u0012\u0010.\u001a\u0004\u0018\u00010\u00042\u0006\u0010/\u001a\u00020\u0004H\u0002J\u0012\u00100\u001a\u0004\u0018\u00010\u00072\u0006\u0010/\u001a\u00020\u0004H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010\u00072\u0006\u0010/\u001a\u00020\u0004H\u0002J\"\u00102\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u00072\u0010\u0010*\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u000b\u0018\u00010+H\u0002J\u0018\u00103\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u00104\u001a\u00020\u0007H\u0002J\u0016\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\u0006\u00107\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u0011\u0010\r\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\t\u00a8\u00068"}, d2={"Lcom/netacom/base/chat/android_utils/LanguageUtils$Companion;", "", "()V", "KEY_LOCALE", "", "VALUE_FOLLOW_SYSTEM", "appContextLanguage", "Ljava/util/Locale;", "getAppContextLanguage", "()Ljava/util/Locale;", "isAppliedLanguage", "", "()Z", "systemLanguage", "getSystemLanguage", "applyLanguage", "", "locale", "isRelaunchApp", "applyLanguageReal", "applySystemLanguage", "attachBaseContext", "activity", "Landroid/app/Activity;", "getAppliedLanguage", "getContextLanguage", "context", "Landroid/content/Context;", "getLanguage", "getLocal", "configuration", "Landroid/content/res/Configuration;", "isRightFormatLocalStr", "localStr", "isSameLocale", "l0", "l1", "locale2String", "pollCheckAppContextLocal", "destLocale", "index", "", "consumer", "Lcom/netacom/base/chat/android_utils/Utils$Consumer;", "restart", "setLocal", "string2Language", "str", "string2Locale", "string2LocaleReal", "updateAppContextLanguage", "updateConfiguration", "destLocal", "updateLocale", "c", "languageToSwitchTo", "netacom-base-chat_NetAloDevRelease"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        public final void applySystemLanguage(boolean isRelaunchApp) {
            this.applyLanguageReal(null, isRelaunchApp);
        }

        public static /* synthetic */ void applySystemLanguage$default(Companion companion, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                bl = false;
            }
            companion.applySystemLanguage(bl);
        }

        @JvmOverloads
        public final void applyLanguage(@NotNull Locale locale, boolean isRelaunchApp) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            this.applyLanguageReal(locale, isRelaunchApp);
        }

        public static /* synthetic */ void applyLanguage$default(Companion companion, Locale locale, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            companion.applyLanguage(locale, bl);
        }

        private final void applyLanguageReal(Locale locale, boolean isRelaunchApp) {
            Locale locale2;
            if (locale == null) {
                UtilsBridge.INSTANCE.getSpUtils4Utils().put(LanguageUtils.KEY_LOCALE, LanguageUtils.VALUE_FOLLOW_SYSTEM, true);
            } else {
                UtilsBridge.INSTANCE.getSpUtils4Utils().put(LanguageUtils.KEY_LOCALE, this.locale2String(locale), true);
            }
            Locale locale3 = locale;
            if (locale3 == null) {
                Configuration configuration = Resources.getSystem().getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getSystem().configuration");
                locale2 = this.getLocal(configuration);
            } else {
                locale2 = locale3;
            }
            Locale destLocal = locale2;
            this.updateAppContextLanguage(destLocal, new Utils.Consumer<Boolean>(isRelaunchApp){
                final /* synthetic */ boolean $isRelaunchApp;
                {
                    this.$isRelaunchApp = $isRelaunchApp;
                }

                public final void accept(@Nullable Boolean success) {
                    if (Intrinsics.areEqual((Object)success, (Object)true)) {
                        com.netacom.base.chat.android_utils.LanguageUtils$Companion.access$restart(LanguageUtils.Companion, this.$isRelaunchApp);
                    } else {
                        UtilsBridge.INSTANCE.relaunchApp();
                    }
                }
            });
        }

        private final void restart(boolean isRelaunchApp) {
            if (isRelaunchApp) {
                UtilsBridge.INSTANCE.relaunchApp();
            } else {
                for (Activity activity : UtilsBridge.INSTANCE.getActivityList()) {
                    activity.recreate();
                }
            }
        }

        public final boolean isAppliedLanguage() {
            return this.getAppliedLanguage() != null;
        }

        public final boolean isAppliedLanguage(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            Locale locale2 = this.getAppliedLanguage();
            if (locale2 == null) {
                return false;
            }
            Locale appliedLocale = locale2;
            return this.isSameLocale(locale, appliedLocale);
        }

        @Nullable
        public final Locale getAppliedLanguage() {
            Locale locale;
            String spLocaleStr = UtilsBridge.INSTANCE.getSpUtils4Utils().getString(LanguageUtils.KEY_LOCALE);
            if (TextUtils.isEmpty((CharSequence)spLocaleStr) || Intrinsics.areEqual((Object)LanguageUtils.VALUE_FOLLOW_SYSTEM, (Object)spLocaleStr)) {
                locale = null;
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)spLocaleStr, (String)"spLocaleStr");
                locale = this.string2Locale(spLocaleStr);
            }
            return locale;
        }

        private final Locale getContextLanguage(Context context) {
            Configuration configuration = context.getResources().getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"context.resources.configuration");
            return this.getLocal(configuration);
        }

        @NotNull
        public final Locale getAppContextLanguage() {
            Application application = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApp()");
            return this.getContextLanguage((Context)application);
        }

        @NotNull
        public final Locale getSystemLanguage() {
            Configuration configuration = Resources.getSystem().getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getSystem().configuration");
            return this.getLocal(configuration);
        }

        private final void updateAppContextLanguage(Locale destLocale, Utils.Consumer<Boolean> consumer) {
            this.pollCheckAppContextLocal(destLocale, 0, consumer);
        }

        private final void pollCheckAppContextLocal(Locale destLocale, int index, Utils.Consumer<Boolean> consumer) {
            Resources appResources = Utils.getApp().getResources();
            Configuration appConfig = appResources.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)appConfig, (String)"appConfig");
            Locale appLocal = this.getLocal(appConfig);
            this.setLocal(appConfig, destLocale);
            Utils.getApp().getResources().updateConfiguration(appConfig, appResources.getDisplayMetrics());
            if (consumer == null) {
                return;
            }
            if (this.isSameLocale(appLocal, destLocale)) {
                consumer.accept(true);
            } else {
                if (index < 20) {
                    UtilsBridge.runOnUiThreadDelayed(new Runnable(destLocale, index, consumer){
                        final /* synthetic */ Locale $destLocale;
                        final /* synthetic */ int $index;
                        final /* synthetic */ Utils.Consumer<Boolean> $consumer;
                        {
                            this.$destLocale = $destLocale;
                            this.$index = $index;
                            this.$consumer = $consumer;
                        }

                        public final void run() {
                            com.netacom.base.chat.android_utils.LanguageUtils$Companion.access$pollCheckAppContextLocal(LanguageUtils.Companion, this.$destLocale, this.$index + 1, this.$consumer);
                        }
                    }, 16L);
                    return;
                }
                Log.e((String)"LanguageUtils", (String)"appLocal didn't update.");
                consumer.accept(false);
            }
        }

        public final void attachBaseContext(@NotNull Activity activity) {
            Locale destLocal;
            Locale locale;
            Configuration configuration;
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            String spLocale = UtilsBridge.INSTANCE.getSpUtils4Utils().getString(LanguageUtils.KEY_LOCALE);
            if (TextUtils.isEmpty((CharSequence)spLocale)) {
                return;
            }
            if (Intrinsics.areEqual((Object)LanguageUtils.VALUE_FOLLOW_SYSTEM, (Object)spLocale)) {
                configuration = Resources.getSystem().getConfiguration();
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getSystem().configuration");
                locale = this.getLocal(configuration);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)spLocale, (String)"spLocale");
                locale = destLocal = this.string2Locale(spLocale);
            }
            if (destLocal == null) {
                return;
            }
            this.updateConfiguration((Context)activity, destLocal);
            configuration = Utils.getApp();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"getApp()");
            this.updateConfiguration((Context)configuration, destLocal);
        }

        private final void updateConfiguration(Context context, Locale destLocal) {
            Resources resources = context.getResources();
            Configuration config = resources.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)config, (String)"config");
            this.setLocal(config, destLocal);
            resources.updateConfiguration(config, resources.getDisplayMetrics());
        }

        private final String locale2String(Locale locale) {
            String localLanguage = locale.getLanguage();
            String localCountry = locale.getCountry();
            return localLanguage + '$' + localCountry;
        }

        private final Locale string2Locale(String str) {
            Locale locale = this.string2LocaleReal(str);
            if (locale == null) {
                Log.e((String)"LanguageUtils", (String)("The string of " + str + " is not in the correct format."));
                UtilsBridge.INSTANCE.getSpUtils4Utils().remove(LanguageUtils.KEY_LOCALE);
            }
            return locale;
        }

        private final Locale string2LocaleReal(String str) {
            Locale locale;
            if (!this.isRightFormatLocalStr(str)) {
                locale = null;
            } else {
                Locale locale2;
                try {
                    int splitIndex = StringsKt.indexOf$default((CharSequence)str, (String)"$", (int)0, (boolean)false, (int)6, null);
                    String string2 = str;
                    int n = 0;
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(n, splitIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string2 = str;
                    n = splitIndex + 1;
                    bl = false;
                    String string5 = string2;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.String).substring(startIndex)");
                    locale2 = new Locale(string4, string6);
                }
                catch (Exception ignore) {
                    locale2 = null;
                }
                locale = locale2;
            }
            return locale;
        }

        private final String string2Language(String str) {
            String string2;
            if (!this.isRightFormatLocalStr(str)) {
                string2 = null;
            } else {
                String string3;
                try {
                    int splitIndex = StringsKt.indexOf$default((CharSequence)str, (String)"$", (int)0, (boolean)false, (int)6, null);
                    String string4 = str;
                    int n = 0;
                    boolean bl = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string6 = string5.substring(n, splitIndex);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string3 = string6;
                }
                catch (Exception ignore) {
                    string3 = null;
                }
                string2 = string3;
            }
            return string2;
        }

        private final boolean isRightFormatLocalStr(String localStr) {
            String string2 = localStr;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            char[] cArray = string3.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
            char[] chars = cArray;
            int count = 0;
            for (char c : chars) {
                if (c != '$') continue;
                if (count >= 1) {
                    return false;
                }
                ++count;
            }
            return count == 1;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSameLocale(Locale l0, Locale l1) {
            if (!UtilsBridge.equals(l1.getLanguage(), l0.getLanguage())) return false;
            if (!UtilsBridge.equals(l1.getCountry(), l0.getCountry())) return false;
            return true;
        }

        private final Locale getLocal(Configuration configuration) {
            Locale locale;
            if (Build.VERSION.SDK_INT >= 24) {
                Locale locale2 = configuration.getLocales().get(0);
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"{\n                configuration.locales[0]\n            }");
                locale = locale2;
            } else {
                Locale locale3 = configuration.locale;
                Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"{\n                configuration.locale\n            }");
                locale = locale3;
            }
            return locale;
        }

        @SuppressLint(value={"ObsoleteSdkInt", "AnnotateVersionCheck"})
        private final void setLocal(Configuration configuration, Locale locale) {
            if (Build.VERSION.SDK_INT >= 17) {
                configuration.setLocale(locale);
            } else {
                configuration.locale = locale;
            }
        }

        @NotNull
        public final String getLanguage() {
            String string2;
            String string3 = UtilsBridge.INSTANCE.getSpUtils4Utils().getString(LanguageUtils.KEY_LOCALE);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"UtilsBridge.spUtils4Utils.getString(KEY_LOCALE)");
            String string4 = this.string2Language(string3);
            if (string4 == null) {
                string3 = Locale.getDefault().getLanguage();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getDefault().language");
                string2 = string3;
            } else {
                string2 = string4;
            }
            return string2;
        }

        @NotNull
        public final Context updateLocale(@NotNull Context c, @NotNull String languageToSwitchTo) {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)languageToSwitchTo, (String)"languageToSwitchTo");
            Locale locale = new Locale(languageToSwitchTo);
            Locale.setDefault(locale);
            Context context = c;
            Resources resources = context.getResources();
            Configuration configuration = resources.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"resources.configuration");
            Configuration configuration2 = configuration;
            configuration2.setLayoutDirection(locale);
            if (Build.VERSION.SDK_INT >= 24) {
                Locale[] localeArray = new Locale[]{locale};
                LocaleList localeList = new LocaleList(localeArray);
                LocaleList.setDefault((LocaleList)localeList);
                configuration2.setLocales(localeList);
            } else {
                configuration2.locale = locale;
            }
            if (Build.VERSION.SDK_INT >= 25) {
                configuration = context.createConfigurationContext(configuration2);
                Intrinsics.checkNotNullExpressionValue((Object)configuration, (String)"context.createConfigurationContext(configuration)");
                context = configuration;
            }
            resources.updateConfiguration(configuration2, resources.getDisplayMetrics());
            return context;
        }

        @JvmOverloads
        public final void applySystemLanguage() {
            com.netacom.base.chat.android_utils.LanguageUtils$Companion.applySystemLanguage$default(this, false, 1, null);
        }

        @JvmOverloads
        public final void applyLanguage(@NotNull Locale locale) {
            Intrinsics.checkNotNullParameter((Object)locale, (String)"locale");
            com.netacom.base.chat.android_utils.LanguageUtils$Companion.applyLanguage$default(this, locale, false, 2, null);
        }

        public static final /* synthetic */ void access$restart(Companion $this, boolean isRelaunchApp) {
            $this.restart(isRelaunchApp);
        }

        public static final /* synthetic */ void access$pollCheckAppContextLocal(Companion $this, Locale destLocale, int index, Utils.Consumer consumer) {
            $this.pollCheckAppContextLocal(destLocale, index, consumer);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

