/*
 * Decompiled with CFR 0.152.
 */
package com.netacom.base.chat.util;

import com.google.firebase.crashlytics.FirebaseCrashlytics;
import com.netacom.base.chat.android_utils.LanguageUtils;
import com.netacom.base.chat.type.Language;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b0\u0007j\b\u0012\u0004\u0012\u00020\b`\t2\u0006\u0010\n\u001a\u00020\u000bJ\u001c\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u00042\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007J\b\u0010\u0010\u001a\u00020\u000bH\u0007J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bJ\b\u0010\u0012\u001a\u00020\u0013H\u0007J\b\u0010\u0014\u001a\u00020\u0013H\u0007J\u001a\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007J\u001a\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u000b2\b\b\u0002\u0010\u000f\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/netacom/base/chat/util/TimeUtils;", "", "()V", "DATE_FORMAT", "", "PATTERN_ISO_INSTANT", "distanceTime", "Ljava/util/ArrayList;", "", "Lkotlin/collections/ArrayList;", "time", "", "getDateByUTC", "Ljava/util/Date;", "dateInString", "pattern", "getTimeStamp", "parseTimeAgo", "timeZoneDefault", "Ljava/util/TimeZone;", "timeZoneGMT", "toDate", "timestamp", "toUTCDate", "netacom-base-chat_NetAloDevRelease"})
public final class TimeUtils {
    @NotNull
    public static final String DATE_FORMAT = "dd/MM/yyyy";
    @NotNull
    public static final String PATTERN_ISO_INSTANT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    @NotNull
    public static final TimeUtils INSTANCE;

    @JvmStatic
    @NotNull
    public static final String toDate(long timestamp, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        return dateFormat.format(new Date(timestamp)).toString();
    }

    public static /* synthetic */ String toDate$default(long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = DATE_FORMAT;
        }
        return TimeUtils.toDate(l, string2);
    }

    @JvmStatic
    @NotNull
    public static final String toUTCDate(long timestamp, @NotNull String pattern) {
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        dateFormat.setTimeZone(TimeUtils.timeZoneGMT());
        return dateFormat.format(new Date(timestamp)).toString();
    }

    public static /* synthetic */ String toUTCDate$default(long l, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = PATTERN_ISO_INSTANT;
        }
        return TimeUtils.toUTCDate(l, string2);
    }

    @JvmStatic
    @NotNull
    public static final TimeZone timeZoneGMT() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"TimeZone.getTimeZone(\"GMT\")");
        return timeZone;
    }

    @JvmStatic
    @NotNull
    public static final TimeZone timeZoneDefault() {
        TimeZone timeZone = TimeZone.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)timeZone, (String)"TimeZone.getDefault()");
        return timeZone;
    }

    @JvmStatic
    @Nullable
    public static final Date getDateByUTC(@NotNull String dateInString, @NotNull String pattern) {
        Date date;
        Intrinsics.checkNotNullParameter((Object)dateInString, (String)"dateInString");
        Intrinsics.checkNotNullParameter((Object)pattern, (String)"pattern");
        SimpleDateFormat dateFormat = new SimpleDateFormat(pattern, Locale.getDefault());
        dateFormat.setTimeZone(TimeUtils.timeZoneGMT());
        try {
            date = dateFormat.parse(dateInString);
        }
        catch (Exception e) {
            FirebaseCrashlytics.getInstance().recordException((Throwable)e);
            date = null;
        }
        return date;
    }

    public static /* synthetic */ Date getDateByUTC$default(String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            string3 = PATTERN_ISO_INSTANT;
        }
        return TimeUtils.getDateByUTC(string2, string3);
    }

    @JvmStatic
    public static final long getTimeStamp() {
        Calendar calendar = Calendar.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)calendar, (String)"Calendar.getInstance()");
        return calendar.getTimeInMillis();
    }

    @NotNull
    public final ArrayList<Integer> distanceTime(long time) {
        ArrayList results = CollectionsKt.arrayListOf((Object[])new Integer[]{0, 0, 0, 0});
        long currentMillis = System.currentTimeMillis() / (long)1000;
        long distanceTime = currentMillis - time;
        if (distanceTime < 0L) {
            return results;
        }
        int distanceTimeInt = (int)distanceTime;
        results.set(0, distanceTimeInt / 86400);
        results.set(1, distanceTimeInt % 86400 / 3600);
        results.set(2, distanceTimeInt % 3600 / 60);
        results.set(3, distanceTimeInt % 60);
        return results;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String parseTimeAgo(long time) {
        long l;
        int n;
        int n2;
        if (time == 0L) {
            return "";
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        if (String.valueOf(time).length() > 10) {
            String string2 = String.valueOf(time);
            n2 = 0;
            n = 10;
            boolean bl4 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.substring(n2, n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string2 = string4;
            n2 = 0;
            l = Long.parseLong(string2);
        } else {
            l = time;
        }
        long timeMillis = l;
        String resultTime = "";
        if (timeMillis > 0L) {
            List list;
            String string5 = null;
            if (Intrinsics.areEqual((Object)LanguageUtils.Companion.getLanguage(), (Object)Language.ENGLISH.getValue())) {
                string5 = "now";
                list = CollectionsKt.mutableListOf((Object[])new String[]{"day", "hour", "min", "second"});
            } else {
                string5 = "m\u1edbi \u0111\u00e2y";
                list = CollectionsKt.mutableListOf((Object[])new String[]{"ng\u00e0y", "gi\u1edd", "ph\u00fat", "gi\u00e2y"});
            }
            List labels = list;
            ArrayList<Integer> times = this.distanceTime(timeMillis);
            n2 = 0;
            Collection collection = times;
            boolean bl5 = false;
            n = collection.size();
            while (n2 < n) {
                void index;
                if (Intrinsics.compare((int)((Number)times.get((int)index)).intValue(), (int)0) > 0) {
                    resultTime = index == false && Intrinsics.compare((int)((Number)times.get((int)index)).intValue(), (int)7) > 0 ? TimeUtils.toDate$default(time * (long)1000, null, 2, null) : (index == 3 ? string5 : (Intrinsics.compare((int)((Number)times.get((int)index)).intValue(), (int)2) < 0 ? "" + times.get((int)index) + ' ' + (String)labels.get((int)index) : (Intrinsics.areEqual((Object)LanguageUtils.Companion.getLanguage(), (Object)Language.ENGLISH.getValue()) ? "" + times.get((int)index) + ' ' + (String)labels.get((int)index) + "s ago" : "" + times.get((int)index) + ' ' + (String)labels.get((int)index) + " tr\u01b0\u1edbc")));
                    break;
                }
                collection = times;
                bl5 = false;
                if (index == collection.size() - 1) {
                    resultTime = string5;
                }
                ++index;
            }
        }
        return resultTime;
    }

    private TimeUtils() {
    }

    static {
        TimeUtils timeUtils;
        INSTANCE = timeUtils = new TimeUtils();
    }
}

