/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl.persistence.handler;

import com.alibaba.nacos.plugin.auth.impl.persistence.handler.PageHandlerAdapter;
import com.alibaba.nacos.plugin.auth.impl.persistence.handler.support.DefaultPageHandlerAdapter;
import com.alibaba.nacos.plugin.auth.impl.persistence.handler.support.DerbyPageHandlerAdapter;
import com.alibaba.nacos.plugin.auth.impl.persistence.handler.support.MysqlPageHandlerAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PageHandlerAdapterFactory {
    private static PageHandlerAdapterFactory instance;
    private List<PageHandlerAdapter> handlerAdapters = new ArrayList<PageHandlerAdapter>(3);
    private Map<String, PageHandlerAdapter> handlerAdapterMap = new HashMap<String, PageHandlerAdapter>(3);

    public List<PageHandlerAdapter> getHandlerAdapters() {
        return this.handlerAdapters;
    }

    public Map<String, PageHandlerAdapter> getHandlerAdapterMap() {
        return this.handlerAdapterMap;
    }

    private PageHandlerAdapterFactory() {
        this.initHandlerAdapters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PageHandlerAdapterFactory getInstance() {
        if (instance != null) return instance;
        Class<PageHandlerAdapterFactory> clazz = PageHandlerAdapterFactory.class;
        synchronized (PageHandlerAdapterFactory.class) {
            if (instance != null) return instance;
            instance = new PageHandlerAdapterFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private void initHandlerAdapters() {
        this.addHandlerAdapter(new MysqlPageHandlerAdapter());
        this.addHandlerAdapter(new DerbyPageHandlerAdapter());
        this.addHandlerAdapter(new DefaultPageHandlerAdapter());
    }

    private void addHandlerAdapter(PageHandlerAdapter handlerAdapter) {
        this.handlerAdapters.add(handlerAdapter);
        this.handlerAdapterMap.put(handlerAdapter.getClass().getName(), handlerAdapter);
    }
}

