/*
 * Decompiled with CFR 0.152.
 */
package video.api.rtmpdroid;

import java.io.Closeable;
import java.net.ConnectException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import video.api.rtmpdroid.RtmpPacket;
import video.api.rtmpdroid.internal.ExVideoCodecs;
import video.api.rtmpdroid.internal.VideoCodecs;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0011\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 F2\u00020\u0001:\u0001FB\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u000bJ\u0006\u0010\u001b\u001a\u00020\u0018J\u0006\u0010\u001c\u001a\u00020\u0018J\t\u0010\u001d\u001a\u00020\bH\u0082 J\t\u0010\u001e\u001a\u00020\u0018H\u0082 J\t\u0010\u001f\u001a\u00020\u0011H\u0082 J\t\u0010 \u001a\u00020\u0011H\u0082 J\t\u0010!\u001a\u00020\u0011H\u0082 J\t\u0010\"\u001a\u00020\u0011H\u0082 J\u000b\u0010#\u001a\u0004\u0018\u00010\u000bH\u0082 J\t\u0010$\u001a\u00020\u0011H\u0082 J\t\u0010%\u001a\u00020\u0011H\u0082 J\t\u0010&\u001a\u00020\u0003H\u0082 J\t\u0010'\u001a\u00020\u0011H\u0082 J!\u0010(\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011H\u0082 J\u000b\u0010-\u001a\u0004\u0018\u00010.H\u0082 J\t\u0010/\u001a\u00020\u0011H\u0082 J\u0011\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0011H\u0082 J\u0013\u00102\u001a\u00020\u00112\b\u00103\u001a\u0004\u0018\u00010\u000bH\u0082 J\u0011\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u00020\u0011H\u0082 J\u0011\u00106\u001a\u00020\u00112\u0006\u00107\u001a\u00020\u0011H\u0082 J\u0011\u00108\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u000bH\u0082 J!\u00109\u001a\u00020\u00112\u0006\u0010:\u001a\u00020;2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011H\u0082 J!\u00109\u001a\u00020\u00112\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020\u0011H\u0082 J\u0011\u0010<\u001a\u00020\u00112\u0006\u0010=\u001a\u00020.H\u0082 J\u0006\u0010>\u001a\u00020\u0018J\"\u0010?\u001a\u00020\u00112\u0006\u0010@\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u00112\b\b\u0002\u0010,\u001a\u00020\u0011J\u0006\u0010A\u001a\u00020.J\u0006\u0010B\u001a\u00020\u0018J\u000e\u0010C\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u0011J\u000e\u0010D\u001a\u00020\u00112\u0006\u0010:\u001a\u00020;J\"\u0010D\u001a\u00020\u00112\u0006\u0010@\u001a\u00020*2\b\b\u0002\u0010+\u001a\u00020\u00112\b\b\u0002\u0010,\u001a\u00020\u0011J\u000e\u0010E\u001a\u00020\u00182\u0006\u0010=\u001a\u00020.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R0\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R$\u0010\u0012\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\u00118F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016\u00a8\u0006G"}, d2={"Lvideo/api/rtmpdroid/Rtmp;", "Ljava/io/Closeable;", "enableWrite", "", "(Z)V", "isConnected", "()Z", "ptr", "", "value", "", "", "supportedVideoCodecs", "getSupportedVideoCodecs", "()Ljava/util/List;", "setSupportedVideoCodecs", "(Ljava/util/List;)V", "", "timeout", "getTimeout", "()I", "setTimeout", "(I)V", "close", "", "connect", "url", "connectStream", "deleteStream", "nativeAlloc", "nativeClose", "nativeConnect", "nativeConnectStream", "nativeDeleteStream", "nativeEnableWrite", "nativeGetExVideoCodecs", "nativeGetTimeout", "nativeGetVideoCodecs", "nativeIsConnected", "nativePause", "nativeRead", "data", "", "offset", "size", "nativeReadPacket", "Lvideo/api/rtmpdroid/RtmpPacket;", "nativeResume", "nativeServe", "fd", "nativeSetExVideoCodec", "exVideoCodec", "nativeSetTimeout", "timeoutInMs", "nativeSetVideoCodec", "videoCodec", "nativeSetupURL", "nativeWrite", "buffer", "Ljava/nio/ByteBuffer;", "nativeWritePacket", "packet", "pause", "read", "array", "readPacket", "resume", "serve", "write", "writePacket", "Companion", "lib_unpackedRelease"})
@SourceDebugExtension(value={"SMAP\nRtmp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Rtmp.kt\nvideo/api/rtmpdroid/Rtmp\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,334:1\n1855#2,2:335\n1#3:337\n*S KotlinDebug\n*F\n+ 1 Rtmp.kt\nvideo/api/rtmpdroid/Rtmp\n*L\n99#1:335,2\n*E\n"})
public final class Rtmp
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final boolean enableWrite;
    private long ptr;

    public Rtmp(boolean enableWrite) {
        this.enableWrite = enableWrite;
        this.ptr = this.nativeAlloc();
        if (this.ptr == 0L) {
            throw new UnsupportedOperationException("Can't allocate a RTMP context");
        }
    }

    public /* synthetic */ Rtmp(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = true;
        }
        this(bl);
    }

    private final native boolean nativeIsConnected();

    public final boolean isConnected() {
        return this.nativeIsConnected();
    }

    private final native int nativeGetTimeout();

    private final native int nativeSetTimeout(int var1);

    public final int getTimeout() {
        int timeout = this.nativeGetTimeout();
        if (timeout < 0) {
            throw new UnsupportedOperationException("Can't get timeout");
        }
        return timeout;
    }

    public final void setTimeout(int value) {
        if (this.nativeSetTimeout(value) != 0) {
            throw new UnsupportedOperationException("Can't set timeout");
        }
    }

    private final native String nativeGetExVideoCodecs();

    private final native int nativeSetExVideoCodec(String var1);

    private final native int nativeGetVideoCodecs();

    private final native int nativeSetVideoCodec(int var1);

    @NotNull
    public final List<String> getSupportedVideoCodecs() {
        int videoCodecs = this.nativeGetVideoCodecs();
        if (videoCodecs <= 0) {
            throw new UnsupportedOperationException("Can't get supported video codecs");
        }
        VideoCodecs supportedCodecs = new VideoCodecs(videoCodecs);
        ExVideoCodecs supportedExCodecs = new ExVideoCodecs(this.nativeGetExVideoCodecs());
        return CollectionsKt.plus((Collection)supportedCodecs.getSupportedCodecs(), (Iterable)supportedExCodecs.getSupportedCodecs());
    }

    public final void setSupportedVideoCodecs(@NotNull List<String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        if (value.isEmpty()) {
            throw new IllegalArgumentException("At least one codec must be supported");
        }
        List supportedCodecs = new ArrayList();
        List supportedExCodecs = new ArrayList();
        Iterable $this$forEach$iv = value;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            if (VideoCodecs.Companion.isSupportedCodec(it)) {
                supportedCodecs.add(it);
                continue;
            }
            if (ExVideoCodecs.Companion.isSupportedCodec(it)) {
                supportedExCodecs.add(it);
                continue;
            }
            throw new IllegalArgumentException("Unsupported codec " + it);
        }
        if (this.nativeSetVideoCodec(VideoCodecs.Companion.fromMimeTypes(supportedCodecs).getValue()) != 0) {
            throw new UnsupportedOperationException("Can't set supported video codecs");
        }
        if (this.nativeSetExVideoCodec(ExVideoCodecs.Companion.fromMimeTypes(supportedExCodecs).getValue()) != 0) {
            throw new UnsupportedOperationException("Can't set supported extended video codecs");
        }
    }

    private final native long nativeAlloc();

    private final native int nativeSetupURL(String var1);

    private final native int nativeEnableWrite();

    private final native int nativeConnect();

    public final void connect(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.nativeSetupURL(url) != 0) {
            throw new IllegalArgumentException("Invalid RTMP URL: " + url);
        }
        if (this.enableWrite && this.nativeEnableWrite() != 0) {
            throw new UnsupportedOperationException("Failed to enable write");
        }
        if (this.nativeConnect() != 0) {
            throw new ConnectException("Failed to connect");
        }
    }

    private final native int nativeConnectStream();

    public final void connectStream() {
        if (this.nativeConnectStream() != 0) {
            throw new ConnectException("Failed to connectStream");
        }
    }

    private final native int nativeDeleteStream();

    public final void deleteStream() {
        if (this.nativeDeleteStream() != 0) {
            throw new UnsupportedOperationException("Failed to delete stream");
        }
    }

    private final native int nativeWrite(ByteBuffer var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int write(@NotNull ByteBuffer buffer) {
        int n;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!buffer.isDirect()) {
            boolean bl = false;
            String string = "ByteBuffer must be a direct buffer";
            throw new IllegalArgumentException(string.toString());
        }
        Rtmp rtmp = this;
        synchronized (rtmp) {
            boolean bl = false;
            n = this.nativeWrite(buffer, buffer.position(), buffer.remaining());
        }
        int byteSent = n;
        if (byteSent < 0) {
            throw new SocketException("Connection error");
        }
        if (byteSent == 0) {
            throw new SocketTimeoutException("Timeout exception");
        }
        return byteSent;
    }

    private final native int nativeWrite(byte[] var1, int var2, int var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int write(@NotNull byte[] array, int offset, int size) {
        int n;
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        Rtmp rtmp = this;
        synchronized (rtmp) {
            boolean bl = false;
            n = this.nativeWrite(array, offset, size);
        }
        int byteSent = n;
        if (byteSent < 0) {
            throw new SocketException("Connection error");
        }
        if (byteSent == 0) {
            throw new SocketTimeoutException("Timeout exception");
        }
        return byteSent;
    }

    public static /* synthetic */ int write$default(Rtmp rtmp, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return rtmp.write(byArray, n, n2);
    }

    private final native int nativeRead(byte[] var1, int var2, int var3);

    public final int read(@NotNull byte[] array, int offset, int size) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        int byteReceived = this.nativeRead(array, offset, size);
        if (byteReceived < 0) {
            throw new SocketException("Connection error");
        }
        if (byteReceived == 0) {
            throw new SocketTimeoutException("Timeout exception");
        }
        return byteReceived;
    }

    public static /* synthetic */ int read$default(Rtmp rtmp, byte[] byArray, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        return rtmp.read(byArray, n, n2);
    }

    private final native int nativeWritePacket(RtmpPacket var1);

    public final void writePacket(@NotNull RtmpPacket packet) {
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        if (this.nativeWritePacket(packet) != 0) {
            throw new SocketException("Failed to write packet");
        }
    }

    private final native RtmpPacket nativeReadPacket();

    @NotNull
    public final RtmpPacket readPacket() {
        RtmpPacket rtmpPacket = this.nativeReadPacket();
        if (rtmpPacket == null) {
            throw new SocketException("Failed to read packet");
        }
        return rtmpPacket;
    }

    private final native int nativePause();

    public final void pause() {
        if (this.nativePause() != 0) {
            throw new SocketException("Can't pause");
        }
    }

    private final native int nativeResume();

    public final void resume() {
        if (this.nativeResume() != 0) {
            throw new SocketException("Can't resume");
        }
    }

    private final native void nativeClose();

    @Override
    public void close() {
        if (this.ptr != 0L) {
            this.nativeClose();
            this.ptr = 0L;
        }
    }

    private final native int nativeServe(int var1);

    public final void serve(int fd) {
        if (this.nativeServe(fd) != 0) {
            throw new SocketException("Can't serve");
        }
    }

    public Rtmp() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lvideo/api/rtmpdroid/Rtmp$Companion;", "", "()V", "lib_unpackedRelease"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

