/*
 * Decompiled with CFR 0.152.
 */
package video.api.rtmpdroid.amf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import video.api.rtmpdroid.amf.AmfType;
import video.api.rtmpdroid.amf.models.EcmaArray;
import video.api.rtmpdroid.amf.models.NamedParameter;
import video.api.rtmpdroid.amf.models.NullParameter;
import video.api.rtmpdroid.amf.models.ObjectParameter;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0001J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0001J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0010J\u0018\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0001H\u0002R\u0011\u0010\u0003\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lvideo/api/rtmpdroid/amf/AmfEncoder;", "", "()V", "minBufferSize", "", "getMinBufferSize", "()I", "parameters", "", "add", "", "parameter", "name", "", "value", "encode", "Ljava/nio/ByteBuffer;", "buffer", "Companion", "lib_unpackedRelease"})
@SourceDebugExtension(value={"SMAP\nAmfEncoder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmfEncoder.kt\nvideo/api/rtmpdroid/amf/AmfEncoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,256:1\n1#2:257\n1855#3,2:258\n1855#3,2:260\n1855#3,2:262\n*S KotlinDebug\n*F\n+ 1 AmfEncoder.kt\nvideo/api/rtmpdroid/amf/AmfEncoder\n*L\n55#1:258,2\n108#1:260,2\n114#1:262,2\n*E\n"})
public final class AmfEncoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Object> parameters = new ArrayList();

    public final void add(@NotNull Object parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        this.parameters.add(parameter);
    }

    public final void add(@NotNull String name, @NotNull Object value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.parameters.add(new NamedParameter(name, value));
    }

    @NotNull
    public final ByteBuffer encode() {
        ByteBuffer buffer = ByteBuffer.allocateDirect(this.getMinBufferSize());
        Intrinsics.checkNotNullExpressionValue((Object)buffer, (String)"buffer");
        this.encode(buffer);
        buffer.rewind();
        return buffer;
    }

    public final void encode(@NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!buffer.isDirect()) {
            boolean $i$a$-require-AmfEncoder$encode$22 = false;
            String $i$a$-require-AmfEncoder$encode$22 = "ByteBuffer must be a direct buffer";
            throw new IllegalArgumentException($i$a$-require-AmfEncoder$encode$22.toString());
        }
        Iterable $this$forEach$iv = this.parameters;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            this.encode(buffer, it);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void encode(ByteBuffer buffer, Object parameter) {
        Object it;
        Object element$iv;
        Iterator iterator;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        int n;
        Object object = parameter;
        if (object instanceof Boolean) {
            n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeBoolean$default(Companion, buffer, 0, 0, (Boolean)parameter, 6, null);
        } else if (object instanceof Integer) {
            n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeInt$default(Companion, buffer, 0, 0, ((Number)parameter).intValue(), 6, null);
        } else if (object instanceof Double) {
            n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeNumber$default(Companion, buffer, 0, 0, ((Number)parameter).doubleValue(), 6, null);
        } else if (object instanceof String) {
            n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeString$default(Companion, buffer, 0, 0, (String)parameter, 6, null);
        } else if (object instanceof NullParameter) {
            buffer.put(AmfType.NULL.getValue());
            n = buffer.position();
        } else if (object instanceof NamedParameter) {
            Object object2 = ((NamedParameter)parameter).getValue();
            if (object2 instanceof Boolean) {
                n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeNamedBoolean$default(Companion, buffer, 0, 0, ((NamedParameter)parameter).getName(), (Boolean)((NamedParameter)parameter).getValue(), 6, null);
            } else if (object2 instanceof Double) {
                n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeNamedNumber$default(Companion, buffer, 0, 0, ((NamedParameter)parameter).getName(), ((Number)((NamedParameter)parameter).getValue()).doubleValue(), 6, null);
            } else {
                if (!(object2 instanceof String)) throw new IOException("Named parameter type is not supported: " + ((NamedParameter)parameter).getValue().getClass().getSimpleName());
                n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeNamedString$default(Companion, buffer, 0, 0, ((NamedParameter)parameter).getName(), (String)((NamedParameter)parameter).getValue(), 6, null);
            }
        } else if (object instanceof ObjectParameter) {
            buffer.put(AmfType.OBJECT.getValue());
            $this$forEach$iv = ((ObjectParameter)parameter).getParameters$lib_unpackedRelease();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                it = element$iv = iterator.next();
                boolean bl = false;
                this.encode(buffer, it);
            }
            n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeInt24$default(Companion, buffer, 0, 0, AmfType.OBJECT_END.getValue(), 6, null);
        } else {
            if (!(object instanceof EcmaArray)) throw new IOException("Parameter type is not supported: " + parameter.getClass().getSimpleName());
            buffer.put(AmfType.ECMA_ARRAY.getValue());
            buffer.position(video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeInt$default(Companion, buffer, 0, 0, ((EcmaArray)parameter).getParameters$lib_unpackedRelease().size(), 6, null));
            $this$forEach$iv = ((EcmaArray)parameter).getParameters$lib_unpackedRelease();
            $i$f$forEach = false;
            iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                it = element$iv = iterator.next();
                boolean bl = false;
                this.encode(buffer, it);
            }
            n = video.api.rtmpdroid.amf.AmfEncoder$Companion.nativeEncodeInt24$default(Companion, buffer, 0, 0, AmfType.OBJECT_END.getValue(), 6, null);
        }
        int size = n;
        if (size < 0) {
            throw new ArrayIndexOutOfBoundsException(buffer.position());
        }
        buffer.position(size);
    }

    /*
     * WARNING - void declaration
     */
    public final int getMinBufferSize() {
        Iterable iterable = this.parameters;
        int n = 0;
        Iterator iterator = iterable.iterator();
        while (iterator.hasNext()) {
            void it;
            Object t;
            Object t2 = t = iterator.next();
            int n2 = n;
            boolean bl = false;
            int n3 = AmfEncoder.Companion.getParameterSize(it);
            n = n2 + n3;
        }
        return n;
    }

    @JvmStatic
    private static final native int nativeEncodeBoolean(ByteBuffer var0, int var1, int var2, boolean var3);

    @JvmStatic
    private static final native int nativeEncodeInt24(ByteBuffer var0, int var1, int var2, int var3);

    @JvmStatic
    private static final native int nativeEncodeInt(ByteBuffer var0, int var1, int var2, int var3);

    @JvmStatic
    private static final native int nativeEncodeNumber(ByteBuffer var0, int var1, int var2, double var3);

    @JvmStatic
    private static final native int nativeEncodeString(ByteBuffer var0, int var1, int var2, String var3);

    @JvmStatic
    private static final native int nativeEncodeNamedBoolean(ByteBuffer var0, int var1, int var2, String var3, boolean var4);

    @JvmStatic
    private static final native int nativeEncodeNamedNumber(ByteBuffer var0, int var1, int var2, String var3, double var4);

    @JvmStatic
    private static final native int nativeEncodeNamedString(ByteBuffer var0, int var1, int var2, String var3, String var4);

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0001H\u0002J-\u0010\u0006\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000bH\u0083 J-\u0010\f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0083 J-\u0010\r\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0083 J5\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u000bH\u0083 J5\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0012H\u0083 J5\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u0010H\u0083 J-\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0012H\u0083 J-\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\u00042\b\b\u0002\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0010H\u0083 \u00a8\u0006\u0016"}, d2={"Lvideo/api/rtmpdroid/amf/AmfEncoder$Companion;", "", "()V", "getParameterSize", "", "parameter", "nativeEncodeBoolean", "buffer", "Ljava/nio/ByteBuffer;", "offset", "end", "", "nativeEncodeInt", "nativeEncodeInt24", "nativeEncodeNamedBoolean", "name", "", "nativeEncodeNamedNumber", "", "nativeEncodeNamedString", "nativeEncodeNumber", "nativeEncodeString", "lib_unpackedRelease"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        private final int getParameterSize(Object parameter) {
            int n;
            Object object = parameter;
            if (object instanceof Boolean) {
                n = 2;
            } else if (object instanceof Short) {
                n = 2;
            } else if (object instanceof Integer) {
                n = 4;
            } else if (object instanceof Double) {
                n = 9;
            } else if (object instanceof String) {
                n = 3 + ((String)parameter).length();
            } else if (object instanceof NullParameter) {
                n = 1;
            } else if (object instanceof NamedParameter) {
                n = 2 + ((NamedParameter)parameter).getName().length() + this.getParameterSize(((NamedParameter)parameter).getValue());
            } else if (object instanceof ObjectParameter) {
                int n2;
                Iterable iterable = ((ObjectParameter)parameter).getParameters$lib_unpackedRelease();
                int n3 = 4;
                int n4 = 0;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    void it;
                    Object t;
                    Object t2 = t = iterator.next();
                    n2 = n4;
                    boolean bl = false;
                    int n5 = Companion.getParameterSize(it);
                    n4 = n2 + n5;
                }
                n2 = n4;
                n = n3 + n2;
            } else if (object instanceof EcmaArray) {
                int n6;
                Iterable iterable = ((EcmaArray)parameter).getParameters$lib_unpackedRelease();
                int n7 = 8;
                int n8 = 0;
                Iterator iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    Object t;
                    Object it = t = iterator.next();
                    n6 = n8;
                    boolean bl = false;
                    int n9 = Companion.getParameterSize(it);
                    n8 = n6 + n9;
                }
                n6 = n8;
                n = n7 + n6;
            } else {
                throw new IOException("Parameter type is not supported: " + parameter.getClass().getSimpleName());
            }
            return n;
        }

        @JvmStatic
        private final int nativeEncodeBoolean(ByteBuffer buffer, int offset, int end, boolean parameter) {
            return AmfEncoder.nativeEncodeBoolean(buffer, offset, end, parameter);
        }

        static /* synthetic */ int nativeEncodeBoolean$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, boolean bl, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = byteBuffer.position();
            }
            if ((n3 & 4) != 0) {
                n2 = byteBuffer.limit();
            }
            return companion.nativeEncodeBoolean(byteBuffer, n, n2, bl);
        }

        @JvmStatic
        private final int nativeEncodeInt24(ByteBuffer buffer, int offset, int end, int parameter) {
            return AmfEncoder.nativeEncodeInt24(buffer, offset, end, parameter);
        }

        static /* synthetic */ int nativeEncodeInt24$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n = byteBuffer.position();
            }
            if ((n4 & 4) != 0) {
                n2 = byteBuffer.limit();
            }
            return companion.nativeEncodeInt24(byteBuffer, n, n2, n3);
        }

        @JvmStatic
        private final int nativeEncodeInt(ByteBuffer buffer, int offset, int end, int parameter) {
            return AmfEncoder.nativeEncodeInt(buffer, offset, end, parameter);
        }

        static /* synthetic */ int nativeEncodeInt$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 2) != 0) {
                n = byteBuffer.position();
            }
            if ((n4 & 4) != 0) {
                n2 = byteBuffer.limit();
            }
            return companion.nativeEncodeInt(byteBuffer, n, n2, n3);
        }

        @JvmStatic
        private final int nativeEncodeNumber(ByteBuffer buffer, int offset, int end, double parameter) {
            return AmfEncoder.nativeEncodeNumber(buffer, offset, end, parameter);
        }

        static /* synthetic */ int nativeEncodeNumber$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, double d, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = byteBuffer.position();
            }
            if ((n3 & 4) != 0) {
                n2 = byteBuffer.limit();
            }
            return companion.nativeEncodeNumber(byteBuffer, n, n2, d);
        }

        @JvmStatic
        private final int nativeEncodeString(ByteBuffer buffer, int offset, int end, String parameter) {
            return AmfEncoder.nativeEncodeString(buffer, offset, end, parameter);
        }

        static /* synthetic */ int nativeEncodeString$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, String string, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = byteBuffer.position();
            }
            if ((n3 & 4) != 0) {
                n2 = byteBuffer.limit();
            }
            return companion.nativeEncodeString(byteBuffer, n, n2, string);
        }

        @JvmStatic
        private final int nativeEncodeNamedBoolean(ByteBuffer buffer, int offset, int end, String name, boolean parameter) {
            return AmfEncoder.nativeEncodeNamedBoolean(buffer, offset, end, name, parameter);
        }

        static /* synthetic */ int nativeEncodeNamedBoolean$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, String string, boolean bl, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = byteBuffer.position();
            }
            if ((n3 & 4) != 0) {
                n2 = byteBuffer.limit();
            }
            return companion.nativeEncodeNamedBoolean(byteBuffer, n, n2, string, bl);
        }

        @JvmStatic
        private final int nativeEncodeNamedNumber(ByteBuffer buffer, int offset, int end, String name, double parameter) {
            return AmfEncoder.nativeEncodeNamedNumber(buffer, offset, end, name, parameter);
        }

        static /* synthetic */ int nativeEncodeNamedNumber$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, String string, double d, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = byteBuffer.position();
            }
            if ((n3 & 4) != 0) {
                n2 = byteBuffer.limit();
            }
            return companion.nativeEncodeNamedNumber(byteBuffer, n, n2, string, d);
        }

        @JvmStatic
        private final int nativeEncodeNamedString(ByteBuffer buffer, int offset, int end, String name, String parameter) {
            return AmfEncoder.nativeEncodeNamedString(buffer, offset, end, name, parameter);
        }

        static /* synthetic */ int nativeEncodeNamedString$default(Companion companion, ByteBuffer byteBuffer, int n, int n2, String string, String string2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = byteBuffer.position();
            }
            if ((n3 & 4) != 0) {
                n2 = byteBuffer.limit();
            }
            return companion.nativeEncodeNamedString(byteBuffer, n, n2, string, string2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

