/*
 * Decompiled with CFR 0.152.
 */
package video.api.uploader.api.services;

import android.app.Notification;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.IBinder;
import androidx.annotation.ColorRes;
import androidx.annotation.DrawableRes;
import androidx.annotation.StringRes;
import androidx.core.app.NotificationCompat;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.uploader.VideosApi;
import video.api.uploader.api.ApiClient;
import video.api.uploader.api.R;
import video.api.uploader.api.models.Environment;
import video.api.uploader.api.models.Video;
import video.api.uploader.api.services.NotificationUtils;
import video.api.uploader.api.services.UploadService;
import video.api.uploader.api.services.UploadServiceListener;
import video.api.uploader.api.services.UploadTask;
import video.api.uploader.api.upload.IProgressiveUploadSession;
import video.api.uploader.api.upload.UploadProgressListener;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a5\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0001\u001b\b\u0016\u0018\u0000 a2\u00020\u0001:\u0003abcBA\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0003\u0010\u0006\u001a\u00020\u0003\u0012\b\b\u0003\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0003\u0010\b\u001a\u00020\u0003\u0012\b\b\u0003\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u00109\u001a\u00020:2\u0006\u0010\u001a\u001a\u00020\u001fJ\u000e\u0010;\u001a\u00020:2\u0006\u0010<\u001a\u00020\u0005J\u0006\u0010=\u001a\u00020:J\b\u0010>\u001a\u00020:H\u0002J\u0012\u0010?\u001a\u00060@R\u00020\u00002\u0006\u0010A\u001a\u00020BJ\u0010\u0010C\u001a\u00020:2\u0006\u0010D\u001a\u00020EH\u0002J\u0010\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020:H\u0016J\b\u0010K\u001a\u00020:H\u0016J\n\u0010L\u001a\u0004\u0018\u00010EH\u0016J\u0012\u0010M\u001a\u0004\u0018\u00010E2\u0006\u0010<\u001a\u00020\u0005H\u0016J\u001e\u0010N\u001a\u0004\u0018\u00010E2\u0006\u0010<\u001a\u00020\u00052\n\u0010O\u001a\u00060Pj\u0002`QH\u0016J\u001a\u0010R\u001a\u0004\u0018\u00010E2\u0006\u0010<\u001a\u00020\u00052\u0006\u0010S\u001a\u00020\u0003H\u0016J\u0012\u0010T\u001a\u0004\u0018\u00010E2\u0006\u0010<\u001a\u00020\u0005H\u0016J\u0012\u0010U\u001a\u0004\u0018\u00010E2\u0006\u0010V\u001a\u000206H\u0016J\u000e\u0010W\u001a\u00020:2\u0006\u0010\u001a\u001a\u00020\u001fJ\u0016\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020[J\u0016\u0010X\u001a\u00020\u00052\u0006\u0010Y\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u0005J\u0016\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u00052\u0006\u0010Z\u001a\u00020[J\u0016\u0010]\u001a\u00020\u00052\u0006\u0010^\u001a\u00020\u00052\u0006\u0010\\\u001a\u00020\u0005J \u0010_\u001a\u00020`*\u00020`2\b\b\u0001\u0010\b\u001a\u00020\u00032\b\b\u0001\u0010\t\u001a\u00020\u0003H\u0004R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000f\u001a\u00060\u0010R\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \u0015*\u0004\u0018\u00010\u00140\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0014\u0010\b\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010!R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8DX\u0084\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&R\u0011\u0010)\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b*\u0010!R\u0011\u0010+\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b,\u0010!R\u0011\u0010-\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b.\u0010!R\u0011\u0010/\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b0\u0010!R\u0011\u00101\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b2\u0010!R \u00103\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u0002060504X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u00107\u001a\u000208X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006d"}, d2={"Lvideo/api/uploader/api/services/UploadService;", "Landroid/app/Service;", "notificationId", "", "channelId", "", "channelNameResourceId", "channelDescriptionResourceId", "notificationIconResourceId", "notificationColorResourceId", "(ILjava/lang/String;IIII)V", "_numOfCancelled", "_numOfError", "_numOfUploaded", "_totalNumOfUploads", "binder", "Lvideo/api/uploader/api/services/UploadService$UploadServiceBinder;", "getChannelId", "()Ljava/lang/String;", "executor", "Ljava/util/concurrent/ExecutorService;", "kotlin.jvm.PlatformType", "hasRemaining", "", "getHasRemaining", "()Z", "listener", "video/api/uploader/api/services/UploadService$listener$1", "Lvideo/api/uploader/api/services/UploadService$listener$1;", "listeners", "", "Lvideo/api/uploader/api/services/UploadServiceListener;", "getNotificationColorResourceId", "()I", "getNotificationIconResourceId", "notificationUtils", "Lvideo/api/uploader/api/services/NotificationUtils;", "getNotificationUtils", "()Lvideo/api/uploader/api/services/NotificationUtils;", "notificationUtils$delegate", "Lkotlin/Lazy;", "numOfCancelled", "getNumOfCancelled", "numOfError", "getNumOfError", "numOfRemaining", "getNumOfRemaining", "numOfUploaded", "getNumOfUploaded", "totalNumOfUploads", "getTotalNumOfUploads", "uploadFuturesMap", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/concurrent/Future;", "Lvideo/api/uploader/api/models/Video;", "videosApi", "Lvideo/api/uploader/VideosApi;", "addListener", "", "cancel", "id", "cancelAll", "cancelNotification", "createProgressiveUploadSession", "Lvideo/api/uploader/api/services/UploadService$ProgressiveUploadSession;", "session", "Lvideo/api/uploader/api/upload/IProgressiveUploadSession;", "notify", "notification", "Landroid/app/Notification;", "onBind", "Landroid/os/IBinder;", "intent", "Landroid/content/Intent;", "onCreate", "onDestroy", "onLastUploadNotification", "onUploadCancelledNotification", "onUploadErrorNotification", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "onUploadProgressNotification", "progress", "onUploadStartedNotification", "onUploadSuccessNotification", "video", "removeListener", "upload", "videoId", "file", "Ljava/io/File;", "filePath", "uploadWithUploadToken", "token", "setStyle", "Landroidx/core/app/NotificationCompat$Builder;", "Companion", "ProgressiveUploadSession", "UploadServiceBinder", "android-video-uploader_release"})
public class UploadService
extends Service {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int notificationId;
    @NotNull
    private final String channelId;
    private final int channelNameResourceId;
    private final int channelDescriptionResourceId;
    private final int notificationIconResourceId;
    private final int notificationColorResourceId;
    @NotNull
    private final ConcurrentHashMap<String, Future<Video>> uploadFuturesMap;
    @NotNull
    private final UploadServiceBinder binder;
    private VideosApi videosApi;
    private final ExecutorService executor;
    @NotNull
    private final listener.1 listener;
    @NotNull
    private final Lazy notificationUtils$delegate;
    @NotNull
    private final List<UploadServiceListener> listeners;
    private int _totalNumOfUploads;
    private int _numOfCancelled;
    private int _numOfError;
    private int _numOfUploaded;
    @NotNull
    public static final String TAG = "UploadService";
    @NotNull
    public static final String DEFAULT_NOTIFICATION_CHANNEL_ID = "video.api.uploader.service";
    public static final int DEFAULT_NOTIFICATION_ID = 3333;
    @NotNull
    public static final String BASE_PATH_KEY = "base_path_key";
    @NotNull
    public static final String API_KEY_KEY = "api_key_key";
    @NotNull
    public static final String TIMEOUT_KEY = "timeout_key";
    @NotNull
    public static final String SDK_NAME_KEY = "sdk_name_key";
    @NotNull
    public static final String SDK_VERSION_KEY = "sdk_version_key";
    @NotNull
    public static final String APP_NAME_KEY = "app_name_key";
    @NotNull
    public static final String APP_VERSION_KEY = "app_version_key";

    public UploadService(int notificationId, @NotNull String channelId, @StringRes int channelNameResourceId, @StringRes int channelDescriptionResourceId, @DrawableRes int notificationIconResourceId, @ColorRes int notificationColorResourceId) {
        Intrinsics.checkNotNullParameter((Object)channelId, (String)"channelId");
        this.notificationId = notificationId;
        this.channelId = channelId;
        this.channelNameResourceId = channelNameResourceId;
        this.channelDescriptionResourceId = channelDescriptionResourceId;
        this.notificationIconResourceId = notificationIconResourceId;
        this.notificationColorResourceId = notificationColorResourceId;
        this.uploadFuturesMap = new ConcurrentHashMap();
        this.binder = new UploadServiceBinder();
        this.executor = Executors.newSingleThreadExecutor();
        this.listener = new UploadServiceListener(this){
            final /* synthetic */ UploadService this$0;
            {
                this.this$0 = $receiver;
            }

            public void onUploadStarted(@NotNull String id) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Notification notification = this.this$0.onUploadStartedNotification(id);
                if (notification != null) {
                    Notification notification2 = notification;
                    UploadService uploadService = this.this$0;
                    Notification it = notification2;
                    boolean bl = false;
                    UploadService.access$notify(uploadService, it);
                }
                Iterable $this$forEach$iv = UploadService.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    UploadServiceListener it = (UploadServiceListener)element$iv;
                    boolean bl = false;
                    it.onUploadStarted(id);
                }
            }

            public void onUploadProgress(@NotNull String id, int progress) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Notification notification = this.this$0.onUploadProgressNotification(id, progress);
                if (notification != null) {
                    Notification notification2 = notification;
                    UploadService uploadService = this.this$0;
                    Notification it = notification2;
                    boolean bl = false;
                    UploadService.access$notify(uploadService, it);
                }
                Iterable $this$forEach$iv = UploadService.access$getListeners$p(this.this$0);
                boolean $i$f$forEach = false;
                for (E element$iv : $this$forEach$iv) {
                    UploadServiceListener it = (UploadServiceListener)element$iv;
                    boolean bl = false;
                    it.onUploadProgress(id, progress);
                }
            }

            public void onUploadError(@NotNull String id, @NotNull Exception e) {
                Object it;
                Object object;
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                UploadService uploadService = this.this$0;
                int n = UploadService.access$get_numOfError$p(uploadService);
                UploadService.access$set_numOfError$p(uploadService, n + 1);
                uploadService = this.this$0.onUploadErrorNotification(id, e);
                if (uploadService != null) {
                    UploadService uploadService2 = uploadService;
                    object = this.this$0;
                    it = uploadService2;
                    boolean bl = false;
                    UploadService.access$notify((UploadService)((Object)object), (Notification)it);
                }
                Iterable $this$forEach$iv = UploadService.access$getListeners$p(this.this$0);
                boolean $i$f$forEach2 = false;
                for (E element$iv : $this$forEach$iv) {
                    UploadServiceListener it2 = (UploadServiceListener)element$iv;
                    boolean bl = false;
                    it2.onUploadError(id, e);
                }
                if (!this.this$0.getHasRemaining()) {
                    $this$forEach$iv = this.this$0.onLastUploadNotification();
                    if ($this$forEach$iv != null) {
                        Iterable $i$f$forEach2 = $this$forEach$iv;
                        object = this.this$0;
                        it = $i$f$forEach2;
                        boolean bl = false;
                        UploadService.access$notify((UploadService)((Object)object), (Notification)it);
                    }
                    $this$forEach$iv = UploadService.access$getListeners$p(this.this$0);
                    boolean $i$f$forEach3 = false;
                    for (E element$iv : $this$forEach$iv) {
                        UploadServiceListener it3 = (UploadServiceListener)element$iv;
                        boolean bl = false;
                        it3.onLastUpload();
                    }
                }
            }

            public void onUploadCancelled(@NotNull String id) {
                Object it;
                Object object;
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Notification notification = this.this$0.onUploadCancelledNotification(id);
                if (notification != null) {
                    Notification notification2 = notification;
                    object = this.this$0;
                    it = notification2;
                    boolean bl = false;
                    UploadService.access$notify((UploadService)((Object)object), it);
                }
                Iterable $this$forEach$iv = UploadService.access$getListeners$p(this.this$0);
                boolean $i$f$forEach2 = false;
                for (E element$iv : $this$forEach$iv) {
                    UploadServiceListener it2 = (UploadServiceListener)element$iv;
                    boolean bl = false;
                    it2.onUploadCancelled(id);
                }
                if (!this.this$0.getHasRemaining()) {
                    $this$forEach$iv = this.this$0.onLastUploadNotification();
                    if ($this$forEach$iv != null) {
                        Iterable $i$f$forEach2 = $this$forEach$iv;
                        object = this.this$0;
                        it = $i$f$forEach2;
                        boolean bl = false;
                        UploadService.access$notify((UploadService)((Object)object), it);
                    }
                    $this$forEach$iv = UploadService.access$getListeners$p(this.this$0);
                    boolean $i$f$forEach3 = false;
                    for (E element$iv : $this$forEach$iv) {
                        UploadServiceListener it3 = (UploadServiceListener)element$iv;
                        boolean bl = false;
                        it3.onLastUpload();
                    }
                }
            }

            public void onUploadComplete(@NotNull Video video) {
                Object it;
                Object object;
                Intrinsics.checkNotNullParameter((Object)video, (String)"video");
                UploadService uploadService = this.this$0;
                int n = UploadService.access$get_numOfUploaded$p(uploadService);
                UploadService.access$set_numOfUploaded$p(uploadService, n + 1);
                uploadService = this.this$0.onUploadSuccessNotification(video);
                if (uploadService != null) {
                    UploadService uploadService2 = uploadService;
                    object = this.this$0;
                    it = uploadService2;
                    boolean bl = false;
                    UploadService.access$notify((UploadService)((Object)object), (Notification)it);
                }
                Iterable $this$forEach$iv = UploadService.access$getListeners$p(this.this$0);
                boolean $i$f$forEach2 = false;
                for (E element$iv : $this$forEach$iv) {
                    UploadServiceListener it2 = (UploadServiceListener)element$iv;
                    boolean bl = false;
                    it2.onUploadComplete(video);
                }
                if (!this.this$0.getHasRemaining()) {
                    $this$forEach$iv = this.this$0.onLastUploadNotification();
                    if ($this$forEach$iv != null) {
                        Iterable $i$f$forEach2 = $this$forEach$iv;
                        object = this.this$0;
                        it = $i$f$forEach2;
                        boolean bl = false;
                        UploadService.access$notify((UploadService)((Object)object), (Notification)it);
                    }
                    $this$forEach$iv = UploadService.access$getListeners$p(this.this$0);
                    boolean $i$f$forEach3 = false;
                    for (E element$iv : $this$forEach$iv) {
                        UploadServiceListener it3 = (UploadServiceListener)element$iv;
                        boolean bl = false;
                        it3.onLastUpload();
                    }
                }
            }

            public void onLastUpload() {
            }
        };
        this.notificationUtils$delegate = LazyKt.lazy((Function0)((Function0)new Function0<NotificationUtils>(this){
            final /* synthetic */ UploadService this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final NotificationUtils invoke() {
                return new NotificationUtils(this.this$0, this.this$0.getChannelId(), UploadService.access$getNotificationId$p(this.this$0));
            }
        }));
        this.listeners = new ArrayList();
    }

    public /* synthetic */ UploadService(int n, String string2, int n2, int n3, int n4, int n5, int n6, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n6 & 1) != 0) {
            n = 3333;
        }
        if ((n6 & 2) != 0) {
            string2 = DEFAULT_NOTIFICATION_CHANNEL_ID;
        }
        if ((n6 & 4) != 0) {
            n2 = R.string.channel_name;
        }
        if ((n6 & 8) != 0) {
            n3 = 0;
        }
        if ((n6 & 0x10) != 0) {
            n4 = R.drawable.ic_api_video_logo;
        }
        if ((n6 & 0x20) != 0) {
            n5 = R.color.primary_orange;
        }
        this(n, string2, n2, n3, n4, n5);
    }

    @NotNull
    protected final String getChannelId() {
        return this.channelId;
    }

    protected final int getNotificationIconResourceId() {
        return this.notificationIconResourceId;
    }

    protected final int getNotificationColorResourceId() {
        return this.notificationColorResourceId;
    }

    @NotNull
    protected final NotificationUtils getNotificationUtils() {
        Lazy lazy = this.notificationUtils$delegate;
        Object var2_2 = null;
        return (NotificationUtils)lazy.getValue();
    }

    public final int getTotalNumOfUploads() {
        return this._totalNumOfUploads;
    }

    public final int getNumOfCancelled() {
        return this._numOfCancelled;
    }

    public final int getNumOfRemaining() {
        return this.getTotalNumOfUploads() - this.getNumOfCancelled() - this.getNumOfUploaded() - this.getNumOfError();
    }

    public final int getNumOfError() {
        return this._numOfError;
    }

    public final int getNumOfUploaded() {
        return this._numOfUploaded;
    }

    public final boolean getHasRemaining() {
        return this.getNumOfRemaining() > 0;
    }

    public final void cancel(@NotNull String id) {
        Boolean bl;
        Future<Video> future2;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Future<Video> future3 = future2 = this.uploadFuturesMap.get(id);
        if (future3 == null) {
            bl = null;
        } else {
            Future<Video> future4;
            Future<Video> it = future4 = future3;
            boolean bl2 = false;
            UploadService uploadService = this;
            int n = uploadService._numOfCancelled;
            uploadService._numOfCancelled = n + 1;
            bl = it.cancel(true);
        }
        Boolean bl3 = bl;
        if (bl3 == null) {
            throw new NoSuchElementException(Intrinsics.stringPlus((String)"Failed to find upload id ", (Object)id));
        }
        bl3.booleanValue();
    }

    public final void cancelAll() {
        Set set = this.uploadFuturesMap.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"uploadFuturesMap.keys");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
            this.cancel(it);
        }
        this.uploadFuturesMap.clear();
        this._numOfUploaded = 0;
        this._numOfError = 0;
        this._numOfCancelled = 0;
        this._totalNumOfUploads = 0;
    }

    public final void addListener(@NotNull UploadServiceListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.add(listener2);
    }

    public final void removeListener(@NotNull UploadServiceListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.listeners.remove(listener2);
    }

    @Nullable
    public Notification onUploadErrorNotification(@NotNull String id, @NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        return this.setStyle(new NotificationCompat.Builder((Context)this, this.channelId), this.notificationIconResourceId, this.notificationColorResourceId).setContentTitle((CharSequence)this.getString(R.string.notification_error_title)).setContentText((CharSequence)e.getLocalizedMessage()).build();
    }

    @Nullable
    public Notification onUploadProgressNotification(@NotNull String id, int progress) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Object[] objectArray = new Object[]{this.getNumOfUploaded(), this.getTotalNumOfUploads() - this.getNumOfCancelled()};
        return this.setStyle(new NotificationCompat.Builder((Context)this, this.channelId), this.notificationIconResourceId, this.notificationColorResourceId).setOngoing(true).setContentTitle((CharSequence)this.getString(R.string.notification_progress_title)).setContentText((CharSequence)this.getString(R.string.notification_progress_text, objectArray)).setProgress(100, progress, false).build();
    }

    @Nullable
    public Notification onUploadStartedNotification(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return null;
    }

    @Nullable
    public Notification onUploadCancelledNotification(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return null;
    }

    @Nullable
    public Notification onUploadSuccessNotification(@NotNull Video video) {
        Intrinsics.checkNotNullParameter((Object)video, (String)"video");
        return null;
    }

    @Nullable
    public Notification onLastUploadNotification() {
        this.cancelNotification();
        return null;
    }

    @NotNull
    public final String upload(@NotNull String videoId, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.upload(videoId, new File(filePath));
    }

    @NotNull
    public final String upload(@NotNull String videoId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        UploadService uploadService = this;
        int n = uploadService._totalNumOfUploads;
        uploadService._totalNumOfUploads = n + 1;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
        String id = string2;
        Future future2 = this.executor.submit(new UploadTask(id, file, (Function2<? super File, ? super UploadProgressListener, ? extends Video>)((Function2)new Function2<File, UploadProgressListener, Video>(this, videoId){
            final /* synthetic */ UploadService this$0;
            final /* synthetic */ String $videoId;
            {
                this.this$0 = $receiver;
                this.$videoId = $videoId;
                super(2);
            }

            @NotNull
            public final Video invoke(@NotNull File fileToUpload, @NotNull UploadProgressListener progressListener) {
                VideosApi videosApi;
                Intrinsics.checkNotNullParameter((Object)fileToUpload, (String)"fileToUpload");
                Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
                VideosApi videosApi2 = UploadService.access$getVideosApi$p(this.this$0);
                if (videosApi2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"videosApi");
                    videosApi = null;
                } else {
                    videosApi = videosApi2;
                }
                Video video = videosApi.upload(this.$videoId, fileToUpload, progressListener);
                Intrinsics.checkNotNullExpressionValue((Object)video, (String)"videosApi.upload(\n      \u2026ner\n                    )");
                return video;
            }
        }), this.listener));
        Map map = this.uploadFuturesMap;
        Intrinsics.checkNotNullExpressionValue(future2, (String)"future");
        Future future3 = future2;
        map.put(id, future3);
        return id;
    }

    @NotNull
    public final String uploadWithUploadToken(@NotNull String token, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        return this.uploadWithUploadToken(token, new File(filePath));
    }

    @NotNull
    public final String uploadWithUploadToken(@NotNull String token, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        UploadService uploadService = this;
        int n = uploadService._totalNumOfUploads;
        uploadService._totalNumOfUploads = n + 1;
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"randomUUID().toString()");
        String id = string2;
        Future future2 = this.executor.submit(new UploadTask(id, file, (Function2<? super File, ? super UploadProgressListener, ? extends Video>)((Function2)new Function2<File, UploadProgressListener, Video>(this, token){
            final /* synthetic */ UploadService this$0;
            final /* synthetic */ String $token;
            {
                this.this$0 = $receiver;
                this.$token = $token;
                super(2);
            }

            @NotNull
            public final Video invoke(@NotNull File fileToUpload, @NotNull UploadProgressListener progressListener) {
                VideosApi videosApi;
                Intrinsics.checkNotNullParameter((Object)fileToUpload, (String)"fileToUpload");
                Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
                VideosApi videosApi2 = UploadService.access$getVideosApi$p(this.this$0);
                if (videosApi2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"videosApi");
                    videosApi = null;
                } else {
                    videosApi = videosApi2;
                }
                Video video = videosApi.uploadWithUploadToken(this.$token, fileToUpload, progressListener);
                Intrinsics.checkNotNullExpressionValue((Object)video, (String)"videosApi.uploadWithUplo\u2026ner\n                    )");
                return video;
            }
        }), this.listener));
        Map map = this.uploadFuturesMap;
        Intrinsics.checkNotNullExpressionValue(future2, (String)"future");
        Future future3 = future2;
        map.put(id, future3);
        return id;
    }

    @NotNull
    public final ProgressiveUploadSession createProgressiveUploadSession(@NotNull IProgressiveUploadSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return new ProgressiveUploadSession(session);
    }

    public void onCreate() {
        super.onCreate();
        this.getNotificationUtils().createNotificationChannel(this.channelNameResourceId, this.channelDescriptionResourceId);
    }

    @NotNull
    public IBinder onBind(@NotNull Intent intent) {
        ApiClient apiClient;
        ApiClient apiClient2;
        String apiKey;
        Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
        String string2 = intent.getStringExtra(BASE_PATH_KEY);
        String basePath = string2 == null ? Environment.SANDBOX.basePath : string2;
        String string3 = apiKey = intent.getStringExtra(API_KEY_KEY);
        if (string3 == null) {
            apiClient2 = null;
        } else {
            String string4;
            String it = string4 = string3;
            boolean bl = false;
            apiClient2 = new ApiClient(it, basePath);
        }
        ApiClient apiClient3 = apiClient2;
        ApiClient apiClient4 = apiClient = apiClient3 == null ? new ApiClient(basePath) : apiClient3;
        if (intent.hasExtra(TIMEOUT_KEY)) {
            int timeout = intent.getIntExtra(TIMEOUT_KEY, 0);
            apiClient.setWriteTimeout(timeout);
            apiClient.setReadTimeout(timeout);
        }
        String sdkName = intent.getStringExtra(SDK_NAME_KEY);
        String sdkVersion = intent.getStringExtra(SDK_VERSION_KEY);
        if (sdkName != null && sdkVersion != null) {
            apiClient.setSdkName(sdkName, sdkVersion);
        } else {
            apiClient.setSdkName("service", "1.0.0");
        }
        String appName = intent.getStringExtra(APP_NAME_KEY);
        String appVersion = intent.getStringExtra(APP_VERSION_KEY);
        if (appName != null && appVersion != null) {
            apiClient.setSdkName(appName, appVersion);
        }
        this.videosApi = new VideosApi(apiClient);
        return (IBinder)this.binder;
    }

    private final void notify(Notification notification) {
        this.getNotificationUtils().notify(notification);
    }

    private final void cancelNotification() {
        this.getNotificationUtils().cancel();
    }

    public void onDestroy() {
        super.onDestroy();
        this.executor.shutdownNow();
        this.listeners.clear();
    }

    @NotNull
    protected final NotificationCompat.Builder setStyle(@NotNull NotificationCompat.Builder $this$setStyle, @DrawableRes int notificationIconResourceId, @ColorRes int notificationColorResourceId) {
        NotificationCompat.Builder builder;
        Intrinsics.checkNotNullParameter((Object)$this$setStyle, (String)"<this>");
        NotificationCompat.Builder $this$setStyle_u24lambda_u2d3 = builder = $this$setStyle;
        boolean bl = false;
        $this$setStyle_u24lambda_u2d3.setSmallIcon(notificationIconResourceId);
        $this$setStyle_u24lambda_u2d3.setColor(this.getColor(notificationColorResourceId));
        return builder;
    }

    public UploadService() {
        this(0, null, 0, 0, 0, 0, 63, null);
    }

    public static final /* synthetic */ VideosApi access$getVideosApi$p(UploadService $this) {
        return $this.videosApi;
    }

    public static final /* synthetic */ List access$getListeners$p(UploadService $this) {
        return $this.listeners;
    }

    public static final /* synthetic */ int access$get_numOfError$p(UploadService $this) {
        return $this._numOfError;
    }

    public static final /* synthetic */ void access$set_numOfError$p(UploadService $this, int n) {
        $this._numOfError = n;
    }

    public static final /* synthetic */ int access$get_numOfUploaded$p(UploadService $this) {
        return $this._numOfUploaded;
    }

    public static final /* synthetic */ void access$set_numOfUploaded$p(UploadService $this, int n) {
        $this._numOfUploaded = n;
    }

    public static final /* synthetic */ void access$notify(UploadService $this, Notification notification) {
        $this.notify(notification);
    }

    public static final /* synthetic */ int access$getNotificationId$p(UploadService $this) {
        return $this.notificationId;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u000e\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006J\u0016\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lvideo/api/uploader/api/services/UploadService$ProgressiveUploadSession;", "", "session", "Lvideo/api/uploader/api/upload/IProgressiveUploadSession;", "(Lvideo/api/uploader/api/services/UploadService;Lvideo/api/uploader/api/upload/IProgressiveUploadSession;)V", "uploadLastPart", "", "file", "Ljava/io/File;", "partId", "", "filePath", "uploadPart", "android-video-uploader_release"})
    public final class ProgressiveUploadSession {
        @NotNull
        private final IProgressiveUploadSession session;

        public ProgressiveUploadSession(IProgressiveUploadSession session) {
            Intrinsics.checkNotNullParameter((Object)((Object)UploadService.this), (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            this.session = session;
        }

        @NotNull
        public final String uploadPart(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return this.uploadPart(new File(filePath));
        }

        @NotNull
        public final String uploadPart(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            UploadService uploadService = UploadService.this;
            int n = uploadService._totalNumOfUploads;
            uploadService._totalNumOfUploads = n + 1;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            String id = string;
            Future future2 = UploadService.this.executor.submit(new UploadTask(id, file, (Function2<? super File, ? super UploadProgressListener, ? extends Video>)((Function2)new Function2<File, UploadProgressListener, Video>(this){
                final /* synthetic */ ProgressiveUploadSession this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final Video invoke(@NotNull File fileToUpload, @NotNull UploadProgressListener progressListener) {
                    Intrinsics.checkNotNullParameter((Object)fileToUpload, (String)"fileToUpload");
                    Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
                    Video video = ProgressiveUploadSession.access$getSession$p(this.this$0).uploadPart(fileToUpload, (arg_0, arg_1) -> uploadPart.future.1.invoke$lambda-0(progressListener, arg_0, arg_1));
                    Intrinsics.checkNotNullExpressionValue((Object)video, (String)"session.uploadPart(\n    \u2026                        }");
                    return video;
                }

                private static final void invoke$lambda-0(UploadProgressListener $progressListener, Long bytesWritten, Long totalBytes) {
                    Intrinsics.checkNotNullParameter((Object)$progressListener, (String)"$progressListener");
                    $progressListener.onProgress(bytesWritten, totalBytes, 0, 0);
                }
            }), UploadService.this.listener));
            Map map = UploadService.this.uploadFuturesMap;
            Intrinsics.checkNotNullExpressionValue(future2, (String)"future");
            Future future3 = future2;
            map.put(id, future3);
            return id;
        }

        @NotNull
        public final String uploadPart(@NotNull String filePath, int partId) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return this.uploadPart(new File(filePath), partId);
        }

        @NotNull
        public final String uploadPart(@NotNull File file, int partId) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            UploadService uploadService = UploadService.this;
            int n = uploadService._totalNumOfUploads;
            uploadService._totalNumOfUploads = n + 1;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            String id = string;
            Future future2 = UploadService.this.executor.submit(new UploadTask(id, file, (Function2<? super File, ? super UploadProgressListener, ? extends Video>)((Function2)new Function2<File, UploadProgressListener, Video>(this, partId){
                final /* synthetic */ ProgressiveUploadSession this$0;
                final /* synthetic */ int $partId;
                {
                    this.this$0 = $receiver;
                    this.$partId = $partId;
                    super(2);
                }

                @NotNull
                public final Video invoke(@NotNull File fileToUpload, @NotNull UploadProgressListener progressListener) {
                    Intrinsics.checkNotNullParameter((Object)fileToUpload, (String)"fileToUpload");
                    Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
                    Video video = ProgressiveUploadSession.access$getSession$p(this.this$0).uploadPart(fileToUpload, this.$partId, (arg_0, arg_1) -> uploadPart.future.2.invoke$lambda-0(progressListener, arg_0, arg_1));
                    Intrinsics.checkNotNullExpressionValue((Object)video, (String)"session.uploadPart(\n    \u2026                        }");
                    return video;
                }

                private static final void invoke$lambda-0(UploadProgressListener $progressListener, Long bytesWritten, Long totalBytes) {
                    Intrinsics.checkNotNullParameter((Object)$progressListener, (String)"$progressListener");
                    $progressListener.onProgress(bytesWritten, totalBytes, 0, 0);
                }
            }), UploadService.this.listener));
            Map map = UploadService.this.uploadFuturesMap;
            Intrinsics.checkNotNullExpressionValue(future2, (String)"future");
            Future future3 = future2;
            map.put(id, future3);
            return id;
        }

        @NotNull
        public final String uploadLastPart(@NotNull String filePath) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return this.uploadLastPart(new File(filePath));
        }

        @NotNull
        public final String uploadLastPart(@NotNull File file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            UploadService uploadService = UploadService.this;
            int n = uploadService._totalNumOfUploads;
            uploadService._totalNumOfUploads = n + 1;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            String id = string;
            Future future2 = UploadService.this.executor.submit(new UploadTask(id, file, (Function2<? super File, ? super UploadProgressListener, ? extends Video>)((Function2)new Function2<File, UploadProgressListener, Video>(this){
                final /* synthetic */ ProgressiveUploadSession this$0;
                {
                    this.this$0 = $receiver;
                    super(2);
                }

                @NotNull
                public final Video invoke(@NotNull File fileToUpload, @NotNull UploadProgressListener progressListener) {
                    Intrinsics.checkNotNullParameter((Object)fileToUpload, (String)"fileToUpload");
                    Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
                    Video video = ProgressiveUploadSession.access$getSession$p(this.this$0).uploadLastPart(fileToUpload, (arg_0, arg_1) -> uploadLastPart.future.1.invoke$lambda-0(progressListener, arg_0, arg_1));
                    Intrinsics.checkNotNullExpressionValue((Object)video, (String)"session.uploadLastPart(\n\u2026                        }");
                    return video;
                }

                private static final void invoke$lambda-0(UploadProgressListener $progressListener, Long bytesWritten, Long totalBytes) {
                    Intrinsics.checkNotNullParameter((Object)$progressListener, (String)"$progressListener");
                    $progressListener.onProgress(bytesWritten, totalBytes, 0, 0);
                }
            }), UploadService.this.listener));
            Map map = UploadService.this.uploadFuturesMap;
            Intrinsics.checkNotNullExpressionValue(future2, (String)"future");
            Future future3 = future2;
            map.put(id, future3);
            return id;
        }

        @NotNull
        public final String uploadLastPart(@NotNull String filePath, int partId) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            return this.uploadLastPart(new File(filePath), partId);
        }

        @NotNull
        public final String uploadLastPart(@NotNull File file, int partId) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            UploadService uploadService = UploadService.this;
            int n = uploadService._totalNumOfUploads;
            uploadService._totalNumOfUploads = n + 1;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
            String id = string;
            Future future2 = UploadService.this.executor.submit(new UploadTask(id, file, (Function2<? super File, ? super UploadProgressListener, ? extends Video>)((Function2)new Function2<File, UploadProgressListener, Video>(this, partId){
                final /* synthetic */ ProgressiveUploadSession this$0;
                final /* synthetic */ int $partId;
                {
                    this.this$0 = $receiver;
                    this.$partId = $partId;
                    super(2);
                }

                @NotNull
                public final Video invoke(@NotNull File fileToUpload, @NotNull UploadProgressListener progressListener) {
                    Intrinsics.checkNotNullParameter((Object)fileToUpload, (String)"fileToUpload");
                    Intrinsics.checkNotNullParameter((Object)progressListener, (String)"progressListener");
                    Video video = ProgressiveUploadSession.access$getSession$p(this.this$0).uploadLastPart(fileToUpload, this.$partId, (arg_0, arg_1) -> uploadLastPart.future.2.invoke$lambda-0(progressListener, arg_0, arg_1));
                    Intrinsics.checkNotNullExpressionValue((Object)video, (String)"session.uploadLastPart(\n\u2026                        }");
                    return video;
                }

                private static final void invoke$lambda-0(UploadProgressListener $progressListener, Long bytesWritten, Long totalBytes) {
                    Intrinsics.checkNotNullParameter((Object)$progressListener, (String)"$progressListener");
                    $progressListener.onProgress(bytesWritten, totalBytes, 0, 0);
                }
            }), UploadService.this.listener));
            Map map = UploadService.this.uploadFuturesMap;
            Intrinsics.checkNotNullExpressionValue(future2, (String)"future");
            Future future3 = future2;
            map.put(id, future3);
            return id;
        }

        public static final /* synthetic */ IProgressiveUploadSession access$getSession$p(ProgressiveUploadSession $this) {
            return $this.session;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lvideo/api/uploader/api/services/UploadService$UploadServiceBinder;", "Landroid/os/Binder;", "(Lvideo/api/uploader/api/services/UploadService;)V", "service", "Lvideo/api/uploader/api/services/UploadService;", "getService", "()Lvideo/api/uploader/api/services/UploadService;", "android-video-uploader_release"})
    public final class UploadServiceBinder
    extends Binder {
        @NotNull
        private final UploadService service;

        public UploadServiceBinder() {
            Intrinsics.checkNotNullParameter((Object)((Object)UploadService.this), (String)"this$0");
            this.service = UploadService.this;
        }

        @NotNull
        public final UploadService getService() {
            return this.service;
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u00ac\u0001\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u000e\u0010\u0013\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00150\u00142\b\u0010\u0016\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u0010\u0017\u001a\u00020\u00182\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\n2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00100\u001b2#\u0010\u001c\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u001d\u00a2\u0006\f\b\u001e\u0012\b\b\u001f\u0012\u0004\b\b(\u001f\u0012\u0004\u0012\u00020\u00100\u001b2\n\b\u0002\u0010 \u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\"\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010#\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010$R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lvideo/api/uploader/api/services/UploadService$Companion;", "", "()V", "API_KEY_KEY", "", "APP_NAME_KEY", "APP_VERSION_KEY", "BASE_PATH_KEY", "DEFAULT_NOTIFICATION_CHANNEL_ID", "DEFAULT_NOTIFICATION_ID", "", "SDK_NAME_KEY", "SDK_VERSION_KEY", "TAG", "TIMEOUT_KEY", "startService", "", "context", "Landroid/content/Context;", "serviceClass", "Ljava/lang/Class;", "Lvideo/api/uploader/api/services/UploadService;", "apiKey", "environment", "Lvideo/api/uploader/api/models/Environment;", "timeout", "onServiceCreated", "Lkotlin/Function1;", "onServiceDisconnected", "Landroid/content/ComponentName;", "Lkotlin/ParameterName;", "name", "appName", "appVersion", "sdkName", "sdkVersion", "(Landroid/content/Context;Ljava/lang/Class;Ljava/lang/String;Lvideo/api/uploader/api/models/Environment;Ljava/lang/Integer;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "android-video-uploader_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void startService(@NotNull Context context, @NotNull Class<? extends UploadService> serviceClass, @Nullable String apiKey, @NotNull Environment environment, @Nullable Integer timeout, @NotNull Function1<? super UploadService, Unit> onServiceCreated, @NotNull Function1<? super ComponentName, Unit> onServiceDisconnected, @Nullable String appName, @Nullable String appVersion, @Nullable String sdkName, @Nullable String sdkVersion) {
            Object it;
            Object object;
            Intent intent;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter(serviceClass, (String)"serviceClass");
            Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
            Intrinsics.checkNotNullParameter(onServiceCreated, (String)"onServiceCreated");
            Intrinsics.checkNotNullParameter(onServiceDisconnected, (String)"onServiceDisconnected");
            ServiceConnection connection2 = new ServiceConnection(onServiceCreated, onServiceDisconnected){
                final /* synthetic */ Function1<UploadService, Unit> $onServiceCreated;
                final /* synthetic */ Function1<ComponentName, Unit> $onServiceDisconnected;
                {
                    this.$onServiceCreated = $onServiceCreated;
                    this.$onServiceDisconnected = $onServiceDisconnected;
                }

                public void onServiceConnected(@Nullable ComponentName name, @NotNull IBinder binder) {
                    Intrinsics.checkNotNullParameter((Object)binder, (String)"binder");
                    if (binder instanceof UploadServiceBinder) {
                        this.$onServiceCreated.invoke((Object)((Object)((UploadServiceBinder)binder).getService()));
                    }
                }

                public void onServiceDisconnected(@Nullable ComponentName name) {
                    this.$onServiceDisconnected.invoke((Object)name);
                }
            };
            Intent $this$startService_u24lambda_u2d6 = intent = new Intent(context, serviceClass);
            boolean bl = false;
            Object object2 = apiKey;
            if (object2 != null) {
                it = object = object2;
                boolean bl2 = false;
                $this$startService_u24lambda_u2d6.putExtra(UploadService.API_KEY_KEY, (String)it);
            }
            $this$startService_u24lambda_u2d6.putExtra(UploadService.BASE_PATH_KEY, environment.basePath);
            object2 = timeout;
            if (object2 != null) {
                object = object2;
                int it2 = ((Number)object).intValue();
                boolean bl3 = false;
                $this$startService_u24lambda_u2d6.putExtra(UploadService.TIMEOUT_KEY, it2);
            }
            object2 = sdkName;
            if (object2 != null) {
                it = object = object2;
                boolean bl4 = false;
                $this$startService_u24lambda_u2d6.putExtra(UploadService.SDK_NAME_KEY, (String)it);
            }
            object2 = sdkVersion;
            if (object2 != null) {
                it = object = object2;
                boolean bl5 = false;
                $this$startService_u24lambda_u2d6.putExtra(UploadService.SDK_VERSION_KEY, (String)it);
            }
            object2 = appName;
            if (object2 != null) {
                it = object = object2;
                boolean bl6 = false;
                $this$startService_u24lambda_u2d6.putExtra(UploadService.APP_NAME_KEY, (String)it);
            }
            object2 = appVersion;
            if (object2 != null) {
                it = object = object2;
                boolean bl7 = false;
                $this$startService_u24lambda_u2d6.putExtra(UploadService.APP_VERSION_KEY, (String)it);
            }
            Intent intent2 = intent;
            context.bindService(intent2, connection2, 1);
        }

        public static /* synthetic */ void startService$default(Companion companion, Context context, Class clazz, String string, Environment environment, Integer n, Function1 function1, Function1 function12, String string2, String string3, String string4, String string5, int n2, Object object) {
            if ((n2 & 8) != 0) {
                environment = Environment.PRODUCTION;
            }
            if ((n2 & 0x10) != 0) {
                n = null;
            }
            if ((n2 & 0x80) != 0) {
                string2 = null;
            }
            if ((n2 & 0x100) != 0) {
                string3 = null;
            }
            if ((n2 & 0x200) != 0) {
                string4 = null;
            }
            if ((n2 & 0x400) != 0) {
                string5 = null;
            }
            companion.startService(context, clazz, string, environment, n, (Function1<? super UploadService, Unit>)function1, (Function1<? super ComponentName, Unit>)function12, string2, string3, string4, string5);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

