/*
 * Decompiled with CFR 0.152.
 */
package video.api.videouploader_module;

import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.LongProgression;
import kotlin.ranges.RangesKt;
import okhttp3.Callback;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import video.api.videouploader_module.ApiError;
import video.api.videouploader_module.CallBack;
import video.api.videouploader_module.CallbackImpl;
import video.api.videouploader_module.RequestBodyUtil;
import video.api.videouploader_module.UploaderRequestExecutor;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J4\u0010\u0017\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00032\b\u0010\u000f\u001a\u0004\u0018\u00010\u00032\b\u0010\u0010\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J&\u0010\u0018\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0003X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lvideo/api/videouploader_module/VideoUploader;", "", "baseUri", "", "executorUploader", "Lvideo/api/videouploader_module/UploaderRequestExecutor;", "client", "Lokhttp3/OkHttpClient;", "chunkLength", "", "(Ljava/lang/String;Lvideo/api/videouploader_module/UploaderRequestExecutor;Lokhttp3/OkHttpClient;J)V", "userAgent", "upload", "", "apiPath", "bearerToken", "videoId", "file", "Ljava/io/File;", "callBack", "Lvideo/api/videouploader_module/CallBack;", "uploadBigFile", "_videoId", "uploadSmallFile", "uploadWithAuthentication", "uploadWithDelegatedToken", "delegatedToken", "Companion", "videouploader-module_release"})
public final class VideoUploader {
    private final String userAgent;
    private final String baseUri;
    private final UploaderRequestExecutor executorUploader;
    private final OkHttpClient client;
    private final long chunkLength;
    private static final String boundary;
    @NotNull
    public static final Companion Companion;

    public final void uploadWithDelegatedToken(@NotNull String delegatedToken, @NotNull File file, @NotNull CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)delegatedToken, (String)"delegatedToken");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        this.upload(this.baseUri + "/upload?token=" + delegatedToken, null, null, file, callBack);
    }

    public final void uploadWithAuthentication(@NotNull String bearerToken, @NotNull String videoId, @NotNull File file, @NotNull CallBack callBack) {
        Intrinsics.checkNotNullParameter((Object)bearerToken, (String)"bearerToken");
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)callBack, (String)"callBack");
        this.upload(this.baseUri + "/videos/" + videoId + "/source", bearerToken, videoId, file, callBack);
    }

    private final void upload(String apiPath, String bearerToken, String videoId, File file, CallBack callBack) {
        long size = file.length();
        if (size < this.chunkLength) {
            this.uploadSmallFile(apiPath, bearerToken, videoId, file, callBack);
        } else {
            this.uploadBigFile(apiPath, bearerToken, videoId, file, callBack);
        }
    }

    private final void uploadSmallFile(String apiPath, String bearerToken, String videoId, File file, CallBack callBack) {
        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), RequestBody.Companion.create$default((RequestBody.Companion)RequestBody.Companion, (File)file, null, (int)1, null));
        if (videoId != null) {
            requestBodyBuilder.addFormDataPart("videoId", videoId);
        }
        MultipartBody requestBody = requestBodyBuilder.build();
        Request.Builder requestBuilder = new Request.Builder().url(apiPath).addHeader("Content-Type", "multipart/form-data; boundary=" + boundary).addHeader("User-Agent", this.userAgent).post((RequestBody)requestBody);
        if (bearerToken != null) {
            requestBuilder.header("Authorization", "Bearer " + bearerToken);
        }
        this.executorUploader.execute(requestBuilder.build(), callBack);
    }

    /*
     * WARNING - void declaration
     */
    private final void uploadBigFile(String apiPath, String bearerToken, String _videoId, File file, CallBack callBack) {
        block14: {
            void result;
            long fileLength = file.length();
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = _videoId;
            Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
            objectRef2.element = null;
            try {
                Log.e((String)"chunkLength", (String)String.valueOf(this.chunkLength));
                byte[] b = new byte[(int)this.chunkLength];
                int bytesReads = 0;
                LongProgression longProgression = RangesKt.step((LongProgression)((LongProgression)RangesKt.until((int)0, (long)fileLength)), (long)this.chunkLength);
                long l = longProgression.getFirst();
                long l2 = longProgression.getLast();
                long l3 = longProgression.getStep();
                long l4 = l;
                long l5 = l2;
                if (l3 >= 0L ? l4 <= l5 : l4 >= l5) {
                    while (true) {
                        void fatal;
                        void apiError;
                        void videoId;
                        void offset;
                        int readBytes = 0;
                        File file2 = file;
                        boolean bl = false;
                        FileInputStream fileStream = new FileInputStream(file2);
                        int currentPosition = (int)offset + (int)this.chunkLength - 1;
                        if (offset > 0L) {
                            fileStream.skip((long)offset);
                        }
                        if ((long)currentPosition > fileLength) {
                            readBytes = fileStream.read(b, 0, (int)(fileLength - (long)bytesReads));
                            currentPosition = (int)file.length() - 1;
                        } else {
                            readBytes = fileStream.read(b, 0, (int)this.chunkLength);
                        }
                        bytesReads += readBytes;
                        ByteArrayOutputStream byteArrayOutput = new ByteArrayOutputStream();
                        byteArrayOutput.write(b, 0, readBytes);
                        ByteArrayInputStream byteArrayInput = new ByteArrayInputStream(byteArrayOutput.toByteArray());
                        RequestBody videoFile = RequestBodyUtil.Companion.create(byteArrayInput);
                        MultipartBody.Builder requestBodyBuilder = new MultipartBody.Builder(null, 1, null).setType(MultipartBody.FORM).addFormDataPart("file", file.getName(), videoFile);
                        if ((String)videoId.element != null) {
                            requestBodyBuilder.addFormDataPart("videoId", (String)videoId.element);
                        }
                        MultipartBody body = requestBodyBuilder.build();
                        Request.Builder requestBuilder = new Request.Builder().url(apiPath).addHeader("Content-Range", "bytes " + (int)offset + '-' + currentPosition + '/' + (int)file.length()).addHeader("User-Agent", this.userAgent).post((RequestBody)body);
                        if (bearerToken != null) {
                            requestBuilder.header("Authorization", "Bearer " + bearerToken);
                        }
                        CountDownLatch countDownLatch = new CountDownLatch(1);
                        Ref.ObjectRef objectRef3 = new Ref.ObjectRef();
                        objectRef3.element = null;
                        Ref.ObjectRef objectRef4 = new Ref.ObjectRef();
                        objectRef4.element = null;
                        this.client.newCall(requestBuilder.build()).enqueue((Callback)new CallbackImpl(new CallBack((Ref.ObjectRef)apiError, countDownLatch, (Ref.ObjectRef)fatal, (Ref.ObjectRef)videoId, (Ref.ObjectRef)result){
                            final /* synthetic */ Ref.ObjectRef $apiError;
                            final /* synthetic */ CountDownLatch $countDownLatch;
                            final /* synthetic */ Ref.ObjectRef $fatal;
                            final /* synthetic */ Ref.ObjectRef $videoId;
                            final /* synthetic */ Ref.ObjectRef $result;

                            public void onError(@NotNull ApiError e) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                this.$apiError.element = e;
                                this.$countDownLatch.countDown();
                            }

                            public void onFatal(@NotNull IOException e) {
                                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                                this.$fatal.element = e;
                                this.$countDownLatch.countDown();
                            }

                            public void onSuccess(@NotNull JSONObject r) {
                                Intrinsics.checkNotNullParameter((Object)r, (String)"r");
                                this.$videoId.element = r.getString("videoId");
                                this.$result.element = r;
                                this.$countDownLatch.countDown();
                            }
                            {
                                this.$apiError = $captured_local_variable$0;
                                this.$countDownLatch = $captured_local_variable$1;
                                this.$fatal = $captured_local_variable$2;
                                this.$videoId = $captured_local_variable$3;
                                this.$result = $captured_local_variable$4;
                            }
                        }));
                        countDownLatch.await();
                        byteArrayOutput.close();
                        byteArrayInput.close();
                        fileStream.close();
                        if ((IOException)fatal.element != null) {
                            IOException iOException = (IOException)fatal.element;
                            Intrinsics.checkNotNull((Object)iOException);
                            callBack.onFatal(iOException);
                        } else if ((ApiError)apiError.element != null) {
                            ApiError apiError2 = (ApiError)apiError.element;
                            Intrinsics.checkNotNull((Object)apiError2);
                            callBack.onError(apiError2);
                        } else if (offset != l2) {
                            offset += l3;
                            continue;
                        }
                        break;
                    }
                }
            }
            catch (IOException e) {
                callBack.onFatal(e);
            }
            JSONObject jSONObject = (JSONObject)result.element;
            if (jSONObject == null) break block14;
            JSONObject jSONObject2 = jSONObject;
            boolean bl = false;
            boolean bl2 = false;
            JSONObject it = jSONObject2;
            boolean bl3 = false;
            callBack.onSuccess(it);
        }
    }

    public VideoUploader(@NotNull String baseUri, @NotNull UploaderRequestExecutor executorUploader, @NotNull OkHttpClient client, long chunkLength) {
        Intrinsics.checkNotNullParameter((Object)baseUri, (String)"baseUri");
        Intrinsics.checkNotNullParameter((Object)executorUploader, (String)"executorUploader");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        this.baseUri = baseUri;
        this.executorUploader = executorUploader;
        this.client = client;
        this.chunkLength = chunkLength;
        this.userAgent = "api.video uploader (android; v:0.0.7; )";
        if (this.chunkLength < 0x500000L || this.chunkLength > 0x8000000L) {
            throw (Throwable)new IllegalArgumentException("Invalid chunk size: must be greater that 5MB and smaller than 128MB");
        }
    }

    public /* synthetic */ VideoUploader(String string, UploaderRequestExecutor uploaderRequestExecutor, OkHttpClient okHttpClient, long l, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            l = 0x3200000L;
        }
        this(string, uploaderRequestExecutor, okHttpClient, l);
    }

    static {
        Companion = new Companion(null);
        boundary = "----WebKitFormBoundary" + System.currentTimeMillis();
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvideo/api/videouploader_module/VideoUploader$Companion;", "", "()V", "boundary", "", "videouploader-module_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

