/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream;

import android.annotation.SuppressLint;
import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.util.Log;
import android.util.Size;
import android.view.Display;
import android.view.Surface;
import android.view.SurfaceHolder;
import androidx.annotation.RequiresPermission;
import io.github.thibaultbee.streampack.error.StreamPackError;
import io.github.thibaultbee.streampack.ext.rtmp.streamers.CameraRtmpLiveStreamer;
import io.github.thibaultbee.streampack.listeners.OnConnectionListener;
import io.github.thibaultbee.streampack.listeners.OnErrorListener;
import io.github.thibaultbee.streampack.streamers.interfaces.ICameraStreamer;
import io.github.thibaultbee.streampack.utils.CameraExtensionsKt;
import io.github.thibaultbee.streampack.views.CameraSizesKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.livestream.ApiVideoLiveStream;
import video.api.livestream.ExtensionsKt;
import video.api.livestream.R;
import video.api.livestream.enums.CameraFacingDirection;
import video.api.livestream.interfaces.IConnectionChecker;
import video.api.livestream.models.AudioConfig;
import video.api.livestream.models.VideoConfig;
import video.api.livestream.views.ApiVideoView;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000g\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\b\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005*\u0003\u001d *\u0018\u0000 ?2\u00020\u0001:\u0001?B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\b\u00107\u001a\u000208H\u0007J\u0018\u00109\u001a\u0002082\u0006\u0010:\u001a\u00020;2\b\b\u0002\u0010<\u001a\u00020;J\u0006\u0010=\u001a\u000208J\u0006\u0010>\u001a\u000208R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u0012\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u0007@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R$\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u00020\u001dX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010!R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\"\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u0011\u0010&\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b&\u0010#R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u00020*X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010+R$\u0010-\u001a\u00020,2\u0006\u0010\u0011\u001a\u00020,8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R$\u00102\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\t@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106\u00a8\u0006@"}, d2={"Lvideo/api/livestream/ApiVideoLiveStream;", "", "context", "Landroid/content/Context;", "connectionChecker", "Lvideo/api/livestream/interfaces/IConnectionChecker;", "initialAudioConfig", "Lvideo/api/livestream/models/AudioConfig;", "initialVideoConfig", "Lvideo/api/livestream/models/VideoConfig;", "initialCamera", "Lvideo/api/livestream/enums/CameraFacingDirection;", "apiVideoView", "Lvideo/api/livestream/views/ApiVideoView;", "(Landroid/content/Context;Lvideo/api/livestream/interfaces/IConnectionChecker;Lvideo/api/livestream/models/AudioConfig;Lvideo/api/livestream/models/VideoConfig;Lvideo/api/livestream/enums/CameraFacingDirection;Lvideo/api/livestream/views/ApiVideoView;)V", "_isStreaming", "", "value", "audioConfig", "getAudioConfig", "()Lvideo/api/livestream/models/AudioConfig;", "setAudioConfig", "(Lvideo/api/livestream/models/AudioConfig;)V", "camera", "getCamera", "()Lvideo/api/livestream/enums/CameraFacingDirection;", "setCamera", "(Lvideo/api/livestream/enums/CameraFacingDirection;)V", "connectionListener", "video/api/livestream/ApiVideoLiveStream$connectionListener$1", "Lvideo/api/livestream/ApiVideoLiveStream$connectionListener$1;", "errorListener", "video/api/livestream/ApiVideoLiveStream$errorListener$1", "Lvideo/api/livestream/ApiVideoLiveStream$errorListener$1;", "isMuted", "()Z", "setMuted", "(Z)V", "isStreaming", "streamer", "Lio/github/thibaultbee/streampack/ext/rtmp/streamers/CameraRtmpLiveStreamer;", "surfaceCallback", "video/api/livestream/ApiVideoLiveStream$surfaceCallback$1", "Lvideo/api/livestream/ApiVideoLiveStream$surfaceCallback$1;", "", "videoBitrate", "getVideoBitrate", "()I", "setVideoBitrate", "(I)V", "videoConfig", "getVideoConfig", "()Lvideo/api/livestream/models/VideoConfig;", "setVideoConfig", "(Lvideo/api/livestream/models/VideoConfig;)V", "startPreview", "", "startStreaming", "streamKey", "", "url", "stopPreview", "stopStreaming", "Companion", "livestream_release"})
public final class ApiVideoLiveStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final IConnectionChecker connectionChecker;
    @NotNull
    private final AudioConfig initialAudioConfig;
    @NotNull
    private final VideoConfig initialVideoConfig;
    @NotNull
    private final CameraFacingDirection initialCamera;
    @NotNull
    private final ApiVideoView apiVideoView;
    @NotNull
    private AudioConfig audioConfig;
    @NotNull
    private VideoConfig videoConfig;
    @NotNull
    private final connectionListener.1 connectionListener;
    @NotNull
    private final errorListener.1 errorListener;
    @NotNull
    private final surfaceCallback.1 surfaceCallback;
    @NotNull
    private final CameraRtmpLiveStreamer streamer;
    private boolean _isStreaming;
    @NotNull
    private static final String TAG = "ApiVideoLiveStream";

    @RequiresPermission(allOf={"android.permission.RECORD_AUDIO", "android.permission.CAMERA"})
    public ApiVideoLiveStream(@NotNull Context context, @NotNull IConnectionChecker connectionChecker, @NotNull AudioConfig initialAudioConfig, @NotNull VideoConfig initialVideoConfig, @NotNull CameraFacingDirection initialCamera, @NotNull ApiVideoView apiVideoView) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectionChecker, (String)"connectionChecker");
        Intrinsics.checkNotNullParameter((Object)initialAudioConfig, (String)"initialAudioConfig");
        Intrinsics.checkNotNullParameter((Object)initialVideoConfig, (String)"initialVideoConfig");
        Intrinsics.checkNotNullParameter((Object)((Object)initialCamera), (String)"initialCamera");
        Intrinsics.checkNotNullParameter((Object)((Object)apiVideoView), (String)"apiVideoView");
        this.context = context;
        this.connectionChecker = connectionChecker;
        this.initialAudioConfig = initialAudioConfig;
        this.initialVideoConfig = initialVideoConfig;
        this.initialCamera = initialCamera;
        this.apiVideoView = apiVideoView;
        this.audioConfig = this.initialAudioConfig;
        this.videoConfig = this.initialVideoConfig;
        this.connectionListener = new OnConnectionListener(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onFailed(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onConnectionFailed(message);
            }

            public void onLost(@NotNull String message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onDisconnect();
            }

            public void onSuccess() {
                ApiVideoLiveStream.access$getConnectionChecker$p(this.this$0).onConnectionSuccess();
            }
        };
        this.errorListener = new OnErrorListener(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            public void onError(@NotNull StreamPackError error) {
                Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                ApiVideoLiveStream.access$set_isStreaming$p(this.this$0, false);
                Log.e((String)"ApiVideoLiveStream", (String)"An error happened", (Throwable)((Throwable)error));
            }
        };
        this.surfaceCallback = new SurfaceHolder.Callback(this){
            final /* synthetic */ ApiVideoLiveStream this$0;
            {
                this.this$0 = $receiver;
            }

            @SuppressLint(value={"MissingPermission"})
            public void surfaceCreated(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                String string2 = ApiVideoLiveStream.access$getStreamer$p(this.this$0).getCamera();
                ApiVideoLiveStream apiVideoLiveStream = this.this$0;
                String it = string2;
                boolean bl = false;
                Display display = ApiVideoLiveStream.access$getApiVideoView$p(apiVideoLiveStream).getDisplay();
                Intrinsics.checkNotNullExpressionValue((Object)display, (String)"apiVideoView.display");
                Size previewSize = CameraSizesKt.getPreviewOutputSize$default((Display)display, (CameraCharacteristics)CameraExtensionsKt.getCameraCharacteristics((Context)ApiVideoLiveStream.access$getContext$p(apiVideoLiveStream), (String)it), SurfaceHolder.class, null, (int)8, null);
                Log.d((String)"ApiVideoLiveStream", (String)("View finder size: " + ApiVideoLiveStream.access$getApiVideoView$p(apiVideoLiveStream).getWidth() + " x " + ApiVideoLiveStream.access$getApiVideoView$p(apiVideoLiveStream).getHeight()));
                Log.d((String)"ApiVideoLiveStream", (String)Intrinsics.stringPlus((String)"Selected preview size: ", (Object)previewSize));
                ApiVideoLiveStream.access$getApiVideoView$p(apiVideoLiveStream).setAspectRatio(previewSize.getWidth(), previewSize.getHeight());
                ApiVideoLiveStream.access$getApiVideoView$p(apiVideoLiveStream).post(() -> surfaceCallback.1.surfaceCreated$lambda-1$lambda-0(apiVideoLiveStream));
            }

            public void surfaceChanged(@NotNull SurfaceHolder holder, int format, int width, int height) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
            }

            public void surfaceDestroyed(@NotNull SurfaceHolder holder) {
                Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
                this.this$0.stopStreaming();
                this.this$0.stopPreview();
            }

            private static final void surfaceCreated$lambda-1$lambda-0(ApiVideoLiveStream this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                ICameraStreamer iCameraStreamer = (ICameraStreamer)ApiVideoLiveStream.access$getStreamer$p(this$0);
                Surface surface = ApiVideoLiveStream.access$getApiVideoView$p(this$0).getHolder().getSurface();
                Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"apiVideoView.holder.surface");
                ICameraStreamer.DefaultImpls.startPreview$default((ICameraStreamer)iCameraStreamer, (Surface)surface, null, (int)2, null);
            }
        };
        this.streamer = new CameraRtmpLiveStreamer(this.context, null, true, (OnErrorListener)this.errorListener, (OnConnectionListener)this.connectionListener, 2, null);
        this.apiVideoView.getHolder().addCallback((SurfaceHolder.Callback)this.surfaceCallback);
        this.streamer.configure(this.audioConfig.toSdkConfig$livestream_release(), this.videoConfig.toSdkConfig$livestream_release());
    }

    public /* synthetic */ ApiVideoLiveStream(Context context, IConnectionChecker iConnectionChecker, AudioConfig audioConfig, VideoConfig videoConfig, CameraFacingDirection cameraFacingDirection, ApiVideoView apiVideoView, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            cameraFacingDirection = CameraFacingDirection.BACK;
        }
        this(context, iConnectionChecker, audioConfig, videoConfig, cameraFacingDirection, apiVideoView);
    }

    @NotNull
    public final AudioConfig getAudioConfig() {
        return this.audioConfig;
    }

    @RequiresPermission(value="android.permission.RECORD_AUDIO")
    public final void setAudioConfig(@NotNull AudioConfig value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("You have to stop streaming first");
        }
        this.streamer.configure(value.toSdkConfig$livestream_release());
        this.audioConfig = value;
    }

    @NotNull
    public final VideoConfig getVideoConfig() {
        return this.videoConfig;
    }

    @RequiresPermission(allOf={"android.permission.CAMERA", "android.permission.RECORD_AUDIO"})
    public final void setVideoConfig(@NotNull VideoConfig value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("You have to stop streaming first");
        }
        if (this.videoConfig.getResolution() != value.getResolution()) {
            Log.i((String)Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName(), (String)("Resolution has been changed from " + (Object)((Object)this.videoConfig.getResolution()) + " to " + (Object)((Object)value.getResolution()) + ". Restarting preview."));
            this.stopPreview();
            this.streamer.configure(value.toSdkConfig$livestream_release());
            ICameraStreamer iCameraStreamer = (ICameraStreamer)this.streamer;
            Surface surface = this.apiVideoView.getHolder().getSurface();
            Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"apiVideoView.holder.surface");
            ICameraStreamer.DefaultImpls.startPreview$default((ICameraStreamer)iCameraStreamer, (Surface)surface, null, (int)2, null);
        }
        this.videoConfig = value;
    }

    public final int getVideoBitrate() {
        return this.streamer.getSettings().getVideo().getBitrate();
    }

    public final void setVideoBitrate(int value) {
        this.streamer.getSettings().getVideo().setBitrate(value);
    }

    @NotNull
    public final CameraFacingDirection getCamera() {
        return CameraExtensionsKt.isFrontCamera((Context)this.context, (String)this.streamer.getCamera()) ? CameraFacingDirection.FRONT : CameraFacingDirection.BACK;
    }

    public final void setCamera(@NotNull CameraFacingDirection value) {
        Intrinsics.checkNotNullParameter((Object)((Object)value), (String)"value");
        if (value == CameraFacingDirection.BACK && CameraExtensionsKt.isFrontCamera((Context)this.context, (String)this.streamer.getCamera()) || value == CameraFacingDirection.FRONT && CameraExtensionsKt.isBackCamera((Context)this.context, (String)this.streamer.getCamera())) {
            List cameraList = value == CameraFacingDirection.BACK ? CameraExtensionsKt.getBackCameraList((Context)this.context) : CameraExtensionsKt.getFrontCameraList((Context)this.context);
            this.streamer.setCamera((String)cameraList.get(0));
        }
    }

    public final boolean isMuted() {
        return this.streamer.getSettings().getAudio().isMuted();
    }

    public final void setMuted(boolean value) {
        this.streamer.getSettings().getAudio().setMuted(value);
    }

    public final void startStreaming(@NotNull String streamKey, @NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)streamKey, (String)"streamKey");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        if (this.isStreaming()) {
            throw new UnsupportedOperationException("Stream is already started");
        }
        if (((CharSequence)streamKey).length() == 0) {
            throw new IllegalArgumentException("Stream key must not be empty");
        }
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, url, streamKey, null){
            int label;
            final /* synthetic */ ApiVideoLiveStream this$0;
            final /* synthetic */ String $url;
            final /* synthetic */ String $streamKey;
            {
                this.this$0 = $receiver;
                this.$url = $url;
                this.$streamKey = $streamKey;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var2_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = ApiVideoLiveStream.access$getStreamer$p(this.this$0).startStream(Intrinsics.stringPlus((String)ExtensionsKt.addTrailingSlashIfNeeded(this.$url), (Object)this.$streamKey), (Continuation)this);
                        if (v0 == var2_2) {
                            return var2_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        ApiVideoLiveStream.access$set_isStreaming$p(this.this$0, true);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void startStreaming$default(ApiVideoLiveStream apiVideoLiveStream, String string2, String string3, int n, Object object) {
        if ((n & 2) != 0) {
            String string4 = apiVideoLiveStream.context.getString(R.string.default_rtmp_url);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"fun startStreaming(\n    \u2026ng = true\n        }\n    }");
            string3 = string4;
        }
        apiVideoLiveStream.startStreaming(string2, string3);
    }

    public final void stopStreaming() {
        this.streamer.stopStream();
        this._isStreaming = false;
    }

    public final boolean isStreaming() {
        return this._isStreaming;
    }

    @RequiresPermission(value="android.permission.CAMERA")
    public final void startPreview() {
        ICameraStreamer iCameraStreamer = (ICameraStreamer)this.streamer;
        Surface surface = this.apiVideoView.getHolder().getSurface();
        Intrinsics.checkNotNullExpressionValue((Object)surface, (String)"apiVideoView.holder.surface");
        ICameraStreamer.DefaultImpls.startPreview$default((ICameraStreamer)iCameraStreamer, (Surface)surface, null, (int)2, null);
    }

    public final void stopPreview() {
        this.streamer.stopPreview();
    }

    public static final /* synthetic */ CameraRtmpLiveStreamer access$getStreamer$p(ApiVideoLiveStream $this) {
        return $this.streamer;
    }

    public static final /* synthetic */ void access$set_isStreaming$p(ApiVideoLiveStream $this, boolean bl) {
        $this._isStreaming = bl;
    }

    public static final /* synthetic */ IConnectionChecker access$getConnectionChecker$p(ApiVideoLiveStream $this) {
        return $this.connectionChecker;
    }

    public static final /* synthetic */ ApiVideoView access$getApiVideoView$p(ApiVideoLiveStream $this) {
        return $this.apiVideoView;
    }

    public static final /* synthetic */ Context access$getContext$p(ApiVideoLiveStream $this) {
        return $this.context;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lvideo/api/livestream/ApiVideoLiveStream$Companion;", "", "()V", "TAG", "", "livestream_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

