/*
 * Decompiled with CFR 0.152.
 */
package video.api.livestream_module;

import android.content.Context;
import android.view.SurfaceView;
import com.pedro.encoder.input.video.CameraHelper;
import com.pedro.rtplibrary.base.Camera1Base;
import com.pedro.rtplibrary.rtmp.RtmpCamera1;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.ossrs.rtmp.ConnectCheckerRtmp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.livestream_module.model.LiveStream;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0011B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream;", "", "config", "Lvideo/api/livestream_module/ApiVideoLiveStream$Config;", "(Lvideo/api/livestream_module/ApiVideoLiveStream$Config;)V", "start", "Lcom/pedro/rtplibrary/base/Camera1Base;", "streamKey", "", "surfaceView", "Landroid/view/SurfaceView;", "context", "Landroid/content/Context;", "connectChecker", "Lnet/ossrs/rtmp/ConnectCheckerRtmp;", "liveStream", "Lvideo/api/livestream_module/model/LiveStream;", "Config", "livestream-module_release"})
public final class ApiVideoLiveStream {
    private final Config config;

    @NotNull
    public final Camera1Base start(@NotNull LiveStream liveStream, @NotNull SurfaceView surfaceView, @NotNull Context context, @NotNull ConnectCheckerRtmp connectChecker) {
        Intrinsics.checkNotNullParameter((Object)liveStream, (String)"liveStream");
        Intrinsics.checkNotNullParameter((Object)surfaceView, (String)"surfaceView");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        String string = liveStream.getStreamKey();
        Intrinsics.checkNotNull((Object)string);
        return this.start(string, surfaceView, context, connectChecker);
    }

    @NotNull
    public final Camera1Base start(@NotNull LiveStream liveStream, @NotNull Context context, @NotNull ConnectCheckerRtmp connectChecker) {
        Intrinsics.checkNotNullParameter((Object)liveStream, (String)"liveStream");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        String string = liveStream.getStreamKey();
        Intrinsics.checkNotNull((Object)string);
        return this.start(string, null, context, connectChecker);
    }

    @NotNull
    public final Camera1Base start(@NotNull String streamKey, @Nullable SurfaceView surfaceView, @NotNull Context context, @NotNull ConnectCheckerRtmp connectChecker) {
        Intrinsics.checkNotNullParameter((Object)streamKey, (String)"streamKey");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)connectChecker, (String)"connectChecker");
        RtmpCamera1 rtmpCamera1 = surfaceView != null ? new RtmpCamera1(surfaceView, connectChecker) : new RtmpCamera1(context, connectChecker);
        boolean audioReady = rtmpCamera1.prepareAudio(this.config.getAudioBitrate(), this.config.getAudioSampleRate(), this.config.getStereo(), this.config.getEchoCanceler(), this.config.getNoiseSuppressor());
        boolean videoReady = rtmpCamera1.prepareVideo(this.config.getVideoQuality().getWidth(), this.config.getVideoQuality().getHeight(), this.config.getVideoFps(), this.config.getVideoBitrate(), this.config.getVideoHardwareRotation(), CameraHelper.getCameraOrientation((Context)context));
        if (audioReady && videoReady) {
            rtmpCamera1.startStream("rtmp://broadcast.api.video/s/" + streamKey);
            return (Camera1Base)rtmpCamera1;
        }
        throw (Throwable)new IOException("Could not start RTMP streaming. audioReady=" + audioReady + ", videoReady=" + videoReady);
    }

    public ApiVideoLiveStream(@NotNull Config config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.config = config;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u00002\u00020\u0001:\u0002\u001b\u001cBO\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0003\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u0003\u0012\u0006\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0010R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\t\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u0011\u0010\f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0010R\u0011\u0010\r\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0013R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006\u001d"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream$Config;", "", "audioBitrate", "", "audioSampleRate", "stereo", "", "echoCanceler", "noiseSuppressor", "videoBitrate", "videoQuality", "Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "videoFps", "videoHardwareRotation", "(IIZZZILvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;IZ)V", "getAudioBitrate", "()I", "getAudioSampleRate", "getEchoCanceler", "()Z", "getNoiseSuppressor", "getStereo", "getVideoBitrate", "getVideoFps", "getVideoHardwareRotation", "getVideoQuality", "()Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "Builder", "Quality", "livestream-module_release"})
    public static final class Config {
        private final int audioBitrate;
        private final int audioSampleRate;
        private final boolean stereo;
        private final boolean echoCanceler;
        private final boolean noiseSuppressor;
        private final int videoBitrate;
        @NotNull
        private final Quality videoQuality;
        private final int videoFps;
        private final boolean videoHardwareRotation;

        public final int getAudioBitrate() {
            return this.audioBitrate;
        }

        public final int getAudioSampleRate() {
            return this.audioSampleRate;
        }

        public final boolean getStereo() {
            return this.stereo;
        }

        public final boolean getEchoCanceler() {
            return this.echoCanceler;
        }

        public final boolean getNoiseSuppressor() {
            return this.noiseSuppressor;
        }

        public final int getVideoBitrate() {
            return this.videoBitrate;
        }

        @NotNull
        public final Quality getVideoQuality() {
            return this.videoQuality;
        }

        public final int getVideoFps() {
            return this.videoFps;
        }

        public final boolean getVideoHardwareRotation() {
            return this.videoHardwareRotation;
        }

        private Config(int audioBitrate, int audioSampleRate, boolean stereo, boolean echoCanceler, boolean noiseSuppressor, int videoBitrate, Quality videoQuality, int videoFps, boolean videoHardwareRotation) {
            this.audioBitrate = audioBitrate;
            this.audioSampleRate = audioSampleRate;
            this.stereo = stereo;
            this.echoCanceler = echoCanceler;
            this.noiseSuppressor = noiseSuppressor;
            this.videoBitrate = videoBitrate;
            this.videoQuality = videoQuality;
            this.videoFps = videoFps;
            this.videoHardwareRotation = videoHardwareRotation;
        }

        public /* synthetic */ Config(int audioBitrate, int audioSampleRate, boolean stereo, boolean echoCanceler, boolean noiseSuppressor, int videoBitrate, Quality videoQuality, int videoFps, boolean videoHardwareRotation, DefaultConstructorMarker $constructor_marker) {
            this(audioBitrate, audioSampleRate, stereo, echoCanceler, noiseSuppressor, videoBitrate, videoQuality, videoFps, videoHardwareRotation);
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007j\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\fj\u0002\b\r\u00a8\u0006\u000e"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "", "width", "", "height", "(Ljava/lang/String;III)V", "getHeight", "()I", "getWidth", "QUALITY_240", "QUALITY_480", "QUALITY_720", "QUALITY_1080", "QUALITY_2160", "livestream-module_release"})
        public static final class Quality
        extends Enum<Quality> {
            public static final /* enum */ Quality QUALITY_240;
            public static final /* enum */ Quality QUALITY_480;
            public static final /* enum */ Quality QUALITY_720;
            public static final /* enum */ Quality QUALITY_1080;
            public static final /* enum */ Quality QUALITY_2160;
            private static final /* synthetic */ Quality[] $VALUES;
            private final int width;
            private final int height;

            static {
                Quality[] qualityArray = new Quality[5];
                Quality[] qualityArray2 = qualityArray;
                qualityArray[0] = QUALITY_240 = new Quality(352, 240);
                qualityArray[1] = QUALITY_480 = new Quality(858, 480);
                qualityArray[2] = QUALITY_720 = new Quality(1280, 720);
                qualityArray[3] = QUALITY_1080 = new Quality(1920, 1080);
                qualityArray[4] = QUALITY_2160 = new Quality(3860, 2160);
                $VALUES = qualityArray;
            }

            public final int getWidth() {
                return this.width;
            }

            public final int getHeight() {
                return this.height;
            }

            private Quality(int width, int height) {
                this.width = width;
                this.height = height;
            }

            public static Quality[] values() {
                return (Quality[])$VALUES.clone();
            }

            public static Quality valueOf(String string) {
                return Enum.valueOf(Quality.class, string);
            }
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B_\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\u0003\u0012\b\b\u0002\u0010\r\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003J\u0006\u0010'\u001a\u00020(J\t\u0010)\u001a\u00020\u0003H\u00c6\u0003J\t\u0010*\u001a\u00020\u0003H\u00c6\u0003J\t\u0010+\u001a\u00020\u0006H\u00c6\u0003J\t\u0010,\u001a\u00020\u0006H\u00c6\u0003J\t\u0010-\u001a\u00020\u0006H\u00c6\u0003J\t\u0010.\u001a\u00020\u0003H\u00c6\u0003J\t\u0010/\u001a\u00020\u000bH\u00c6\u0003J\t\u00100\u001a\u00020\u0003H\u00c6\u0003J\t\u00101\u001a\u00020\u0006H\u00c6\u0003Jc\u00102\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\u00032\b\b\u0002\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u0006H\u00c6\u0001J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\u0006J\u0013\u00104\u001a\u00020\u00062\b\u00105\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u00106\u001a\u00020\u0003H\u00d6\u0001J\u000e\u00107\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0006J\u000e\u00108\u001a\u00020\u00002\u0006\u00108\u001a\u00020\u0006J\t\u00109\u001a\u00020:H\u00d6\u0001J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003J\u000e\u0010\f\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\u0003J\u000e\u0010\r\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u0006J\u000e\u0010\n\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u000bR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0010\"\u0004\b\u0018\u0010\u0012R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0014\"\u0004\b\u001a\u0010\u0016R\u001a\u0010\b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0014\"\u0004\b\u001c\u0010\u0016R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0010\"\u0004\b\u001e\u0010\u0012R\u001a\u0010\f\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0010\"\u0004\b \u0010\u0012R\u001a\u0010\r\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0014\"\u0004\b\"\u0010\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&\u00a8\u0006;"}, d2={"Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Builder;", "", "audioBitrate", "", "audioSampleRate", "audioStereo", "", "audioCancelEcho", "audioSuppressNoise", "videoBitrate", "videoQuality", "Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "videoFps", "videoHardwareRotation", "(IIZZZILvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;IZ)V", "getAudioBitrate", "()I", "setAudioBitrate", "(I)V", "getAudioCancelEcho", "()Z", "setAudioCancelEcho", "(Z)V", "getAudioSampleRate", "setAudioSampleRate", "getAudioStereo", "setAudioStereo", "getAudioSuppressNoise", "setAudioSuppressNoise", "getVideoBitrate", "setVideoBitrate", "getVideoFps", "setVideoFps", "getVideoHardwareRotation", "setVideoHardwareRotation", "getVideoQuality", "()Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;", "setVideoQuality", "(Lvideo/api/livestream_module/ApiVideoLiveStream$Config$Quality;)V", "build", "Lvideo/api/livestream_module/ApiVideoLiveStream$Config;", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "echoCanceler", "equals", "other", "hashCode", "noiseSuppressor", "stereo", "toString", "", "livestream-module_release"})
        public static final class Builder {
            private int audioBitrate;
            private int audioSampleRate;
            private boolean audioStereo;
            private boolean audioCancelEcho;
            private boolean audioSuppressNoise;
            private int videoBitrate;
            @NotNull
            private Quality videoQuality;
            private int videoFps;
            private boolean videoHardwareRotation;

            @NotNull
            public final Builder audioBitrate(int audioBitrate) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioBitrate = audioBitrate;
                return builder;
            }

            @NotNull
            public final Builder audioSampleRate(int audioSampleRate) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioSampleRate = audioSampleRate;
                return builder;
            }

            @NotNull
            public final Builder stereo(boolean stereo) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioStereo = stereo;
                return builder;
            }

            @NotNull
            public final Builder echoCanceler(boolean audioCancelEcho) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioCancelEcho = audioCancelEcho;
                return builder;
            }

            @NotNull
            public final Builder noiseSuppressor(boolean audioSuppressNoise) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.audioSuppressNoise = audioSuppressNoise;
                return builder;
            }

            @NotNull
            public final Builder videoBitrate(int videoBitrate) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.videoBitrate = videoBitrate;
                return builder;
            }

            @NotNull
            public final Builder videoQuality(@NotNull Quality videoQuality) {
                Intrinsics.checkNotNullParameter((Object)((Object)videoQuality), (String)"videoQuality");
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.videoQuality = videoQuality;
                return builder;
            }

            @NotNull
            public final Builder videoFps(int videoFps) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.videoFps = videoFps;
                return builder;
            }

            @NotNull
            public final Builder videoHardwareRotation(boolean videoHardwareRotation) {
                Builder builder = this;
                boolean bl = false;
                boolean bl2 = false;
                Builder $this$apply = builder;
                boolean bl3 = false;
                $this$apply.videoHardwareRotation = videoHardwareRotation;
                return builder;
            }

            @NotNull
            public final Config build() {
                return new Config(this.audioBitrate, this.audioSampleRate, this.audioStereo, this.audioCancelEcho, this.audioSuppressNoise, this.videoBitrate, this.videoQuality, this.videoFps, this.videoHardwareRotation, null);
            }

            public final int getAudioBitrate() {
                return this.audioBitrate;
            }

            public final void setAudioBitrate(int n) {
                this.audioBitrate = n;
            }

            public final int getAudioSampleRate() {
                return this.audioSampleRate;
            }

            public final void setAudioSampleRate(int n) {
                this.audioSampleRate = n;
            }

            public final boolean getAudioStereo() {
                return this.audioStereo;
            }

            public final void setAudioStereo(boolean bl) {
                this.audioStereo = bl;
            }

            public final boolean getAudioCancelEcho() {
                return this.audioCancelEcho;
            }

            public final void setAudioCancelEcho(boolean bl) {
                this.audioCancelEcho = bl;
            }

            public final boolean getAudioSuppressNoise() {
                return this.audioSuppressNoise;
            }

            public final void setAudioSuppressNoise(boolean bl) {
                this.audioSuppressNoise = bl;
            }

            public final int getVideoBitrate() {
                return this.videoBitrate;
            }

            public final void setVideoBitrate(int n) {
                this.videoBitrate = n;
            }

            @NotNull
            public final Quality getVideoQuality() {
                return this.videoQuality;
            }

            public final void setVideoQuality(@NotNull Quality quality) {
                Intrinsics.checkNotNullParameter((Object)((Object)quality), (String)"<set-?>");
                this.videoQuality = quality;
            }

            public final int getVideoFps() {
                return this.videoFps;
            }

            public final void setVideoFps(int n) {
                this.videoFps = n;
            }

            public final boolean getVideoHardwareRotation() {
                return this.videoHardwareRotation;
            }

            public final void setVideoHardwareRotation(boolean bl) {
                this.videoHardwareRotation = bl;
            }

            public Builder(int audioBitrate, int audioSampleRate, boolean audioStereo, boolean audioCancelEcho, boolean audioSuppressNoise, int videoBitrate, @NotNull Quality videoQuality, int videoFps, boolean videoHardwareRotation) {
                Intrinsics.checkNotNullParameter((Object)((Object)videoQuality), (String)"videoQuality");
                this.audioBitrate = audioBitrate;
                this.audioSampleRate = audioSampleRate;
                this.audioStereo = audioStereo;
                this.audioCancelEcho = audioCancelEcho;
                this.audioSuppressNoise = audioSuppressNoise;
                this.videoBitrate = videoBitrate;
                this.videoQuality = videoQuality;
                this.videoFps = videoFps;
                this.videoHardwareRotation = videoHardwareRotation;
            }

            public /* synthetic */ Builder(int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, Quality quality, int n4, boolean bl4, int n5, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n5 & 1) != 0) {
                    n = 128000;
                }
                if ((n5 & 2) != 0) {
                    n2 = 44100;
                }
                if ((n5 & 4) != 0) {
                    bl = true;
                }
                if ((n5 & 8) != 0) {
                    bl2 = false;
                }
                if ((n5 & 0x10) != 0) {
                    bl3 = false;
                }
                if ((n5 & 0x20) != 0) {
                    n3 = 4500000;
                }
                if ((n5 & 0x40) != 0) {
                    quality = Quality.QUALITY_720;
                }
                if ((n5 & 0x80) != 0) {
                    n4 = 25;
                }
                if ((n5 & 0x100) != 0) {
                    bl4 = false;
                }
                this(n, n2, bl, bl2, bl3, n3, quality, n4, bl4);
            }

            public Builder() {
                this(0, 0, false, false, false, 0, null, 0, false, 511, null);
            }

            public final int component1() {
                return this.audioBitrate;
            }

            public final int component2() {
                return this.audioSampleRate;
            }

            public final boolean component3() {
                return this.audioStereo;
            }

            public final boolean component4() {
                return this.audioCancelEcho;
            }

            public final boolean component5() {
                return this.audioSuppressNoise;
            }

            public final int component6() {
                return this.videoBitrate;
            }

            @NotNull
            public final Quality component7() {
                return this.videoQuality;
            }

            public final int component8() {
                return this.videoFps;
            }

            public final boolean component9() {
                return this.videoHardwareRotation;
            }

            @NotNull
            public final Builder copy(int audioBitrate, int audioSampleRate, boolean audioStereo, boolean audioCancelEcho, boolean audioSuppressNoise, int videoBitrate, @NotNull Quality videoQuality, int videoFps, boolean videoHardwareRotation) {
                Intrinsics.checkNotNullParameter((Object)((Object)videoQuality), (String)"videoQuality");
                return new Builder(audioBitrate, audioSampleRate, audioStereo, audioCancelEcho, audioSuppressNoise, videoBitrate, videoQuality, videoFps, videoHardwareRotation);
            }

            public static /* synthetic */ Builder copy$default(Builder builder, int n, int n2, boolean bl, boolean bl2, boolean bl3, int n3, Quality quality, int n4, boolean bl4, int n5, Object object) {
                if ((n5 & 1) != 0) {
                    n = builder.audioBitrate;
                }
                if ((n5 & 2) != 0) {
                    n2 = builder.audioSampleRate;
                }
                if ((n5 & 4) != 0) {
                    bl = builder.audioStereo;
                }
                if ((n5 & 8) != 0) {
                    bl2 = builder.audioCancelEcho;
                }
                if ((n5 & 0x10) != 0) {
                    bl3 = builder.audioSuppressNoise;
                }
                if ((n5 & 0x20) != 0) {
                    n3 = builder.videoBitrate;
                }
                if ((n5 & 0x40) != 0) {
                    quality = builder.videoQuality;
                }
                if ((n5 & 0x80) != 0) {
                    n4 = builder.videoFps;
                }
                if ((n5 & 0x100) != 0) {
                    bl4 = builder.videoHardwareRotation;
                }
                return builder.copy(n, n2, bl, bl2, bl3, n3, quality, n4, bl4);
            }

            @NotNull
            public String toString() {
                return "Builder(audioBitrate=" + this.audioBitrate + ", audioSampleRate=" + this.audioSampleRate + ", audioStereo=" + this.audioStereo + ", audioCancelEcho=" + this.audioCancelEcho + ", audioSuppressNoise=" + this.audioSuppressNoise + ", videoBitrate=" + this.videoBitrate + ", videoQuality=" + (Object)((Object)this.videoQuality) + ", videoFps=" + this.videoFps + ", videoHardwareRotation=" + this.videoHardwareRotation + ")";
            }

            public int hashCode() {
                int n = (Integer.hashCode(this.audioBitrate) * 31 + Integer.hashCode(this.audioSampleRate)) * 31;
                int n2 = this.audioStereo ? 1 : 0;
                if (n2 != 0) {
                    n2 = 1;
                }
                int n3 = (n + n2) * 31;
                int n4 = this.audioCancelEcho ? 1 : 0;
                if (n4 != 0) {
                    n4 = 1;
                }
                int n5 = (n3 + n4) * 31;
                int n6 = this.audioSuppressNoise ? 1 : 0;
                if (n6 != 0) {
                    n6 = 1;
                }
                Quality quality = this.videoQuality;
                int n7 = ((((n5 + n6) * 31 + Integer.hashCode(this.videoBitrate)) * 31 + (quality != null ? ((Object)((Object)quality)).hashCode() : 0)) * 31 + Integer.hashCode(this.videoFps)) * 31;
                int n8 = this.videoHardwareRotation ? 1 : 0;
                if (n8 != 0) {
                    n8 = 1;
                }
                return n7 + n8;
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof Builder)) break block3;
                        Builder builder = (Builder)object;
                        if (this.audioBitrate != builder.audioBitrate || this.audioSampleRate != builder.audioSampleRate || this.audioStereo != builder.audioStereo || this.audioCancelEcho != builder.audioCancelEcho || this.audioSuppressNoise != builder.audioSuppressNoise || this.videoBitrate != builder.videoBitrate || !Intrinsics.areEqual((Object)((Object)this.videoQuality), (Object)((Object)builder.videoQuality)) || this.videoFps != builder.videoFps || this.videoHardwareRotation != builder.videoHardwareRotation) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

