/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.work;

import android.content.Context;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.Operation;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import video.api.client.api.upload.IProgressiveUploadSession;
import video.api.client.api.work.OperationWithRequest;
import video.api.client.api.work.stores.ProgressiveUploadSessionStore;
import video.api.client.api.work.workers.ProgressiveUploadWorker;
import video.api.client.api.work.workers.UploadWorker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J$\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J$\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u001c\u0010\u0017\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\u00042\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J2\u0010\u0018\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u0010\b\u0002\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0007J@\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0002J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001bH\u0007J.\u0010\u0018\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dJ(\u0010\u001f\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0003J8\u0010\u001f\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0\u001dH\u0003J(\u0010\u001f\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!H\u0007J8\u0010\u001f\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020!2\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\"0\u001dH\u0007J,\u0010#\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J<\u0010#\u001a\u00020\u00192\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0007J,\u0010#\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0004H\u0007J<\u0010#\u001a\u00020\u00192\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u000e\u0010\u001c\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001e0\u001dH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lvideo/api/client/api/work/UploadWorkerHelper;", "", "()V", "PREFIX_SESSION_ID", "", "PREFIX_TOKEN", "PREFIX_VIDEO_ID", "cancel", "Landroidx/work/Operation;", "context", "Landroid/content/Context;", "videoId", "workManager", "Landroidx/work/WorkManager;", "cancelProgressiveUploadSession", "", "session", "Lvideo/api/client/api/upload/IProgressiveUploadSession;", "cancelWithUploadToken", "token", "generateSessionTag", "sessionIndex", "", "generateTag", "upload", "Lvideo/api/client/api/work/OperationWithRequest;", "file", "Ljava/io/File;", "workerClass", "Ljava/lang/Class;", "Lvideo/api/client/api/work/workers/UploadWorker;", "uploadPart", "isLastPart", "", "Lvideo/api/client/api/work/workers/ProgressiveUploadWorker;", "uploadWithUploadToken", "android-api-client_release"})
public final class UploadWorkerHelper {
    @NotNull
    public static final UploadWorkerHelper INSTANCE = new UploadWorkerHelper();
    @NotNull
    private static final String PREFIX_VIDEO_ID = "videoId=";
    @NotNull
    private static final String PREFIX_TOKEN = "token=";
    @NotNull
    private static final String PREFIX_SESSION_ID = "sessionIndex=";

    private UploadWorkerHelper() {
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest upload(@NotNull Context context, @NotNull String videoId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        return UploadWorkerHelper.upload(workManager, videoId, file);
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest upload(@NotNull Context context, @NotNull String videoId, @NotNull File file, @NotNull Class<? extends UploadWorker> workerClass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        return INSTANCE.upload(workManager, videoId, file, workerClass);
    }

    public static /* synthetic */ OperationWithRequest upload$default(Context context, String string2, File file, Class clazz, int n, Object object) {
        if ((n & 8) != 0) {
            clazz = UploadWorker.class;
        }
        return UploadWorkerHelper.upload(context, string2, file, clazz);
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest upload(@NotNull WorkManager workManager, @NotNull String videoId, @NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return INSTANCE.upload(workManager, videoId, file, UploadWorker.class);
    }

    @NotNull
    public final OperationWithRequest upload(@NotNull WorkManager workManager, @NotNull String videoId, @NotNull File file, @NotNull Class<? extends UploadWorker> workerClass) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
        return this.upload(workManager, file, null, videoId, workerClass);
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest uploadWithUploadToken(@NotNull Context context, @NotNull String token, @NotNull File file, @Nullable String videoId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        return UploadWorkerHelper.uploadWithUploadToken(workManager, token, file, videoId, UploadWorker.class);
    }

    public static /* synthetic */ OperationWithRequest uploadWithUploadToken$default(Context context, String string2, File file, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return UploadWorkerHelper.uploadWithUploadToken(context, string2, file, string3);
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest uploadWithUploadToken(@NotNull Context context, @NotNull String token, @NotNull File file, @Nullable String videoId, @NotNull Class<? extends UploadWorker> workerClass) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        return UploadWorkerHelper.uploadWithUploadToken(workManager, token, file, videoId, workerClass);
    }

    public static /* synthetic */ OperationWithRequest uploadWithUploadToken$default(Context context, String string2, File file, String string3, Class clazz, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return UploadWorkerHelper.uploadWithUploadToken(context, string2, file, string3, (Class<? extends UploadWorker>)clazz);
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest uploadWithUploadToken(@NotNull WorkManager workManager, @NotNull String token, @NotNull File file, @Nullable String videoId) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UploadWorkerHelper.uploadWithUploadToken(workManager, token, file, videoId, UploadWorker.class);
    }

    public static /* synthetic */ OperationWithRequest uploadWithUploadToken$default(WorkManager workManager, String string2, File file, String string3, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return UploadWorkerHelper.uploadWithUploadToken(workManager, string2, file, string3);
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest uploadWithUploadToken(@NotNull WorkManager workManager, @NotNull String token, @NotNull File file, @Nullable String videoId, @NotNull Class<? extends UploadWorker> workerClass) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
        return INSTANCE.upload(workManager, file, token, videoId, workerClass);
    }

    public static /* synthetic */ OperationWithRequest uploadWithUploadToken$default(WorkManager workManager, String string2, File file, String string3, Class clazz, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return UploadWorkerHelper.uploadWithUploadToken(workManager, string2, file, string3, (Class<? extends UploadWorker>)clazz);
    }

    private final OperationWithRequest upload(WorkManager workManager, File file, String token, String videoId, Class<? extends UploadWorker> workerClass) {
        if (!(token != null || videoId != null)) {
            boolean bl = false;
            String string2 = "You must provide either a token or a videoId";
            throw new IllegalArgumentException(string2.toString());
        }
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(workerClass).setConstraints(new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build())).setInputData(UploadWorker.Companion.createInputData(token, videoId, file))).addTag(this.generateTag(videoId, token))).build();
        Operation operation = workManager.enqueue((WorkRequest)workRequest);
        Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"workManager.enqueue(workRequest)");
        return new OperationWithRequest(operation, (WorkRequest)workRequest);
    }

    static /* synthetic */ OperationWithRequest upload$default(UploadWorkerHelper uploadWorkerHelper, WorkManager workManager, File file, String string2, String string3, Class clazz, int n, Object object) {
        if ((n & 4) != 0) {
            string2 = null;
        }
        if ((n & 8) != 0) {
            string3 = null;
        }
        return uploadWorkerHelper.upload(workManager, file, string2, string3, clazz);
    }

    @JvmStatic
    @NotNull
    public static final Operation cancel(@NotNull Context context, @NotNull String videoId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        return UploadWorkerHelper.cancel(workManager, videoId);
    }

    @JvmStatic
    @NotNull
    public static final Operation cancel(@NotNull WorkManager workManager, @NotNull String videoId) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        Operation operation = workManager.cancelAllWorkByTag(INSTANCE.generateTag(videoId, null));
        Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"workManager.cancelAllWor\u2026nerateTag(videoId, null))");
        return operation;
    }

    @JvmStatic
    @NotNull
    public static final Operation cancelWithUploadToken(@NotNull Context context, @NotNull String token, @Nullable String videoId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        return UploadWorkerHelper.cancelWithUploadToken(workManager, token, videoId);
    }

    public static /* synthetic */ Operation cancelWithUploadToken$default(Context context, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return UploadWorkerHelper.cancelWithUploadToken(context, string2, string3);
    }

    @JvmStatic
    @NotNull
    public static final Operation cancelWithUploadToken(@NotNull WorkManager workManager, @NotNull String token, @Nullable String videoId) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Operation operation = workManager.cancelAllWorkByTag(INSTANCE.generateTag(videoId, token));
        Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"workManager.cancelAllWor\u2026erateTag(videoId, token))");
        return operation;
    }

    public static /* synthetic */ Operation cancelWithUploadToken$default(WorkManager workManager, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = null;
        }
        return UploadWorkerHelper.cancelWithUploadToken(workManager, string2, string3);
    }

    private final String generateTag(String videoId, String token) {
        return "(videoId=" + videoId + ", token=" + token + ')';
    }

    @JvmStatic
    private static final OperationWithRequest uploadPart(Context context, IProgressiveUploadSession session, File file, boolean isLastPart) {
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        return UploadWorkerHelper.uploadPart(workManager, session, file, isLastPart, ProgressiveUploadWorker.class);
    }

    @JvmStatic
    private static final OperationWithRequest uploadPart(Context context, IProgressiveUploadSession session, File file, boolean isLastPart, Class<? extends ProgressiveUploadWorker> workerClass) {
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        return UploadWorkerHelper.uploadPart(workManager, session, file, isLastPart, workerClass);
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest uploadPart(@NotNull WorkManager workManager, @NotNull IProgressiveUploadSession session, @NotNull File file, boolean isLastPart) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        return UploadWorkerHelper.uploadPart(workManager, session, file, isLastPart, ProgressiveUploadWorker.class);
    }

    @JvmStatic
    @NotNull
    public static final OperationWithRequest uploadPart(@NotNull WorkManager workManager, @NotNull IProgressiveUploadSession session, @NotNull File file, boolean isLastPart, @NotNull Class<? extends ProgressiveUploadWorker> workerClass) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(workerClass, (String)"workerClass");
        int sessionIndex = ProgressiveUploadSessionStore.INSTANCE.add(session);
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(workerClass).setConstraints(new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build())).setInputData(ProgressiveUploadWorker.Companion.createInputData(sessionIndex, file, isLastPart))).addTag(INSTANCE.generateSessionTag(sessionIndex))).build();
        Operation operation = workManager.enqueue((WorkRequest)workRequest);
        Intrinsics.checkNotNullExpressionValue((Object)operation, (String)"workManager.enqueue(workRequest)");
        return new OperationWithRequest(operation, (WorkRequest)workRequest);
    }

    @JvmStatic
    public static final void cancelProgressiveUploadSession(@NotNull Context context, @NotNull IProgressiveUploadSession session) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        WorkManager workManager = WorkManager.getInstance((Context)context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        UploadWorkerHelper.cancelProgressiveUploadSession(workManager, session);
    }

    @JvmStatic
    public static final void cancelProgressiveUploadSession(@NotNull WorkManager workManager, @NotNull IProgressiveUploadSession session) {
        Intrinsics.checkNotNullParameter((Object)workManager, (String)"workManager");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        int sessionIndex = ProgressiveUploadSessionStore.INSTANCE.indexOf(session);
        workManager.cancelAllWorkByTag(INSTANCE.generateSessionTag(sessionIndex));
    }

    private final String generateSessionTag(int sessionIndex) {
        return "(sessionIndex=" + sessionIndex + ')';
    }
}

