/*
 * Decompiled with CFR 0.152.
 */
package video.api.client.api.clients;

import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import okhttp3.Call;
import video.api.client.api.ApiCallback;
import video.api.client.api.ApiClient;
import video.api.client.api.ApiException;
import video.api.client.api.ApiResponse;
import video.api.client.api.Pair;
import video.api.client.api.models.Caption;
import video.api.client.api.models.CaptionsListResponse;
import video.api.client.api.models.CaptionsUpdatePayload;
import video.api.client.api.models.Environment;
import video.api.client.api.models.Page;

public class CaptionsApi {
    private ApiClient localVarApiClient;

    public CaptionsApi(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public CaptionsApi() {
        this.localVarApiClient = new ApiClient(Environment.PRODUCTION.basePath);
    }

    public CaptionsApi(String basePath) {
        this.localVarApiClient = new ApiClient(basePath);
    }

    public CaptionsApi(String apiKey, String basePath) {
        this.localVarApiClient = new ApiClient(apiKey, basePath);
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    private Call uploadCall(String videoId, String language, File file, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/captions/{language}".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString())).replaceAll("\\{language\\}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (file != null) {
            localVarFormParams.put("file", file);
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"multipart/form-data"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call uploadValidateBeforeCall(String videoId, String language, File file, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling upload");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling upload");
        }
        if (file == null) {
            throw new ApiException("Missing the required parameter 'file' when calling upload");
        }
        Call localVarCall = this.uploadCall(videoId, language, file, _callback);
        return localVarCall;
    }

    public Caption upload(String videoId, String language, File file) throws ApiException {
        ApiResponse<Caption> localVarResp = this.uploadWithHttpInfo(videoId, language, file);
        return localVarResp.getData();
    }

    public ApiResponse<Caption> uploadWithHttpInfo(String videoId, String language, File file) throws ApiException {
        Call localVarCall = this.uploadValidateBeforeCall(videoId, language, file, null);
        Type localVarReturnType = new TypeToken<Caption>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call getCall(String videoId, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/captions/{language}".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString())).replaceAll("\\{language\\}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call getValidateBeforeCall(String videoId, String language, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling get");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling get");
        }
        Call localVarCall = this.getCall(videoId, language, _callback);
        return localVarCall;
    }

    public Caption get(String videoId, String language) throws ApiException {
        ApiResponse<Caption> localVarResp = this.getWithHttpInfo(videoId, language);
        return localVarResp.getData();
    }

    public ApiResponse<Caption> getWithHttpInfo(String videoId, String language) throws ApiException {
        Call localVarCall = this.getValidateBeforeCall(videoId, language, null);
        Type localVarReturnType = new TypeToken<Caption>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call updateCall(String videoId, String language, CaptionsUpdatePayload captionsUpdatePayload, ApiCallback _callback) throws ApiException {
        CaptionsUpdatePayload localVarPostBody = captionsUpdatePayload;
        String localVarPath = "/videos/{videoId}/captions/{language}".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString())).replaceAll("\\{language\\}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/json"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "PATCH", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call updateValidateBeforeCall(String videoId, String language, CaptionsUpdatePayload captionsUpdatePayload, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling update");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling update");
        }
        if (captionsUpdatePayload == null) {
            throw new ApiException("Missing the required parameter 'captionsUpdatePayload' when calling update");
        }
        Call localVarCall = this.updateCall(videoId, language, captionsUpdatePayload, _callback);
        return localVarCall;
    }

    public Caption update(String videoId, String language, CaptionsUpdatePayload captionsUpdatePayload) throws ApiException {
        ApiResponse<Caption> localVarResp = this.updateWithHttpInfo(videoId, language, captionsUpdatePayload);
        return localVarResp.getData();
    }

    public ApiResponse<Caption> updateWithHttpInfo(String videoId, String language, CaptionsUpdatePayload captionsUpdatePayload) throws ApiException {
        Call localVarCall = this.updateValidateBeforeCall(videoId, language, captionsUpdatePayload, null);
        Type localVarReturnType = new TypeToken<Caption>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteCall(String videoId, String language, ApiCallback _callback) throws ApiException {
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/captions/{language}".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString())).replaceAll("\\{language\\}", this.localVarApiClient.escapeString(language.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call deleteValidateBeforeCall(String videoId, String language, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling delete");
        }
        if (language == null) {
            throw new ApiException("Missing the required parameter 'language' when calling delete");
        }
        Call localVarCall = this.deleteCall(videoId, language, _callback);
        return localVarCall;
    }

    public void delete(String videoId, String language) throws ApiException {
        this.deleteWithHttpInfo(videoId, language);
    }

    public ApiResponse<Void> deleteWithHttpInfo(String videoId, String language) throws ApiException {
        Call localVarCall = this.deleteValidateBeforeCall(videoId, language, null);
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call listCall(String videoId, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        Object localVarPostBody = null;
        String localVarPath = "/videos/{videoId}/captions".replaceAll("\\{videoId\\}", this.localVarApiClient.escapeString(videoId.toString()));
        ArrayList<Pair> localVarQueryParams = new ArrayList<Pair>();
        ArrayList<Pair> localVarCollectionQueryParams = new ArrayList<Pair>();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap<String, String> localVarCookieParams = new HashMap<String, String>();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (currentPage != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("currentPage", currentPage));
        }
        if (pageSize != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("pageSize", pageSize));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);
        String[] localVarAuthNames = new String[]{"bearerAuth"};
        return this.localVarApiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames, _callback);
    }

    private Call listValidateBeforeCall(String videoId, Integer currentPage, Integer pageSize, ApiCallback _callback) throws ApiException {
        if (videoId == null) {
            throw new ApiException("Missing the required parameter 'videoId' when calling list");
        }
        Call localVarCall = this.listCall(videoId, currentPage, pageSize, _callback);
        return localVarCall;
    }

    private ApiResponse<CaptionsListResponse> listWithHttpInfo(String videoId, Integer currentPage, Integer pageSize) throws ApiException {
        Call localVarCall = this.listValidateBeforeCall(videoId, currentPage, pageSize, null);
        Type localVarReturnType = new TypeToken<CaptionsListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    public APIlistRequest list(String videoId) {
        return new APIlistRequest(videoId);
    }

    public class APIlistRequest {
        private final String videoId;
        private Integer currentPage;
        private Integer pageSize;

        private APIlistRequest(String videoId) {
            this.videoId = videoId;
        }

        public APIlistRequest currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public APIlistRequest pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Call buildCall(ApiCallback _callback) throws ApiException {
            return CaptionsApi.this.listCall(this.videoId, this.currentPage, this.pageSize, _callback);
        }

        public Page<Caption> execute() throws ApiException {
            ApiResponse localVarResp = CaptionsApi.this.listWithHttpInfo(this.videoId, this.currentPage, this.pageSize);
            return new Page<Caption>(((CaptionsListResponse)localVarResp.getData()).getData(), ((CaptionsListResponse)localVarResp.getData()).getPagination(), () -> {
                try {
                    return this.copy().currentPage((this.currentPage == null ? 1 : this.currentPage) + 1).execute();
                }
                catch (ApiException e) {
                    throw new RuntimeException(e);
                }
            });
        }

        private APIlistRequest copy() {
            APIlistRequest copy = new APIlistRequest(this.videoId);
            copy.currentPage(this.currentPage);
            copy.pageSize(this.pageSize);
            return copy;
        }

        public ApiResponse<CaptionsListResponse> executeWithHttpInfo() throws ApiException {
            return CaptionsApi.this.listWithHttpInfo(this.videoId, this.currentPage, this.pageSize);
        }
    }
}

