/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.ToolContext;
import org.apache.velocity.tools.Toolbox;
import org.apache.velocity.tools.view.ServletUtils;
import org.apache.velocity.tools.view.ViewContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ViewToolContext
extends ToolContext
implements ViewContext {
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ServletContext application;
    private final VelocityEngine velocity;

    public ViewToolContext(VelocityEngine velocity, HttpServletRequest request, HttpServletResponse response, ServletContext application) {
        super(velocity);
        this.velocity = velocity;
        this.request = request;
        this.response = response;
        this.application = application;
        this.putToolProperties();
    }

    protected void putToolProperties() {
        this.putToolProperty("request", this.getRequest());
        this.putToolProperty("response", this.getResponse());
        this.putToolProperty("session", this.getSession());
        this.putToolProperty("servletContext", this.getServletContext());
        this.putToolProperty("requestPath", ServletUtils.getPath(this.getRequest()));
    }

    public Map<String, Object> getToolbox() {
        HashMap<String, Object> aggregate = new HashMap<String, Object>();
        Map<String, Object> toolProps = this.getToolProperties();
        for (Toolbox toolbox : this.getToolboxes()) {
            aggregate.putAll(toolbox.getAll(toolProps));
        }
        return aggregate;
    }

    @Override
    protected List<Toolbox> getToolboxes() {
        if (super.getToolboxes().isEmpty()) {
            this.addToolboxesUnderKey(DEFAULT_TOOLBOX_KEY);
        }
        return super.getToolboxes();
    }

    public void addToolboxesUnderKey(String toolboxKey) {
        Toolbox appTools;
        Toolbox sessTools;
        Toolbox reqTools = (Toolbox)this.getRequest().getAttribute(toolboxKey);
        if (reqTools != null) {
            this.addToolbox(reqTools);
        }
        if (this.getSession() != null && (sessTools = (Toolbox)this.getSession().getAttribute(toolboxKey)) != null) {
            this.addToolbox(sessTools);
        }
        if ((appTools = (Toolbox)this.getServletContext().getAttribute(toolboxKey)) != null) {
            this.addToolbox(appTools);
        }
    }

    @Override
    public Object get(String key) {
        Object o = this.findTool(key);
        if (o != null) {
            return o;
        }
        o = this.getServletApi(key);
        if (o != null) {
            return o;
        }
        o = this.internalGet(key);
        if (o != null) {
            return o;
        }
        return this.getAttribute(key);
    }

    protected Object getServletApi(String key) {
        if (key.equals("request")) {
            return this.request;
        }
        if (key.equals("response")) {
            return this.response;
        }
        if (key.equals("session")) {
            return this.getSession();
        }
        if (key.equals("application")) {
            return this.application;
        }
        return null;
    }

    @Override
    public Object getAttribute(String key) {
        Object o = this.request.getAttribute(key);
        if (o == null) {
            if (this.getSession() != null) {
                try {
                    o = this.getSession().getAttribute(key);
                }
                catch (IllegalStateException ise) {
                    o = null;
                }
            }
            if (o == null) {
                o = this.application.getAttribute(key);
            }
        }
        return o;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    public HttpSession getSession() {
        return this.getRequest().getSession(false);
    }

    @Override
    public ServletContext getServletContext() {
        return this.application;
    }

    @Override
    public Context getVelocityContext() {
        return this;
    }

    @Override
    public VelocityEngine getVelocityEngine() {
        return this.velocity;
    }
}

