/*
 * Decompiled with CFR 0.152.
 */
package com.recurly.android.network;

import android.net.Uri;
import com.android.volley.AuthFailureError;
import com.android.volley.Cache;
import com.android.volley.NetworkResponse;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.HttpHeaderParser;
import com.google.gson.Gson;
import com.recurly.android.model.BaseModel;
import com.recurly.android.network.NetworkResponseError;
import com.recurly.android.network.ResponseHandler;
import com.recurly.android.network.request.BaseRequest;
import com.recurly.android.network.response.StringResponse;
import com.recurly.android.util.RecurlyLog;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

public class RecurlyRequest<Res extends BaseModel>
extends Request<Res> {
    private static Gson sErrorParser = new Gson();
    private BaseRequest mOriginalRequest;
    private Class<Res> mResponseClass;
    private ResponseHandler<Res> mHandler;
    private Map<String, String> mHeaders = new HashMap<String, String>();
    private Map<String, Object> mPostParams;

    public RecurlyRequest(BaseRequest originalRequest, Class<Res> responseClass, int method, String url, ResponseHandler<Res> handler) {
        super(method, url, handler);
        this.mOriginalRequest = originalRequest;
        this.mResponseClass = responseClass;
        this.mHandler = handler;
    }

    public static String buildRequestUrl(String baseUrl, HashMap<String, String> params) {
        Uri.Builder builder = Uri.parse((String)baseUrl).buildUpon();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            builder.appendQueryParameter(entry.getKey(), entry.getValue());
        }
        return builder.build().toString();
    }

    public String getBodyContentType() {
        if (this.mPostParams != null) {
            return "application/json";
        }
        return super.getBodyContentType();
    }

    public byte[] getBody() throws AuthFailureError {
        if (this.mPostParams != null) {
            Gson gson = new Gson();
            String body = gson.toJson(this.mPostParams);
            return body.getBytes();
        }
        return super.getBody();
    }

    protected Response<Res> parseNetworkResponse(NetworkResponse networkResponse) {
        BaseModel parsedResponse;
        String responseString = null;
        try {
            responseString = new String(networkResponse.data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        try {
            NetworkResponseError model = (NetworkResponseError)((Object)sErrorParser.fromJson(responseString, NetworkResponseError.class));
            if (model.isError()) {
                this.mOriginalRequest.setFinished(true);
                return Response.error((VolleyError)model);
            }
        }
        catch (Exception ex) {
            // empty catch block
        }
        RecurlyLog.d("Response code " + networkResponse.statusCode);
        RecurlyLog.d("Response string " + responseString);
        if (this.mResponseClass == StringResponse.class) {
            parsedResponse = new StringResponse(responseString);
        } else {
            try {
                parsedResponse = (BaseModel)BaseModel.getParser().fromJson(responseString, this.mResponseClass);
            }
            catch (Exception ex) {
                RecurlyLog.d("Error parsing response " + responseString);
                ex.printStackTrace();
                this.mOriginalRequest.setFinished(true);
                return Response.error((VolleyError)new VolleyError((Throwable)ex));
            }
        }
        this.mOriginalRequest.setFinished(true);
        return Response.success((Object)parsedResponse, (Cache.Entry)HttpHeaderParser.parseCacheHeaders((NetworkResponse)networkResponse));
    }

    protected void deliverResponse(Res res) {
        if (this.mHandler != null) {
            this.mHandler.onResponse(res);
        }
    }

    public Map<String, String> getHeaders() throws AuthFailureError {
        Map headers = super.getHeaders();
        if (headers == null) {
            return this.mHeaders;
        }
        this.mHeaders.putAll(headers);
        return this.mHeaders;
    }

    public void setHeaders(Map<String, String> headers) {
        this.mHeaders = headers;
    }

    public void setPostParams(Map<String, Object> params) {
        this.mPostParams = params;
    }

    public BaseRequest getOriginalRequest() {
        return this.mOriginalRequest;
    }
}

