/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.shape.primitives.Box3D;
import us.ihmc.euclid.shape.primitives.interfaces.Shape3DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class BoxTerrainObject
implements TerrainObject3D,
HeightMapWithNormals {
    private final BoundingBox3D boundingBox;
    private Graphics3DObject linkGraphics;
    private final ArrayList<Shape3DReadOnly> terrainCollisionShapes = new ArrayList();

    public BoxTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double zStart, double zEnd, AppearanceDefinition appearance) {
        double xMin = Math.min(xStart, xEnd);
        double xMax = Math.max(xStart, xEnd);
        double yMin = Math.min(yStart, yEnd);
        double yMax = Math.max(yStart, yEnd);
        double zMin = Math.min(zStart, zEnd);
        double zMax = Math.max(zStart, zEnd);
        Point3D minPoint = new Point3D(xMin, yMin, zMin);
        Point3D maxPoint = new Point3D(xMax, yMax, zMax);
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)minPoint, (Point3DReadOnly)maxPoint);
        this.linkGraphics = new Graphics3DObject();
        this.linkGraphics.translate((xStart + xEnd) / 2.0, (yStart + yEnd) / 2.0, zMin);
        this.linkGraphics.addCube(Math.abs(xEnd - xStart), Math.abs(yEnd - yStart), zMax - zMin, appearance);
        Box3D boxShape = new Box3D(Math.abs(xStart - xEnd), Math.abs(yStart - yEnd), Math.abs(zStart - zEnd));
        boxShape.getPose().getTranslation().set((xStart + xEnd) / 2.0, (yStart + yEnd) / 2.0, (zStart + zEnd) / 2.0);
        this.terrainCollisionShapes.add((Shape3DReadOnly)boxShape);
    }

    public BoxTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double height, AppearanceDefinition appearance) {
        this(xStart, yStart, xEnd, yEnd, 0.0, height, appearance);
    }

    public BoxTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double height) {
        this(xStart, yStart, xEnd, yEnd, height, YoAppearance.Gray());
    }

    public BoxTerrainObject(double xStart, double yStart, double xEnd, double yEnd, double zStart, double zEnd) {
        this(xStart, yStart, xEnd, yEnd, zStart, zEnd, YoAppearance.Gray());
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        if (x > this.boundingBox.getMinX() && x < this.boundingBox.getMaxX() && y > this.boundingBox.getMinY() && y < this.boundingBox.getMaxY()) {
            return this.boundingBox.getMaxZ();
        }
        return 0.0;
    }

    private void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        double threshhold = 0.015;
        normal.setX(0.0);
        normal.setY(0.0);
        normal.setZ(1.0);
        if (!this.boundingBox.isXYInsideInclusive(x, y) || z > this.boundingBox.getMaxZ() - threshhold) {
            return;
        }
        if (Math.abs(x - this.boundingBox.getMinX()) < threshhold) {
            normal.setX(-1.0);
            normal.setY(0.0);
            normal.setZ(0.0);
        } else if (Math.abs(x - this.boundingBox.getMaxX()) < threshhold) {
            normal.setX(1.0);
            normal.setY(0.0);
            normal.setZ(0.0);
        } else if (Math.abs(y - this.boundingBox.getMinY()) < threshhold) {
            normal.setX(0.0);
            normal.setY(-1.0);
            normal.setZ(0.0);
        } else if (Math.abs(y - this.boundingBox.getMaxY()) < threshhold) {
            normal.setX(0.0);
            normal.setY(1.0);
            normal.setZ(0.0);
        }
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersection, Vector3DBasics normal) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normal);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        intersectionToPack.setX(x);
        intersectionToPack.setY(y);
        intersectionToPack.setZ(this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normalToPack);
        return z < intersectionToPack.getZ();
    }

    public boolean isClose(double x, double y, double z) {
        return this.boundingBox.isXYInsideInclusive(x, y);
    }

    public double getXMin() {
        return this.boundingBox.getMinX();
    }

    public double getYMin() {
        return this.boundingBox.getMinY();
    }

    public double getXMax() {
        return this.boundingBox.getMaxX();
    }

    public double getYMax() {
        return this.boundingBox.getMaxY();
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }

    public List<Shape3DReadOnly> getTerrainCollisionShapes() {
        return this.terrainCollisionShapes;
    }
}

