/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicVector;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.simulationconstructionset.ContactingExternalForcePoint;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;

public class ContactingExternalForcePointsVisualizer {
    private static final ReferenceFrame worldFrame = ReferenceFrame.getWorldFrame();
    private final YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final List<YoFramePoint3D> contactPointsWorld = new ArrayList<YoFramePoint3D>();
    private final List<YoGraphicPosition> contactPointsViz = new ArrayList<YoGraphicPosition>();
    private final List<YoFrameVector3D> contactNormals = new ArrayList<YoFrameVector3D>();
    private final List<YoGraphicVector> contactNormalsViz = new ArrayList<YoGraphicVector>();
    private final List<YoFrameVector3D> forceVectors = new ArrayList<YoFrameVector3D>();
    private final List<YoGraphicVector> forceVectorsViz = new ArrayList<YoGraphicVector>();
    private double normalVectorScale = 0.03;
    private double forceVectorScale = 0.01;
    private final ArrayList<ContactingExternalForcePoint> contactPoints = new ArrayList();
    private final Point3D tempPoint = new Point3D();
    private final Vector3D tempVector = new Vector3D();

    public ContactingExternalForcePointsVisualizer(int maxNumberOfYoGraphicPositions, YoGraphicsListRegistry yoGraphicsListRegistry, YoRegistry parentRegistry) {
        for (int i = 0; i < maxNumberOfYoGraphicPositions; ++i) {
            YoFramePoint3D contactPointWorld = new YoFramePoint3D("contactPoint" + i, worldFrame, this.registry);
            this.contactPointsWorld.add(contactPointWorld);
            YoGraphicPosition yoGraphicPosition = new YoGraphicPosition("contactViz" + i, contactPointWorld, 0.01, YoAppearance.Crimson());
            this.contactPointsViz.add(yoGraphicPosition);
            yoGraphicsListRegistry.registerYoGraphic("contactPoints", (YoGraphic)yoGraphicPosition);
            YoFrameVector3D normalVector = new YoFrameVector3D("contactNormal" + i, worldFrame, this.registry);
            this.contactNormals.add(normalVector);
            YoGraphicVector contactNormalViz = new YoGraphicVector("contactNormalViz" + i, contactPointWorld, normalVector, YoAppearance.Gold());
            contactNormalViz.setDrawArrowhead(false);
            contactNormalViz.setLineRadiusWhenOneMeterLong(0.005);
            this.contactNormalsViz.add(contactNormalViz);
            yoGraphicsListRegistry.registerYoGraphic("contactPoints", (YoGraphic)contactNormalViz);
            YoFrameVector3D forceVector = new YoFrameVector3D("forceVector" + i, worldFrame, this.registry);
            this.forceVectors.add(forceVector);
            YoGraphicVector forceVectorViz = new YoGraphicVector("forceVectorViz" + i, contactPointWorld, forceVector, YoAppearance.Crimson());
            forceVectorViz.setDrawArrowhead(false);
            this.forceVectorsViz.add(forceVectorViz);
            yoGraphicsListRegistry.registerYoGraphic("contactPoints", (YoGraphic)forceVectorViz);
        }
        parentRegistry.addChild(this.registry);
    }

    public void setNormalVectorScale(double normalVectorScale) {
        this.normalVectorScale = normalVectorScale;
    }

    public void setForceVectorScale(double forceVectorScale) {
        this.forceVectorScale = forceVectorScale;
    }

    public void addPoints(List<ContactingExternalForcePoint> contactingExternalForcePoints) {
        this.contactPoints.addAll(contactingExternalForcePoints);
    }

    public void update() {
        int yoGraphicIndex = 0;
        for (int contactPointIndex = 0; contactPointIndex < Math.min(this.contactPoints.size(), this.contactPointsWorld.size()); ++contactPointIndex) {
            ContactingExternalForcePoint contactPoint = this.contactPoints.get(contactPointIndex);
            if (!contactPoint.isInContact()) continue;
            contactPoint.getPosition((Tuple3DBasics)this.tempPoint);
            this.contactPointsWorld.get(yoGraphicIndex).set((Tuple3DReadOnly)this.tempPoint);
            contactPoint.getSurfaceNormalInWorld((Vector3DBasics)this.tempVector);
            this.tempVector.scale(this.normalVectorScale);
            this.contactNormals.get(yoGraphicIndex).set((Tuple3DReadOnly)this.tempVector);
            contactPoint.getForce((Vector3DBasics)this.tempVector);
            this.tempVector.scale(this.forceVectorScale);
            this.forceVectors.get(yoGraphicIndex).set((Tuple3DReadOnly)this.tempVector);
            this.contactPointsViz.get(yoGraphicIndex).update();
            this.contactNormalsViz.get(yoGraphicIndex).update();
            this.forceVectorsViz.get(yoGraphicIndex).update();
            ++yoGraphicIndex;
        }
        for (int j = yoGraphicIndex; j < this.contactPointsViz.size(); ++j) {
            this.contactPointsWorld.get(j).setToNaN();
            this.contactNormals.get(j).set(Double.NaN, Double.NaN, Double.NaN);
        }
    }
}

