/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.simulatedSensors;

import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.jMonkeyEngineToolkit.GPULidar;
import us.ihmc.jMonkeyEngineToolkit.Graphics3DAdapter;
import us.ihmc.robotics.robotDescription.LidarSensorDescription;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.SimulatedSensor;

public class LidarMount
implements SimulatedSensor {
    private final LidarSensorDescription description;
    protected RigidBodyTransform transformToHere = new RigidBodyTransform();
    private final RigidBodyTransform transformFromJoint;
    private GPULidar lidar;
    private final String lidarName;
    private Joint parentJoint;

    public LidarMount(LidarSensorDescription description) {
        this.description = description;
        this.transformFromJoint = new RigidBodyTransform((RigidBodyTransformReadOnly)description.getTransformToJoint());
        this.lidarName = description.getName();
    }

    @Override
    public void updateTransform(RigidBodyTransformReadOnly transformToHere, double time) {
        this.transformToHere.set(transformToHere);
        this.transformToHere.multiply((RigidBodyTransformReadOnly)this.transformFromJoint);
        if (this.lidar != null) {
            this.lidar.setTransformFromWorld(this.transformToHere, time);
        }
    }

    @Override
    public String getName() {
        return this.lidarName;
    }

    public void setLidar(GPULidar lidar) {
        this.lidar = lidar;
    }

    public LidarSensorDescription getDescription() {
        return this.description;
    }

    @Override
    public void setWorld(Graphics3DAdapter graphics3dAdapter) {
    }

    public void setParentJoint(Joint parent) {
        this.parentJoint = parent;
    }

    public Joint getParentJoint() {
        return this.parentJoint;
    }

    @Override
    public RigidBodyTransform getTransformToHere() {
        return this.transformToHere;
    }

    public void updateTransformFromJoint(RigidBodyTransformReadOnly transformFromJoint) {
        this.transformFromJoint.multiply(transformFromJoint);
    }
}

