/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.yoVariableSearch;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanel;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariablePanelJPopupMenu;
import us.ihmc.simulationconstructionset.gui.yoVariableSearch.YoVariableSearchPanel;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoVariable;

public class YoVariableListPanel
extends YoVariablePanel {
    private static final long serialVersionUID = -995471860623897960L;
    private YoVariableList varList;

    public YoVariableListPanel(String name, SelectedVariableHolder holder, YoVariablePanelJPopupMenu varPanelJPopupMenu, YoVariableSearchPanel searchPanel) {
        this(new YoVariableList(name), holder, varPanelJPopupMenu, searchPanel);
    }

    public YoVariableListPanel(YoVariableList list, SelectedVariableHolder holder, YoVariablePanelJPopupMenu varPanelJPopupMenu, YoVariableSearchPanel searchPanel) {
        super(list.getName(), holder, varPanelJPopupMenu, searchPanel);
        this.varList = list;
        this.clearAndSetUpTextFields();
    }

    public YoVariableListPanel(String name, SelectedVariableHolder holder, YoVariablePanelJPopupMenu varPanelJPopupMenu) {
        this(new YoVariableList(name), holder, varPanelJPopupMenu, null);
    }

    public YoVariableListPanel(YoVariableList list, SelectedVariableHolder holder, YoVariablePanelJPopupMenu varPanelJPopupMenu) {
        this(list, holder, varPanelJPopupMenu, null);
    }

    @Override
    protected int getNumberOfYoVariables() {
        if (this.varList == null) {
            return 0;
        }
        return this.varList.size();
    }

    @Override
    protected YoVariable getYoVariable(int index) {
        return this.varList.get(index);
    }

    @Override
    protected List<YoVariable> getAllYoVariablesCopy() {
        return new ArrayList<YoVariable>(this.varList.getVariables());
    }

    @Override
    public YoVariable getYoVariable(String name) {
        return this.varList.findVariable(name);
    }

    public void addVariable(final YoVariable v) {
        if (v != null) {
            this.varList.add(v);
            EventDispatchThreadHelper.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    YoVariableListPanel.this.addTextFieldForVariable(v);
                }
            });
        }
    }

    public void removeVariable(YoVariable v) {
        int indexOfVariableValueToRemove = this.varList.indexOf((Object)v);
        if (indexOfVariableValueToRemove >= 0 && indexOfVariableValueToRemove < this.getYoVariableSpinners().size()) {
            System.out.println("removing var");
            Component field = this.getYoVariableSpinners().remove(indexOfVariableValueToRemove);
            this.remove(field);
        }
        this.varList.remove((Object)v);
        this.invalidate();
        this.revalidate();
        this.updateUI();
        this.repaint();
    }

    public void removeAllVariables() {
        this.varList.clear();
        this.getYoVariableSpinners().clear();
        this.removeAll();
    }

    @Override
    public String toString() {
        StringBuffer retBuffer = new StringBuffer();
        retBuffer.append(this.varList.toString());
        return retBuffer.toString();
    }
}

