/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Frame;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSpinner;
import org.fest.swing.core.GenericTypeMatcher;
import org.fest.swing.core.MouseButton;
import org.fest.swing.edt.FailOnThreadViolationRepaintManager;
import org.fest.swing.edt.GuiActionRunner;
import org.fest.swing.edt.GuiQuery;
import org.fest.swing.exception.ComponentLookupException;
import org.fest.swing.exception.WaitTimedOutError;
import org.fest.swing.finder.FrameFinder;
import org.fest.swing.finder.WindowFinder;
import org.fest.swing.fixture.FrameFixture;
import org.fest.swing.fixture.JButtonFixture;
import org.fest.swing.fixture.JCheckBoxFixture;
import org.fest.swing.fixture.JComboBoxFixture;
import org.fest.swing.fixture.JLabelFixture;
import org.fest.swing.fixture.JMenuItemFixture;
import org.fest.swing.fixture.JPanelFixture;
import org.fest.swing.fixture.JPopupMenuFixture;
import org.fest.swing.fixture.JSpinnerFixture;
import org.fest.swing.fixture.JTabbedPaneFixture;
import org.fest.swing.fixture.JTextComponentFixture;
import org.fest.swing.fixture.JTreeFixture;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.gui.YoGraph;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;

public class SimulationGUITestFixture {
    private FrameFixture focusedWindow;
    private final FrameFixture mainSCSWindow;

    public SimulationGUITestFixture(final SimulationConstructionSet scs) {
        if (System.getProperty("java.vendor").toLowerCase().contains("oracle")) {
            FailOnThreadViolationRepaintManager.install();
        }
        JFrame frame = (JFrame)GuiActionRunner.execute((GuiQuery)new GuiQuery<JFrame>(){

            protected JFrame executeInEDT() throws BlockingSimulationRunner.SimulationExceededMaximumTimeException {
                JFrame jFrame = scs.getJFrame();
                return jFrame;
            }
        });
        this.focusedWindow = new FrameFixture((Frame)frame);
        ThreadTools.sleep((long)1000L);
        this.focusedWindow.focus();
        this.mainSCSWindow = this.focusedWindow;
    }

    public void closeAllViewportWindows() {
        NthViewportWindowMatcher matcher;
        FrameFixture window;
        while ((window = this.getWindowIfItExists(matcher = new NthViewportWindowMatcher(0))) != null) {
            window.moveToFront();
            window.focus();
            window.close();
        }
        return;
    }

    public void focusNthViewportWindow(int n) {
        FrameFixture frameFixture;
        NthViewportWindowMatcher matcher = new NthViewportWindowMatcher(n);
        FrameFinder findFrame = WindowFinder.findFrame((GenericTypeMatcher)matcher);
        this.focusedWindow = frameFixture = findFrame.using(this.focusedWindow.robot);
        this.focusedWindow.focus();
    }

    public void closeAllGraphArrayWindows() {
        NthGraphArrayWindowMatcher matcher;
        FrameFixture window;
        while ((window = this.getWindowIfItExists(matcher = new NthGraphArrayWindowMatcher(0))) != null) {
            window.moveToFront();
            window.focus();
            window.close();
        }
        return;
    }

    public void focusNthGraphArrayWindow(int n) {
        FrameFixture frameFixture;
        NthGraphArrayWindowMatcher matcher = new NthGraphArrayWindowMatcher(n);
        FrameFinder findFrame = WindowFinder.findFrame((GenericTypeMatcher)matcher);
        this.focusedWindow = frameFixture = findFrame.using(this.focusedWindow.robot);
        this.focusedWindow.focus();
    }

    public void focusWindow(String name) {
        FrameFixture frameFixture;
        FrameFinder findFrame = WindowFinder.findFrame((String)name);
        this.focusedWindow = frameFixture = findFrame.using(this.focusedWindow.robot);
        this.focusedWindow.focus();
    }

    public void focusDialog(String name) {
        this.focusedWindow.dialog(name);
    }

    public void focusMainSCSWindow() {
        this.focusedWindow = this.mainSCSWindow;
        this.focusedWindow.focus();
    }

    public void showWindow() {
        this.focusedWindow.show();
    }

    public void closeAndDispose() {
        if (this.focusedWindow != null) {
            this.focusedWindow.cleanUp();
        }
    }

    public void clickExportDataButton() {
        JButtonFixture exportDataButton = this.focusedWindow.button("Export Data...");
        exportDataButton.click();
    }

    public void clickImportDataButton() {
        JButtonFixture importDataButton = this.focusedWindow.button("Import Data...");
        importDataButton.click();
    }

    public void clickMediaCaptureButton() {
        JButtonFixture mediaCaptureButton = this.focusedWindow.button("Media Capture...");
        mediaCaptureButton.click();
    }

    public void clickExportSnapshotButton() {
        JButtonFixture exportSnapshotButton = this.focusedWindow.button("Export Snapshot...");
        exportSnapshotButton.click();
    }

    public void clickSimulateButton() {
        JButtonFixture simulateButton = this.focusedWindow.button("Simulate");
        simulateButton.click();
    }

    public void clickPlayButton() {
        JButtonFixture playButton = this.focusedWindow.button("Play");
        playButton.click();
    }

    public void clickStopButton() {
        JButtonFixture stopButton = this.focusedWindow.button("Stop");
        stopButton.click();
    }

    public void clickSetInPointButton() {
        JButtonFixture setInPointButton = this.focusedWindow.button("Set In Point");
        setInPointButton.click();
    }

    public void clickGotoInPointButton() {
        JButtonFixture gotoInPointButton = this.focusedWindow.button("Goto In Point");
        gotoInPointButton.click();
    }

    public void clickStepBackwardButton() {
        JButtonFixture stepBackwardButton = this.focusedWindow.button("Step Backward");
        stepBackwardButton.click();
    }

    public void clickStepForwardButton() {
        JButtonFixture stepForwardButton = this.focusedWindow.button("Step Forward");
        stepForwardButton.click();
    }

    public void clickGotoOutPointButton() {
        JButtonFixture gotoOutPointButton = this.focusedWindow.button("Goto Out Point");
        gotoOutPointButton.click();
    }

    public void clickSetOutPointButton() {
        JButtonFixture setOutPointButton = this.focusedWindow.button("Set Out Point");
        setOutPointButton.click();
    }

    public void clickAddKeyPointButton() {
        JButtonFixture addKeyPointButton = this.focusedWindow.button("Add Key Point");
        addKeyPointButton.click();
    }

    public void clickToggleKeyModeButton() {
        JButtonFixture toggleKeyModeButton = this.focusedWindow.button("Toggle Key Mode");
        toggleKeyModeButton.click();
    }

    public void clickZoomInButton() {
        JButtonFixture zoomInButton = this.focusedWindow.button("Zoom In");
        zoomInButton.click();
    }

    public void clickZoomOutButton() {
        JButtonFixture zoomOutButton = this.focusedWindow.button("Zoom Out");
        zoomOutButton.click();
    }

    public void clickPrintGraphsButton() {
        JButtonFixture printGraphsButton = this.focusedWindow.button("Print Graphs");
        printGraphsButton.click();
    }

    public void clickTrackCheckBox() {
        JCheckBoxFixture trackCheckBox = this.focusedWindow.checkBox("Track");
        trackCheckBox.click();
    }

    public void clickDollyCheckBox() {
        JCheckBoxFixture dollyCheckBox = this.focusedWindow.checkBox("Dolly");
        dollyCheckBox.click();
    }

    public void selectFileMenu() {
        JMenuItemFixture fileMenu = this.focusedWindow.menuItem("File");
        fileMenu.click();
    }

    public void selectRunMenu() {
        JMenuItemFixture runMenu = this.focusedWindow.menuItem("Run");
        runMenu.click();
    }

    public void selectConfigurationMenu() {
        JMenuItemFixture configurationMenu = this.focusedWindow.menuItem("Configuration");
        configurationMenu.click();
    }

    public void selectGraphsMenu() {
        JMenuItemFixture graphsMenu = this.focusedWindow.menuItem("Graphs");
        graphsMenu.click();
    }

    public void selectDataBufferMenu() {
        JMenuItemFixture dataBufferMenu = this.focusedWindow.menuItem("Data Buffer");
        dataBufferMenu.click();
    }

    public void selectViewportMenu() {
        JMenuItemFixture viewportMenu = this.focusedWindow.menuItem("Viewport");
        viewportMenu.click();
    }

    public void selectWindowMenu() {
        JMenuItemFixture windowMenu = this.focusedWindow.menuItem("Window");
        windowMenu.click();
    }

    public void selectHelpMenu() {
        JMenuItemFixture helpMenu = this.focusedWindow.menuItem("Help");
        helpMenu.click();
    }

    public void selectPlayMenu() {
        MenuItemTextTypeMatcher matcher = new MenuItemTextTypeMatcher("Play");
        JMenuItemFixture playMenu = this.focusedWindow.menuItem((GenericTypeMatcher)matcher);
        playMenu.click();
    }

    public void selectNewGraphWindowMenu() {
        MenuItemTextTypeMatcher matcher = new MenuItemTextTypeMatcher("New Graph Window");
        JMenuItemFixture newGraphWindowMenu = this.focusedWindow.menuItem((GenericTypeMatcher)matcher);
        newGraphWindowMenu.click();
    }

    public void selectNewViewportWindowMenu() {
        MenuItemTextTypeMatcher matcher = new MenuItemTextTypeMatcher("New Viewport Window");
        JMenuItemFixture newViewportWindowMenu = this.focusedWindow.menuItem((GenericTypeMatcher)matcher);
        newViewportWindowMenu.click();
    }

    public void selectPlaybackPropertiesMenu() {
        MenuItemTextTypeMatcher matcher = new MenuItemTextTypeMatcher("Playback Properties...");
        JMenuItemFixture playbackPropertiesMenu = this.focusedWindow.menuItem((GenericTypeMatcher)matcher);
        playbackPropertiesMenu.click();
    }

    public void selectNamespaceTab() {
        JTabbedPaneFixture combinedVarPanelTabbedPane = this.focusedWindow.tabbedPane("CombinedVarPanel");
        combinedVarPanelTabbedPane.selectTab("Namespace");
    }

    public void selectNamespace(String namespace) {
        JTabbedPaneFixture combinedVarPanelTabbedPane = this.focusedWindow.tabbedPane("CombinedVarPanel");
        combinedVarPanelTabbedPane.selectTab("Namespace");
        JTreeFixture tree = this.focusedWindow.tree();
        tree.doubleClickPath(namespace);
    }

    public void selectSearchTab() {
        JTabbedPaneFixture combinedVarPanelTabbedPane = this.focusedWindow.panel("CombinedVarPanel").tabbedPane();
        combinedVarPanelTabbedPane.selectTab("Search");
    }

    public void deleteSearchText() {
        JPanelFixture searchPanel = this.focusedWindow.panel("SearchPanel");
        JTextComponentFixture searchTextField = searchPanel.textBox("SearchTextField");
        searchTextField.deleteText();
    }

    public void enterSearchText(String text) {
        JPanelFixture searchPanel = this.focusedWindow.panel("SearchPanel");
        JTextComponentFixture searchTextField = searchPanel.textBox("SearchTextField");
        searchTextField.enterText(text);
    }

    public void selectVariableInOpenTab(String variableNameEndsWith) {
        JSpinnerNameEndsWithMatcher matcher = new JSpinnerNameEndsWithMatcher(variableNameEndsWith);
        JSpinnerFixture spinner = this.focusedWindow.spinner((GenericTypeMatcher)matcher);
        spinner.focus();
    }

    public void selectVariableInSearchTab(String variableNameEndsWith) {
        JPanelFixture searchPanel = this.focusedWindow.panel("SearchPanel");
        JPanelFixture searchVarListVarPanel = searchPanel.panel("Search");
        JSpinnerNameEndsWithMatcher matcher = new JSpinnerNameEndsWithMatcher(variableNameEndsWith);
        JSpinnerFixture spinner = searchVarListVarPanel.spinner((GenericTypeMatcher)matcher);
        spinner.focus();
    }

    public void selectVariableAndSetValueInSearchTab(String variableNameEndsWith, double value) {
        JPanelFixture searchPanel = this.focusedWindow.panel("SearchPanel");
        JPanelFixture searchVarListVarPanel = searchPanel.panel("Search");
        JSpinnerNameEndsWithMatcher matcher = new JSpinnerNameEndsWithMatcher(variableNameEndsWith);
        JSpinnerFixture spinner = searchVarListVarPanel.spinner((GenericTypeMatcher)matcher);
        spinner.click();
        spinner.enterTextAndCommit(String.valueOf(value));
    }

    public void middleClickInEmptyGraph() {
        YoGraphIsEmptyMatcher matcher = new YoGraphIsEmptyMatcher();
        JPanelFixture panel = this.focusedWindow.panel((GenericTypeMatcher)matcher);
        panel.click(MouseButton.MIDDLE_BUTTON);
    }

    public void middleClickInNthGraph(int nThToFind) {
        NthYoGraphMatcher matcher = new NthYoGraphMatcher(nThToFind);
        JPanelFixture panel = this.focusedWindow.panel((GenericTypeMatcher)matcher);
        panel.click(MouseButton.MIDDLE_BUTTON);
    }

    public void removeAllGraphs() {
        this.clickRemoveEmptyGraphButton();
        NthYoGraphMatcher matcher;
        JPanelFixture panel;
        while ((panel = this.getPanelIfItExists(matcher = new NthYoGraphMatcher(0))) != null) {
            panel.rightClick();
            JPopupMenuFixture popupMenu = new JPopupMenuFixture(panel.robot, (JPopupMenu)panel.showPopupMenu().target);
            MenuItemTextTypeMatcher textMatcher = new MenuItemTextTypeMatcher("Delete Graph");
            popupMenu.menuItem((GenericTypeMatcher)textMatcher).click();
        }
        return;
    }

    private FrameFixture getWindowIfItExists(GenericTypeMatcher<JFrame> matcher) {
        try {
            FrameFinder findFrame = WindowFinder.findFrame(matcher);
            FrameFixture frameFixture = findFrame.using(this.focusedWindow.robot);
            return frameFixture;
        }
        catch (WaitTimedOutError waitTimedOutError) {
            return null;
        }
    }

    private JPanelFixture getPanelIfItExists(GenericTypeMatcher<JPanel> matcher) {
        try {
            return this.focusedWindow.panel(matcher);
        }
        catch (ComponentLookupException componentLookupException) {
            return null;
        }
    }

    public void removeVariableFromNthGraph(String variableName, int nThToFind) {
        NthYoGraphMatcher matcher = new NthYoGraphMatcher(nThToFind);
        JPanelFixture panel = this.focusedWindow.panel((GenericTypeMatcher)matcher);
        panel.rightClick();
        JPopupMenuFixture popupMenu = new JPopupMenuFixture(panel.robot, (JPopupMenu)panel.showPopupMenu().target);
        MenuItemTextTypeMatcher textMatcher = new MenuItemTextTypeMatcher("Remove " + variableName);
        popupMenu.menuItem((GenericTypeMatcher)textMatcher).click();
    }

    public void clickOnAddNumericEntryBox() {
        JButtonFixture addNumericEntryBox = this.focusedWindow.button("Add Numeric Entry Box");
        addNumericEntryBox.click();
    }

    public void clickOnUnusedEntryBox() {
        JPanelFixture unusedEntryBox = this.focusedWindow.panel("UNUSED");
        unusedEntryBox.click();
        LabelTextMatcher matcher = new LabelTextMatcher("UNUSED");
        JLabelFixture label = unusedEntryBox.label((GenericTypeMatcher)matcher);
        label.click();
    }

    public void removeAllEntryBoxes() {
        NthEntryBoxMatcher matcher;
        JPanelFixture panel;
        while ((panel = this.getPanelIfItExists(matcher = new NthEntryBoxMatcher(0))) != null) {
            panel.rightClick();
            JPopupMenuFixture popupMenu = new JPopupMenuFixture(panel.robot, (JPopupMenu)panel.showPopupMenu().target);
            MenuItemTextTypeMatcher textMatcher = new MenuItemTextTypeMatcher("Delete Entry Box");
            popupMenu.menuItem((GenericTypeMatcher)textMatcher).click();
        }
        return;
    }

    public void removeNthEntryBox(int n) {
        NthEntryBoxMatcher matcher = new NthEntryBoxMatcher(n);
        JPanelFixture entryBoxPanel = this.focusedWindow.panel((GenericTypeMatcher)matcher);
        entryBoxPanel.rightClick();
        JPopupMenuFixture popupMenu = new JPopupMenuFixture(entryBoxPanel.robot, (JPopupMenu)entryBoxPanel.showPopupMenu().target);
        MenuItemTextTypeMatcher textMatcher = new MenuItemTextTypeMatcher("Delete Entry Box");
        popupMenu.menuItem((GenericTypeMatcher)textMatcher).click();
    }

    public void findEntryBoxAndEnterValue(String name, double value) {
        JPanelFixture entryBoxArrayPanel = this.focusedWindow.panel("EntryBoxArrayPanel");
        JPanelFixture enumEntryBox = entryBoxArrayPanel.panel(name + "_YoEntryBox");
        JTextComponentFixture textBox = enumEntryBox.textBox();
        textBox.setText(Double.toString(value));
        textBox.enterText("\n");
        ThreadTools.sleep((long)500L);
    }

    public void findEnumEntryBoxAndSelectValue(String name, String value) {
        JPanelFixture entryBoxArrayPanel = this.focusedWindow.panel("EntryBoxArrayPanel");
        JPanelFixture enumEntryBox = entryBoxArrayPanel.panel(name + "_YoEntryBox");
        JComboBoxFixture comboBox = enumEntryBox.comboBox();
        comboBox.selectItem(value);
    }

    public void clickNewGraphButton() {
        JButtonFixture newGraphButton = this.focusedWindow.button("New Graph");
        newGraphButton.click();
    }

    public void clickRemoveEmptyGraphButton() {
        JButtonFixture removeEmptyGraphButton = this.focusedWindow.button("Remove Empty");
        removeEmptyGraphButton.click();
    }

    public void clickAddGraphColumnButton() {
        JButtonFixture addGraphColumnButton = this.focusedWindow.button("Add Column");
        addGraphColumnButton.click();
    }

    public void clickSubGraphColumnButton() {
        JButtonFixture subGraphColumnButton = this.focusedWindow.button("Sub Column");
        subGraphColumnButton.click();
    }

    public static boolean isRunningOnContinuousIntegrationServer() {
        String property = System.getProperty("runningOnCIServer");
        String environmentVariable = System.getenv("RUNNING_ON_CONTINUOUS_INTEGRATION_SERVER");
        if (property != null && property.trim().toLowerCase().contains("true")) {
            return true;
        }
        return environmentVariable != null && environmentVariable.trim().toLowerCase().contains("true");
    }

    public static void main(String[] args) {
        System.out.println(System.getProperty("java.vendor"));
        System.out.println(System.getProperty("java.vendor.url"));
    }

    private class NthViewportWindowMatcher
    extends GenericTypeMatcher<JFrame> {
        private final int nThToFind;
        private int currentIndex;

        public NthViewportWindowMatcher(int nThToFind) {
            super(JFrame.class);
            this.currentIndex = 0;
            this.nThToFind = nThToFind;
        }

        protected boolean isMatching(JFrame component) {
            String name = component.getName();
            if (name == null) {
                return false;
            }
            boolean isAGraphWindow = name.startsWith("Viewport Window");
            if (!isAGraphWindow) {
                return false;
            }
            if (!component.isVisible()) {
                return false;
            }
            if (this.currentIndex == this.nThToFind) {
                ++this.currentIndex;
                return true;
            }
            ++this.currentIndex;
            return false;
        }
    }

    private class NthGraphArrayWindowMatcher
    extends GenericTypeMatcher<JFrame> {
        private final int nThToFind;
        private int currentIndex;

        public NthGraphArrayWindowMatcher(int nThToFind) {
            super(JFrame.class);
            this.currentIndex = 0;
            this.nThToFind = nThToFind;
        }

        protected boolean isMatching(JFrame component) {
            String name = component.getName();
            if (name == null) {
                return false;
            }
            boolean isAGraphWindow = name.startsWith("Graph Window");
            if (!isAGraphWindow) {
                return false;
            }
            if (!component.isVisible()) {
                return false;
            }
            if (this.currentIndex == this.nThToFind) {
                ++this.currentIndex;
                return true;
            }
            ++this.currentIndex;
            return false;
        }
    }

    private class MenuItemTextTypeMatcher
    extends GenericTypeMatcher<JMenuItem> {
        private final String text;

        public MenuItemTextTypeMatcher(String text) {
            super(JMenuItem.class);
            this.text = text;
        }

        protected boolean isMatching(JMenuItem component) {
            return this.text.equals(component.getText());
        }
    }

    private class JSpinnerNameEndsWithMatcher
    extends GenericTypeMatcher<JSpinner> {
        private final String nameEnding;

        public JSpinnerNameEndsWithMatcher(String nameEnding) {
            super(JSpinner.class);
            this.nameEnding = nameEnding;
        }

        protected boolean isMatching(JSpinner component) {
            return component.getName().endsWith(this.nameEnding);
        }
    }

    private class YoGraphIsEmptyMatcher
    extends GenericTypeMatcher<JPanel> {
        public YoGraphIsEmptyMatcher() {
            super(JPanel.class);
        }

        protected boolean isMatching(JPanel component) {
            String name = component.getName();
            if (name == null) {
                return false;
            }
            boolean isAYoGraph = name.equals("YoGraph");
            if (!isAYoGraph) {
                return false;
            }
            YoGraph yoGraph = (YoGraph)component;
            return yoGraph.isEmpty();
        }
    }

    private class NthYoGraphMatcher
    extends GenericTypeMatcher<JPanel> {
        private final int nThToFind;
        private int currentIndex;

        public NthYoGraphMatcher(int nThToFind) {
            super(JPanel.class);
            this.currentIndex = 0;
            this.nThToFind = nThToFind;
        }

        protected boolean isMatching(JPanel component) {
            String name = component.getName();
            if (name == null) {
                return false;
            }
            boolean isAYoGraph = name.equals("YoGraph");
            if (!isAYoGraph) {
                return false;
            }
            if (this.currentIndex == this.nThToFind) {
                ++this.currentIndex;
                return true;
            }
            ++this.currentIndex;
            return false;
        }
    }

    private class LabelTextMatcher
    extends GenericTypeMatcher<JLabel> {
        private final String labelText;

        public LabelTextMatcher(String labelText) {
            super(JLabel.class);
            this.labelText = labelText;
        }

        protected boolean isMatching(JLabel label) {
            return label.getText().equals(this.labelText);
        }
    }

    private class NthEntryBoxMatcher
    extends GenericTypeMatcher<JPanel> {
        private final int nThToFind;
        private int currentIndex;

        public NthEntryBoxMatcher(int nThToFind) {
            super(JPanel.class);
            this.currentIndex = 0;
            this.nThToFind = nThToFind;
        }

        protected boolean isMatching(JPanel component) {
            String name = component.getName();
            if (name == null) {
                return false;
            }
            boolean isAYoGraph = name.endsWith("YoEntryBox");
            if (!isAYoGraph) {
                return false;
            }
            if (this.currentIndex == this.nThToFind) {
                ++this.currentIndex;
                return true;
            }
            ++this.currentIndex;
            return false;
        }
    }
}

