/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import us.ihmc.graphicsDescription.graphInterfaces.GraphIndicesHolder;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.simulationconstructionset.GraphConfiguration;
import us.ihmc.simulationconstructionset.commands.ZoomGraphCommandExecutor;
import us.ihmc.simulationconstructionset.gui.DataBufferChangeListener;
import us.ihmc.simulationconstructionset.gui.EventDispatchThreadHelper;
import us.ihmc.simulationconstructionset.gui.StandardSimulationGUI;
import us.ihmc.simulationconstructionset.gui.YoGraph;
import us.ihmc.simulationconstructionset.gui.YoGraphRemover;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryHolder;
import us.ihmc.yoVariables.buffer.interfaces.YoBufferVariableEntryReader;
import us.ihmc.yoVariables.buffer.interfaces.YoTimeBufferHolder;
import us.ihmc.yoVariables.variable.YoVariable;

public class GraphArrayPanel
extends JPanel
implements GraphIndicesHolder,
YoGraphRemover,
DataBufferChangeListener,
Printable,
ZoomGraphCommandExecutor {
    private static final long serialVersionUID = -4366771635271760899L;
    private ArrayList<YoGraph> graphsOnThisPanel;
    private JFrame parentFrame;
    private YoBuffer dataBuffer;
    private int numColumns = 1;
    public final int MAX_GRAPHS = 24;
    public final int MAX_COLS = 4;
    private int leftPlotIndex;
    private int rightPlotIndex;
    private SelectedVariableHolder selectedVariableHolder;
    private int oldIndex = 99;
    private boolean isPainting = false;
    private int doTick = 0;
    private int doIndex = -1;

    public GraphArrayPanel(SelectedVariableHolder holder, YoBuffer buffer, JFrame frame, StandardSimulationGUI standardSimulationGUI) {
        super(new GridLayout(0, 1, 2, 2));
        this.selectedVariableHolder = holder;
        this.setBackground(Color.lightGray);
        this.parentFrame = frame;
        this.dataBuffer = buffer;
        this.leftPlotIndex = 0;
        this.rightPlotIndex = this.getMaxIndex();
        this.setOpaque(true);
        this.graphsOnThisPanel = new ArrayList(16);
        this.setPreferredSize(new Dimension(800, 400));
    }

    public int getNumberOfColumns() {
        return this.numColumns;
    }

    public List<YoGraph> getGraphsOnThisPanel() {
        return this.graphsOnThisPanel;
    }

    public void setNumColumns(int numColumns) {
        this.numColumns = numColumns;
        this.setLayout(new GridLayout(0, numColumns, 2, 2));
        this.updateGraphs();
    }

    public void addColumn() {
        if (this.numColumns >= 4) {
            return;
        }
        ++this.numColumns;
        this.setLayout(new GridLayout(0, this.numColumns, 2, 2));
        this.updateGraphs();
    }

    public void subColumn() {
        if (this.numColumns <= 1) {
            return;
        }
        --this.numColumns;
        this.setLayout(new GridLayout(0, this.numColumns, 2, 2));
        this.updateGraphs();
    }

    @Override
    public void dataBufferChanged() {
        this.zoomFullView();
    }

    public void setInteractionEnable(boolean enable) {
        for (int i = 0; i < this.graphsOnThisPanel.size(); ++i) {
            YoGraph yoGraph = this.graphsOnThisPanel.get(i);
            yoGraph.setInteractionEnable(enable);
        }
    }

    public void repaintGraphs() {
        boolean repaintAll;
        int index = this.getIndex();
        int inPoint = this.getInPoint();
        int outPoint = this.getOutPoint();
        int leftPlotIndex = this.getLeftPlotIndex();
        int rightPlotIndex = this.getRightPlotIndex();
        boolean bl = repaintAll = index < this.oldIndex;
        if (index < leftPlotIndex || index > rightPlotIndex) {
            this.recenter();
            leftPlotIndex = this.getLeftPlotIndex();
            rightPlotIndex = this.getRightPlotIndex();
            repaintAll = true;
        }
        for (int i = 0; i < this.graphsOnThisPanel.size(); ++i) {
            YoGraph g = this.graphsOnThisPanel.get(i);
            if (g.getNumVars() <= 0) continue;
            if (repaintAll) {
                g.repaintAllGraph();
                continue;
            }
            g.repaintPartialGraph(index, this.oldIndex, inPoint, outPoint, leftPlotIndex, rightPlotIndex);
        }
        this.oldIndex = index;
    }

    @Override
    public void paint(Graphics g) {
        this.isPainting = true;
        super.paint(g);
        this.isPainting = false;
    }

    public boolean isPaintingPanel() {
        return this.isPainting;
    }

    public void goToInPointNow() {
        this.dataBuffer.gotoInPoint();
    }

    public void goToOutPointNow() {
        this.dataBuffer.gotoOutPoint();
    }

    public boolean tick(int n) {
        boolean ret = this.dataBuffer.tickAndReadFromBuffer(n);
        this.repaintGraphs();
        return ret;
    }

    public int getInPoint() {
        return this.dataBuffer.getInPoint();
    }

    public int getOutPoint() {
        return this.dataBuffer.getOutPoint();
    }

    public int getIndex() {
        return this.dataBuffer.getCurrentIndex();
    }

    public boolean isIndexAtOutPoint() {
        return this.getIndex() == this.getOutPoint();
    }

    public int getMaxIndex() {
        return this.dataBuffer.getBufferSize() - 1;
    }

    public int getLeftPlotIndex() {
        return this.leftPlotIndex;
    }

    public int getRightPlotIndex() {
        return this.rightPlotIndex;
    }

    public void setLeftPlotIndex(int idx) {
        this.leftPlotIndex = idx;
        this.repaintGraphs();
    }

    public void setRightPlotIndex(int idx) {
        this.rightPlotIndex = idx;
        this.repaintGraphs();
    }

    public void zoomFullView() {
        this.rightPlotIndex = this.getMaxIndex();
        this.leftPlotIndex = 0;
        this.updateGraphs();
    }

    @Override
    public void zoomIn() {
        this.zoomIn(2);
    }

    public void zoomIn(int factor) {
        int index = this.getIndex();
        int oldLength = this.rightPlotIndex - this.leftPlotIndex;
        int newLength = oldLength / factor;
        if (newLength < 4) {
            return;
        }
        this.leftPlotIndex = index - newLength / 2;
        this.rightPlotIndex = this.leftPlotIndex + newLength;
        if (this.leftPlotIndex < 0) {
            this.leftPlotIndex = 0;
            this.rightPlotIndex = this.leftPlotIndex + newLength;
            if (this.rightPlotIndex > this.getMaxIndex()) {
                this.rightPlotIndex = this.getMaxIndex();
            }
        } else if (this.rightPlotIndex > this.getMaxIndex()) {
            this.rightPlotIndex = this.getMaxIndex();
            this.leftPlotIndex = this.rightPlotIndex - newLength;
            if (this.leftPlotIndex < 0) {
                this.leftPlotIndex = 0;
            }
        }
        this.repaint();
    }

    @Override
    public void zoomOut() {
        this.zoomOut(2);
    }

    public void zoomOut(int factor) {
        int index = this.getIndex();
        int oldLength = this.rightPlotIndex - this.leftPlotIndex;
        int newLength = oldLength * factor;
        this.leftPlotIndex = index - newLength / 2;
        this.rightPlotIndex = this.leftPlotIndex + newLength;
        if (this.leftPlotIndex < 0) {
            this.leftPlotIndex = 0;
            this.rightPlotIndex = this.leftPlotIndex + newLength;
            if (this.rightPlotIndex > this.getMaxIndex()) {
                this.rightPlotIndex = this.getMaxIndex();
            }
        } else if (this.rightPlotIndex > this.getMaxIndex()) {
            this.rightPlotIndex = this.getMaxIndex();
            this.leftPlotIndex = this.rightPlotIndex - newLength;
            if (this.leftPlotIndex < 0) {
                this.leftPlotIndex = 0;
            }
        }
        this.repaint();
    }

    public void recenter() {
        this.zoomIn(1);
    }

    public void tickLater(int n) {
        if (this.dataBuffer.getKeyPointsHandler().areKeyPointsEnabled()) {
            if (n > 0) {
                this.setIndexLater(this.dataBuffer.getNextKeyPoint());
            } else {
                this.setIndexLater(this.dataBuffer.getPreviousKeyPoint());
            }
        } else {
            this.doTick = n;
        }
    }

    public void setIndexLater(int idx) {
        this.doIndex = idx;
    }

    public boolean allowTickUpdatesNow() {
        boolean ret = false;
        if (this.doTick != 0) {
            this.dataBuffer.tickAndReadFromBuffer(this.doTick);
            ret = true;
            this.doTick = 0;
        }
        if (this.doIndex != -1) {
            this.dataBuffer.setCurrentIndex(this.doIndex);
            this.doIndex = -1;
            ret = true;
        }
        return ret;
    }

    public void setupGraph(String varname) {
        YoBufferVariableEntry entry = this.dataBuffer.findVariableEntry(varname);
        if (entry != null) {
            EventDispatchThreadHelper.invokeAndWait(() -> {
                YoGraph g = new YoGraph(this.getGraphArrayPanel(), this.getGraphArrayPanel(), this.selectedVariableHolder, (YoBufferVariableEntryHolder)this.dataBuffer, (YoTimeBufferHolder)this.dataBuffer, this.parentFrame);
                g.addVariable((YoBufferVariableEntryReader)entry);
                this.addGraph(g);
            });
        }
    }

    private GraphArrayPanel getGraphArrayPanel() {
        return this;
    }

    public void setupGraph(final String[] varnames) {
        if (varnames == null) {
            return;
        }
        EventDispatchThreadHelper.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                YoGraph g = new YoGraph(GraphArrayPanel.this.getGraphArrayPanel(), GraphArrayPanel.this.getGraphArrayPanel(), GraphArrayPanel.this.selectedVariableHolder, (YoBufferVariableEntryHolder)GraphArrayPanel.this.dataBuffer, (YoTimeBufferHolder)GraphArrayPanel.this.dataBuffer, GraphArrayPanel.this.parentFrame);
                for (int i = 0; i < varnames.length; ++i) {
                    YoBufferVariableEntry entry = GraphArrayPanel.this.dataBuffer.findVariableEntry(varnames[i]);
                    if (entry == null) continue;
                    g.addVariable((YoBufferVariableEntryReader)entry);
                }
                GraphArrayPanel.this.addGraph(g);
            }
        });
    }

    public void setupGraph(String[] varnames, GraphConfiguration config) {
        if (varnames == null) {
            return;
        }
        YoGraph g = new YoGraph(this, this, this.selectedVariableHolder, (YoBufferVariableEntryHolder)this.dataBuffer, (YoTimeBufferHolder)this.dataBuffer, this.parentFrame);
        for (int i = 0; i < varnames.length; ++i) {
            YoBufferVariableEntry entry = this.dataBuffer.findVariableEntry(varnames[i]);
            if (entry == null) continue;
            g.addVariable((YoBufferVariableEntryReader)entry);
        }
        if (config != null) {
            g.setGraphConfiguration(config);
        }
        this.addGraph(g);
    }

    public void RepaintOnSetPoint() {
        for (int i = 0; i < this.graphsOnThisPanel.size(); ++i) {
            this.graphsOnThisPanel.get(i).repaintGraphOnSetPoint(this.getInPoint(), this.getOutPoint(), this.getLeftPlotIndex(), this.getRightPlotIndex());
        }
    }

    public void addSelectedVariableGraph() {
        YoVariable variable = this.selectedVariableHolder.getSelectedVariable();
        YoBufferVariableEntry entry = this.dataBuffer.getEntry(variable);
        YoGraph g = new YoGraph(this, this, this.selectedVariableHolder, (YoBufferVariableEntryHolder)this.dataBuffer, (YoTimeBufferHolder)this.dataBuffer, this.parentFrame);
        g.addVariable((YoBufferVariableEntryReader)entry);
        this.addGraph(g);
    }

    public void addEmptyGraph() {
        YoGraph g = new YoGraph(this, this, this.selectedVariableHolder, (YoBufferVariableEntryHolder)this.dataBuffer, (YoTimeBufferHolder)this.dataBuffer, this.parentFrame);
        this.addGraph(g);
    }

    @Deprecated
    public void addNew3dGraph() {
    }

    public void removeEmptyGraphs() {
        YoGraph emptyGraph = null;
        for (int i = 0; i < this.graphsOnThisPanel.size(); ++i) {
            YoGraph graph = this.graphsOnThisPanel.get(i);
            if (graph.getNumVars() != 0) continue;
            emptyGraph = graph;
        }
        if (emptyGraph != null) {
            this.remove(emptyGraph);
            this.graphsOnThisPanel.remove(emptyGraph);
            this.removeEmptyGraphs();
        } else {
            this.updateGraphs();
        }
    }

    public void addGraph(YoGraph graph) {
        int numGraphs = this.graphsOnThisPanel.size();
        if (numGraphs >= 24) {
            return;
        }
        this.graphsOnThisPanel.add(graph);
        this.add(graph);
        this.updateGraphs();
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageNumber) {
        Graphics2D g2 = (Graphics2D)g;
        if (pageNumber == 0) {
            g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            double pageWidth = pageFormat.getImageableWidth();
            double pageHeight = pageFormat.getImageableHeight();
            YoGraph graph = this.graphsOnThisPanel.get(0);
            for (int i = 0; i < this.graphsOnThisPanel.size(); ++i) {
                graph = this.graphsOnThisPanel.get(i);
                if (graph.getEntriesOnThisGraph().size() <= 0) continue;
                graph.printGraph(g2, (int)pageWidth, (int)(pageHeight / 10.0));
                g2.translate(0.0, pageHeight / 8.0);
            }
            return 0;
        }
        return 1;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    public void closeAndDispose() {
        this.parentFrame = null;
        this.dataBuffer = null;
        if (this.graphsOnThisPanel != null) {
            this.graphsOnThisPanel.clear();
            this.graphsOnThisPanel = null;
        }
        this.selectedVariableHolder = null;
        this.removeAll();
    }

    @Override
    public void removeGraph(YoGraph graph) {
        this.graphsOnThisPanel.remove(graph);
        this.remove(graph);
        this.updateGraphs();
    }

    public void removeAllGraphs() {
        this.graphsOnThisPanel.clear();
        this.removeAll();
        this.updateGraphs();
    }

    public JPanel createGraphButtonPanel() {
        JPanel graphButtonPanel = new JPanel();
        JButton newGraphButton = new JButton("New Graph");
        newGraphButton.setName("New Graph");
        newGraphButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphArrayPanel.this.addEmptyGraph();
            }
        });
        graphButtonPanel.add(newGraphButton);
        JButton removeEmptyGraphsButton = new JButton("Remove Empty");
        removeEmptyGraphsButton.setName("Remove Empty");
        removeEmptyGraphsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphArrayPanel.this.removeEmptyGraphs();
            }
        });
        graphButtonPanel.add(removeEmptyGraphsButton);
        JButton addColumnButton = new JButton("Add Column");
        addColumnButton.setName("Add Column");
        addColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphArrayPanel.this.addColumn();
            }
        });
        graphButtonPanel.add(addColumnButton);
        JButton subColumnButton = new JButton("Sub Column");
        subColumnButton.setName("Sub Column");
        subColumnButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphArrayPanel.this.subColumn();
            }
        });
        graphButtonPanel.add(subColumnButton);
        JButton new3DGraphButton = new JButton("New 3D Graph");
        new3DGraphButton.setName("New 3D Graph");
        new3DGraphButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GraphArrayPanel.this.addNew3dGraph();
            }
        });
        graphButtonPanel.add(new3DGraphButton);
        return graphButtonPanel;
    }

    public String getXMLRepresentationOfClass() {
        Object returnString = "<GraphGroup>\n";
        returnString = (String)returnString + "\t<Cols>" + this.numColumns + "</Cols>\n";
        for (int j = 0; j < this.graphsOnThisPanel.size(); ++j) {
            YoGraph graph = this.graphsOnThisPanel.get(j);
            returnString = (String)returnString + "\t<Graph>\n";
            returnString = (String)returnString + "\t\t<Variables>";
            if (graph.getEntriesOnThisGraph().size() > 0) {
                returnString = (String)returnString + graph.getEntriesOnThisGraph().get(0).getVariableFullNameString();
                for (int i = 1; i < graph.getEntriesOnThisGraph().size(); ++i) {
                    returnString = (String)returnString + "," + graph.getEntriesOnThisGraph().get(i).getVariableFullNameString();
                }
            }
            returnString = (String)returnString + "</Variables>";
            returnString = (String)returnString + "\n" + graph.getGraphConfiguration().getXMLStyleRepresentationOfClass();
            returnString = (String)returnString + "\n\t</Graph>\n";
        }
        returnString = (String)returnString + "</GraphGroup>";
        return returnString;
    }

    public List<Integer> getKeyPoints() {
        return this.dataBuffer.getKeyPointsHandler().getKeyPoints();
    }

    private void updateGraphs() {
        this.updateUI();
    }
}

