/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;

public abstract class GroundProfileFromHeightMap
implements HeightMapWithNormals,
GroundProfile3D {
    public boolean isClose(double x, double y, double z) {
        return this.getBoundingBox().isInsideInclusive(x, y, z);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        double heightAt = this.heightAndNormalAt(x, y, z, normalToPack);
        intersectionToPack.set(x, y, heightAt);
        return z < heightAt;
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        double heightAt = this.heightAndNormalAt(x, y, z, normalToPack);
        intersectionToPack.set(x, y, heightAt);
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }

    public static GroundProfileFromHeightMap createAGroundProfileFromAHeightMap(final HeightMap heightMap) {
        GroundProfileFromHeightMap ret = new GroundProfileFromHeightMap(){

            public double heightAt(double x, double y, double z) {
                return heightMap.heightAt(x, y, z);
            }

            public BoundingBox3D getBoundingBox() {
                return heightMap.getBoundingBox();
            }

            public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
                normalToPack.set(0.0, 0.0, 1.0);
                return heightMap.heightAt(x, y, z);
            }
        };
        return ret;
    }

    public static GroundProfileFromHeightMap createAGroundProfileFromAHeightMapWithNormals(final HeightMapWithNormals heightMap) {
        GroundProfileFromHeightMap ret = new GroundProfileFromHeightMap(){

            public double heightAt(double x, double y, double z) {
                return heightMap.heightAt(x, y, z);
            }

            public BoundingBox3D getBoundingBox() {
                return heightMap.getBoundingBox();
            }

            public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
                return heightMap.heightAndNormalAt(x, y, z, normalToPack);
            }
        };
        return ret;
    }
}

