/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.simulationRunner;

import java.util.ArrayList;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.util.simulationRunner.SimulationRewindabilityVerifierWithStackTracing;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariableDifference;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariablesThatShouldMatchList;
import us.ihmc.yoVariables.registry.YoRegistry;

public class SimulationRewindabilityVerifier {
    private static final boolean DEBUG = false;
    private final SimulationConstructionSet[] simulations;
    private final ArrayList<String> exceptions;

    public SimulationRewindabilityVerifier(SimulationConstructionSet simulationOne, SimulationConstructionSet simulationTwo, ArrayList<String> exceptions) {
        this.simulations = new SimulationConstructionSet[]{simulationOne, simulationTwo};
        this.exceptions = exceptions;
    }

    public SimulationRewindabilityVerifier(SimulationConstructionSet[] simulations, ArrayList<String> exceptions) {
        this.exceptions = exceptions;
        if (simulations.length != 2) {
            throw new RuntimeException("Need exactly 2 simulations in order to do rewindability verifier");
        }
        this.simulations = simulations;
    }

    public ArrayList<VariableDifference> verifySimulationsAreSameToStart() {
        double time = this.simulations[0].getTime();
        YoRegistry registry0 = this.simulations[0].getRootRegistry();
        YoRegistry registry1 = this.simulations[1].getRootRegistry();
        VariablesThatShouldMatchList variablesThatShouldMatchList = new VariablesThatShouldMatchList(registry0, registry1, this.exceptions);
        boolean checkForPercentDifference = false;
        double maxDifferenceAllowed = Double.MIN_VALUE;
        ArrayList<VariableDifference> variableDifferences = new ArrayList<VariableDifference>();
        variablesThatShouldMatchList.doVariableValuesMatch(variableDifferences, time, maxDifferenceAllowed, checkForPercentDifference);
        return variableDifferences;
    }

    public ArrayList<VariableDifference> checkRewindabilityWithSimpleMethod(int numTicksToTest, double maxDifferenceAllowed) throws UnreasonableAccelerationException {
        int numTicksToStartComparingAt = 1;
        return this.checkRewindabilityWithSimpleMethod(numTicksToStartComparingAt, numTicksToTest, maxDifferenceAllowed);
    }

    public ArrayList<VariableDifference> checkRewindabilityWithSimpleMethod(int numTicksToStartComparingAt, int numTicksToTest, double maxDifferenceAllowed) throws UnreasonableAccelerationException {
        ArrayList<VariableDifference> variableDifferencesToReturn = new ArrayList<VariableDifference>();
        this.checkRewindabilityWithSimpleMethod(numTicksToStartComparingAt, numTicksToTest, maxDifferenceAllowed, variableDifferencesToReturn);
        return variableDifferencesToReturn;
    }

    public int checkRewindabilityWithSimpleMethod(int numTicksToStartComparingAt, int numTicksToTest, double maxDifferenceAllowed, ArrayList<VariableDifference> variableDifferencesToPack) throws UnreasonableAccelerationException {
        int numTicksToSimulateAhead = 1;
        return this.checkRewindabilityWithRigorousMethod(numTicksToStartComparingAt, numTicksToTest, numTicksToSimulateAhead, maxDifferenceAllowed, variableDifferencesToPack);
    }

    public ArrayList<VariableDifference> checkRewindabilityWithRigorousMethod(int numTicksToStartComparingAt, int numTicksToTest, int numTicksToSimulateAhead, double maxDifferenceAllowed) throws UnreasonableAccelerationException {
        ArrayList<VariableDifference> variableDifferencesToReturn = new ArrayList<VariableDifference>();
        this.checkRewindabilityWithRigorousMethod(numTicksToStartComparingAt, numTicksToTest, numTicksToSimulateAhead, maxDifferenceAllowed, variableDifferencesToReturn);
        return variableDifferencesToReturn;
    }

    public int checkRewindabilityWithRigorousMethod(int numTicksToStartComparingAt, int numTicksToTest, int numTicksToSimulateAhead, double maxDifferenceAllowed, ArrayList<VariableDifference> variableDifferencesToPack) throws UnreasonableAccelerationException {
        YoRegistry registry0 = this.simulations[0].getRootRegistry();
        YoRegistry registry1 = this.simulations[1].getRootRegistry();
        variableDifferencesToPack.clear();
        VariablesThatShouldMatchList variablesThatShouldMatchList = new VariablesThatShouldMatchList(registry0, registry1, this.exceptions);
        SimulationRewindabilityVerifier.simulateForNumberOfTicks(this.simulations[0], numTicksToStartComparingAt);
        SimulationRewindabilityVerifier.simulateForNumberOfTicks(this.simulations[1], numTicksToStartComparingAt);
        for (int tickIndex = 0; tickIndex < numTicksToTest; ++tickIndex) {
            int i;
            boolean passesTest = this.verifyMatch(variablesThatShouldMatchList, variableDifferencesToPack, maxDifferenceAllowed);
            if (!passesTest) {
                System.err.println("Was not rewindable. Failed on tick " + tickIndex);
                return tickIndex;
            }
            this.simulations[0].simulateOneRecordStepNow();
            for (i = 0; i < numTicksToSimulateAhead; ++i) {
                this.simulations[1].simulateOneRecordStepNow();
            }
            for (i = 0; i < numTicksToSimulateAhead; ++i) {
                this.simulations[1].stepBackwardNow();
            }
            this.simulations[1].simulateOneRecordStepNow();
        }
        return numTicksToTest;
    }

    public void checkRewindabilityUsingIndividualVariableChangesAndTrackingStackTraces(int numTicksToStartComparingAt, int numTicksToTest, double maxDifferenceAllowed, ArrayList<VariableDifference> variableDifferencesToPack) throws UnreasonableAccelerationException {
        variableDifferencesToPack.clear();
        SimulationRewindabilityVerifier.simulateForNumberOfTicks(this.simulations[0], numTicksToStartComparingAt);
        SimulationRewindabilityVerifier.simulateForNumberOfTicks(this.simulations[1], numTicksToStartComparingAt);
        SimulationRewindabilityVerifierWithStackTracing helper = new SimulationRewindabilityVerifierWithStackTracing(this.simulations[0], this.simulations[1], this.exceptions);
        for (int tickIndex = 0; tickIndex < numTicksToTest; ++tickIndex) {
            int i;
            boolean areTheVariableChangesDifferent = helper.areTheVariableChangesDifferent();
            if (areTheVariableChangesDifferent) {
                helper.printOutStackTracesOfFirstChangedVariable();
                return;
            }
            helper.clearChangesForSimulations();
            helper.setRecordDifferencesForSimOne(true);
            helper.setRecordDifferencesForSimTwo(false);
            this.simulations[0].simulateOneRecordStepNow();
            helper.setRecordDifferencesForSimOne(false);
            int numberOfStepsForward = 1;
            for (i = 0; i < numberOfStepsForward; ++i) {
                this.simulations[1].simulateOneRecordStepNow();
            }
            for (i = 0; i < numberOfStepsForward; ++i) {
                this.simulations[1].stepBackwardNow();
            }
            helper.setRecordDifferencesForSimTwo(true);
            this.simulations[1].simulateOneRecordStepNow();
        }
    }

    public void simulateForNumberOfTicks(int numberOfTicks) throws UnreasonableAccelerationException {
        SimulationRewindabilityVerifier.simulateForNumberOfTicks(this.simulations[0], numberOfTicks);
        SimulationRewindabilityVerifier.simulateForNumberOfTicks(this.simulations[1], numberOfTicks);
    }

    private static void simulateForNumberOfTicks(SimulationConstructionSet scs, int numberOfTicks) throws UnreasonableAccelerationException {
        for (int i = 0; i < numberOfTicks; ++i) {
            scs.simulateOneRecordStepNow();
        }
    }

    private boolean verifyMatch(VariablesThatShouldMatchList variablesThatShouldMatchList, ArrayList<VariableDifference> variableDifferencesToPack, double maxDifferenceAllowed) {
        double time = this.simulations[0].getTime();
        boolean checkForPercentDifference = false;
        return variablesThatShouldMatchList.doVariableValuesMatch(variableDifferencesToPack, time, maxDifferenceAllowed, checkForPercentDifference);
    }
}

