/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import java.util.ArrayList;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointGroup;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.RigidJoint;
import us.ihmc.simulationconstructionset.SpatialVector;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.JointPhysics;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.SpatialInertiaMatrix;

public class RigidJointPhysics
extends JointPhysics<RigidJoint> {
    private Vector3D w_hXr_i = new Vector3D();
    private Vector3D temp1 = new Vector3D();

    public RigidJointPhysics(RigidJoint owner) {
        super(owner);
        this.u_i = null;
        this.u_iXd_i = null;
        this.s_hat_i = null;
    }

    @Override
    protected void jointDependentChangeVelocity(double delta_qd) {
    }

    @Override
    protected void jointDependentSetAndGetRotation(RotationMatrixBasics Rh_i) {
        Rh_i.set(((RigidJoint)this.owner).getRigidRotation());
    }

    @Override
    public void featherstonePassOne(Vector3DReadOnly w_h, Vector3DReadOnly v_h, RotationMatrixReadOnly Rh_0) {
        int i;
        this.r_in.set((Tuple3DReadOnly)((RigidJoint)this.owner).getOffset());
        if (((RigidJoint)this.owner).parentJoint != null) {
            this.r_in.sub((Tuple3DReadOnly)((RigidJoint)this.owner).parentJoint.link.getComOffset());
        }
        this.jointDependentSetAndGetRotation((RotationMatrixBasics)this.Rh_i);
        this.Ri_h.set(this.Rh_i);
        this.Ri_h.transpose();
        this.Ri_0.set(this.Ri_h);
        this.Ri_0.multiply(Rh_0);
        this.jointDependentSet_d_i();
        this.r_i.set(this.r_in);
        this.Ri_h.transform((Tuple3DBasics)this.r_i);
        this.r_i.add((Tuple3DReadOnly)this.d_i);
        this.r_h.set(this.r_i);
        this.r_h.scale(-1.0);
        this.Rh_i.transform((Tuple3DBasics)this.r_h);
        this.w_i.set((Tuple3DReadOnly)w_h);
        this.Ri_h.transform((Tuple3DBasics)this.w_i);
        this.v_i.set((Tuple3DReadOnly)v_h);
        this.Ri_h.transform((Tuple3DBasics)this.v_i);
        this.v_i_temp.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)this.r_i);
        this.v_i.add((Tuple3DReadOnly)this.v_i_temp);
        this.jointDependentFeatherstonePassOne();
        this.R0_i.set(this.Ri_0);
        this.R0_i.transpose();
        if (this.groundContactPointGroupList != null) {
            for (i = 0; i < this.groundContactPointGroupList.size(); ++i) {
                ArrayList<GroundContactPoint> groundContactPoints = ((GroundContactPointGroup)this.groundContactPointGroupList.get(i)).getGroundContactPoints();
                for (int y = 0; y < groundContactPoints.size(); ++y) {
                    GroundContactPoint point = groundContactPoints.get(y);
                    point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((RigidJoint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
                }
            }
        }
        if (this.kinematicPoints != null) {
            for (i = 0; i < this.kinematicPoints.size(); ++i) {
                KinematicPoint point = (KinematicPoint)this.kinematicPoints.get(i);
                point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((RigidJoint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
            }
        }
        for (i = 0; i < ((RigidJoint)this.owner).getChildrenJoints().size(); ++i) {
            Joint child = ((RigidJoint)this.owner).getChildrenJoints().get(i);
            child.physics.featherstonePassOne((Vector3DReadOnly)this.w_i, (Vector3DReadOnly)this.v_i, (RotationMatrixReadOnly)this.Ri_0);
        }
    }

    @Override
    protected void jointDependentSet_d_i() {
        this.d_i.set((Tuple3DReadOnly)((RigidJoint)this.owner).getRigidTranslation());
        ((RigidJoint)this.owner).getRigidRotation().inverseTransform((Tuple3DBasics)this.d_i);
        this.d_i.add((Tuple3DReadOnly)((RigidJoint)this.owner).getLink().getComOffset());
    }

    @Override
    public void featherstonePassThree() {
        for (int i = 0; i < ((RigidJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((RigidJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassThree(this.I_hat_i, this.Z_hat_i);
        }
    }

    @Override
    public void featherstonePassThree(SpatialInertiaMatrix I_hat_h, SpatialVector Z_hat_h) {
        for (int i = 0; i < ((RigidJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((RigidJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassThree(this.I_hat_i, this.Z_hat_i);
        }
        this.i_X_hat_h.setFromOffsetAndRotation((Vector3DReadOnly)this.r_i, (RotationMatrixReadOnly)this.Ri_h);
        this.h_X_hat_i.setFromOffsetAndRotation((Vector3DReadOnly)this.r_h, (RotationMatrixReadOnly)this.Rh_i);
        this.SIM2.set(this.I_hat_i);
        this.h_X_hat_i.transformSpatialInertia(this.SIM2);
        I_hat_h.add(this.SIM2);
        this.sV1.set(this.c_hat_i);
        this.I_hat_i.multiply(this.sV1);
        this.sV1.add(this.Z_hat_i);
        this.h_X_hat_i.transform(this.sV1);
        Z_hat_h.add(this.sV1);
    }

    @Override
    public void featherstonePassFour(SpatialVector a_hat_h, int passNumber) throws UnreasonableAccelerationException {
        this.X_hat_h_a_hat_h.set(a_hat_h);
        this.i_X_hat_h.transform(this.X_hat_h_a_hat_h);
        this.I_hat_i.multiply(this.X_hat_h_a_hat_h);
        this.jointDependentFeatherstonePassFour(0.0, passNumber);
        this.a_hat_i.set(a_hat_h);
        this.i_X_hat_h.transform(this.a_hat_i);
        this.a_hat_i.add(this.c_hat_i);
        if (!this.jointDependentVerifyReasonableAccelerations()) {
            ArrayList<Joint> unreasonableAccelerationJoints = new ArrayList<Joint>();
            unreasonableAccelerationJoints.add(this.owner);
            throw new UnreasonableAccelerationException(unreasonableAccelerationJoints);
        }
        for (int i = 0; i < ((RigidJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((RigidJoint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassFour(this.a_hat_i, passNumber);
        }
        if (this.jointWrenchSensor != null) {
            this.computeAndSetWrenchAtJoint();
        }
    }

    @Override
    protected void jointDependentFeatherstonePassOne() {
    }

    @Override
    protected void jointDependentFeatherstonePassTwo(Vector3DReadOnly w_h) {
        this.c_hat_i.top.set(0.0, 0.0, 0.0);
        this.w_hXr_i.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.r_i);
        this.temp1.cross((Tuple3DReadOnly)w_h, (Tuple3DReadOnly)this.w_hXr_i);
        this.c_hat_i.bottom.set(this.temp1);
    }

    @Override
    protected void jointDependentFeatherstonePassFour(double Q, int passNumber) {
    }

    @Override
    protected void jointDependentRecordK(int passNumber) {
    }

    @Override
    public void recursiveEulerIntegrate(double stepSize) {
        for (int i = 0; i < ((RigidJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((RigidJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveEulerIntegrate(stepSize);
        }
    }

    @Override
    public void recursiveRungeKuttaSum(double stepSize) {
        for (int i = 0; i < ((RigidJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((RigidJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRungeKuttaSum(stepSize);
        }
    }

    @Override
    public void recursiveSaveTempState() {
        for (int i = 0; i < ((RigidJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((RigidJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveSaveTempState();
        }
    }

    @Override
    public void recursiveRestoreTempState() {
        for (int i = 0; i < ((RigidJoint)this.owner).childrenJoints.size(); ++i) {
            Joint child = (Joint)((RigidJoint)this.owner).childrenJoints.get(i);
            child.physics.recursiveRestoreTempState();
        }
    }

    @Override
    protected boolean jointDependentVerifyReasonableAccelerations() {
        return true;
    }
}

