/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.geometry.LineSegment3D;
import us.ihmc.euclid.geometry.interfaces.BoundingBox3DReadOnly;
import us.ihmc.euclid.shape.collision.EuclidShape3DCollisionResult;
import us.ihmc.euclid.shape.collision.epa.ExpandingPolytopeAlgorithm;
import us.ihmc.euclid.shape.collision.gjk.GilbertJohnsonKeerthiCollisionDetector;
import us.ihmc.euclid.shape.collision.interfaces.EuclidShape3DCollisionResultBasics;
import us.ihmc.euclid.shape.collision.interfaces.SupportingVertexHolder;
import us.ihmc.euclid.shape.convexPolytope.ConvexPolytope3D;
import us.ihmc.euclid.shape.primitives.Cylinder3D;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.physics.CollisionShape;
import us.ihmc.simulationconstructionset.physics.CollisionShapeDescription;
import us.ihmc.simulationconstructionset.physics.CollisionShapeFactory;
import us.ihmc.simulationconstructionset.physics.ScsCollisionDetector;
import us.ihmc.simulationconstructionset.physics.collision.CollisionDetectionResult;
import us.ihmc.simulationconstructionset.physics.collision.simple.BoxShapeDescription;
import us.ihmc.simulationconstructionset.physics.collision.simple.CapsuleShapeDescription;
import us.ihmc.simulationconstructionset.physics.collision.simple.CylinderShapeDescription;
import us.ihmc.simulationconstructionset.physics.collision.simple.PolytopeShapeDescription;
import us.ihmc.simulationconstructionset.physics.collision.simple.SimpleCollisionShapeFactory;
import us.ihmc.simulationconstructionset.physics.collision.simple.SimpleContactWrapper;
import us.ihmc.simulationconstructionset.physics.collision.simple.SphereShapeDescription;

public class SimpleCollisionDetector
implements ScsCollisionDetector {
    private boolean VERBOSE = false;
    private final ArrayList<CollisionShape> collisionObjects = new ArrayList();
    private final Point3D centerOne = new Point3D();
    private final Point3D centerTwo = new Point3D();
    private final Vector3D tempVector = new Vector3D();
    private final Random random = new Random(1776L);
    private boolean[][] haveCollided = null;
    private boolean useSimpleSpeedupMethod = false;
    private double percentChanceCheckCollision = 0.9;
    private final BoundingBox3D boundingBoxOne = new BoundingBox3D(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final BoundingBox3D boundingBoxTwo = new BoundingBox3D(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private final LineSegment3D lineSegmentOne = new LineSegment3D();
    private final LineSegment3D lineSegmentTwo = new LineSegment3D();
    private final Point3D closestPointOnOne = new Point3D();
    private final Point3D closestPointOnTwo = new Point3D();
    private final GilbertJohnsonKeerthiCollisionDetector gjkCollisionDetector = new GilbertJohnsonKeerthiCollisionDetector();
    private final ExpandingPolytopeAlgorithm expandingPolytopeAlgorithm = new ExpandingPolytopeAlgorithm();
    private final Point3D pointOnAToPack = new Point3D();
    private final Point3D pointOnBToPack = new Point3D();
    private final Point3D centerOfSphere = new Point3D();
    private final LineSegment3D tempLineSegment = new LineSegment3D();
    private final Vector3D tempSegmentPointVector = new Vector3D();
    private final Vector3D uVector = new Vector3D();
    private final Vector3D vVector = new Vector3D();
    private final Vector3D w0Vector = new Vector3D();

    @Override
    public void initialize() {
    }

    @Override
    public CollisionShapeFactory getShapeFactory() {
        return new SimpleCollisionShapeFactory(this);
    }

    public void setUseSimpleSpeedupMethod() {
        this.useSimpleSpeedupMethod = true;
    }

    @Override
    public void performCollisionDetection(CollisionDetectionResult result) {
        int i;
        int boundingBoxChecks = 0;
        int collisionChecks = 0;
        int numberOfCollisions = 0;
        int numberOfObjects = this.collisionObjects.size();
        if (this.useSimpleSpeedupMethod && this.haveCollided == null) {
            this.haveCollided = new boolean[numberOfObjects][numberOfObjects];
        }
        for (i = 0; i < numberOfObjects; ++i) {
            CollisionShape collisionShape = this.collisionObjects.get(i);
            collisionShape.computeTransformedCollisionShape();
        }
        for (i = 0; i < numberOfObjects; ++i) {
            CollisionShape objectOne = this.collisionObjects.get(i);
            CollisionShapeDescription<?> descriptionOne = objectOne.getTransformedCollisionShapeDescription();
            for (int j = i + 1; j < numberOfObjects; ++j) {
                if (this.useSimpleSpeedupMethod && !this.haveCollided[i][j] && this.random.nextDouble() < this.percentChanceCheckCollision) continue;
                CollisionShape objectTwo = this.collisionObjects.get(j);
                if (objectOne.isGround() && objectTwo.isGround()) continue;
                CollisionShapeDescription<?> descriptionTwo = objectTwo.getTransformedCollisionShapeDescription();
                if ((objectOne.getCollisionGroup() & objectTwo.getCollisionMask()) == 0 || (objectTwo.getCollisionGroup() & objectOne.getCollisionMask()) == 0) continue;
                objectOne.getBoundingBox(this.boundingBoxOne);
                objectTwo.getBoundingBox(this.boundingBoxTwo);
                ++boundingBoxChecks;
                if (!this.boundingBoxOne.intersectsInclusive((BoundingBox3DReadOnly)this.boundingBoxTwo)) continue;
                ++collisionChecks;
                boolean areColliding = false;
                if (descriptionOne instanceof SphereShapeDescription && descriptionTwo instanceof SphereShapeDescription) {
                    areColliding = this.doSphereSphereCollisionDetection(objectOne, (SphereShapeDescription)descriptionOne, objectTwo, (SphereShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof CapsuleShapeDescription && descriptionTwo instanceof CapsuleShapeDescription) {
                    areColliding = this.doCapsuleCapsuleCollisionDetection(objectOne, (CapsuleShapeDescription)descriptionOne, objectTwo, (CapsuleShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof PolytopeShapeDescription && descriptionTwo instanceof PolytopeShapeDescription) {
                    areColliding = this.doPolytopePolytopeCollisionDetection(objectOne, (PolytopeShapeDescription)descriptionOne, objectTwo, (PolytopeShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof CylinderShapeDescription && descriptionTwo instanceof CylinderShapeDescription) {
                    areColliding = this.doCylinderCylinderCollisionDetection(objectOne, (CylinderShapeDescription)descriptionOne, objectTwo, (CylinderShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof SphereShapeDescription && descriptionTwo instanceof CapsuleShapeDescription) {
                    areColliding = this.doCapsuleSphereCollisionDetection(objectTwo, (CapsuleShapeDescription)descriptionTwo, objectOne, (SphereShapeDescription)descriptionOne, result);
                } else if (descriptionOne instanceof CapsuleShapeDescription && descriptionTwo instanceof SphereShapeDescription) {
                    areColliding = this.doCapsuleSphereCollisionDetection(objectOne, (CapsuleShapeDescription)descriptionOne, objectTwo, (SphereShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof SphereShapeDescription && descriptionTwo instanceof PolytopeShapeDescription) {
                    areColliding = this.doSpherePolytopeCollisionDetection(objectOne, (SphereShapeDescription)descriptionOne, objectTwo, (PolytopeShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof PolytopeShapeDescription && descriptionTwo instanceof SphereShapeDescription) {
                    areColliding = this.doSpherePolytopeCollisionDetection(objectTwo, (SphereShapeDescription)descriptionTwo, objectOne, (PolytopeShapeDescription)descriptionOne, result);
                } else if (descriptionOne instanceof SphereShapeDescription && descriptionTwo instanceof CylinderShapeDescription) {
                    areColliding = this.doSphereCylinderCollisionDetection(objectOne, (SphereShapeDescription)descriptionOne, objectTwo, (CylinderShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof CylinderShapeDescription && descriptionTwo instanceof SphereShapeDescription) {
                    areColliding = this.doSphereCylinderCollisionDetection(objectTwo, (SphereShapeDescription)descriptionTwo, objectOne, (CylinderShapeDescription)descriptionOne, result);
                } else if (descriptionOne instanceof CapsuleShapeDescription && descriptionTwo instanceof PolytopeShapeDescription) {
                    areColliding = this.doCapsulePolytopeCollisionDetection(objectOne, (CapsuleShapeDescription)descriptionOne, objectTwo, (PolytopeShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof PolytopeShapeDescription && descriptionTwo instanceof CapsuleShapeDescription) {
                    areColliding = this.doCapsulePolytopeCollisionDetection(objectTwo, (CapsuleShapeDescription)descriptionTwo, objectOne, (PolytopeShapeDescription)descriptionOne, result);
                } else if (descriptionOne instanceof CapsuleShapeDescription && descriptionTwo instanceof CylinderShapeDescription) {
                    areColliding = this.doCapsuleCylinderCollisionDetection(objectOne, (CapsuleShapeDescription)descriptionOne, objectTwo, (CylinderShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof CylinderShapeDescription && descriptionTwo instanceof CapsuleShapeDescription) {
                    areColliding = this.doCapsuleCylinderCollisionDetection(objectTwo, (CapsuleShapeDescription)descriptionTwo, objectOne, (CylinderShapeDescription)descriptionOne, result);
                } else if (descriptionOne instanceof PolytopeShapeDescription && descriptionTwo instanceof CylinderShapeDescription) {
                    areColliding = this.doCylinderPolytopeCollisionDetection(objectTwo, (CylinderShapeDescription)descriptionTwo, objectOne, (PolytopeShapeDescription)descriptionOne, result);
                } else if (descriptionOne instanceof CylinderShapeDescription && descriptionTwo instanceof PolytopeShapeDescription) {
                    areColliding = this.doCylinderPolytopeCollisionDetection(objectOne, (CylinderShapeDescription)descriptionOne, objectTwo, (PolytopeShapeDescription)descriptionTwo, result);
                } else if (descriptionOne instanceof BoxShapeDescription && descriptionTwo instanceof BoxShapeDescription) {
                    areColliding = this.doBoxBoxCollisionDetection(objectOne, (BoxShapeDescription)descriptionOne, objectTwo, (BoxShapeDescription)descriptionTwo, result);
                }
                if (!areColliding) continue;
                ++numberOfCollisions;
                if (!this.useSimpleSpeedupMethod) continue;
                this.haveCollided[i][j] = true;
            }
        }
        if (this.VERBOSE) {
            System.out.println("\nboundingBoxChecks = " + boundingBoxChecks);
            System.out.println("collisionChecks = " + collisionChecks);
            System.out.println("numberOfCollisions = " + numberOfCollisions);
        }
    }

    public ArrayList<CollisionShape> getCollisionObjects() {
        return this.collisionObjects;
    }

    private boolean doPolytopePolytopeCollisionDetection(CollisionShape objectOne, PolytopeShapeDescription<?> polytopeShapeDescriptionOne, CollisionShape objectTwo, PolytopeShapeDescription<?> polytopeShapeDescriptionTwo, CollisionDetectionResult result) {
        ConvexPolytope3D polytopeOne = polytopeShapeDescriptionOne.getPolytope();
        ConvexPolytope3D polytopeTwo = polytopeShapeDescriptionTwo.getPolytope();
        double radiusOne = polytopeShapeDescriptionOne.getSmoothingRadius();
        double radiusTwo = polytopeShapeDescriptionTwo.getSmoothingRadius();
        return this.doPolytopePolytopeCollisionDetection(objectOne, (SupportingVertexHolder)polytopeOne, radiusOne, objectTwo, (SupportingVertexHolder)polytopeTwo, radiusTwo, result);
    }

    private boolean doCylinderPolytopeCollisionDetection(CollisionShape objectOne, CylinderShapeDescription<?> descriptionOne, CollisionShape objectTwo, PolytopeShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        Cylinder3D polytopeOne = descriptionOne.getSupportingVertexHolder();
        ConvexPolytope3D polytopeTwo = descriptionTwo.getPolytope();
        double radiusOne = descriptionOne.getSmoothingRadius();
        double radiusTwo = descriptionTwo.getSmoothingRadius();
        return this.doPolytopePolytopeCollisionDetection(objectOne, (SupportingVertexHolder)polytopeOne, radiusOne, objectTwo, (SupportingVertexHolder)polytopeTwo, radiusTwo, result);
    }

    private boolean doCylinderCylinderCollisionDetection(CollisionShape objectOne, CylinderShapeDescription<?> descriptionOne, CollisionShape objectTwo, CylinderShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        Cylinder3D polytopeOne = descriptionOne.getSupportingVertexHolder();
        Cylinder3D polytopeTwo = descriptionTwo.getSupportingVertexHolder();
        double radiusOne = descriptionOne.getSmoothingRadius();
        double radiusTwo = descriptionTwo.getSmoothingRadius();
        return this.doPolytopePolytopeCollisionDetection(objectOne, (SupportingVertexHolder)polytopeOne, radiusOne, objectTwo, (SupportingVertexHolder)polytopeTwo, radiusTwo, result);
    }

    private boolean doBoxBoxCollisionDetection(CollisionShape objectOne, BoxShapeDescription<?> descriptionOne, CollisionShape objectTwo, BoxShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        return false;
    }

    private boolean doCapsuleSphereCollisionDetection(CollisionShape objectOne, CapsuleShapeDescription<?> descriptionOne, CollisionShape objectTwo, SphereShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        double capsuleRadius = descriptionOne.getRadius();
        descriptionOne.getLineSegment(this.lineSegmentOne);
        double sphereRadius = descriptionTwo.getRadius();
        descriptionTwo.getCenter(this.centerOfSphere);
        this.lineSegmentOne.orthogonalProjection((Point3DReadOnly)this.centerOfSphere, (Point3DBasics)this.closestPointOnOne);
        double distanceSquared = this.centerOfSphere.distanceSquared((Point3DReadOnly)this.closestPointOnOne);
        if (distanceSquared <= (capsuleRadius + sphereRadius) * (capsuleRadius + sphereRadius)) {
            this.addCollisionPairToResult(this.closestPointOnOne, this.centerOfSphere, capsuleRadius, sphereRadius, distanceSquared, objectOne, objectTwo, result);
            return true;
        }
        return false;
    }

    private boolean doSphereCylinderCollisionDetection(CollisionShape objectOne, SphereShapeDescription<?> descriptionOne, CollisionShape objectTwo, CylinderShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        double sphereRadius = descriptionOne.getRadius();
        descriptionOne.getCenter(this.centerOfSphere);
        descriptionTwo.getProjection(this.centerOfSphere, this.closestPointOnTwo);
        double cylinderSmoothingRadius = descriptionTwo.getSmoothingRadius();
        double distanceSquared = this.centerOfSphere.distanceSquared((Point3DReadOnly)this.closestPointOnTwo);
        if (distanceSquared <= (cylinderSmoothingRadius + sphereRadius) * (cylinderSmoothingRadius + sphereRadius)) {
            this.addCollisionPairToResult(this.centerOfSphere, this.closestPointOnTwo, sphereRadius, cylinderSmoothingRadius, distanceSquared, objectOne, objectTwo, result);
            return true;
        }
        return false;
    }

    private boolean doCapsuleCylinderCollisionDetection(CollisionShape capsuleShape, CapsuleShapeDescription<?> capsuleDescription, CollisionShape cylinderShape, CylinderShapeDescription<?> cylinderDescription, CollisionDetectionResult result) {
        double cylinderSmoothingRadius = cylinderDescription.getSmoothingRadius();
        Cylinder3D cylinderSupportingVertexHolder = cylinderDescription.getSupportingVertexHolder();
        return this.doCapsuleSupportingVertexHolderCollisionDetection(capsuleShape, capsuleDescription, cylinderShape, (SupportingVertexHolder)cylinderSupportingVertexHolder, cylinderSmoothingRadius, result);
    }

    private boolean doCapsuleCapsuleCollisionDetection(CollisionShape objectOne, CapsuleShapeDescription<?> descriptionOne, CollisionShape objectTwo, CapsuleShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        double radiusOne = descriptionOne.getRadius();
        double radiusTwo = descriptionTwo.getRadius();
        descriptionOne.getLineSegment(this.lineSegmentOne);
        descriptionTwo.getLineSegment(this.lineSegmentTwo);
        this.getClosestPointsOnLineSegments(this.lineSegmentOne, this.lineSegmentTwo, this.closestPointOnOne, this.closestPointOnTwo);
        double distanceSquared = this.closestPointOnOne.distanceSquared((Point3DReadOnly)this.closestPointOnTwo);
        if (distanceSquared <= (radiusOne + radiusTwo) * (radiusOne + radiusTwo)) {
            this.addCollisionPairToResult(this.closestPointOnOne, this.closestPointOnTwo, radiusOne, radiusTwo, distanceSquared, objectOne, objectTwo, result);
            return true;
        }
        return false;
    }

    private void addCollisionPairToResult(Point3D pointOne, Point3D pointTwo, double radiusOne, double radiusTwo, double distanceSquared, CollisionShape objectOne, CollisionShape objectTwo, CollisionDetectionResult result) {
        Vector3D normalVector = new Vector3D();
        normalVector.sub((Tuple3DReadOnly)pointTwo, (Tuple3DReadOnly)pointOne);
        if (normalVector.lengthSquared() < 1.0E-10) {
            return;
        }
        normalVector.normalize();
        Point3D pointOnOne = new Point3D((Tuple3DReadOnly)pointOne);
        this.tempVector.set(normalVector);
        this.tempVector.scale(radiusOne);
        pointOnOne.add((Tuple3DReadOnly)this.tempVector);
        Point3D pointOnTwo = new Point3D((Tuple3DReadOnly)pointTwo);
        this.tempVector.set(normalVector);
        this.tempVector.scale(-radiusTwo);
        pointOnTwo.add((Tuple3DReadOnly)this.tempVector);
        double distance = Math.sqrt(distanceSquared) - radiusOne - radiusTwo;
        SimpleContactWrapper contacts = new SimpleContactWrapper(objectOne, objectTwo);
        contacts.addContact(pointOnOne, pointOnTwo, normalVector, distance);
        result.addContact(contacts);
    }

    private boolean doSphereSphereCollisionDetection(CollisionShape objectOne, SphereShapeDescription<?> descriptionOne, CollisionShape objectTwo, SphereShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        double radiusOne = descriptionOne.getRadius();
        double radiusTwo = descriptionTwo.getRadius();
        descriptionOne.getCenter(this.centerOne);
        descriptionTwo.getCenter(this.centerTwo);
        double distanceSquared = this.centerOne.distanceSquared((Point3DReadOnly)this.centerTwo);
        if (distanceSquared <= (radiusOne + radiusTwo) * (radiusOne + radiusTwo)) {
            this.addCollisionPairToResult(this.centerOne, this.centerTwo, radiusOne, radiusTwo, distanceSquared, objectOne, objectTwo, result);
            return true;
        }
        return false;
    }

    private boolean doSpherePolytopeCollisionDetection(CollisionShape objectOne, SphereShapeDescription<?> descriptionOne, CollisionShape objectTwo, PolytopeShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        descriptionOne.getCenter(this.centerOfSphere);
        double sphereRadius = descriptionOne.getRadius();
        double polytopeSmoothingRadius = descriptionTwo.getSmoothingRadius();
        SupportingVertexHolder sphereAsSupportingVertexHolder = new SupportingVertexHolder(){

            public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
                supportingVertexToPack.set((Tuple3DReadOnly)SimpleCollisionDetector.this.centerOfSphere);
                return true;
            }
        };
        return this.doPolytopePolytopeCollisionDetection(objectOne, sphereAsSupportingVertexHolder, sphereRadius, objectTwo, (SupportingVertexHolder)descriptionTwo.getPolytope(), polytopeSmoothingRadius, result);
    }

    private boolean doCapsulePolytopeCollisionDetection(CollisionShape objectOne, CapsuleShapeDescription<?> descriptionOne, CollisionShape objectTwo, PolytopeShapeDescription<?> descriptionTwo, CollisionDetectionResult result) {
        double polytopeSmoothingRadius = descriptionTwo.getSmoothingRadius();
        return this.doCapsuleSupportingVertexHolderCollisionDetection(objectOne, descriptionOne, objectTwo, (SupportingVertexHolder)descriptionTwo.getPolytope(), polytopeSmoothingRadius, result);
    }

    private boolean doCapsuleSupportingVertexHolderCollisionDetection(CollisionShape objectOne, CapsuleShapeDescription<?> descriptionOne, CollisionShape objectTwo, SupportingVertexHolder descriptionTwo, double smoothingRadiusTwo, CollisionDetectionResult result) {
        descriptionOne.getLineSegment(this.tempLineSegment);
        final Point3DBasics tempSegmentPointOne = this.tempLineSegment.getFirstEndpoint();
        final Point3DBasics tempSegmentPointTwo = this.tempLineSegment.getSecondEndpoint();
        double capsuleRadius = descriptionOne.getRadius();
        SupportingVertexHolder capsuleAsSupportingVertexHolder = new SupportingVertexHolder(){

            public boolean getSupportingVertex(Vector3DReadOnly supportDirection, Point3DBasics supportingVertexToPack) {
                SimpleCollisionDetector.this.tempSegmentPointVector.set((Tuple3DReadOnly)tempSegmentPointOne);
                double dotOne = SimpleCollisionDetector.this.tempSegmentPointVector.dot((Tuple3DReadOnly)supportDirection);
                SimpleCollisionDetector.this.tempSegmentPointVector.set((Tuple3DReadOnly)tempSegmentPointTwo);
                double dotTwo = SimpleCollisionDetector.this.tempSegmentPointVector.dot((Tuple3DReadOnly)supportDirection);
                if (dotOne > dotTwo) {
                    supportingVertexToPack.set((Tuple3DReadOnly)tempSegmentPointOne);
                } else {
                    supportingVertexToPack.set((Tuple3DReadOnly)tempSegmentPointTwo);
                }
                return true;
            }
        };
        return this.doPolytopePolytopeCollisionDetection(objectOne, capsuleAsSupportingVertexHolder, capsuleRadius, objectTwo, descriptionTwo, smoothingRadiusTwo, result);
    }

    private boolean doPolytopePolytopeCollisionDetection(CollisionShape objectOne, SupportingVertexHolder supportingVertexHolderOne, double radiusOne, CollisionShape objectTwo, SupportingVertexHolder supportingVertexHolderTwo, double radiusTwo, CollisionDetectionResult result) {
        EuclidShape3DCollisionResult collisionResult = this.gjkCollisionDetector.evaluateCollision(supportingVertexHolderOne, supportingVertexHolderTwo);
        boolean areColliding = collisionResult.areShapesColliding();
        if (!areColliding) {
            this.pointOnAToPack.set(collisionResult.getPointOnA());
            this.pointOnBToPack.set(collisionResult.getPointOnB());
            double separationDistanceForContact = radiusOne + radiusTwo;
            double distanceSquared = this.pointOnAToPack.distanceSquared((Point3DReadOnly)this.pointOnBToPack);
            if (distanceSquared < separationDistanceForContact * separationDistanceForContact) {
                SimpleContactWrapper contacts = new SimpleContactWrapper(objectOne, objectTwo);
                Vector3D normalVector = new Vector3D();
                normalVector.sub((Tuple3DReadOnly)this.pointOnBToPack, (Tuple3DReadOnly)this.pointOnAToPack);
                if (normalVector.lengthSquared() > 1.0E-6) {
                    normalVector.normalize();
                    double distanceToReport = -this.pointOnAToPack.distance((Point3DReadOnly)this.pointOnBToPack);
                    Point3D contactOnA = new Point3D((Tuple3DReadOnly)normalVector);
                    contactOnA.scaleAdd(radiusOne, (Tuple3DReadOnly)this.pointOnAToPack);
                    Point3D contactOnB = new Point3D((Tuple3DReadOnly)normalVector);
                    contactOnB.scaleAdd(-radiusTwo, (Tuple3DReadOnly)this.pointOnBToPack);
                    contacts.addContact(contactOnA, contactOnB, normalVector, distanceToReport);
                    result.addContact(contacts);
                    return true;
                }
            }
        } else {
            this.expandingPolytopeAlgorithm.evaluateCollision(supportingVertexHolderOne, supportingVertexHolderTwo, this.gjkCollisionDetector.getSimplex().getVertices(), (EuclidShape3DCollisionResultBasics)collisionResult);
            this.pointOnAToPack.set(collisionResult.getPointOnA());
            this.pointOnBToPack.set(collisionResult.getPointOnB());
            if (!collisionResult.areShapesColliding()) {
                return false;
            }
            Vector3D collisionNormal = new Vector3D((Tuple3DReadOnly)this.expandingPolytopeAlgorithm.getClosestFace().getClosestPointToOrigin());
            if (collisionNormal.lengthSquared() > 1.0E-6) {
                collisionNormal.normalize();
                SimpleContactWrapper contacts = new SimpleContactWrapper(objectOne, objectTwo);
                double distanceToReport = -this.pointOnAToPack.distance((Point3DReadOnly)this.pointOnBToPack);
                contacts.addContact(new Point3D((Tuple3DReadOnly)this.pointOnAToPack), new Point3D((Tuple3DReadOnly)this.pointOnBToPack), collisionNormal, distanceToReport);
                result.addContact(contacts);
            }
            return true;
        }
        return false;
    }

    public void addShape(CollisionShape collisionShape) {
        this.collisionObjects.add(collisionShape);
    }

    public void getClosestPointsOnLineSegments(LineSegment3D segmentOne, LineSegment3D segmentTwo, Point3D closestPointOnOneToPack, Point3D closestPointOnTwoToPack) {
        double numeratorTwo;
        double numeratorOne;
        double denominator;
        Point3DBasics p0 = segmentOne.getFirstEndpoint();
        Point3DBasics p1 = segmentOne.getSecondEndpoint();
        Point3DBasics q0 = segmentTwo.getFirstEndpoint();
        Point3DBasics q1 = segmentTwo.getSecondEndpoint();
        this.uVector.sub((Tuple3DReadOnly)p1, (Tuple3DReadOnly)p0);
        this.vVector.sub((Tuple3DReadOnly)q1, (Tuple3DReadOnly)q0);
        this.w0Vector.sub((Tuple3DReadOnly)p0, (Tuple3DReadOnly)q0);
        double a = this.uVector.dot((Tuple3DReadOnly)this.uVector);
        double b = this.uVector.dot((Tuple3DReadOnly)this.vVector);
        double c = this.vVector.dot((Tuple3DReadOnly)this.vVector);
        double d = this.uVector.dot((Tuple3DReadOnly)this.w0Vector);
        double e = this.vVector.dot((Tuple3DReadOnly)this.w0Vector);
        double denominatorOne = denominator = a * c - b * b;
        double denominatorTwo = denominator;
        double smallNumber = 1.0E-7;
        if (denominator < smallNumber) {
            numeratorOne = 0.0;
            denominatorOne = 1.0;
            numeratorTwo = e;
            denominatorTwo = c;
        } else {
            numeratorOne = b * e - c * d;
            numeratorTwo = a * e - b * d;
            if (numeratorOne < 0.0) {
                numeratorOne = 0.0;
                numeratorTwo = e;
                denominatorTwo = c;
            } else if (numeratorOne > denominatorOne) {
                numeratorOne = denominatorOne;
                numeratorTwo = e + b;
                denominatorTwo = c;
            }
        }
        if (numeratorTwo < 0.0) {
            numeratorTwo = 0.0;
            if (-d < 0.0) {
                numeratorOne = 0.0;
            } else if (-d > a) {
                numeratorOne = denominatorOne;
            } else {
                numeratorOne = -d;
                denominatorOne = a;
            }
        } else if (numeratorTwo > denominatorTwo) {
            numeratorTwo = denominatorTwo;
            if (-d + b < 0.0) {
                numeratorOne = 0.0;
            } else if (-d + b > a) {
                numeratorOne = denominatorOne;
            } else {
                numeratorOne = -d + b;
                denominatorOne = a;
            }
        }
        double lambdaOne = Math.abs(numeratorOne) < smallNumber ? 0.0 : numeratorOne / denominatorOne;
        double lambdaTwo = Math.abs(numeratorTwo) < smallNumber ? 0.0 : numeratorTwo / denominatorTwo;
        closestPointOnOneToPack.set((Tuple3DReadOnly)this.uVector);
        closestPointOnOneToPack.scaleAdd(lambdaOne, (Tuple3DReadOnly)p0);
        closestPointOnTwoToPack.set((Tuple3DReadOnly)this.vVector);
        closestPointOnTwoToPack.scaleAdd(lambdaTwo, (Tuple3DReadOnly)q0);
    }
}

