/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.commons.lang3.mutable.MutableDouble;
import us.ihmc.commons.MathTools;
import us.ihmc.graphicsDescription.graphInterfaces.SelectedVariableHolder;
import us.ihmc.tools.thread.CloseableAndDisposable;
import us.ihmc.tools.thread.CloseableAndDisposableRegistry;
import us.ihmc.yoVariables.listener.YoVariableChangedListener;
import us.ihmc.yoVariables.variable.YoVariable;

public class JSliderYoVariableControl
extends JPanel
implements CloseableAndDisposable,
MouseListener {
    private static final int SLIDER_MIN_VALUE = 0;
    private static final int SLIDER_MAX_VALUE = 100;
    private YoVariable yoVariable;
    private static final long serialVersionUID = 8570638563928914747L;
    private boolean changeLock = false;
    private JTextField jTextFieldValue;
    private JSlider jSlider;
    private YoVariableChangeListener yoVariableChangeListener;
    private String name;
    private SelectedVariableHolder selectedVariableHolder;
    private TextFieldListener valueTextFieldListener;
    private boolean sliderToBeSetWithoutNotifiers;
    private MinMaxTextEntryBox minTextEntryBox;
    private MinMaxTextEntryBox maxTextEntryBox;

    public JSliderYoVariableControl(SelectedVariableHolder selectedVariableHolder, CloseableAndDisposableRegistry closeableAndDisposableRegistry) {
        super(new BorderLayout());
        this.setMinimumSize(new Dimension(200, 400));
        JPanel mainPanel = new JPanel(new BorderLayout());
        JPanel minMaxTextFields = new JPanel(new BorderLayout());
        this.jSlider = new JSlider(1, 0, 100, 50);
        mainPanel.add((Component)minMaxTextFields, "Center");
        mainPanel.add((Component)this.jSlider, "East");
        JTextField jTextFieldMin = new JTextField(10);
        this.minTextEntryBox = new MinMaxTextEntryBox(this, jTextFieldMin);
        this.minTextEntryBox.setValue(-1000.0);
        jTextFieldMin.addActionListener(this.minTextEntryBox);
        JTextField jTextFieldMax = new JTextField(10);
        this.maxTextEntryBox = new MinMaxTextEntryBox(this, jTextFieldMax);
        this.maxTextEntryBox.setValue(1000.0);
        jTextFieldMax.addActionListener(this.maxTextEntryBox);
        minMaxTextFields.add((Component)jTextFieldMax, "North");
        minMaxTextFields.add((Component)jTextFieldMin, "South");
        this.yoVariable = null;
        this.setTitle();
        this.jSlider.setPaintLabels(false);
        this.jSlider.addChangeListener(new SliderChangeListener(this.jSlider, this));
        this.jSlider.setEnabled(false);
        this.selectedVariableHolder = selectedVariableHolder;
        this.jTextFieldValue = new JTextField(String.valueOf(1));
        this.valueTextFieldListener = new TextFieldListener(this);
        this.jTextFieldValue.addActionListener(this.valueTextFieldListener);
        this.add((Component)mainPanel, "Center");
        this.add((Component)this.jTextFieldValue, "South");
        closeableAndDisposableRegistry.registerCloseableAndDisposable((CloseableAndDisposable)this);
        mainPanel.addMouseListener(this);
    }

    private boolean getSliderToBeSetWithoutNotifiers() {
        return this.sliderToBeSetWithoutNotifiers;
    }

    private void setSliderToBeSetWithoutNotifiers(boolean value) {
        this.sliderToBeSetWithoutNotifiers = value;
    }

    @Override
    public String getName() {
        if (this.yoVariable != null) {
            return this.yoVariable.getName();
        }
        return "Not Set";
    }

    public void closeAndDispose() {
    }

    private void setTitle() {
        this.setBorder(new TitledBorder(this.getName()));
        this.repaint();
    }

    public synchronized void lock() {
        if (!this.changeLock) {
            Thread timer = new Thread(new Runnable(){

                @Override
                public void run() {
                    JSliderYoVariableControl.this.changeLock = true;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    JSliderYoVariableControl.this.changeLock = false;
                }
            }, "JSliderYoVariableControl");
            timer.start();
        }
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.getButton() != 1) {
            if (e.getButton() == 2) {
                YoVariable yoVariable = this.selectedVariableHolder.getSelectedVariable();
                if (yoVariable != null) {
                    if (this.yoVariable != null) {
                        this.yoVariable.removeListener((YoVariableChangedListener)this.yoVariableChangeListener);
                    }
                    this.jSlider.setEnabled(true);
                    this.yoVariable = yoVariable;
                    this.setTitle();
                    this.addListenersForYoVariable();
                    this.setMinMaxValuesFromYoVariable();
                    this.setTextFieldDouble(this.yoVariable.getValueAsDouble());
                }
            } else if (e.getButton() == 3) {
                // empty if block
            }
        }
    }

    private void setMinMaxValuesFromYoVariable() {
        this.minTextEntryBox.setValue(this.yoVariable.getLowerBound());
        this.maxTextEntryBox.setValue(this.yoVariable.getUpperBound());
        this.setSliderPosition(this.convertParameterValueToSlider(this.yoVariable.getValueAsDouble()));
    }

    private boolean areMinMaxValid() {
        return this.minTextEntryBox.getValue() < this.maxTextEntryBox.getValue();
    }

    private void addListenersForYoVariable() {
        this.yoVariableChangeListener = new YoVariableChangeListener(this);
        this.yoVariable.addListener((YoVariableChangedListener)this.yoVariableChangeListener);
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    private void setYoVariable(double value) {
        this.yoVariableChangeListener.enabled = false;
        this.yoVariable.setValueFromDouble(value);
        this.yoVariableChangeListener.enabled = true;
    }

    private double convertSliderToParameterValue(int sliderValue) {
        double percentOfRange = (double)(sliderValue - 0) / 100.0;
        double actualValue = this.minTextEntryBox.getValue() + percentOfRange * (this.maxTextEntryBox.getValue() - this.minTextEntryBox.getValue());
        return actualValue;
    }

    private int convertParameterValueToSlider(double value) {
        double percentOfRange = (value - this.minTextEntryBox.getValue()) / (this.maxTextEntryBox.getValue() - this.minTextEntryBox.getValue());
        percentOfRange = MathTools.clamp((double)percentOfRange, (double)0.0, (double)1.0);
        int actualValue = 0 + (int)(percentOfRange * 100.0);
        return actualValue;
    }

    private double getTextFieldValue() {
        return Double.parseDouble(this.jTextFieldValue.getText());
    }

    private void setTextFieldDouble(double value) {
        String formattedValue = new DecimalFormat("#.#####").format(value);
        this.jTextFieldValue.setText(formattedValue);
    }

    private void setSliderPosition(int sliderValue) {
        this.setSliderToBeSetWithoutNotifiers(true);
        sliderValue = MathTools.clamp((int)sliderValue, (int)0, (int)100);
        this.jSlider.setValue(sliderValue);
        this.setSliderToBeSetWithoutNotifiers(false);
    }

    private void setSliderEnable(boolean value) {
        this.jSlider.setEnabled(value);
    }

    private class TextFieldListener
    implements ActionListener {
        JSliderYoVariableControl jSliderYoVariableControl;

        public TextFieldListener(JSliderYoVariableControl jSliderYoVariableControl2) {
            this.jSliderYoVariableControl = jSliderYoVariableControl2;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                double value = this.jSliderYoVariableControl.getTextFieldValue();
                this.jSliderYoVariableControl.setSliderPosition(this.jSliderYoVariableControl.convertParameterValueToSlider(value));
                JSliderYoVariableControl.this.setYoVariable(value);
            }
            catch (Exception ex) {
                JSliderYoVariableControl.this.setTextFieldDouble(JSliderYoVariableControl.this.yoVariable.getValueAsDouble());
            }
        }
    }

    private class MinMaxTextEntryBox
    implements ActionListener {
        JSliderYoVariableControl jSliderYoVariableControl;
        MutableDouble valueToUpdate = new MutableDouble();
        JTextField jTextField;

        public MinMaxTextEntryBox(JSliderYoVariableControl jSliderYoVariableControl2, JTextField jTextField) {
            this.jSliderYoVariableControl = jSliderYoVariableControl2;
            this.jTextField = jTextField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                double value = Double.parseDouble(this.jTextField.getText());
                this.valueToUpdate.setValue(value);
                this.jSliderYoVariableControl.setSliderPosition(this.jSliderYoVariableControl.convertParameterValueToSlider(JSliderYoVariableControl.this.yoVariable.getValueAsDouble()));
                JSliderYoVariableControl.this.setSliderEnable(JSliderYoVariableControl.this.areMinMaxValid());
            }
            catch (Exception ex) {
                this.jTextField.setText(String.valueOf(this.getValue()));
            }
        }

        public void setValue(double value) {
            this.valueToUpdate.setValue(value);
            this.jTextField.setText(String.valueOf(this.valueToUpdate.getValue()));
        }

        public double getValue() {
            return this.valueToUpdate.getValue();
        }
    }

    private class YoVariableChangeListener
    implements YoVariableChangedListener {
        JSliderYoVariableControl jSliderYoVariableControl;
        boolean enabled = true;

        public YoVariableChangeListener(JSliderYoVariableControl jSliderYoVariableControl2) {
            this.jSliderYoVariableControl = jSliderYoVariableControl2;
        }

        public void changed(YoVariable v) {
            if (!this.enabled) {
                return;
            }
            this.jSliderYoVariableControl.setSliderPosition(JSliderYoVariableControl.this.convertParameterValueToSlider(v.getValueAsDouble()));
            JSliderYoVariableControl.this.setTextFieldDouble(v.getValueAsDouble());
        }
    }

    private class SliderChangeListener
    implements ChangeListener {
        JSlider slider;
        JSliderYoVariableControl jSliderYoVariableControl;

        public SliderChangeListener(JSlider slider, JSliderYoVariableControl jSliderYoVariableControl2) {
            this.slider = slider;
            this.jSliderYoVariableControl = jSliderYoVariableControl2;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!this.jSliderYoVariableControl.getSliderToBeSetWithoutNotifiers()) {
                int sliderValue = this.slider.getValue();
                if (JSliderYoVariableControl.this.yoVariable != null) {
                    double value = JSliderYoVariableControl.this.convertSliderToParameterValue(sliderValue);
                    JSliderYoVariableControl.this.setYoVariable(value);
                }
                JSliderYoVariableControl.this.setTextFieldDouble(JSliderYoVariableControl.this.convertSliderToParameterValue(sliderValue));
            }
        }
    }
}

