/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.engine.featherstone;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import us.ihmc.euclid.matrix.Matrix3D;
import us.ihmc.euclid.matrix.RotationMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixBasics;
import us.ihmc.euclid.matrix.interfaces.RotationMatrixReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.ExternalTorque;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.GroundContactPointGroup;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.JointWrenchSensor;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.SpatialVector;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.CollisionIntegrator;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.SpatialInertiaMatrix;
import us.ihmc.simulationconstructionset.physics.engine.featherstone.SpatialTransformationMatrix;

public abstract class JointPhysics<J extends Joint> {
    protected J owner;
    public Vector3D u_i;
    public Vector3D d_i = new Vector3D();
    public Vector3D u_iXd_i = new Vector3D();
    public Vector3D r_in = new Vector3D();
    public Vector3D w_i = new Vector3D();
    public Vector3D v_i = new Vector3D();
    public Vector3D r_i = new Vector3D();
    protected Vector3D r_h = new Vector3D();
    protected Vector3D v_i_temp = new Vector3D();
    protected SpatialTransformationMatrix i_X_hat_h = new SpatialTransformationMatrix();
    protected SpatialTransformationMatrix h_X_hat_i = new SpatialTransformationMatrix();
    public SpatialVector Z_hat_i = new SpatialVector();
    public SpatialInertiaMatrix I_hat_i = new SpatialInertiaMatrix();
    public SpatialVector c_hat_i = new SpatialVector();
    public SpatialVector a_hat_i = new SpatialVector();
    public SpatialVector s_hat_i = new SpatialVector();
    public double Q_i;
    public List<KinematicPoint> kinematicPoints;
    protected List<ExternalForcePoint> externalForcePoints;
    protected List<ExternalTorque> externalTorques;
    public LinkedHashMap<Integer, GroundContactPointGroup> groundContactPointGroups;
    public List<GroundContactPointGroup> groundContactPointGroupList;
    protected JointWrenchSensor jointWrenchSensor;
    private SpatialVector tempJointWrenchVector;
    private Vector3D tempVectorForWrenchTranslation;
    private Vector3D tempOffsetForWrenchTranslation;
    public RotationMatrix Ri_0 = new RotationMatrix();
    public RotationMatrix R0_i = new RotationMatrix();
    public RotationMatrix Ri_h = new RotationMatrix();
    public RotationMatrix Rh_i = new RotationMatrix();
    public RotationMatrix Rtemp = new RotationMatrix();
    private final Vector3D externalForceVector = new Vector3D();
    private final Vector3D externalForceR = new Vector3D();
    private final Vector3D tempExternalMomentVector = new Vector3D();
    private final Vector3D externalMomentVector = new Vector3D();
    private final Vector3D w_h = new Vector3D();
    private double sIs;
    private double Qi_etc;
    protected SpatialInertiaMatrix SIM1 = new SpatialInertiaMatrix();
    protected SpatialInertiaMatrix SIM2 = new SpatialInertiaMatrix();
    protected SpatialVector sV1 = new SpatialVector();
    protected SpatialVector sV2 = new SpatialVector();
    protected SpatialVector X_hat_h_a_hat_h = new SpatialVector();
    private SpatialVector qdd_s_hat_i = new SpatialVector();
    private final Vector3D tempDeltaPVector = new Vector3D();
    private final Vector3D tempOmegaCrossDeltaPVector = new Vector3D();
    private final Vector3D tempOmegaCrossOmegaCrossDeltaPVector = new Vector3D();
    private Matrix3D Ki = new Matrix3D();
    private CollisionIntegrator collisionIntegrator = new CollisionIntegrator();
    private SpatialVector p_hat_k = new SpatialVector();
    private SpatialTransformationMatrix k_X_hat_coll = new SpatialTransformationMatrix();
    private Vector3D tempVector = new Vector3D();
    private SpatialVector delta_v_hat_null = new SpatialVector();
    private final SpatialVector p_hat_coll = new SpatialVector();
    private final SpatialVector delta_v_hat_k = new SpatialVector();
    private final SpatialTransformationMatrix coll_X_hat_k = new SpatialTransformationMatrix();
    protected final SpatialVector Y_hat_i = new SpatialVector();
    private final SpatialVector Y_hat_parent = new SpatialVector();
    private SpatialVector delta_v_hat_h = new SpatialVector();
    private final SpatialVector delta_v_temp1 = new SpatialVector();
    private final SpatialVector delta_v_temp2 = new SpatialVector();
    private final Point3D tempCOMPoint = new Point3D();
    private Vector3D tempLinearMomentum = new Vector3D();
    private Vector3D tempAngularMomentum = new Vector3D();
    private Vector3D tempCOMVector = new Vector3D();
    private Vector3D tempRotationalEnergyVector = new Vector3D();
    private final Point3D tempPE_COMPoint = new Point3D();
    private boolean doFreezeFrame = false;

    public JointPhysics(J owner) {
        this.owner = owner;
    }

    public void featherstonePassOne(Vector3DReadOnly w_h, Vector3DReadOnly v_h, RotationMatrixReadOnly Rh_0) {
        int i;
        this.r_in.set((Tuple3DReadOnly)((Joint)this.owner).getOffset());
        if (((Joint)this.owner).parentJoint != null) {
            this.r_in.sub((Tuple3DReadOnly)((Joint)this.owner).parentJoint.link.getComOffset());
        }
        this.jointDependentSetAndGetRotation((RotationMatrixBasics)this.Rh_i);
        this.Ri_h.set(this.Rh_i);
        this.Ri_h.transpose();
        this.Ri_0.set(this.Ri_h);
        this.Ri_0.multiply(Rh_0);
        this.jointDependentSet_d_i();
        this.u_iXd_i.cross((Tuple3DReadOnly)this.u_i, (Tuple3DReadOnly)this.d_i);
        this.r_i.set(this.r_in);
        this.Ri_h.transform((Tuple3DBasics)this.r_i);
        this.r_i.add((Tuple3DReadOnly)this.d_i);
        this.r_h.set(this.r_i);
        this.r_h.scale(-1.0);
        this.Rh_i.transform((Tuple3DBasics)this.r_h);
        this.w_i.set((Tuple3DReadOnly)w_h);
        this.Ri_h.transform((Tuple3DBasics)this.w_i);
        this.v_i.set((Tuple3DReadOnly)v_h);
        this.Ri_h.transform((Tuple3DBasics)this.v_i);
        this.v_i_temp.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)this.r_i);
        this.v_i.add((Tuple3DReadOnly)this.v_i_temp);
        this.jointDependentFeatherstonePassOne();
        this.R0_i.set(this.Ri_0);
        this.R0_i.transpose();
        if (this.groundContactPointGroupList != null) {
            for (i = 0; i < this.groundContactPointGroupList.size(); ++i) {
                ArrayList<GroundContactPoint> groundContactPoints = this.groundContactPointGroupList.get(i).getGroundContactPoints();
                for (int y = 0; y < groundContactPoints.size(); ++y) {
                    GroundContactPoint point = (GroundContactPoint)groundContactPoints.get(y);
                    point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((Joint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
                }
            }
        }
        if (this.kinematicPoints != null) {
            for (i = 0; i < this.kinematicPoints.size(); ++i) {
                KinematicPoint point = this.kinematicPoints.get(i);
                point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((Joint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
            }
        }
        for (i = 0; i < ((Joint)this.owner).getChildrenJoints().size(); ++i) {
            Joint child = ((Joint)this.owner).getChildrenJoints().get(i);
            child.physics.featherstonePassOne((Vector3DReadOnly)this.w_i, (Vector3DReadOnly)this.v_i, (RotationMatrixReadOnly)this.Ri_0);
        }
    }

    public void featherstonePassTwo(Vector3DReadOnly w_previous) {
        int i;
        this.w_h.set((Tuple3DReadOnly)w_previous);
        if (this.Ri_h != null) {
            this.Ri_h.transform((Tuple3DBasics)this.w_h);
        }
        this.Z_hat_i.setInitArticulatedZeroAccel(((Joint)this.owner).link.getMass(), (Vector3DReadOnly)this.w_i, (Matrix3DReadOnly)((Joint)this.owner).link.Inertia, (RotationMatrixReadOnly)this.Ri_0, ((Joint)this.owner).rob.gravityX.getDoubleValue(), ((Joint)this.owner).rob.gravityY.getDoubleValue(), ((Joint)this.owner).rob.gravityZ.getDoubleValue());
        this.I_hat_i.setInitArticulatedInertia(((Joint)this.owner).link.getMass(), ((Joint)this.owner).link.Inertia);
        if (this.groundContactPointGroupList != null) {
            for (i = 0; i < this.groundContactPointGroupList.size(); ++i) {
                ArrayList<GroundContactPoint> groundContactPoints = this.groundContactPointGroupList.get(i).getGroundContactPoints();
                for (int y = 0; y < groundContactPoints.size(); ++y) {
                    GroundContactPoint point = (GroundContactPoint)groundContactPoints.get(y);
                    this.applyForcesAndMomentsFromExternalForcePoints(point);
                }
            }
        }
        if (this.externalForcePoints != null) {
            for (i = 0; i < this.externalForcePoints.size(); ++i) {
                ExternalForcePoint point = this.externalForcePoints.get(i);
                point.active = false;
                this.applyForcesAndMomentsFromExternalForcePoints(point);
            }
        }
        if (this.externalTorques != null) {
            for (i = 0; i < this.externalTorques.size(); ++i) {
                ExternalTorque p = this.externalTorques.get(i);
                p.active = false;
                double tx = p.getTorqueX();
                double ty = p.getTorqueY();
                double tz = p.getTorqueZ();
                if (tx == 0.0 && ty == 0.0 && tz == 0.0) continue;
                this.externalForceVector.set(-tx, -ty, -tz);
                this.Ri_0.transform((Tuple3DBasics)this.externalForceVector);
                this.Z_hat_i.bottom.add((Tuple3DReadOnly)this.externalForceVector);
            }
        }
        this.jointDependentFeatherstonePassTwo((Vector3DReadOnly)this.w_h);
        for (i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassTwo((Vector3DReadOnly)this.w_i);
        }
        this.externalForceVector.set(0.0, 0.0, 0.0);
        this.externalForceR.set(0.0, 0.0, 0.0);
        this.tempExternalMomentVector.set(0.0, 0.0, 0.0);
        this.externalMomentVector.set(0.0, 0.0, 0.0);
    }

    private void applyForcesAndMomentsFromExternalForcePoints(ExternalForcePoint point) {
        if (!point.isForceAndMomentZero()) {
            point.getForce((Vector3DBasics)this.externalForceVector);
            this.externalForceVector.negate();
            this.Ri_0.transform((Tuple3DBasics)this.externalForceVector);
            point.getOffset((Tuple3DBasics)this.externalForceR);
            this.externalForceR.sub((Tuple3DReadOnly)((Joint)this.owner).link.comOffset);
            this.externalMomentVector.cross((Tuple3DReadOnly)this.externalForceR, (Tuple3DReadOnly)this.externalForceVector);
            point.getMoment((Vector3DBasics)this.tempExternalMomentVector);
            this.Ri_0.transform((Tuple3DBasics)this.tempExternalMomentVector);
            this.externalMomentVector.sub((Tuple3DReadOnly)this.tempExternalMomentVector);
            this.Z_hat_i.top.add((Tuple3DReadOnly)this.externalForceVector);
            this.Z_hat_i.bottom.add((Tuple3DReadOnly)this.externalMomentVector);
        }
    }

    public void featherstonePassThree() {
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassThree(this.I_hat_i, this.Z_hat_i);
        }
        this.sIs = this.I_hat_i.sIs(this.s_hat_i);
        this.sV1.set(this.c_hat_i);
        this.I_hat_i.multiply(this.sV1);
        this.sV1.add(this.Z_hat_i);
        double temp = this.s_hat_i.innerProduct(this.sV1);
        this.Qi_etc = this.Q_i - temp;
    }

    public void featherstonePassThree(SpatialInertiaMatrix I_hat_h, SpatialVector Z_hat_h) {
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassThree(this.I_hat_i, this.Z_hat_i);
        }
        this.i_X_hat_h.setFromOffsetAndRotation((Vector3DReadOnly)this.r_i, (RotationMatrixReadOnly)this.Ri_h);
        this.h_X_hat_i.setFromOffsetAndRotation((Vector3DReadOnly)this.r_h, (RotationMatrixReadOnly)this.Rh_i);
        this.sIs = this.I_hat_i.sIs(this.s_hat_i);
        this.SIM1.IssI(this.I_hat_i, this.s_hat_i, this.sIs);
        this.SIM2.sub(this.I_hat_i, this.SIM1);
        this.h_X_hat_i.transformSpatialInertia(this.SIM2);
        I_hat_h.add(this.SIM2);
        this.sV1.set(this.c_hat_i);
        this.I_hat_i.multiply(this.sV1);
        this.sV1.add(this.Z_hat_i);
        this.Qi_etc = this.Q_i - this.s_hat_i.innerProduct(this.sV1);
        this.sV2.set(this.s_hat_i);
        this.I_hat_i.multiply(this.sV2);
        this.sV2.scale(this.Qi_etc / this.sIs);
        this.sV1.add(this.sV2);
        this.h_X_hat_i.transform(this.sV1);
        Z_hat_h.add(this.sV1);
    }

    public void featherstonePassFour(SpatialVector a_hat_h, int passNumber) throws UnreasonableAccelerationException {
        this.X_hat_h_a_hat_h.set(a_hat_h);
        this.i_X_hat_h.transform(this.X_hat_h_a_hat_h);
        this.I_hat_i.multiply(this.X_hat_h_a_hat_h);
        double temp = this.s_hat_i.innerProduct(this.X_hat_h_a_hat_h);
        double qdd = (this.Qi_etc - temp) / this.sIs;
        this.jointDependentFeatherstonePassFour(qdd, passNumber);
        this.qdd_s_hat_i.set(this.s_hat_i);
        this.qdd_s_hat_i.scale(qdd);
        this.a_hat_i.set(a_hat_h);
        this.i_X_hat_h.transform(this.a_hat_i);
        this.a_hat_i.add(this.c_hat_i);
        this.a_hat_i.add(this.qdd_s_hat_i);
        if (!this.jointDependentVerifyReasonableAccelerations()) {
            ArrayList<Joint> unreasonableAccelerationJoints = new ArrayList<Joint>();
            unreasonableAccelerationJoints.add((Joint)this.owner);
            throw new UnreasonableAccelerationException(unreasonableAccelerationJoints);
        }
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.featherstonePassFour(this.a_hat_i, passNumber);
        }
        if (this.jointWrenchSensor != null) {
            this.computeAndSetWrenchAtJoint();
        }
    }

    public void getLinearVelocityInBody(Vector3DBasics linearVelocityInBodyToPack, Vector3DBasics pointInBody) {
        this.tempDeltaPVector.set((Tuple3DReadOnly)pointInBody);
        this.tempDeltaPVector.sub((Tuple3DReadOnly)((Joint)this.owner).link.comOffset);
        linearVelocityInBodyToPack.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)this.tempDeltaPVector);
        linearVelocityInBodyToPack.add((Tuple3DReadOnly)this.v_i);
    }

    public void getLinearVelocityInWorld(Vector3DBasics linearVelocityInWorldToPack, Vector3DBasics pointInBody) {
        this.getLinearVelocityInBody(linearVelocityInWorldToPack, pointInBody);
        ((Joint)this.owner).transformToNext.transform(linearVelocityInWorldToPack);
    }

    public void getAngularVelocityInBody(Vector3DBasics angularVelocityInBodyToPack) {
        angularVelocityInBodyToPack.set((Tuple3DReadOnly)this.w_i);
    }

    public void getAngularVelocityInWorld(Vector3DBasics angularVelocityInWorldToPack) {
        this.getAngularVelocityInBody(angularVelocityInWorldToPack);
        ((Joint)this.owner).transformToNext.transform(angularVelocityInWorldToPack);
    }

    public void getLinearAccelerationInBody(Vector3DBasics linearAccelerationInBodyToPack, Vector3DBasics pointInBody) {
        this.tempDeltaPVector.set((Tuple3DReadOnly)pointInBody);
        this.tempDeltaPVector.sub((Tuple3DReadOnly)((Joint)this.owner).link.comOffset);
        this.tempOmegaCrossDeltaPVector.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)this.tempDeltaPVector);
        this.tempOmegaCrossOmegaCrossDeltaPVector.cross((Tuple3DReadOnly)this.w_i, (Tuple3DReadOnly)this.tempOmegaCrossDeltaPVector);
        linearAccelerationInBodyToPack.cross((Tuple3DReadOnly)this.a_hat_i.top, (Tuple3DReadOnly)this.tempDeltaPVector);
        linearAccelerationInBodyToPack.add((Tuple3DReadOnly)this.a_hat_i.bottom);
        linearAccelerationInBodyToPack.add((Tuple3DReadOnly)this.tempOmegaCrossOmegaCrossDeltaPVector);
    }

    public void getLinearAccelerationInWorld(Vector3DBasics linearAccelerationInWorldToPack, Vector3DBasics pointInBody) {
        this.getLinearAccelerationInBody(linearAccelerationInWorldToPack, pointInBody);
        ((Joint)this.owner).transformToNext.transform(linearAccelerationInWorldToPack);
    }

    public void getAngularAccelerationsInBodyFrame(Vector3DBasics angularAccelerationToPack) {
        this.a_hat_i.getTop(angularAccelerationToPack);
    }

    public void getAngularAccelerationsInWorld(Vector3DBasics angularAccelerationInWorldToPack) {
        this.getAngularAccelerationsInBodyFrame(angularAccelerationInWorldToPack);
        ((Joint)this.owner).transformToNext.transform(angularAccelerationInWorldToPack);
    }

    public void recordK(int passNumber) {
        this.jointDependentRecordK(passNumber);
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recordK(passNumber);
        }
    }

    public abstract void recursiveEulerIntegrate(double var1);

    public abstract void recursiveSaveTempState();

    public abstract void recursiveRestoreTempState();

    public abstract void recursiveRungeKuttaSum(double var1);

    public Matrix3D computeKiCollision(Vector3DReadOnly offsetFromCOM, RotationMatrixReadOnly Rk_coll) {
        this.tempVector.set((Tuple3DReadOnly)offsetFromCOM);
        this.tempVector.scale(-1.0);
        this.k_X_hat_coll.setFromOffsetAndRotation((Vector3DReadOnly)this.tempVector, Rk_coll);
        this.computeMultibodyKi(this.k_X_hat_coll, (Matrix3DBasics)this.Ki);
        return this.Ki;
    }

    public void integrateCollision(Matrix3DReadOnly Ki, Vector3DReadOnly u_coll, double epsilon, double mu, Vector3DBasics p_coll) {
        this.collisionIntegrator.setup(Ki, u_coll, epsilon, mu);
        this.collisionIntegrator.computeImpulse(p_coll);
    }

    public void applyImpulse(Vector3DReadOnly p_coll) {
        this.p_hat_k.top.set((Tuple3DReadOnly)p_coll);
        this.p_hat_k.bottom.set(0.0, 0.0, 0.0);
        this.k_X_hat_coll.transform(this.p_hat_k);
        if (p_coll.length() < 1.0E9) {
            this.propagateImpulse(this.p_hat_k);
        } else {
            System.out.println("p_coll is enormous:  " + p_coll);
            System.out.println("K: " + this.Ki);
        }
    }

    public void resolveCollision(Vector3DReadOnly offsetFromCOM, RotationMatrixReadOnly Rk_coll, Vector3DReadOnly u_coll, double epsilon, double mu, Vector3DBasics p_coll) {
        this.computeKiCollision(offsetFromCOM, Rk_coll);
        this.integrateCollision((Matrix3DReadOnly)this.Ki, u_coll, epsilon, mu, p_coll);
        this.applyImpulse((Vector3DReadOnly)p_coll);
    }

    public void resolveMicroCollision(double penetrationSquared, Vector3DReadOnly offsetFromCOM, RotationMatrixReadOnly Rk_coll, Vector3DReadOnly u_coll, double epsilon, double mu, Vector3DBasics p_coll) {
        boolean justUseSpringyEpsilonForMicroCollisions = true;
        if (justUseSpringyEpsilonForMicroCollisions) {
            this.resolveMicroCollisionWithSpringyEpsilon(penetrationSquared, offsetFromCOM, Rk_coll, u_coll, epsilon, mu, p_coll);
            return;
        }
        this.computeKiCollision(offsetFromCOM, Rk_coll);
        this.collisionIntegrator.setup((Matrix3DReadOnly)this.Ki, u_coll, epsilon, mu);
        this.collisionIntegrator.computeMicroImpulse(p_coll);
        if (Math.abs(Math.sqrt(p_coll.getX() * p_coll.getX() + p_coll.getY() * p_coll.getY()) / p_coll.getZ()) > mu) {
            this.resolveCollision(offsetFromCOM, Rk_coll, u_coll, epsilon, mu, p_coll);
        } else {
            this.p_hat_k.top.set((Tuple3DReadOnly)p_coll);
            this.p_hat_k.bottom.set(0.0, 0.0, 0.0);
            this.k_X_hat_coll.transform(this.p_hat_k);
            this.propagateImpulse(this.p_hat_k);
        }
    }

    private void resolveMicroCollisionWithSpringyEpsilon(double penetrationSquared, Vector3DReadOnly offsetFromCOM, RotationMatrixReadOnly Rk_coll, Vector3DReadOnly u_coll, double epsilon, double mu, Vector3DBasics p_coll) {
        if ((epsilon += 1000000.0 * penetrationSquared) > 20.0) {
            epsilon = 20.0;
        }
        this.resolveCollision(offsetFromCOM, Rk_coll, u_coll, epsilon, mu, p_coll);
    }

    private void propagateImpulse(SpatialVector p_hat_k) {
        this.Y_hat_parent.set(p_hat_k);
        this.Y_hat_parent.scale(-1.0);
        this.recursivePropagateImpulse(this.Y_hat_parent, this.delta_v_hat_null, null);
    }

    protected void recursivePropagateImpulse(SpatialVector new_Y_hat, SpatialVector delta_v_hat_return, Joint skipMeBackUp) {
        this.Y_hat_i.set(new_Y_hat);
        if (((Joint)this.owner).parentJoint != null) {
            this.Y_hat_parent.set(this.Y_hat_i);
            this.sIs = this.I_hat_i.sIs(this.s_hat_i);
            this.SIM1.Iss_sIs(this.I_hat_i, this.s_hat_i, this.sIs);
            this.SIM1.oneMinus();
            this.SIM1.multiply(this.Y_hat_parent);
            this.h_X_hat_i.transform(this.Y_hat_parent);
            ((Joint)this.owner).parentJoint.physics.recursivePropagateImpulse(this.Y_hat_parent, this.delta_v_hat_h, (Joint)this.owner);
        } else {
            this.delta_v_hat_h.top.set(0.0, 0.0, 0.0);
            this.delta_v_hat_h.bottom.set(0.0, 0.0, 0.0);
        }
        this.propagateImpulseSetDeltaVOnPath(this.delta_v_hat_h, delta_v_hat_return);
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            if (child == skipMeBackUp) continue;
            super.recursivePropagateImpulseSetDeltaVOffPath(delta_v_hat_return);
        }
    }

    private void computeMultibodyKi(SpatialTransformationMatrix k_X_hat_coll, Matrix3DBasics kiToPack) {
        this.coll_X_hat_k.set(k_X_hat_coll);
        this.coll_X_hat_k.invert();
        this.p_hat_coll.top.setX(1.0);
        this.p_hat_coll.top.setY(0.0);
        this.p_hat_coll.top.setZ(0.0);
        this.p_hat_coll.bottom.setX(0.0);
        this.p_hat_coll.bottom.setY(0.0);
        this.p_hat_coll.bottom.setZ(0.0);
        k_X_hat_coll.transform(this.p_hat_coll);
        this.impulseResponse(this.p_hat_coll, this.delta_v_hat_k);
        this.coll_X_hat_k.transform(this.delta_v_hat_k);
        kiToPack.setM00(this.delta_v_hat_k.bottom.getX());
        kiToPack.setM10(this.delta_v_hat_k.bottom.getY());
        kiToPack.setM20(this.delta_v_hat_k.bottom.getZ());
        this.p_hat_coll.top.setX(0.0);
        this.p_hat_coll.top.setY(1.0);
        this.p_hat_coll.top.setZ(0.0);
        this.p_hat_coll.bottom.setX(0.0);
        this.p_hat_coll.bottom.setY(0.0);
        this.p_hat_coll.bottom.setZ(0.0);
        k_X_hat_coll.transform(this.p_hat_coll);
        this.impulseResponse(this.p_hat_coll, this.delta_v_hat_k);
        this.coll_X_hat_k.transform(this.delta_v_hat_k);
        kiToPack.setM01(this.delta_v_hat_k.bottom.getX());
        kiToPack.setM11(this.delta_v_hat_k.bottom.getY());
        kiToPack.setM21(this.delta_v_hat_k.bottom.getZ());
        this.p_hat_coll.top.setX(0.0);
        this.p_hat_coll.top.setY(0.0);
        this.p_hat_coll.top.setZ(1.0);
        this.p_hat_coll.bottom.setX(0.0);
        this.p_hat_coll.bottom.setY(0.0);
        this.p_hat_coll.bottom.setZ(0.0);
        k_X_hat_coll.transform(this.p_hat_coll);
        this.impulseResponse(this.p_hat_coll, this.delta_v_hat_k);
        this.coll_X_hat_k.transform(this.delta_v_hat_k);
        kiToPack.setM02(this.delta_v_hat_k.bottom.getX());
        kiToPack.setM12(this.delta_v_hat_k.bottom.getY());
        kiToPack.setM22(this.delta_v_hat_k.bottom.getZ());
    }

    private void impulseResponse(SpatialVector p_hat_coll, SpatialVector delta_v_hat) {
        this.Y_hat_parent.set(p_hat_coll);
        this.Y_hat_parent.scale(-1.0);
        this.recursiveImpulseResponseToRootAndBack(this.Y_hat_parent, delta_v_hat);
    }

    protected void recursiveImpulseResponseToRootAndBack(SpatialVector new_Y_hat, SpatialVector delta_v_hat_return) {
        this.Y_hat_i.set(new_Y_hat);
        if (((Joint)this.owner).parentJoint != null) {
            this.Y_hat_parent.set(this.Y_hat_i);
            this.sIs = this.I_hat_i.sIs(this.s_hat_i);
            this.SIM1.Iss_sIs(this.I_hat_i, this.s_hat_i, this.sIs);
            this.SIM1.oneMinus();
            this.SIM1.multiply(this.Y_hat_parent);
            this.h_X_hat_i.transform(this.Y_hat_parent);
            ((Joint)this.owner).parentJoint.physics.recursiveImpulseResponseToRootAndBack(this.Y_hat_parent, this.delta_v_hat_h);
        } else {
            this.delta_v_hat_h.top.set(0.0, 0.0, 0.0);
            this.delta_v_hat_h.bottom.set(0.0, 0.0, 0.0);
        }
        this.impulseResponseComputeDeltaV(this.delta_v_hat_h, delta_v_hat_return);
    }

    protected void impulseResponseComputeDeltaV(SpatialVector delta_v_parent, SpatialVector delta_v_me) {
        this.delta_v_temp1.set(delta_v_parent);
        this.i_X_hat_h.transform(this.delta_v_temp1);
        this.delta_v_temp2.set(this.delta_v_temp1);
        this.I_hat_i.multiply(this.delta_v_temp2);
        this.delta_v_temp2.add(this.Y_hat_i);
        double delta_q_dot_i = -1.0 * this.s_hat_i.innerProduct(this.delta_v_temp2) / this.sIs;
        this.delta_v_temp2.set(this.s_hat_i);
        this.delta_v_temp2.scale(delta_q_dot_i);
        delta_v_me.add(this.delta_v_temp1, this.delta_v_temp2);
    }

    protected void propagateImpulseSetDeltaVOnPath(SpatialVector delta_v_parent, SpatialVector delta_v_me) {
        this.delta_v_temp1.set(delta_v_parent);
        this.i_X_hat_h.transform(this.delta_v_temp1);
        this.delta_v_temp2.set(this.delta_v_temp1);
        this.I_hat_i.multiply(this.delta_v_temp2);
        this.delta_v_temp2.add(this.Y_hat_i);
        double delta_q_dot_i = -1.0 * this.s_hat_i.innerProduct(this.delta_v_temp2) / this.sIs;
        this.jointDependentChangeVelocity(delta_q_dot_i);
        this.delta_v_temp2.set(this.s_hat_i);
        this.delta_v_temp2.scale(delta_q_dot_i);
        delta_v_me.add(this.delta_v_temp1, this.delta_v_temp2);
    }

    private void recursivePropagateImpulseSetDeltaVOffPath(SpatialVector delta_v_parent) {
        this.delta_v_temp1.set(delta_v_parent);
        this.i_X_hat_h.transform(this.delta_v_temp1);
        this.delta_v_temp2.set(this.delta_v_temp1);
        this.I_hat_i.multiply(this.delta_v_temp2);
        double delta_q_dot_i = -1.0 * this.s_hat_i.innerProduct(this.delta_v_temp2) / this.sIs;
        this.jointDependentChangeVelocity(delta_q_dot_i);
        this.delta_v_temp2.set(this.s_hat_i);
        this.delta_v_temp2.scale(delta_q_dot_i);
        this.delta_v_temp1.add(this.delta_v_temp2);
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            super.recursivePropagateImpulseSetDeltaVOffPath(this.delta_v_temp1);
        }
    }

    public double recursiveComputeCenterOfMass(Point3DBasics comPoint) {
        double totalMass = 0.0;
        comPoint.set(0.0, 0.0, 0.0);
        this.tempCOMPoint.set(0.0, 0.0, 0.0);
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            double mass = child.physics.recursiveComputeCenterOfMass((Point3DBasics)this.tempCOMPoint);
            totalMass += mass;
            this.tempCOMPoint.scale(mass);
            comPoint.add((Tuple3DReadOnly)this.tempCOMPoint);
        }
        this.tempCOMPoint.set((Tuple3DReadOnly)((Joint)this.owner).link.comOffset);
        ((Joint)this.owner).transformToNext.transform((Point3DBasics)this.tempCOMPoint);
        totalMass += ((Joint)this.owner).link.getMass();
        this.tempCOMPoint.scale(((Joint)this.owner).link.getMass());
        comPoint.add((Tuple3DReadOnly)this.tempCOMPoint);
        if (totalMass > 0.0) {
            comPoint.scale(1.0 / totalMass);
        } else {
            comPoint.set(0.0, 0.0, 0.0);
        }
        return totalMass;
    }

    public double recursiveComputeLinearMomentum(Vector3DBasics linearMomentum) {
        double totalMass = 0.0;
        linearMomentum.set(0.0, 0.0, 0.0);
        this.tempLinearMomentum.set(0.0, 0.0, 0.0);
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            double mass = child.physics.recursiveComputeLinearMomentum((Vector3DBasics)this.tempLinearMomentum);
            totalMass += mass;
            linearMomentum.add((Tuple3DReadOnly)this.tempLinearMomentum);
        }
        this.tempLinearMomentum.set(this.v_i);
        this.tempLinearMomentum.scale(((Joint)this.owner).link.getMass());
        ((Joint)this.owner).transformToNext.transform((Vector3DBasics)this.tempLinearMomentum);
        linearMomentum.add((Tuple3DReadOnly)this.tempLinearMomentum);
        return totalMass += ((Joint)this.owner).link.getMass();
    }

    public void recursiveComputeAngularMomentum(Vector3DBasics angularMomentum) {
        angularMomentum.set(0.0, 0.0, 0.0);
        this.tempAngularMomentum.set(0.0, 0.0, 0.0);
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveComputeAngularMomentum((Vector3DBasics)this.tempAngularMomentum);
            angularMomentum.add((Tuple3DReadOnly)this.tempAngularMomentum);
        }
        this.tempCOMPoint.set((Tuple3DReadOnly)((Joint)this.owner).link.comOffset);
        ((Joint)this.owner).transformToNext.transform((Point3DBasics)this.tempCOMPoint);
        this.tempCOMVector.set((Tuple3DReadOnly)this.tempCOMPoint);
        this.tempLinearMomentum.set(this.v_i);
        this.tempLinearMomentum.scale(((Joint)this.owner).link.getMass());
        ((Joint)this.owner).transformToNext.transform((Vector3DBasics)this.tempLinearMomentum);
        this.tempAngularMomentum.cross((Tuple3DReadOnly)this.tempCOMVector, (Tuple3DReadOnly)this.tempLinearMomentum);
        angularMomentum.add((Tuple3DReadOnly)this.tempAngularMomentum);
        this.tempAngularMomentum.set(this.w_i);
        ((Joint)this.owner).link.Inertia.transform((Tuple3DBasics)this.tempAngularMomentum);
        ((Joint)this.owner).transformToNext.transform((Vector3DBasics)this.tempAngularMomentum);
        angularMomentum.add((Tuple3DReadOnly)this.tempAngularMomentum);
    }

    public double recursiveComputeRotationalKineticEnergy() {
        this.tempRotationalEnergyVector.set(this.w_i);
        ((Joint)this.owner).link.Inertia.transform((Tuple3DBasics)this.tempRotationalEnergyVector);
        double rotationalKineticEnergy = 0.5 * this.w_i.dot((Vector3DReadOnly)this.tempRotationalEnergyVector);
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            rotationalKineticEnergy += child.physics.recursiveComputeRotationalKineticEnergy();
        }
        return rotationalKineticEnergy;
    }

    public double recursiveComputeTranslationalKineticEnergy() {
        double translationalKineticEnergy = 0.5 * this.v_i.dot((Vector3DReadOnly)this.v_i) * ((Joint)this.owner).link.getMass();
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            translationalKineticEnergy += child.physics.recursiveComputeTranslationalKineticEnergy();
        }
        return translationalKineticEnergy;
    }

    public double recursiveComputeGravitationalPotentialEnergy() {
        this.tempPE_COMPoint.set((Tuple3DReadOnly)((Joint)this.owner).link.comOffset);
        ((Joint)this.owner).transformToNext.transform((Point3DBasics)this.tempPE_COMPoint);
        double gravitationalPotentialEnergy = ((Joint)this.owner).link.getMass() * (-((Joint)this.owner).rob.gravityX.getDoubleValue() * this.tempPE_COMPoint.getX() - ((Joint)this.owner).rob.gravityY.getDoubleValue() * this.tempPE_COMPoint.getY() - ((Joint)this.owner).rob.gravityZ.getDoubleValue() * this.tempPE_COMPoint.getZ());
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            gravitationalPotentialEnergy += child.physics.recursiveComputeGravitationalPotentialEnergy();
        }
        return gravitationalPotentialEnergy;
    }

    public void recursiveDecideGroundContactPointsInContact() {
        int i;
        if (this.groundContactPointGroups != null) {
            for (i = 0; i < this.groundContactPointGroupList.size(); ++i) {
                GroundContactPointGroup groundContactGroup = this.groundContactPointGroupList.get(i);
                groundContactGroup.decideGroundContactPointsInContact();
            }
        }
        for (i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveDecideGroundContactPointsInContact();
        }
    }

    public void recursiveUpdateAllGroundContactPointVelocities() {
        int i;
        if (this.groundContactPointGroupList != null) {
            this.R0_i.set(this.Ri_0);
            this.R0_i.transpose();
            for (i = 0; i < this.groundContactPointGroupList.size(); ++i) {
                ArrayList<GroundContactPoint> groundContactPoints = this.groundContactPointGroupList.get(i).getGroundContactPoints();
                for (int y = 0; y < groundContactPoints.size(); ++y) {
                    GroundContactPoint point = (GroundContactPoint)groundContactPoints.get(y);
                    point.updatePointVelocity((RotationMatrixReadOnly)this.R0_i, (Vector3DReadOnly)((Joint)this.owner).link.comOffset, (Vector3DReadOnly)this.v_i, (Vector3DReadOnly)this.w_i);
                }
            }
        }
        for (i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveUpdateAllGroundContactPointVelocities();
        }
    }

    public void doLoopClosureRecursive() {
        int i;
        for (i = 0; i < ((Joint)this.owner).childrenConstraints.size(); ++i) {
            ((Joint)this.owner).childrenConstraints.get(i).update();
        }
        for (i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            ((Joint)this.owner).childrenJoints.get((int)i).physics.doLoopClosureRecursive();
        }
    }

    protected boolean verifyReasonableAccelerations() {
        if (!this.jointDependentVerifyReasonableAccelerations()) {
            return false;
        }
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            if (child.physics.verifyReasonableAccelerations()) continue;
            return false;
        }
        return true;
    }

    public boolean verifySetupProperly(double epsilon) {
        if (((Joint)this.owner).parentJoint != null) {
            Vector3D parentCoMOffset = new Vector3D();
            ((Joint)this.owner).parentJoint.getLink().getComOffset((Vector3DBasics)parentCoMOffset);
            Vector3D jointOffset = new Vector3D();
            ((Joint)this.owner).getOffset((Vector3DBasics)jointOffset);
            jointOffset.sub((Tuple3DReadOnly)parentCoMOffset);
            jointOffset.sub((Tuple3DReadOnly)this.r_in);
            double length = jointOffset.length();
            if (length > epsilon) {
                return false;
            }
        }
        for (Joint childJoint : ((Joint)this.owner).childrenJoints) {
            boolean childSetupProperly = childJoint.physics.verifySetupProperly(epsilon);
            if (childSetupProperly) continue;
            return false;
        }
        return true;
    }

    public void addKinematicPoint(KinematicPoint point) {
        if (this.kinematicPoints == null) {
            this.kinematicPoints = new ArrayList<KinematicPoint>();
        }
        this.kinematicPoints.add(point);
        point.setParentJoint((Joint)this.owner);
    }

    public void addExternalForcePoint(ExternalForcePoint point) {
        if (this.kinematicPoints == null) {
            this.kinematicPoints = new ArrayList<KinematicPoint>();
        }
        if (this.externalForcePoints == null) {
            this.externalForcePoints = new ArrayList<ExternalForcePoint>();
        }
        this.kinematicPoints.add(point);
        this.externalForcePoints.add(point);
        point.setParentJoint((Joint)this.owner);
    }

    public void addExternalTorque(ExternalTorque torque) {
        if (this.externalTorques == null) {
            this.externalTorques = new ArrayList<ExternalTorque>();
        }
        this.externalTorques.add(torque);
        torque.setParentJoint((Joint)this.owner);
    }

    public void removeExternalForcePoint(ExternalForcePoint point) {
        if (!this.kinematicPoints.remove(point)) {
            throw new RuntimeException("Removing point which is not in the kinematics list!");
        }
        if (!this.externalForcePoints.remove(point)) {
            throw new RuntimeException("Removing point which is not in the external force list!");
        }
    }

    public void removeExternalTorque(ExternalTorque point) {
        if (!this.externalTorques.remove(point)) {
            throw new RuntimeException("Removing torque which is not in the torque list!");
        }
    }

    public void getKinematicPoints(List<KinematicPoint> list) {
        if (this.kinematicPoints != null) {
            list.addAll(this.kinematicPoints);
        }
    }

    protected void recursiveGetKinematicPoints(List<KinematicPoint> list) {
        if (this.kinematicPoints != null) {
            list.addAll(this.kinematicPoints);
        }
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveGetKinematicPoints(list);
        }
    }

    protected void recursiveGetExternalForcePoints(List<ExternalForcePoint> list) {
        list.addAll(this.externalForcePoints);
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveGetExternalForcePoints(list);
        }
    }

    public List<ExternalForcePoint> getExternalForcePoints() {
        return this.externalForcePoints;
    }

    public ExternalForcePoint getExternalForcePoint(String name) {
        if (this.externalForcePoints == null) {
            return null;
        }
        for (int i = 0; i < this.externalForcePoints.size(); ++i) {
            ExternalForcePoint externalForcePoint = this.externalForcePoints.get(i);
            if (!externalForcePoint.getName().equals(name)) continue;
            return externalForcePoint;
        }
        return null;
    }

    public void recursiveGetGroundContactPoints(int groundContactGroupIdentifier, List<GroundContactPoint> list) {
        GroundContactPointGroup groundContactPointGroup;
        if (this.groundContactPointGroups != null && (groundContactPointGroup = this.groundContactPointGroups.get(groundContactGroupIdentifier)) != null) {
            list.addAll(groundContactPointGroup.getGroundContactPoints());
        }
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveGetGroundContactPoints(groundContactGroupIdentifier, list);
        }
    }

    public void recursiveGetAllGroundContactPointsGroupedByJoint(List<List<GroundContactPoint>> listOfLists) {
        if (this.groundContactPointGroupList != null) {
            ArrayList<GroundContactPoint> listForThisJoint = new ArrayList<GroundContactPoint>();
            for (int i = 0; i < this.groundContactPointGroupList.size(); ++i) {
                ArrayList<GroundContactPoint> groundContactPoints = this.groundContactPointGroupList.get(i).getGroundContactPoints();
                listForThisJoint.addAll(groundContactPoints);
            }
            if (!listForThisJoint.isEmpty()) {
                listOfLists.add(listForThisJoint);
            }
        }
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveGetAllGroundContactPointsGroupedByJoint(listOfLists);
        }
    }

    public void recursiveGetAllGroundContactPoints(List<GroundContactPoint> list) {
        int i;
        if (this.groundContactPointGroupList != null) {
            for (i = 0; i < this.groundContactPointGroupList.size(); ++i) {
                ArrayList<GroundContactPoint> groundContactPoints = this.groundContactPointGroupList.get(i).getGroundContactPoints();
                list.addAll(groundContactPoints);
            }
        }
        for (i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveGetAllGroundContactPoints(list);
        }
    }

    public void recursiveGetAllExternalForcePoints(List<ExternalForcePoint> list) {
        if (this.externalForcePoints != null) {
            list.addAll(this.externalForcePoints);
        }
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveGetAllExternalForcePoints(list);
        }
    }

    public void recursiveGetAllKinematicPoints(List<KinematicPoint> list) {
        if (this.kinematicPoints != null) {
            list.addAll(this.kinematicPoints);
        }
        for (int i = 0; i < ((Joint)this.owner).childrenJoints.size(); ++i) {
            Joint child = ((Joint)this.owner).childrenJoints.get(i);
            child.physics.recursiveGetAllKinematicPoints(list);
        }
    }

    public void addGroundContactPoint(GroundContactPoint point) {
        this.addGroundContactPoint(0, point);
    }

    public void addGroundContactPoint(int groupIdentifier, GroundContactPoint point) {
        GroundContactPointGroup groundContactPointGroup;
        if (this.groundContactPointGroups == null) {
            this.groundContactPointGroups = new LinkedHashMap();
        }
        if (this.groundContactPointGroupList == null) {
            this.groundContactPointGroupList = new ArrayList<GroundContactPointGroup>();
        }
        if ((groundContactPointGroup = this.groundContactPointGroups.get(groupIdentifier)) == null) {
            groundContactPointGroup = new GroundContactPointGroup();
            this.groundContactPointGroups.put(groupIdentifier, groundContactPointGroup);
            this.groundContactPointGroupList.add(groundContactPointGroup);
        }
        groundContactPointGroup.addGroundContactPoint(point);
        point.setParentJoint((Joint)this.owner);
    }

    public GroundContactPointGroup getGroundContactPointGroup() {
        return this.getGroundContactPointGroup(0);
    }

    public GroundContactPointGroup getGroundContactPointGroup(int identifier) {
        if (this.groundContactPointGroups == null) {
            return null;
        }
        return this.groundContactPointGroups.get(identifier);
    }

    public void addJointWrenchSensor(JointWrenchSensor jointWrenchSensor) {
        if (this.jointWrenchSensor != null) {
            throw new RuntimeException("Already have a JointWrenchSensor!");
        }
        this.jointWrenchSensor = jointWrenchSensor;
        this.tempJointWrenchVector = new SpatialVector();
        this.tempVectorForWrenchTranslation = new Vector3D();
        this.tempOffsetForWrenchTranslation = new Vector3D();
    }

    public JointWrenchSensor getJointWrenchSensor() {
        return this.jointWrenchSensor;
    }

    public Vector3D getAngularVelocity() {
        return this.w_i;
    }

    public void freezeFrame() {
        this.doFreezeFrame = true;
    }

    public boolean freezeNextFrame() {
        return this.doFreezeFrame;
    }

    public void resetFreezeFrame() {
        this.doFreezeFrame = false;
    }

    public Vector3D getUnitVector() {
        return this.u_i;
    }

    public void getJointAxis(Vector3DBasics axisToPack) {
        if (this.u_i != null) {
            axisToPack.set((Tuple3DReadOnly)this.u_i);
        }
    }

    protected abstract void jointDependentSetAndGetRotation(RotationMatrixBasics var1);

    protected abstract void jointDependentFeatherstonePassOne();

    protected abstract void jointDependentSet_d_i();

    protected abstract void jointDependentFeatherstonePassTwo(Vector3DReadOnly var1);

    protected abstract void jointDependentFeatherstonePassFour(double var1, int var3);

    protected abstract void jointDependentRecordK(int var1);

    protected abstract boolean jointDependentVerifyReasonableAccelerations();

    protected abstract void jointDependentChangeVelocity(double var1);

    public String toString() {
        int i;
        StringBuffer retBuffer = new StringBuffer();
        retBuffer.append("   joint axis vector: " + this.u_i + "\n");
        if (this.kinematicPoints != null && this.kinematicPoints.size() > 0) {
            retBuffer.append("\n");
            retBuffer.append("    Kinematic Points: \n");
            for (i = 0; i < this.kinematicPoints.size(); ++i) {
                KinematicPoint kp = this.kinematicPoints.get(i);
                retBuffer.append("      " + kp.getName());
                if (i == this.kinematicPoints.size() - 1) continue;
                retBuffer.append("\n");
            }
        }
        if (this.externalForcePoints != null && this.externalForcePoints.size() > 0) {
            retBuffer.append("\n");
            retBuffer.append("    External Force Points: \n");
            for (i = 0; i < this.externalForcePoints.size(); ++i) {
                ExternalForcePoint ef = this.externalForcePoints.get(i);
                retBuffer.append("      " + ef.getName());
                if (i == this.kinematicPoints.size() - 1) continue;
                retBuffer.append("\n");
            }
        }
        return retBuffer.toString();
    }

    protected void computeAndSetWrenchAtJoint() {
        this.tempJointWrenchVector.set(this.a_hat_i);
        this.I_hat_i.multiply(this.tempJointWrenchVector);
        this.tempJointWrenchVector.add(this.Z_hat_i);
        this.jointWrenchSensor.getOffsetFromJoint((Tuple3DBasics)this.tempOffsetForWrenchTranslation);
        this.tempOffsetForWrenchTranslation.scale(-1.0);
        this.tempOffsetForWrenchTranslation.add((Tuple3DReadOnly)this.d_i);
        this.tempVectorForWrenchTranslation.cross((Tuple3DReadOnly)this.tempOffsetForWrenchTranslation, (Tuple3DReadOnly)this.tempJointWrenchVector.top);
        this.tempJointWrenchVector.bottom.add((Tuple3DReadOnly)this.tempVectorForWrenchTranslation);
        this.tempJointWrenchVector.scale(-1.0);
        this.jointWrenchSensor.setWrench(this.tempJointWrenchVector);
    }
}

