/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogConstructors;

import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import us.ihmc.simulationconstructionset.gui.GraphArrayPanel;
import us.ihmc.simulationconstructionset.gui.dialogConstructors.PrintGraphsDialogConstructor;

public class PrintGraphsDialogGenerator
implements PrintGraphsDialogConstructor {
    private GraphArrayPanel myGraphArrayPanel;

    public PrintGraphsDialogGenerator(GraphArrayPanel graphArrayPanel) {
        this.myGraphArrayPanel = graphArrayPanel;
    }

    @Override
    public void closeAndDispose() {
        this.myGraphArrayPanel = null;
    }

    @Override
    public void constructDialog() {
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                PrinterJob printerJob = PrinterJob.getPrinterJob();
                PageFormat format = new PageFormat();
                format = printerJob.pageDialog(format);
                printerJob.setPrintable(PrintGraphsDialogGenerator.this.myGraphArrayPanel, format);
                printerJob.setJobName("Simulation Construction Set");
                if (printerJob.printDialog()) {
                    try {
                        printerJob.print();
                    }
                    catch (PrinterException pe) {
                        System.err.println("printing failed: " + pe.getMessage());
                    }
                }
            }
        }, "PrintGraphs");
        t.start();
    }
}

