/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class InclinedGroundProfile
extends GroundProfileFromHeightMap {
    private static final double xMinDefault = -20.0;
    private static final double xMaxDefault = 20.0;
    private static final double yMinDefault = -20.0;
    private static final double yMaxDefault = 20.0;
    private static final double heightOffset = -0.5;
    private static final double angleOfInclinationDefault = 0.0;
    private final BoundingBox3D boundingBox;
    private final double angleOfInclination;

    public InclinedGroundProfile() {
        this(0.0);
    }

    public InclinedGroundProfile(double angleOfInclination) {
        this(angleOfInclination, -20.0, 20.0, -20.0, 20.0);
    }

    public InclinedGroundProfile(double angleOfInclination, double xMin, double xMax, double yMin, double yMax) {
        this.angleOfInclination = angleOfInclination;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Double.POSITIVE_INFINITY;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        double height = 0.0;
        if (this.boundingBox.isXYInsideInclusive(x, y)) {
            height = -x * Math.tan(this.angleOfInclination) + -0.5;
        }
        return height;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        double dzdx = 0.0;
        if (this.boundingBox.isXYInsideInclusive(x, y)) {
            dzdx = -Math.tan(this.angleOfInclination);
        }
        normal.setX(-dzdx);
        normal.setY(0.0);
        normal.setZ(1.0);
        normal.normalize();
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

