/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.simulationRunner;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import us.ihmc.simulationconstructionset.util.simulationRunner.VariableDifference;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoVariable;

public class VariablesThatShouldMatchList {
    private LinkedHashMap<String, YoVariable> variableHashMapOne = new LinkedHashMap();
    private LinkedHashMap<String, YoVariable> variableHashMapTwo = new LinkedHashMap();
    private final List<YoVariable[]> variablesThatShouldMatch = new ArrayList<YoVariable[]>();
    private final List<YoVariable> variablesInOneButNotInTwo = new ArrayList<YoVariable>();
    private final List<YoVariable> variablesInTwoButNotInOne = new ArrayList<YoVariable>();

    public VariablesThatShouldMatchList(YoRegistry registryOne, YoRegistry registryTwo, List<String> exceptions) {
        this(registryOne.collectSubtreeVariables(), registryTwo.collectSubtreeVariables(), exceptions);
    }

    public VariablesThatShouldMatchList(YoVariableList varListOne, YoVariableList varListTwo, List<String> exceptions) {
        this(varListOne.getVariables(), varListTwo.getVariables(), exceptions);
    }

    public VariablesThatShouldMatchList(List<YoVariable> variablesOne, List<YoVariable> variablesTwo, List<String> exceptions) {
        variablesOne = this.copyListButRemoveExceptions(variablesOne, exceptions);
        variablesTwo = this.copyListButRemoveExceptions(variablesTwo, exceptions);
        VariablesThatShouldMatchList.copyListAndReorder(variablesOne, variablesTwo, this.variablesInOneButNotInTwo, this.variablesInTwoButNotInOne);
        if (variablesOne.size() != variablesTwo.size()) {
            throw new RuntimeException("Variable lists don't have same length!");
        }
        for (int i = 0; i < variablesOne.size(); ++i) {
            String nameTwo;
            YoVariable variableOne = variablesOne.get(i);
            YoVariable variableTwo = variablesTwo.get(i);
            String nameOne = variableOne.getFullNameString();
            if (!nameOne.equals(nameTwo = variableTwo.getFullNameString())) {
                throw new RuntimeException(nameOne + " doesn't equal " + nameTwo);
            }
            this.variablesThatShouldMatch.add(new YoVariable[]{variableOne, variableTwo});
            this.variableHashMapOne.put(nameOne, variableOne);
            this.variableHashMapTwo.put(nameTwo, variableTwo);
        }
    }

    public List<YoVariable[]> getVariablesThatShouldMatch() {
        return this.variablesThatShouldMatch;
    }

    public YoVariable getYoVariableInListOne(String fullName) {
        return this.variableHashMapOne.get(fullName);
    }

    public YoVariable getYoVariableInListTwo(String fullName) {
        return this.variableHashMapTwo.get(fullName);
    }

    private List<YoVariable> copyListButRemoveExceptions(List<YoVariable> variables, List<String> exceptions) {
        ArrayList<YoVariable> ret = new ArrayList<YoVariable>();
        for (YoVariable variable : variables) {
            if (VariablesThatShouldMatchList.isException(exceptions, variable)) continue;
            ret.add(variable);
        }
        return ret;
    }

    private static void copyListAndReorder(List<YoVariable> variablesOne, List<YoVariable> variablesTwo, List<YoVariable> variablesInOneButNotInTwoToPack, List<YoVariable> variablesInTwoButNotInOneToPack) {
        variablesInOneButNotInTwoToPack.clear();
        variablesInTwoButNotInOneToPack.clear();
        LinkedHashMap<String, YoVariable> variablesTwoHashMap = new LinkedHashMap<String, YoVariable>();
        for (YoVariable variableInTwo : variablesTwo) {
            variablesTwoHashMap.put(variableInTwo.getFullNameString(), variableInTwo);
        }
        ArrayList<YoVariable> newVariablesTwo = new ArrayList<YoVariable>();
        for (YoVariable variableInOne : variablesOne) {
            YoVariable variableInTwo = (YoVariable)variablesTwoHashMap.get(variableInOne.getFullNameString());
            if (variableInTwo == null) {
                variablesInOneButNotInTwoToPack.add(variableInOne);
                continue;
            }
            newVariablesTwo.add(variableInTwo);
        }
        for (YoVariable variableToRemoveFromOne : variablesInOneButNotInTwoToPack) {
            variablesOne.remove(variableToRemoveFromOne);
        }
        for (YoVariable newVariableTwo : newVariablesTwo) {
            variablesTwo.remove(newVariableTwo);
        }
        for (YoVariable extraVariablesInTwo : variablesTwo) {
            variablesInTwoButNotInOneToPack.add(extraVariablesInTwo);
        }
        variablesTwo.clear();
        variablesTwo.addAll(newVariablesTwo);
    }

    private static boolean isException(List<String> exceptions, YoVariable variable) {
        boolean isException = false;
        if (exceptions != null) {
            for (String exceptionName : exceptions) {
                String lowerCaseExceptionString;
                String lowerCaseVariableName = variable.getName().toLowerCase();
                isException = lowerCaseVariableName.contains(lowerCaseExceptionString = exceptionName.toLowerCase());
                if (!isException) continue;
                return isException;
            }
        }
        return isException;
    }

    public boolean doVariableValuesMatch(List<VariableDifference> variableDifferences, double time, double maxDifferenceAllowed, boolean checkForPercentDifference) {
        boolean ret = true;
        for (YoVariable[] twoVariablesThatShouldMatch : this.variablesThatShouldMatch) {
            boolean variablesAreDifferent;
            YoVariable variableOne = twoVariablesThatShouldMatch[0];
            YoVariable variableTwo = twoVariablesThatShouldMatch[1];
            double valueOne = variableOne.getValueAsDouble();
            double valueTwo = variableTwo.getValueAsDouble();
            double absoluteDifference = Math.abs(valueTwo - valueOne);
            if (checkForPercentDifference) {
                double max = Math.max(Math.abs(valueOne), Math.abs(valueTwo));
                double percentDiff = absoluteDifference / max;
                variablesAreDifferent = percentDiff > maxDifferenceAllowed;
            } else {
                boolean bl = variablesAreDifferent = absoluteDifference > maxDifferenceAllowed;
            }
            if (!variablesAreDifferent) continue;
            variableDifferences.add(new VariableDifference(time, variableOne, variableTwo));
            ret = false;
        }
        for (YoVariable variable : this.variablesInOneButNotInTwo) {
            variableDifferences.add(new VariableDifference(time, variable, null));
            ret = false;
        }
        for (YoVariable variable : this.variablesInTwoButNotInOne) {
            variableDifferences.add(new VariableDifference(time, null, variable));
            ret = false;
        }
        return ret;
    }
}

