/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class DoubleStepGroundProfile
extends GroundProfileFromHeightMap {
    private final BoundingBox3D boundingBox;
    private final double initialGroundXStep;
    private final double finalGroundXStep;
    private final double initialGroundZStep;
    private final double finalGroundZStep;

    public DoubleStepGroundProfile(double yMin, double yMax, double initialElevationChangeX, double finalElevationChangeX, double initialElevationDifference, double finalElevationDifference) {
        double xMin = -1.0;
        double xMax = finalElevationChangeX + 10.0;
        this.initialGroundXStep = initialElevationChangeX;
        this.finalGroundXStep = finalElevationChangeX;
        this.initialGroundZStep = initialElevationDifference;
        this.finalGroundZStep = finalElevationDifference;
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = Math.max(0.0, Math.max(this.initialGroundZStep, this.finalGroundZStep)) + 0.01;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zMin, xMax, yMax, zMax);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        if (x < this.initialGroundXStep) {
            return 0.0;
        }
        if (x < this.finalGroundXStep) {
            return this.initialGroundZStep;
        }
        return this.finalGroundZStep;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.set(0.0, 0.0, 1.0);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

