/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Vector2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.simulationconstructionset.util.ground.TerrainObject3D;

public class BalanceBeamTerrainObject
implements TerrainObject3D,
HeightMapWithNormals {
    private final Point2D origin;
    private final BoundingBox3D boundingBox;
    private final Vector2D direction;
    private final double width;
    private final Vector2D tempVector = new Vector2D();
    private final Graphics3DObject linkGraphics;
    private final double heightAboveGround;

    public BalanceBeamTerrainObject(Point2DReadOnly origin, double back, double forward, Vector2D direction, double width, double heightAboveGround, AppearanceDefinition appearance) {
        Point2D pForward = new Point2D((Tuple2DReadOnly)direction);
        pForward.scale(forward);
        Point2D pBack = new Point2D((Tuple2DReadOnly)direction);
        pBack.scale(-back);
        this.origin = new Point2D((Tuple2DReadOnly)origin);
        double xMin = Math.min(pForward.getX(), pBack.getX());
        double xMax = Math.max(pForward.getX(), pBack.getX());
        double yMin = Math.min(pForward.getY(), pBack.getY());
        double yMax = Math.max(pForward.getY(), pBack.getY());
        double zMin = Double.NEGATIVE_INFINITY;
        double zMax = zMin + heightAboveGround;
        Point3D minPoint = new Point3D(xMin, yMin, zMin);
        Point3D maxPoint = new Point3D(xMax, yMax, zMax);
        this.boundingBox = new BoundingBox3D((Point3DReadOnly)minPoint, (Point3DReadOnly)maxPoint);
        this.direction = direction;
        this.width = width;
        this.heightAboveGround = heightAboveGround;
        this.linkGraphics = new Graphics3DObject();
        double height = width;
        this.linkGraphics.translate(origin.getX() + (xMin + xMax) / 2.0, origin.getY() + (yMin + yMax) / 2.0, heightAboveGround - height);
        double angle = Math.atan2(direction.getY(), direction.getX());
        this.linkGraphics.rotate(angle, Axis3D.Z);
        this.linkGraphics.addCube(forward + back, width, height, appearance);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double heightAt = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return heightAt;
    }

    public double heightAt(double x, double y, double z) {
        double xFromOrigin = x - this.origin.getX();
        double yFromOrigin = y - this.origin.getY();
        this.tempVector.set(xFromOrigin, yFromOrigin);
        double componentAlongBalanceBeam = this.tempVector.dot((Vector2DReadOnly)this.direction);
        this.tempVector.set(this.direction);
        this.tempVector.scale(componentAlongBalanceBeam);
        this.tempVector.setX(xFromOrigin - this.tempVector.getX());
        this.tempVector.setY(xFromOrigin - this.tempVector.getY());
        double distanceFromCenterOfBalanceBeamSquared = this.tempVector.lengthSquared();
        if (distanceFromCenterOfBalanceBeamSquared < this.width * this.width / 4.0) {
            return this.heightAboveGround;
        }
        return -1000.0;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.set(0.0, 0.0, 1.0);
    }

    public void closestIntersectionTo(double x, double y, double z, Point3DBasics intersection) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
    }

    public void closestIntersectionAndNormalAt(double x, double y, double z, Point3DBasics intersection, Vector3DBasics normal) {
        intersection.setX(x);
        intersection.setY(y);
        intersection.setZ(this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normal);
    }

    public boolean checkIfInside(double x, double y, double z, Point3DBasics intersectionToPack, Vector3DBasics normalToPack) {
        intersectionToPack.set(x, y, this.heightAt(x, y, z));
        this.surfaceNormalAt(x, y, z, normalToPack);
        return z < intersectionToPack.getZ();
    }

    public boolean isClose(double x, double y, double z) {
        return this.boundingBox.isInsideInclusive(x, y, z);
    }

    public double getXMin() {
        return this.boundingBox.getMinX();
    }

    public double getYMin() {
        return this.boundingBox.getMinY();
    }

    public double getXMax() {
        return this.boundingBox.getMaxX();
    }

    public double getYMax() {
        return this.boundingBox.getMaxY();
    }

    @Override
    public Graphics3DObject getLinkGraphics() {
        return this.linkGraphics;
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }

    public HeightMapWithNormals getHeightMapIfAvailable() {
        return this;
    }
}

