/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.HashMap;
import us.ihmc.log.LogTools;

public class SimulationConstructionSetParameters {
    public static final String SHOW_SPLASH_SCREEN = "show.splash.screen";
    public static final String CREATE_SCS_GUI = "create.scs.gui";
    public static final String SHOW_SCS_WINDOWS = "show.scs.windows";
    public static final String SCS_DATA_BUFFER_SIZE = "scs.dataBuffer.size";
    public static final String SHOW_SCS_YOGRAPHICS = "show.scs.yographics";
    public static final String SCS_YOGRAPHICS_GLOBALSCALE = "scs.yographics.globalscale";
    public static final String USE_AUTO_GROUND_GRAPHICS = "use.auto.ground.graphics";
    protected HashMap<String, TypeHolder> parameters = new HashMap();

    public SimulationConstructionSetParameters() {
        this.parameters.put(SHOW_SPLASH_SCREEN, new BooleanHolder("true"));
        this.parameters.put(CREATE_SCS_GUI, new BooleanHolder("true"));
        this.parameters.put(SHOW_SCS_WINDOWS, new BooleanHolder("true"));
        this.parameters.put(SCS_DATA_BUFFER_SIZE, new IntHolder("8192"));
        this.parameters.put(SHOW_SCS_YOGRAPHICS, new BooleanHolder("true"));
        this.parameters.put(SCS_YOGRAPHICS_GLOBALSCALE, new DoubleHolder("1.0"));
        this.parameters.put(USE_AUTO_GROUND_GRAPHICS, new BooleanHolder("true"));
    }

    public SimulationConstructionSetParameters(boolean createGUI, int bufferSize) {
        this();
        this.setCreateGUI(createGUI);
        this.setDataBufferSize(bufferSize);
    }

    public SimulationConstructionSetParameters(int dataBufferSize) {
        this();
        this.setDataBufferSize(dataBufferSize);
    }

    public SimulationConstructionSetParameters(boolean createGUI) {
        this();
        this.setCreateGUI(createGUI);
    }

    public static SimulationConstructionSetParameters createFromSystemProperties() {
        SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
        parameters.setFromSystemProperties();
        return parameters;
    }

    @Deprecated
    public static SimulationConstructionSetParameters createFromEnvironmentVariables() {
        return SimulationConstructionSetParameters.createFromSystemProperties();
    }

    public final void setFromSystemProperties() {
        for (String systemPropertyName : this.parameters.keySet()) {
            String propertyValue = System.getProperty(systemPropertyName);
            if (propertyValue != null) {
                this.parameters.get(systemPropertyName).setFromString(propertyValue);
                LogTools.info((String)("Loading " + systemPropertyName + ": " + propertyValue));
                continue;
            }
            LogTools.warn((String)("System property not set: " + systemPropertyName + ". Current value: " + this.parameters.get(systemPropertyName).getStringValue()));
        }
    }

    public int getDataBufferSize() {
        return ((IntHolder)this.parameters.get((Object)SCS_DATA_BUFFER_SIZE)).value;
    }

    public boolean getCreateGUI() {
        return ((BooleanHolder)this.parameters.get((Object)CREATE_SCS_GUI)).value;
    }

    public void setCreateGUI(boolean value) {
        ((BooleanHolder)this.parameters.get((Object)CREATE_SCS_GUI)).value = value;
    }

    public void setDataBufferSize(int value) {
        ((IntHolder)this.parameters.get((Object)SCS_DATA_BUFFER_SIZE)).value = value;
    }

    public void setShowSplashScreen(boolean value) {
        ((BooleanHolder)this.parameters.get((Object)SHOW_SPLASH_SCREEN)).value = value;
    }

    public boolean getShowWindows() {
        return ((BooleanHolder)this.parameters.get((Object)SHOW_SCS_WINDOWS)).value;
    }

    public void setShowWindows(boolean value) {
        ((BooleanHolder)this.parameters.get((Object)SHOW_SCS_WINDOWS)).value = value;
    }

    public boolean getShowSplashScreen() {
        return ((BooleanHolder)this.parameters.get((Object)SHOW_SPLASH_SCREEN)).value;
    }

    public boolean getShowYoGraphicObjects() {
        return ((BooleanHolder)this.parameters.get((Object)SHOW_SCS_YOGRAPHICS)).value;
    }

    public void setShowYoGraphicObjects(boolean value) {
        ((BooleanHolder)this.parameters.get((Object)SHOW_SCS_YOGRAPHICS)).value = value;
    }

    public double getYoGraphicsGlobalScale() {
        return ((DoubleHolder)this.parameters.get((Object)SCS_YOGRAPHICS_GLOBALSCALE)).value;
    }

    public void setYoGraphicsGlobalScale(double value) {
        ((DoubleHolder)this.parameters.get((Object)SCS_YOGRAPHICS_GLOBALSCALE)).value = value;
    }

    public void setUseAutoGroundGraphics(boolean value) {
        ((BooleanHolder)this.parameters.get((Object)USE_AUTO_GROUND_GRAPHICS)).value = value;
    }

    public boolean getUseAutoGroundGraphics() {
        return ((BooleanHolder)this.parameters.get((Object)USE_AUTO_GROUND_GRAPHICS)).value;
    }

    protected abstract class TypeHolder {
        public TypeHolder(String initialValue) {
            this.setFromString(initialValue);
        }

        public abstract void setFromString(String var1);

        public abstract String getStringValue();
    }

    protected class BooleanHolder
    extends TypeHolder {
        public boolean value;

        public BooleanHolder(String initialValue) {
            super(initialValue);
        }

        @Override
        public void setFromString(String stringValue) {
            this.value = Boolean.parseBoolean(stringValue);
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }
    }

    protected class IntHolder
    extends TypeHolder {
        public int value;

        public IntHolder(String initialValue) {
            super(initialValue);
        }

        @Override
        public void setFromString(String stringValue) {
            this.value = Integer.parseInt(stringValue);
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }
    }

    protected class DoubleHolder
    extends TypeHolder {
        public double value;

        public DoubleHolder(String initialValue) {
            super(initialValue);
        }

        @Override
        public void setFromString(String stringValue) {
            this.value = Double.parseDouble(stringValue);
        }

        @Override
        public String getStringValue() {
            return String.valueOf(this.value);
        }
    }
}

