/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ejml.data.DMatrix;
import us.ihmc.euclid.matrix.interfaces.Matrix3DBasics;
import us.ihmc.euclid.matrix.interfaces.Matrix3DReadOnly;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.robotics.robotDescription.BallAndSocketJointDescription;
import us.ihmc.robotics.robotDescription.CameraSensorDescription;
import us.ihmc.robotics.robotDescription.CollisionMeshDescription;
import us.ihmc.robotics.robotDescription.ExternalForcePointDescription;
import us.ihmc.robotics.robotDescription.FloatingJointDescription;
import us.ihmc.robotics.robotDescription.FloatingPlanarJointDescription;
import us.ihmc.robotics.robotDescription.ForceSensorDescription;
import us.ihmc.robotics.robotDescription.GroundContactPointDescription;
import us.ihmc.robotics.robotDescription.IMUSensorDescription;
import us.ihmc.robotics.robotDescription.JointDescription;
import us.ihmc.robotics.robotDescription.JointWrenchSensorDescription;
import us.ihmc.robotics.robotDescription.KinematicPointDescription;
import us.ihmc.robotics.robotDescription.LidarSensorDescription;
import us.ihmc.robotics.robotDescription.LinkDescription;
import us.ihmc.robotics.robotDescription.LinkGraphicsDescription;
import us.ihmc.robotics.robotDescription.LoopClosureConstraintDescription;
import us.ihmc.robotics.robotDescription.PinJointDescription;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.robotics.robotDescription.SliderJointDescription;
import us.ihmc.simulationconstructionset.BallAndSocketJoint;
import us.ihmc.simulationconstructionset.CameraMount;
import us.ihmc.simulationconstructionset.DummyOneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.ExternalForcePoint;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.FloatingPlanarJoint;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.IMUMount;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.JointWrenchSensor;
import us.ihmc.simulationconstructionset.KinematicPoint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.LoopClosureSoftConstraint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJointHolder;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.simulatedSensors.CollisionShapeBasedWrenchCalculator;
import us.ihmc.simulationconstructionset.simulatedSensors.FeatherStoneJointBasedWrenchCalculator;
import us.ihmc.simulationconstructionset.simulatedSensors.GroundContactPointBasedWrenchCalculator;
import us.ihmc.simulationconstructionset.simulatedSensors.LidarMount;
import us.ihmc.simulationconstructionset.simulatedSensors.WrenchCalculatorInterface;

public class RobotFromDescription
extends Robot
implements OneDegreeOfFreedomJointHolder {
    private final Map<String, Joint> jointNameMap = new LinkedHashMap<String, Joint>();
    private final Map<JointDescription, Joint> jointDescriptionMap = new LinkedHashMap<JointDescription, Joint>();
    private final Map<LinkDescription, Link> linkDescriptionMap = new LinkedHashMap<LinkDescription, Link>();
    private final Map<String, OneDegreeOfFreedomJoint> oneDegreeOfFreedomJoints = new LinkedHashMap<String, OneDegreeOfFreedomJoint>();
    private final Map<String, CameraMount> cameraNameMap = new LinkedHashMap<String, CameraMount>();
    private final Map<CameraSensorDescription, CameraMount> cameraDescriptionMap = new LinkedHashMap<CameraSensorDescription, CameraMount>();
    private final Map<String, LidarMount> lidarNameMap = new LinkedHashMap<String, LidarMount>();
    private final Map<LidarSensorDescription, LidarMount> lidarDescriptionMap = new LinkedHashMap<LidarSensorDescription, LidarMount>();
    private final Map<String, IMUMount> imuNameMap = new LinkedHashMap<String, IMUMount>();
    private final Map<IMUSensorDescription, IMUMount> imuDescriptionMap = new LinkedHashMap<IMUSensorDescription, IMUMount>();
    private final Map<String, JointWrenchSensor> wrenchSensorNameMap = new LinkedHashMap<String, JointWrenchSensor>();
    private final Map<JointWrenchSensorDescription, JointWrenchSensor> wrenchSensorDescriptionMap = new LinkedHashMap<JointWrenchSensorDescription, JointWrenchSensor>();
    private final Map<Joint, ArrayList<GroundContactPoint>> jointToGroundContactPointsMap = new LinkedHashMap<Joint, ArrayList<GroundContactPoint>>();

    public RobotFromDescription(RobotDescription description) {
        this(description, true, true);
    }

    public RobotFromDescription(RobotDescription description, boolean enableDamping, boolean enableJointTorqueAndVelocityLimits) {
        super(description.getName());
        this.constructRobotFromDescription(description, enableDamping, enableJointTorqueAndVelocityLimits);
    }

    @Override
    public Joint getJoint(String jointName) {
        return this.jointNameMap.get(jointName);
    }

    public Joint getJoint(JointDescription jointDescription) {
        return this.jointDescriptionMap.get(jointDescription);
    }

    @Override
    public OneDegreeOfFreedomJoint getOneDegreeOfFreedomJoint(String name) {
        return this.oneDegreeOfFreedomJoints.get(name);
    }

    public OneDegreeOfFreedomJoint[] getOneDegreeOfFreedomJoints() {
        return this.oneDegreeOfFreedomJoints.values().toArray(new OneDegreeOfFreedomJoint[this.oneDegreeOfFreedomJoints.size()]);
    }

    public CameraMount getCameraMount(String cameraName) {
        return this.cameraNameMap.get(cameraName);
    }

    public CameraMount getCameraMount(CameraSensorDescription cameraSensorDescription) {
        return this.cameraDescriptionMap.get(cameraSensorDescription);
    }

    public IMUMount getIMUMount(String name) {
        return this.imuNameMap.get(name);
    }

    public IMUMount getIMUMount(IMUSensorDescription imuSensorDescription) {
        return this.imuDescriptionMap.get(imuSensorDescription);
    }

    public JointWrenchSensor getJointWrenchSensor(String name) {
        return this.wrenchSensorNameMap.get(name);
    }

    public JointWrenchSensor getJointWrenchSensor(JointWrenchSensorDescription jointWrenchSensorDescription) {
        return this.wrenchSensorDescriptionMap.get(jointWrenchSensorDescription);
    }

    public ArrayList<GroundContactPoint> getGroundContactPointsOnJoint(Joint joint) {
        return this.jointToGroundContactPointsMap.get(joint);
    }

    private void constructRobotFromDescription(RobotDescription description, boolean enableDamping, boolean enableJointTorqueAndVelocityLimits) {
        List rootJointDescriptions = description.getRootJoints();
        for (JointDescription rootJointDescription : rootJointDescriptions) {
            Joint rootJoint = this.constructJointRecursively(rootJointDescription, enableDamping, enableJointTorqueAndVelocityLimits);
            this.addRootJoint(rootJoint);
        }
        for (JointDescription rootJointDescription : rootJointDescriptions) {
            this.addLoopClosureConstraintsRecursively(rootJointDescription);
        }
        for (JointDescription rootJointDescription : rootJointDescriptions) {
            this.addForceSensorRecursively(rootJointDescription);
        }
    }

    private Joint constructJointRecursively(JointDescription jointDescription, boolean enableDamping, boolean enableJointTorqueAndVelocityLimits) {
        Joint joint = this.createSingleJoint(jointDescription, enableDamping, enableJointTorqueAndVelocityLimits);
        this.addGroundContactPoints(jointDescription, joint);
        this.addExternalForcePoints(jointDescription, joint);
        this.addKinematicPoints(jointDescription, joint);
        this.addExternalForcePointsFromCollisionMesh(jointDescription, joint);
        this.addLidarMounts(jointDescription, joint);
        this.addCameraMounts(jointDescription, joint);
        this.addIMUMounts(jointDescription, joint);
        this.addJointWrenchSensors(jointDescription, joint);
        List childrenJoints = jointDescription.getChildrenJoints();
        for (JointDescription childJointDescription : childrenJoints) {
            Joint childJoint = this.constructJointRecursively(childJointDescription, enableDamping, enableJointTorqueAndVelocityLimits);
            joint.addJoint(childJoint);
        }
        this.jointNameMap.put(joint.getName(), joint);
        this.jointDescriptionMap.put(jointDescription, joint);
        this.linkDescriptionMap.put(jointDescription.getLink(), joint.getLink());
        if (joint instanceof OneDegreeOfFreedomJoint) {
            this.oneDegreeOfFreedomJoints.put(joint.getName(), (OneDegreeOfFreedomJoint)joint);
        }
        return joint;
    }

    private void addForceSensorRecursively(JointDescription jointDescription) {
        Joint joint = this.jointNameMap.get(jointDescription.getName());
        List forceSensorDescriptions = jointDescription.getForceSensors();
        for (ForceSensorDescription forceSensorDescription : forceSensorDescriptions) {
            WrenchCalculatorInterface wrenchCalculator;
            if (forceSensorDescription.useGroundContactPoints()) {
                ArrayList<GroundContactPoint> groundContactPoints = new ArrayList<GroundContactPoint>();
                joint.recursiveGetAllGroundContactPoints(groundContactPoints);
                wrenchCalculator = new GroundContactPointBasedWrenchCalculator(forceSensorDescription.getName(), groundContactPoints, joint, forceSensorDescription.getTransformToJoint(), this.yoRegistry);
                if (forceSensorDescription.useShapeCollision()) {
                    ArrayList<ExternalForcePoint> contactPoints = new ArrayList();
                    contactPoints = joint.getExternalForcePoints();
                    wrenchCalculator = new CollisionShapeBasedWrenchCalculator(forceSensorDescription.getName(), contactPoints, joint, forceSensorDescription.getTransformToJoint(), this.yoRegistry);
                }
            } else {
                Vector3D offsetToPack = new Vector3D();
                offsetToPack.set((Tuple3DReadOnly)forceSensorDescription.getTransformToJoint().getTranslation());
                JointWrenchSensor jointWrenchSensor = new JointWrenchSensor(forceSensorDescription.getName(), (Tuple3DReadOnly)offsetToPack, this);
                joint.addJointWrenchSensor(jointWrenchSensor);
                wrenchCalculator = new FeatherStoneJointBasedWrenchCalculator(forceSensorDescription.getName(), joint);
            }
            joint.addForceSensor(wrenchCalculator);
        }
        List childrenJoints = jointDescription.getChildrenJoints();
        for (JointDescription childJointDescription : childrenJoints) {
            this.addForceSensorRecursively(childJointDescription);
        }
    }

    private void addLoopClosureConstraintsRecursively(JointDescription jointDescription) {
        Joint joint = this.jointNameMap.get(jointDescription.getName());
        List constraintDescriptions = jointDescription.getChildrenConstraintDescriptions();
        for (LoopClosureConstraintDescription constraintDescription : constraintDescriptions) {
            String name = constraintDescription.getName();
            Vector3DBasics offsetFromParentJoint = constraintDescription.getOffsetFromParentJoint();
            Vector3DBasics offsetFromLinkParentJoint = constraintDescription.getOffsetFromLinkParentJoint();
            Matrix3DBasics constraintForceSubSpace = constraintDescription.getConstraintForceSubSpace();
            Matrix3DBasics constraintMomentSubSpace = constraintDescription.getConstraintMomentSubSpace();
            LoopClosureSoftConstraint constraint = new LoopClosureSoftConstraint(name, (Tuple3DReadOnly)offsetFromParentJoint, (Tuple3DReadOnly)offsetFromLinkParentJoint, this, (Matrix3DReadOnly)constraintForceSubSpace, (Matrix3DReadOnly)constraintMomentSubSpace);
            constraint.setGains((Tuple3DReadOnly)constraintDescription.getProportionalGains(), (Tuple3DReadOnly)constraintDescription.getDerivativeGains());
            joint.addLoopClosureConstraint(constraint);
            Link link = this.linkDescriptionMap.get(constraintDescription.getLink());
            Objects.requireNonNull(link, "Could not find link: " + constraintDescription.getLink().getName());
            constraint.setLink(link);
        }
        for (JointDescription childJointDescription : jointDescription.getChildrenJoints()) {
            this.addLoopClosureConstraintsRecursively(childJointDescription);
        }
    }

    private void addExternalForcePointsFromCollisionMesh(JointDescription jointDescription, Joint joint) {
        Link link = joint.getLink();
        List<CollisionMeshDescription> collisionMeshDescriptions = link.getCollisionMeshDescriptions();
        if (collisionMeshDescriptions != null) {
            int estimatedNumberOfContactPoints = 0;
            for (int i = 0; i < collisionMeshDescriptions.size(); ++i) {
                CollisionMeshDescription collisionMesh = collisionMeshDescriptions.get(i);
                estimatedNumberOfContactPoints += collisionMesh.getEstimatedNumberOfContactPoints();
            }
            link.enableContactingExternalForcePoints(estimatedNumberOfContactPoints, this.yoRegistry);
        }
    }

    private void addLidarMounts(JointDescription jointDescription, Joint joint) {
        List lidarSensorDescriptions = jointDescription.getLidarSensors();
        for (LidarSensorDescription lidarSensorDescription : lidarSensorDescriptions) {
            LidarMount lidarMount = new LidarMount(lidarSensorDescription);
            joint.addLidarMount(lidarMount);
            joint.addSensor(lidarMount);
            this.lidarNameMap.put(lidarMount.getName(), lidarMount);
            this.lidarDescriptionMap.put(lidarSensorDescription, lidarMount);
        }
    }

    private void addCameraMounts(JointDescription jointDescription, Joint joint) {
        List cameraSensorDescriptions = jointDescription.getCameraSensors();
        for (CameraSensorDescription cameraSensorDescription : cameraSensorDescriptions) {
            CameraMount cameraMount = new CameraMount(cameraSensorDescription.getName(), (RigidBodyTransformReadOnly)cameraSensorDescription.getTransformToJoint(), cameraSensorDescription.getFieldOfView(), cameraSensorDescription.getClipNear(), cameraSensorDescription.getClipFar(), (Robot)this);
            cameraMount.setImageWidth(cameraSensorDescription.getImageWidth());
            cameraMount.setImageHeight(cameraSensorDescription.getImageHeight());
            joint.addCameraMount(cameraMount);
            this.cameraNameMap.put(cameraMount.getName(), cameraMount);
            this.cameraDescriptionMap.put(cameraSensorDescription, cameraMount);
        }
    }

    private void addIMUMounts(JointDescription jointDescription, Joint joint) {
        List imuSensorDescriptions = jointDescription.getIMUSensors();
        for (IMUSensorDescription imuSensorDescription : imuSensorDescriptions) {
            IMUMount imuMount = new IMUMount(imuSensorDescription.getName(), imuSensorDescription.getTransformToJoint(), this);
            joint.addIMUMount(imuMount);
            this.imuNameMap.put(imuMount.getName(), imuMount);
            this.imuDescriptionMap.put(imuSensorDescription, imuMount);
        }
    }

    private void addJointWrenchSensors(JointDescription jointDescription, Joint joint) {
        List jointWrenchSensorDescriptions = jointDescription.getWrenchSensors();
        for (JointWrenchSensorDescription jointWrenchSensorDescription : jointWrenchSensorDescriptions) {
            JointWrenchSensor jointWrenchSensor = new JointWrenchSensor(jointWrenchSensorDescription.getName(), (Tuple3DReadOnly)jointWrenchSensorDescription.getOffsetFromJoint(), this);
            joint.addJointWrenchSensor(jointWrenchSensor);
            this.wrenchSensorNameMap.put(jointWrenchSensor.getName(), jointWrenchSensor);
            this.wrenchSensorDescriptionMap.put(jointWrenchSensorDescription, jointWrenchSensor);
        }
    }

    private void addForceSensors(JointDescription jointDescription, Joint joint) {
        List forceSensorDescriptions = jointDescription.getForceSensors();
        for (ForceSensorDescription forceSensorDescription : forceSensorDescriptions) {
            WrenchCalculatorInterface wrenchCalculator;
            if (forceSensorDescription.useGroundContactPoints()) {
                ArrayList<GroundContactPoint> groundContactPoints = new ArrayList<GroundContactPoint>();
                joint.recursiveGetAllGroundContactPoints(groundContactPoints);
                wrenchCalculator = new GroundContactPointBasedWrenchCalculator(forceSensorDescription.getName(), groundContactPoints, joint, forceSensorDescription.getTransformToJoint(), this.yoRegistry);
            } else {
                Vector3D offsetToPack = new Vector3D();
                offsetToPack.set((Tuple3DReadOnly)forceSensorDescription.getTransformToJoint().getTranslation());
                JointWrenchSensor jointWrenchSensor = new JointWrenchSensor(forceSensorDescription.getName(), (Tuple3DReadOnly)offsetToPack, this);
                joint.addJointWrenchSensor(jointWrenchSensor);
                wrenchCalculator = new FeatherStoneJointBasedWrenchCalculator(forceSensorDescription.getName(), joint);
            }
            joint.addForceSensor(wrenchCalculator);
        }
    }

    private void addGroundContactPoints(JointDescription jointDescription, Joint joint) {
        List groundContactPointDescriptions = jointDescription.getGroundContactPoints();
        for (GroundContactPointDescription groundContactPointDescription : groundContactPointDescriptions) {
            GroundContactPoint groundContactPoint = new GroundContactPoint(groundContactPointDescription.getName(), (Tuple3DReadOnly)groundContactPointDescription.getOffsetFromJoint(), this);
            joint.addGroundContactPoint(groundContactPointDescription.getGroupIdentifier(), groundContactPoint);
            if (!this.jointToGroundContactPointsMap.containsKey(joint)) {
                this.jointToGroundContactPointsMap.put(joint, new ArrayList());
            }
            this.jointToGroundContactPointsMap.get(joint).add(groundContactPoint);
        }
    }

    private void addExternalForcePoints(JointDescription jointDescription, Joint joint) {
        List ExternalForcePointDescriptions = jointDescription.getExternalForcePoints();
        for (ExternalForcePointDescription ExternalForcePointDescription2 : ExternalForcePointDescriptions) {
            ExternalForcePoint ExternalForcePoint2 = new ExternalForcePoint(ExternalForcePointDescription2.getName(), (Tuple3DReadOnly)ExternalForcePointDescription2.getOffsetFromJoint(), this);
            joint.addExternalForcePoint(ExternalForcePoint2);
        }
    }

    private void addKinematicPoints(JointDescription jointDescription, Joint joint) {
        List KinematicPointDescriptions = jointDescription.getKinematicPoints();
        for (KinematicPointDescription KinematicPointDescription2 : KinematicPointDescriptions) {
            KinematicPoint KinematicPoint2 = new KinematicPoint(KinematicPointDescription2.getName(), (Tuple3DReadOnly)KinematicPointDescription2.getOffsetFromJoint(), this);
            joint.addKinematicPoint(KinematicPoint2);
        }
    }

    private Joint createSingleJoint(JointDescription jointDescription, boolean enableDamping, boolean enableJointTorqueAndVelocityLimits) {
        LinkDescription linkDescription;
        Joint joint;
        Vector3D offset;
        if (jointDescription instanceof FloatingJointDescription) {
            FloatingJointDescription floatingJointDescription = (FloatingJointDescription)jointDescription;
            offset = new Vector3D();
            floatingJointDescription.getOffsetFromParentJoint((Tuple3DBasics)offset);
            joint = new FloatingJoint(jointDescription.getName(), floatingJointDescription.getJointVariableName(), (Tuple3DReadOnly)offset, this, true);
        } else if (jointDescription instanceof FloatingPlanarJointDescription) {
            FloatingPlanarJointDescription floatingPlanarJointDescription = (FloatingPlanarJointDescription)jointDescription;
            joint = new FloatingPlanarJoint(jointDescription.getName(), this, floatingPlanarJointDescription.getPlane());
        } else if (jointDescription instanceof BallAndSocketJointDescription) {
            BallAndSocketJointDescription sphericalJointDescription = (BallAndSocketJointDescription)jointDescription;
            offset = new Vector3D();
            sphericalJointDescription.getOffsetFromParentJoint((Tuple3DBasics)offset);
            joint = new BallAndSocketJoint(jointDescription.getName(), (Tuple3DReadOnly)offset, (Robot)this, true);
        } else if (jointDescription instanceof PinJointDescription) {
            PinJointDescription pinJointDescription = (PinJointDescription)jointDescription;
            offset = new Vector3D();
            pinJointDescription.getOffsetFromParentJoint((Tuple3DBasics)offset);
            if (jointDescription.isDynamic()) {
                Vector3D jointAxis = new Vector3D();
                pinJointDescription.getJointAxis((Vector3DBasics)jointAxis);
                joint = new PinJoint(jointDescription.getName(), (Tuple3DReadOnly)offset, (Robot)this, (Vector3DReadOnly)jointAxis);
                PinJoint pinJoint = (PinJoint)joint;
                if (pinJointDescription.containsLimitStops()) {
                    double[] limitStopParameters = pinJointDescription.getLimitStopParameters();
                    double qMin = limitStopParameters[0];
                    double qMax = limitStopParameters[1];
                    double kLimit = limitStopParameters[2];
                    double bLimit = limitStopParameters[3];
                    pinJoint.setLimitStops(qMin, qMax, kLimit, bLimit);
                }
                if (enableDamping) {
                    pinJoint.setDamping(pinJointDescription.getDamping());
                    pinJoint.setStiction(pinJointDescription.getStiction());
                }
                if (enableJointTorqueAndVelocityLimits) {
                    pinJoint.setVelocityLimits(pinJointDescription.getVelocityLimit(), pinJointDescription.getVelocityDamping());
                }
            } else {
                Vector3D jointAxis = new Vector3D();
                pinJointDescription.getJointAxis((Vector3DBasics)jointAxis);
                joint = new DummyOneDegreeOfFreedomJoint(jointDescription.getName(), (Tuple3DReadOnly)offset, (Robot)this, (Vector3DReadOnly)jointAxis);
            }
        } else if (jointDescription instanceof SliderJointDescription) {
            SliderJointDescription sliderJointDescription = (SliderJointDescription)jointDescription;
            offset = new Vector3D();
            sliderJointDescription.getOffsetFromParentJoint((Tuple3DBasics)offset);
            Vector3D jointAxis = new Vector3D();
            sliderJointDescription.getJointAxis((Vector3DBasics)jointAxis);
            joint = new SliderJoint(jointDescription.getName(), (Tuple3DReadOnly)offset, (Robot)this, (Vector3DReadOnly)jointAxis);
            SliderJoint sliderJoint = (SliderJoint)joint;
            if (sliderJointDescription.containsLimitStops()) {
                double[] limitStopParameters = sliderJointDescription.getLimitStopParameters();
                double qMin = limitStopParameters[0];
                double qMax = limitStopParameters[1];
                double kLimit = limitStopParameters[2];
                double bLimit = limitStopParameters[3];
                sliderJoint.setLimitStops(qMin, qMax, kLimit, bLimit);
            }
        } else {
            throw new RuntimeException("Don't support that joint type yet. Please implement it! Type = " + jointDescription.getClass());
        }
        if (!jointDescription.isDynamic()) {
            joint.setDynamic(false);
        }
        if ((linkDescription = jointDescription.getLink()) == null) {
            throw new RuntimeException("LinkDescription is null for joint " + jointDescription.getName());
        }
        Link link = this.createLink(linkDescription);
        joint.setLink(link);
        return joint;
    }

    private Link createLink(LinkDescription linkDescription) {
        Link link = new Link(linkDescription.getName());
        link.setMass(linkDescription.getMass());
        link.setComOffset((Vector3DReadOnly)linkDescription.getCenterOfMassOffset());
        link.setMomentOfInertia((DMatrix)linkDescription.getMomentOfInertia());
        LinkGraphicsDescription linkGraphics = linkDescription.getLinkGraphics();
        link.setLinkGraphics((Graphics3DObject)linkGraphics);
        List collisonMeshDescriptions = linkDescription.getCollisionMeshes();
        for (int i = 0; i < collisonMeshDescriptions.size(); ++i) {
            link.addCollisionMesh((CollisionMeshDescription)collisonMeshDescriptions.get(i));
        }
        return link;
    }
}

