/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileFromHeightMap;

public class FlatGroundProfile
extends GroundProfileFromHeightMap {
    private final double zHeight;
    private final BoundingBox3D boundingBox;

    public FlatGroundProfile() {
        this(0.0);
    }

    public FlatGroundProfile(double zHeight) {
        this(-500.0, 500.0, -500.0, 500.0, zHeight);
    }

    public FlatGroundProfile(double xMin, double xMax, double yMin, double yMax) {
        this(xMin, xMax, yMin, yMax, 0.0);
    }

    public FlatGroundProfile(double xMin, double xMax, double yMin, double yMax, double zHeight) {
        this.zHeight = zHeight;
        this.boundingBox = new BoundingBox3D(xMin, yMin, zHeight - 1.0, xMax, yMax, zHeight + 0.01);
    }

    public double heightAndNormalAt(double x, double y, double z, Vector3DBasics normalToPack) {
        double height = this.heightAt(x, y, z);
        this.surfaceNormalAt(x, y, z, normalToPack);
        return height;
    }

    public double heightAt(double x, double y, double z) {
        return this.zHeight;
    }

    public void surfaceNormalAt(double x, double y, double z, Vector3DBasics normal) {
        normal.setX(0.0);
        normal.setY(0.0);
        normal.setZ(1.0);
    }

    public BoundingBox3D getBoundingBox() {
        return this.boundingBox;
    }
}

