/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.gui.dialogs;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.Border;
import us.ihmc.simulationconstructionset.gui.DataBufferChangeListener;
import us.ihmc.yoVariables.buffer.YoBuffer;

public class DataBufferPropertiesDialog
extends JDialog
implements ActionListener {
    private JTextField currentTextField;
    private JRadioButton enlargeButton;
    private int newCurrentVal;
    private JButton okButton;
    private JButton applyButton;
    private JButton cancelButton;
    private BufferPropertiesPanel bufferPropertiesPanel;
    private DataBufferChangeListener listener;
    private YoBuffer dataBuffer;

    public DataBufferPropertiesDialog(Container parentContainer, JFrame frame, YoBuffer dataBuffer, DataBufferChangeListener listener) {
        super(frame, "Data Buffer Properties", false);
        this.listener = listener;
        this.dataBuffer = dataBuffer;
        Container contentPane = this.getContentPane();
        this.bufferPropertiesPanel = new BufferPropertiesPanel();
        contentPane.add(this.bufferPropertiesPanel);
        this.okButton = new JButton("OK");
        this.okButton.addActionListener(this);
        this.applyButton = new JButton("Apply");
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.addActionListener(this);
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.okButton);
        buttonPanel.add(this.applyButton);
        buttonPanel.add(this.cancelButton);
        contentPane.add((Component)buttonPanel, "South");
        Point point = parentContainer.getLocation();
        Dimension frameSize = parentContainer.getSize();
        point.translate(frameSize.width / 2, frameSize.height / 4);
        this.setLocation(point);
        this.setResizable(false);
        this.pack();
        Dimension size = this.currentTextField.getSize();
        size.width = size.width * 5 / 4;
        this.currentTextField.setSize(size);
        this.currentTextField.setPreferredSize(size);
        this.currentTextField.setMinimumSize(size);
        this.pack();
        this.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.cancelButton) {
            this.setVisible(false);
        }
        if (event.getSource() == this.applyButton) {
            this.bufferPropertiesPanel.commitChanges();
        }
        if (event.getSource() == this.okButton) {
            this.bufferPropertiesPanel.commitChanges();
            this.setVisible(false);
        }
        if (this.listener != null) {
            this.listener.dataBufferChanged();
        }
    }

    public class BufferPropertiesPanel
    extends JPanel
    implements ActionListener {
        private static final long serialVersionUID = -3906496391997459515L;

        public BufferPropertiesPanel() {
            DataBufferPropertiesDialog.this.newCurrentVal = DataBufferPropertiesDialog.this.dataBuffer.getBufferSize();
            GridBagLayout gridbag = new GridBagLayout();
            this.setLayout(gridbag);
            Border blackLine = BorderFactory.createLineBorder(Color.black);
            this.setBorder(blackLine);
            GridBagConstraints constraints = new GridBagConstraints();
            JLabel policyLabel = new JLabel("   Filled Policy:  ");
            constraints.gridx = 0;
            constraints.gridy = 0;
            constraints.gridwidth = 1;
            constraints.anchor = 13;
            gridbag.setConstraints(policyLabel, constraints);
            this.add(policyLabel);
            ButtonGroup group = new ButtonGroup();
            group.add(DataBufferPropertiesDialog.this.enlargeButton);
            JLabel maxSettingsLabel = new JLabel("  Max Size:  ");
            constraints.gridx = 0;
            constraints.gridy = 1;
            constraints.gridwidth = 1;
            constraints.anchor = 13;
            gridbag.setConstraints(maxSettingsLabel, constraints);
            this.add(maxSettingsLabel);
            JLabel currentSettingsLabel = new JLabel("  Current Size:  ");
            constraints.gridx = 0;
            constraints.gridy = 2;
            constraints.gridwidth = 1;
            constraints.anchor = 13;
            gridbag.setConstraints(currentSettingsLabel, constraints);
            this.add(currentSettingsLabel);
            String currentValString = String.valueOf(DataBufferPropertiesDialog.this.newCurrentVal);
            DataBufferPropertiesDialog.this.currentTextField = new JTextField(currentValString);
            DataBufferPropertiesDialog.this.currentTextField.addActionListener(this);
            DataBufferPropertiesDialog.this.currentTextField.setEnabled(true);
            constraints.gridx = 1;
            constraints.gridy = 2;
            constraints.gridwidth = 2;
            constraints.anchor = 17;
            gridbag.setConstraints(DataBufferPropertiesDialog.this.currentTextField, constraints);
            this.add(DataBufferPropertiesDialog.this.currentTextField);
        }

        public void commitChanges() {
            this.updateCurrentTextField();
            DataBufferPropertiesDialog.this.dataBuffer.resizeBuffer(DataBufferPropertiesDialog.this.newCurrentVal);
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (event.getSource() == DataBufferPropertiesDialog.this.currentTextField) {
                this.updateCurrentTextField();
            }
        }

        public void updateCurrentTextField() {
            String text = DataBufferPropertiesDialog.this.currentTextField.getText();
            try {
                int val = Integer.parseInt(text);
                DataBufferPropertiesDialog.this.newCurrentVal = val;
            }
            catch (NumberFormatException e) {
                DataBufferPropertiesDialog.this.currentTextField.setText(String.valueOf(DataBufferPropertiesDialog.this.newCurrentVal));
            }
        }
    }
}

