/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics;

import java.util.ArrayList;
import java.util.Random;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.commons.RandomNumbers;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreIOTools;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.JointBasics;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.mecano.tools.MultiBodySystemRandomTools;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.tools.RobotTools;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.ControllerFailureException;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.simulationRunner.BlockingSimulationRunner;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.tools.MemoryTools;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class JointPhysicsConservedQuantitiesTest {
    private SimulationTestingParameters simulationTestingParameters = SimulationTestingParameters.createFromSystemProperties();
    private BlockingSimulationRunner blockingSimulationRunner;

    @BeforeEach
    public void showMemoryUsageBeforeTest() {
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " before test."));
    }

    @AfterEach
    public void destroySimulationAndRecycleMemory() {
        if (this.simulationTestingParameters.getKeepSCSUp()) {
            ThreadTools.sleepForever();
        }
        if (this.blockingSimulationRunner != null) {
            this.blockingSimulationRunner.destroySimulation();
            this.blockingSimulationRunner = null;
        }
        this.simulationTestingParameters = null;
        MemoryTools.printCurrentMemoryUsageAndReturnUsedMemoryInMB((String)(this.getClass().getSimpleName() + " after test."));
    }

    private MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain getRandomFloatingChain(int minNumberOfAxes, int maxNumberOfAxes) {
        Random random = new Random(519651L);
        int numberOfAxes = RandomNumbers.nextInt((Random)random, (int)minNumberOfAxes, (int)maxNumberOfAxes);
        Vector3D[] jointAxes = new Vector3D[numberOfAxes];
        for (int i = 0; i < numberOfAxes; ++i) {
            jointAxes[i] = EuclidCoreRandomTools.nextVector3DWithFixedLength((Random)random, (double)1.0);
        }
        MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain randomFloatingChain = new MultiBodySystemRandomTools.RandomFloatingRevoluteJointChain(random, jointAxes);
        randomFloatingChain.nextState(random, new JointStateType[]{JointStateType.CONFIGURATION, JointStateType.VELOCITY});
        return randomFloatingChain;
    }

    @Test
    public void testLinearAndAngularMomentumAreConverved() {
        int numberOfRobotsToTest = 5;
        int minNumberOfAxes = 2;
        int maxNumberOfAxes = 10;
        Robot[] robots = new Robot[numberOfRobotsToTest];
        for (int i = 0; i < numberOfRobotsToTest; ++i) {
            RobotTools.SCSRobotFromInverseDynamicsRobotModel robot = new RobotTools.SCSRobotFromInverseDynamicsRobotModel("robot" + i, (JointBasics)this.getRandomFloatingChain(minNumberOfAxes, maxNumberOfAxes).getRootJoint());
            robot.setGravity(0.0, 0.0, 0.0);
            robot.setController((RobotController)new ConservedQuantitiesChecker((Robot)robot));
            robot.setController((RobotController)new SinusoidalTorqueController((Robot)robot));
            robots[i] = robot;
        }
        SimulationConstructionSet scs = new SimulationConstructionSet(robots, (SimulationConstructionSetParameters)this.simulationTestingParameters);
        scs.startOnAThread();
        BlockingSimulationRunner blockingSimulationRunner = new BlockingSimulationRunner(scs, 30.0);
        try {
            blockingSimulationRunner.simulateAndBlock(8.0);
        }
        catch (ControllerFailureException | BlockingSimulationRunner.SimulationExceededMaximumTimeException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private class ConservedQuantitiesChecker
    implements RobotController {
        private final Robot robot;
        private final YoRegistry registry;
        private final FloatingJoint rootJoint;
        private final double epsilon = 1.0E-5;
        private final Vector3D initialLinearMomentum = new Vector3D();
        private final Vector3D initialAngularMomentum = new Vector3D();
        private boolean firstTick = true;

        ConservedQuantitiesChecker(Robot robot) {
            this.robot = robot;
            this.rootJoint = (FloatingJoint)robot.getRootJoints().get(0);
            this.registry = new YoRegistry(robot.getName() + this.getClass().getSimpleName());
        }

        public void initialize() {
        }

        public YoRegistry getYoRegistry() {
            return this.registry;
        }

        public String getName() {
            return this.robot.getName();
        }

        public String getDescription() {
            return this.robot.getName();
        }

        public void doControl() {
            if (this.firstTick) {
                this.robot.computeCOMMomentum((Joint)this.rootJoint, (Point3DBasics)new Point3D(), (Vector3DBasics)this.initialLinearMomentum, (Vector3DBasics)this.initialAngularMomentum);
                this.firstTick = false;
            }
            Vector3D currentLinearMomentum = new Vector3D();
            Vector3D currentAngularMomentum = new Vector3D();
            this.robot.computeCOMMomentum((Joint)this.rootJoint, (Point3DBasics)new Point3D(), (Vector3DBasics)currentLinearMomentum, (Vector3DBasics)currentAngularMomentum);
            EuclidCoreTestTools.assertEquals((String)("Linear momentum hasn't been conserved. p(t=0)=" + EuclidCoreIOTools.getTuple3DString((String)"%6.8f", (Tuple3DReadOnly)this.initialLinearMomentum) + ", p(t=" + this.robot.getTime() + ")=" + EuclidCoreIOTools.getTuple3DString((String)"%6.8f", (Tuple3DReadOnly)currentLinearMomentum)), (EuclidGeometry)this.initialLinearMomentum, (EuclidGeometry)currentLinearMomentum, (double)1.0E-5);
            EuclidCoreTestTools.assertEquals((String)("Angular momentum hasn't been conserved. L(t=0)=" + EuclidCoreIOTools.getTuple3DString((String)"%6.8f", (Tuple3DReadOnly)this.initialAngularMomentum) + ", L(t=" + this.robot.getTime() + ")=" + EuclidCoreIOTools.getTuple3DString((String)"%6.8f", (Tuple3DReadOnly)currentAngularMomentum)), (EuclidGeometry)this.initialAngularMomentum, (EuclidGeometry)currentAngularMomentum, (double)1.0E-5);
        }
    }

    private class SinusoidalTorqueController
    implements RobotController {
        private final Random random = new Random(3289023L);
        private final YoRegistry registry;
        private final YoDouble t;
        private final ArrayList<Joint> joints = new ArrayList();
        private final ArrayList<Double> amplitudes = new ArrayList();
        private final ArrayList<Double> omegas = new ArrayList();

        SinusoidalTorqueController(Robot robot) {
            this.t = robot.getYoTime();
            this.registry = new YoRegistry(robot.getName() + this.getClass().getSimpleName());
            Joint rootJoint = (Joint)robot.getRootJoints().get(0);
            for (Joint childJoint : rootJoint.getChildrenJoints()) {
                this.recursivelyAddJointTorqueProfile(childJoint);
            }
        }

        private void recursivelyAddJointTorqueProfile(Joint joint) {
            this.joints.add(joint);
            this.amplitudes.add(RandomNumbers.nextDouble((Random)this.random, (double)0.1, (double)1.0));
            this.omegas.add(RandomNumbers.nextDouble((Random)this.random, (double)0.5, (double)3.0));
            for (Joint childJoint : joint.getChildrenJoints()) {
                this.recursivelyAddJointTorqueProfile(childJoint);
            }
        }

        public void initialize() {
        }

        public YoRegistry getYoRegistry() {
            return this.registry;
        }

        public String getName() {
            return this.registry.getName();
        }

        public String getDescription() {
            return this.registry.getName();
        }

        public void doControl() {
            for (int i = 0; i < this.joints.size(); ++i) {
                double torque = this.amplitudes.get(i) * Math.sin(this.t.getDoubleValue() * this.omegas.get(i));
                ((OneDegreeOfFreedomJoint)this.joints.get(i)).setTau(torque);
            }
        }
    }
}

