/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.util.ground;

import java.util.ArrayList;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.euclid.geometry.Plane3D;
import us.ihmc.euclid.geometry.interfaces.Vertex2DSupplier;
import us.ihmc.euclid.interfaces.EuclidGeometry;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationConstructionSetTools.util.ground.RotatableConvexPolygonTerrainObject;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;

public class RotatableConvexPolygonTerrainObjectTest {
    private RotatableConvexPolygonTerrainObject flatTopFaceOctagon3d;
    private RotatableConvexPolygonTerrainObject inclinedTopFaceOctagon3d;
    private RotatableConvexPolygonTerrainObject inclinedTopFaceOctagon3dSecond;
    private Vector3D normalZVector;
    private Vector3D normalYZVector;
    private ConvexPolygon2D convexPolygon;
    private double[][] pointList;
    private double centroidHeight;
    private double epsilon = 1.0E-8;

    @BeforeEach
    public void setUp() throws Exception {
        this.normalZVector = new Vector3D(0.0, 0.0, 1.0);
        double[][] pointList = new double[][]{{2.0, 1.0}, {1.0, 2.0}, {-1.0, 2.0}, {-2.0, 1.0}, {-2.0, -1.0}, {-1.0, -2.0}, {1.0, -2.0}, {2.0, -1.0}};
        this.pointList = pointList;
        this.convexPolygon = new ConvexPolygon2D(Vertex2DSupplier.asVertex2DSupplier((double[][])pointList));
        this.centroidHeight = 1.0;
        this.flatTopFaceOctagon3d = new RotatableConvexPolygonTerrainObject(this.normalZVector, this.convexPolygon, this.centroidHeight);
        this.normalYZVector = new Vector3D(0.0, 1.0, 1.0);
        this.inclinedTopFaceOctagon3d = new RotatableConvexPolygonTerrainObject(this.normalYZVector, this.convexPolygon, this.centroidHeight);
        this.inclinedTopFaceOctagon3dSecond = new RotatableConvexPolygonTerrainObject(this.normalYZVector, this.convexPolygon, 3.0);
    }

    @Test
    public void testHeightAt() {
        Point2DReadOnly centroid = this.convexPolygon.getCentroid();
        Assert.assertEquals((double)this.centroidHeight, (double)this.flatTopFaceOctagon3d.heightAt(centroid.getX(), centroid.getY(), this.centroidHeight), (double)this.epsilon);
        for (double[] point : this.pointList) {
            double expectedY = this.centroidHeight - point[1];
            Assert.assertEquals((double)expectedY, (double)this.inclinedTopFaceOctagon3d.heightAt(point[0], point[1], this.centroidHeight), (double)this.epsilon);
        }
        Assert.assertEquals((double)0.0, (double)this.flatTopFaceOctagon3d.heightAt(5.0, 5.0, 5.0), (double)this.epsilon);
    }

    @Test
    public void testIsClose() {
        Assert.assertTrue((boolean)this.flatTopFaceOctagon3d.isClose(0.0, 0.0, 0.5));
        Assert.assertFalse((boolean)this.flatTopFaceOctagon3d.isClose(0.0, 0.0, 1.5));
        Assert.assertFalse((boolean)this.flatTopFaceOctagon3d.isClose(2.0, 2.0, 1.5));
        Assert.assertTrue((boolean)this.inclinedTopFaceOctagon3d.isClose(0.0, 1.0, this.centroidHeight));
        Assert.assertTrue((boolean)this.inclinedTopFaceOctagon3d.isClose(0.0, -1.0, this.centroidHeight));
        Assert.assertTrue((boolean)this.inclinedTopFaceOctagon3d.isClose(0.0, 0.0, this.centroidHeight));
    }

    @Test
    public void testClosestIntersectionTo() {
        Point3D pointToPack = new Point3D();
        Vector3D normalToPack = new Vector3D();
        Point3D expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.flatTopFaceOctagon3d.checkIfInside(3.0, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint.set(-1.5, -1.5, 0.0);
        this.flatTopFaceOctagon3d.checkIfInside(-4.0, -4.0, 0.0, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint.set(0.0, 2.0, 0.9);
        this.flatTopFaceOctagon3d.checkIfInside(0.0, 2.3, 0.9, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint.set(1.0, -1.0, 1.0);
        this.flatTopFaceOctagon3d.checkIfInside(1.0, -1.0, 1.1, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint.set(1.5, -1.5, 1.0);
        this.flatTopFaceOctagon3d.checkIfInside(1.5, -1.5, 1.0, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint.set(0.0, 1.5, 1.5);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(0.0, 2.0, 2.0, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint.set(0.0, 2.0, 0.5);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(0.0, 3.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(1.0, 2.0, 0.5);
        this.flatTopFaceOctagon3d.checkIfInside(1.1, 5.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(1.0, 2.0, 1.0);
        this.flatTopFaceOctagon3d.checkIfInside(1.1, 5.0, 2.0, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(-1.0, -2.0, 1.0);
        this.flatTopFaceOctagon3d.checkIfInside(-2.0, -4.0, 1.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(-2.0, 0.0, 1.0);
        this.flatTopFaceOctagon3d.checkIfInside(-3.0, 0.0, 1.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.flatTopFaceOctagon3d.checkIfInside(1.99, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(1.99, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.flatTopFaceOctagon3d.checkIfInside(1.5, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(1.5, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(1.49, 0.0, 1.0);
        this.flatTopFaceOctagon3d.checkIfInside(1.49, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(1.49, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
    }

    @Test
    public void testIsInsideTheFace() {
        Point3D faceCenter = new Point3D(1.0, 0.0, 0.0);
        Vector3D faceNormal = new Vector3D(1.0, 0.0, 0.0);
        Plane3D facePlane = new Plane3D((Point3DReadOnly)faceCenter, (Vector3DReadOnly)faceNormal);
        ArrayList<Point3D> faceVertices3d = new ArrayList<Point3D>();
        faceVertices3d.add(new Point3D(1.0, -2.0, 0.0));
        faceVertices3d.add(new Point3D(1.0, 0.0, -2.0));
        faceVertices3d.add(new Point3D(1.0, 2.0, 0.0));
        faceVertices3d.add(new Point3D(1.0, 0.0, 2.0));
        Point3D pointToCheck = new Point3D(1.0, -1.0, 0.0);
        Assert.assertTrue((boolean)this.flatTopFaceOctagon3d.isInsideTheFace(facePlane, faceVertices3d, pointToCheck));
        pointToCheck.set(1.0, -1.0, 1.0);
        Assert.assertTrue((boolean)this.flatTopFaceOctagon3d.isInsideTheFace(facePlane, faceVertices3d, pointToCheck));
        pointToCheck.set(1.0, 1.0, 2.0);
        Assert.assertFalse((boolean)this.flatTopFaceOctagon3d.isInsideTheFace(facePlane, faceVertices3d, pointToCheck));
    }

    @Test
    public void testSurfaceNormalAt() {
        Vector3D normalToPack = new Vector3D();
        Point3D pointToPack = new Point3D();
        this.flatTopFaceOctagon3d.checkIfInside(0.0, 0.0, 1.01, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, 1.0), (EuclidGeometry)normalToPack, (double)1.0E-4);
        this.flatTopFaceOctagon3d.checkIfInside(0.0, 0.0, 0.99, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)new Vector3D(0.0, 0.0, 1.0), (EuclidGeometry)normalToPack, (double)1.0E-4);
        Vector3D expected = new Vector3D(1.0, 0.0, 0.5);
        expected.normalize();
        this.flatTopFaceOctagon3d.checkIfInside(3.0, 0.0, 1.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expected, (EuclidGeometry)normalToPack, (double)this.epsilon);
    }

    @Test
    public void testClosestIntersectionAndNormalAt() {
        Point3D pointToPack = new Point3D();
        Vector3D normalToPack = new Vector3D();
        Vector3D expectedVector = new Vector3D();
        Point3D expectedPoint = new Point3D(2.0, 0.0, 0.5);
        expectedVector.set(1.0, 0.0, 0.0);
        this.flatTopFaceOctagon3d.checkIfInside(3.0, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint.set(-1.5, -1.5, 0.0);
        expectedVector.set(-1.0, -1.0, 0.0);
        expectedVector.normalize();
        this.flatTopFaceOctagon3d.checkIfInside(-4.0, -4.0, 0.0, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint.set(0.0, 2.0, 0.9);
        expectedVector.set(0.0, 1.0, 0.0);
        this.flatTopFaceOctagon3d.checkIfInside(0.0, 2.3, 0.9, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint.set(1.0, -1.0, 1.0);
        expectedVector.set(0.0, 0.0, 1.0);
        this.flatTopFaceOctagon3d.checkIfInside(1.0, -1.0, 1.1, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint.set(1.5, -1.5, 1.0);
        expectedVector.set(1.0, -1.0, 0.0);
        expectedVector.normalize();
        this.flatTopFaceOctagon3d.checkIfInside(1.5, -1.5, 1.0, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint.set(0.0, 1.5, 1.5);
        expectedVector.set(0.0, 1.0, 1.0);
        expectedVector.normalize();
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(0.0, 2.0, 2.0, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint.set(0.0, 2.0, 0.5);
        expectedVector.set(0.0, 1.0, 0.0);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(0.0, 3.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(1.0, 2.0, 0.5);
        expectedVector.set(1.1, 5.0, 0.5);
        expectedVector.sub((Tuple3DReadOnly)expectedPoint);
        expectedVector.normalize();
        this.flatTopFaceOctagon3d.checkIfInside(1.1, 5.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(1.0, 2.0, 1.0);
        expectedVector.set(1.1, 5.0, 2.0);
        expectedVector.sub((Tuple3DReadOnly)expectedPoint);
        expectedVector.normalize();
        this.flatTopFaceOctagon3d.checkIfInside(1.1, 5.0, 2.0, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(-1.0, -2.0, 1.0);
        expectedVector.set(-2.0, -4.0, 1.5);
        expectedVector.sub((Tuple3DReadOnly)expectedPoint);
        expectedVector.normalize();
        this.flatTopFaceOctagon3d.checkIfInside(-2.0, -4.0, 1.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(-2.0, 0.0, 1.0);
        expectedVector.set(-3.0, 0.0, 1.5);
        expectedVector.sub((Tuple3DReadOnly)expectedPoint);
        expectedVector.normalize();
        this.flatTopFaceOctagon3d.checkIfInside(-3.0, 0.0, 1.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        expectedVector.set(1.0, 0.0, 0.0);
        this.flatTopFaceOctagon3d.checkIfInside(1.99, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(1.99, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.flatTopFaceOctagon3d.checkIfInside(1.5, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(1.5, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(1.49, 0.0, 1.0);
        expectedVector.set(0.0, 0.0, 1.0);
        this.flatTopFaceOctagon3d.checkIfInside(1.49, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(2.0, 0.0, 0.5);
        expectedVector.set(1.0, 0.0, 0.0);
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(1.49, 0.0, 0.5, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
        expectedPoint = new Point3D(0.0, -1.85, 4.85);
        expectedVector.set(0.0, 1.0, 1.0);
        expectedVector.normalize();
        this.inclinedTopFaceOctagon3dSecond.checkIfInside(0.0, -1.8, 4.9, (Point3DBasics)pointToPack, (Vector3DBasics)normalToPack);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedPoint, (EuclidGeometry)pointToPack, (double)this.epsilon);
        EuclidCoreTestTools.assertEquals((EuclidGeometry)expectedVector, (EuclidGeometry)normalToPack, (double)this.epsilon);
    }

    @Test
    public void testGetXMin() {
        Assert.assertEquals((double)-2.0, (double)this.flatTopFaceOctagon3d.getBoundingBox().getMinX(), (double)this.epsilon);
    }

    @Test
    public void testGetXMax() {
        Assert.assertEquals((double)2.0, (double)this.flatTopFaceOctagon3d.getBoundingBox().getMaxX(), (double)this.epsilon);
    }

    @Test
    public void testGetYMin() {
        Assert.assertEquals((double)-2.0, (double)this.flatTopFaceOctagon3d.getBoundingBox().getMinY(), (double)this.epsilon);
    }

    @Test
    public void testGetYMax() {
        Assert.assertEquals((double)2.0, (double)this.flatTopFaceOctagon3d.getBoundingBox().getMaxY(), (double)this.epsilon);
    }

    public void testSetupInEnvironment() {
        SimulationConstructionSet scs = new SimulationConstructionSet();
        scs.addStaticLinkGraphics(this.inclinedTopFaceOctagon3d.getLinkGraphics());
        scs.setGroundVisible(false);
        scs.startOnAThread();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }
}

