/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import java.util.ArrayList;
import us.ihmc.simulationConstructionSetTools.simulationTesting.SimulationComparer;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;

public abstract class SimulationTester {
    protected static final int NUMBER_OF_SIMULATIONS = 2;
    private static final boolean DESTROY_SIMULATIONS_WHEN_DONE = true;
    protected final SimulationComparer simulationComparer;

    protected abstract ArrayList<SimulationConstructionSet> createAndStartSimulations();

    public SimulationTester(SimulationComparer simulationComparer) {
        this.simulationComparer = simulationComparer;
    }

    public boolean test(double simulationTime) {
        ArrayList<SimulationConstructionSet> simulationConstructionSets = this.createAndStartSimulations();
        this.simulate(simulationConstructionSets, simulationTime);
        this.waitForSimulationsToFinish(simulationConstructionSets);
        try {
            Thread.sleep(4000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (!this.didSimulationsGetToEndTime(simulationTime, simulationConstructionSets)) {
            System.err.println("Simlulation didn't get to end time!");
            return false;
        }
        boolean ret = this.simulationComparer.compare(simulationConstructionSets.get(0), simulationConstructionSets.get(1));
        for (SimulationConstructionSet scs : simulationConstructionSets) {
            scs.closeAndDispose();
        }
        return ret;
    }

    private boolean didSimulationsGetToEndTime(double simulationTime, ArrayList<SimulationConstructionSet> simulationConstructionSets) {
        double endTime0 = simulationConstructionSets.get(0).getRobots()[0].getTime();
        double endTime1 = simulationConstructionSets.get(0).getRobots()[0].getTime();
        double errorTime0 = Math.abs(simulationTime - endTime0);
        double errorTime1 = Math.abs(simulationTime - endTime1);
        if (errorTime0 > 0.001) {
            return false;
        }
        return !(errorTime1 > 0.001);
    }

    public double findTimeOfFirstDifference(double maxSimulationTime) {
        ArrayList<SimulationConstructionSet> simulationConstructionSets = this.createAndStartSimulations();
        boolean differenceFound = false;
        Robot robotToUseForTime = simulationConstructionSets.get(0).getRobots()[0];
        double time = robotToUseForTime.getTime();
        while (!differenceFound && time < maxSimulationTime) {
            for (SimulationConstructionSet scs : simulationConstructionSets) {
                try {
                    scs.simulateOneTimeStep();
                }
                catch (UnreasonableAccelerationException e) {
                    e.printStackTrace();
                }
            }
            differenceFound = !this.simulationComparer.compare(simulationConstructionSets.get(0), simulationConstructionSets.get(1));
            time = robotToUseForTime.getTime();
        }
        double ret = differenceFound ? time : Double.NaN;
        for (SimulationConstructionSet scs : simulationConstructionSets) {
            scs.closeAndDispose();
        }
        return ret;
    }

    private void simulate(ArrayList<SimulationConstructionSet> simulationConstructionSets, double simulationTime) {
        for (SimulationConstructionSet scs : simulationConstructionSets) {
            scs.simulate(simulationTime);
        }
    }

    private void waitForSimulationsToFinish(ArrayList<SimulationConstructionSet> simulationConstructionSets) {
        boolean allDone = false;
        while (!allDone) {
            allDone = true;
            for (SimulationConstructionSet scs : simulationConstructionSets) {
                if (!scs.isSimulating()) continue;
                allDone = false;
            }
        }
    }
}

