/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationConstructionSetTools.simulationTesting;

import java.lang.reflect.Field;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import us.ihmc.robotics.Assert;
import us.ihmc.robotics.math.filters.AlphaFilteredYoVariable;
import us.ihmc.simulationConstructionSetTools.simulationTesting.SimulationComparer;
import us.ihmc.simulationConstructionSetTools.simulationTesting.SimulationComparisonScript;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.tools.reflect.RecursiveObjectComparer;
import us.ihmc.tools.reflect.StringFieldMatcher;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.listener.YoRegistryChangedListener;
import us.ihmc.yoVariables.registry.YoVariableList;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoInteger;
import us.ihmc.yoVariables.variable.YoVariable;

public class ReflectionSimulationComparer
implements SimulationComparer {
    private RecursiveObjectComparer comparer;

    public ReflectionSimulationComparer(int maxDepth, int maxSize) {
        this.comparer = new RecursiveObjectComparer(maxDepth, maxSize);
    }

    @Override
    public boolean compare(SimulationConstructionSet scs0, SimulationConstructionSet scs1) {
        try {
            return this.comparer.compare((Object)scs0, (Object)scs1);
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return false;
    }

    public void addFieldToIgnore(Field fieldToIgnore) {
        this.comparer.addFieldToIgnore(fieldToIgnore);
    }

    public void addFieldsToIgnore(Collection<Field> fieldsToIgnore) {
        this.comparer.addFieldsToIgnore(fieldsToIgnore);
    }

    public void addClassToIgnore(Class<?> classToIgnore) {
        this.comparer.addClassToIgnore(classToIgnore);
    }

    public void addClassesToIgnore(Collection<Class<?>> classesToIgnore) {
        this.comparer.addClassesToIgnore(classesToIgnore);
    }

    public void addStringFieldsToIgnore(StringFieldMatcher stringFieldMatcherToIgnore) {
        this.comparer.addStringFieldsToIgnore(stringFieldMatcherToIgnore);
    }

    public Collection<Field> getDifferingFields() {
        return this.comparer.getDifferingFields();
    }

    public String toString() {
        return this.comparer.toString();
    }

    public static void compareTwoSimulations(SimulationConstructionSet scs0, SimulationConstructionSet scs1, SimulationComparisonScript script, boolean expectedResult, boolean closeAndDispose) throws IllegalArgumentException, IllegalAccessException, SecurityException, NoSuchFieldException, UnreasonableAccelerationException {
        int maxDepth = Integer.MAX_VALUE;
        int maxSize = Integer.MAX_VALUE;
        script.doInitialAction(scs0, scs1);
        ReflectionSimulationComparer preRewindComparer = new ReflectionSimulationComparer(maxDepth, maxSize);
        ReflectionSimulationComparer.addStandardStuffToIgnore(preRewindComparer);
        System.out.println("Comparing to find fields to ignore...");
        Collection<Field> preRewindFieldDifferences = ReflectionSimulationComparer.compareToFindFieldsToIgnore(scs0, scs1, preRewindComparer);
        preRewindComparer = null;
        System.out.println("Pre rewind field differences:\n" + preRewindFieldDifferences);
        System.out.println("Pre-rewind compare done");
        script.doFinalAction(scs0, scs1);
        Assert.assertEquals((String)"Indices are not equal after final action. Most likely that you overran the data buffer. Check the data buffer size!", (long)scs0.getCurrentIndex(), (long)scs1.getCurrentIndex());
        ArrayList<Field> fieldsToIgnore = new ArrayList<Field>();
        ArrayList<String> fieldNamesToNeverIgnore = new ArrayList<String>();
        fieldNamesToNeverIgnore.add("private int us.ihmc.simulationconstructionset.YoInteger.val");
        fieldNamesToNeverIgnore.add("private double us.ihmc.simulationconstructionset.YoDouble.val");
        fieldNamesToNeverIgnore.add("private boolean us.ihmc.simulationconstructionset.YoBoolean.val");
        for (Field field : preRewindFieldDifferences) {
            String fieldName = field.toString();
            if (!fieldNamesToNeverIgnore.contains(fieldName)) {
                fieldsToIgnore.add(field);
                continue;
            }
            System.err.println("There was a field to never ignore in the preRewind comparison! Field = " + field);
        }
        System.out.println("Fields to ignore:\n" + fieldsToIgnore);
        ReflectionSimulationComparer postRewindComparer = new ReflectionSimulationComparer(maxDepth, maxSize);
        ReflectionSimulationComparer.addStandardStuffToIgnore(postRewindComparer);
        postRewindComparer.addFieldsToIgnore(fieldsToIgnore);
        System.out.println("Comparing...");
        boolean result = postRewindComparer.compare(scs0, scs1);
        String comparerToString = postRewindComparer.toString();
        System.out.println("Post-rewind compare done");
        preRewindComparer = null;
        postRewindComparer = null;
        scs0.closeAndDispose();
        scs1.closeAndDispose();
        if (!result) {
            System.err.println(comparerToString);
        }
        Assert.assertEquals((String)comparerToString, (Object)expectedResult, (Object)result);
    }

    private static void addStandardStuffToIgnore(ReflectionSimulationComparer comparer) {
        comparer.addClassToIgnore(YoBuffer.class);
        comparer.addClassToIgnore(YoVariableList.class);
        comparer.addClassToIgnore(YoRegistryChangedListener.class);
        try {
            StringFieldMatcher stringFieldMatcherToIgnore = new StringFieldMatcher();
            stringFieldMatcherToIgnore.addStringFieldToMatchRegularExpression(YoInteger.class, YoVariable.class.getDeclaredField("name"), ".*StartTimeNano");
            stringFieldMatcherToIgnore.addStringFieldToMatchRegularExpression(YoInteger.class, YoVariable.class.getDeclaredField("name"), ".*StopTimeNano");
            stringFieldMatcherToIgnore.addStringFieldToMatchRegularExpression(YoDouble.class, YoVariable.class.getDeclaredField("name"), ".*DurationMilli");
            stringFieldMatcherToIgnore.addStringFieldToMatchRegularExpression(AlphaFilteredYoVariable.class, YoVariable.class.getDeclaredField("name"), ".*DurationMilli");
            comparer.addStringFieldsToIgnore(stringFieldMatcherToIgnore);
            comparer.addFieldToIgnore(AbstractList.class.getDeclaredField("modCount"));
            comparer.addFieldToIgnore(YoVariable.class.getDeclaredField("stackTraceAtInitialization"));
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
    }

    private static Collection<Field> compareToFindFieldsToIgnore(SimulationConstructionSet scs0, SimulationConstructionSet scs1, ReflectionSimulationComparer comparer) {
        comparer.compare(scs0, scs1);
        return new LinkedHashSet<Field>(comparer.getDifferingFields());
    }
}

