/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.util.ground.AlternatingSlopesGroundProfile;
import us.ihmc.simulationconstructionset.util.ground.GroundProfileTest;

public class AlternatingSlopesGroundProfileTest
extends GroundProfileTest {
    private static final double epsilon = 1.0E-7;

    @Override
    public GroundProfile3D getGroundProfile() {
        double[][] xSlopePairs = new double[][]{{-5.0, 1.0}, {0.0, -1.0}, {5.0, 1.0}};
        AlternatingSlopesGroundProfile groundProfile = new AlternatingSlopesGroundProfile((double[][])xSlopePairs);
        return groundProfile;
    }

    @Override
    public double getMaxPercentageOfAllowableValleyPoints() {
        return 0.05;
    }

    @Override
    public double getMaxPercentageOfAllowablePeakPoints() {
        return 0.05;
    }

    @Override
    public double getMaxPercentageOfAllowableDropOffs() {
        return 0.0;
    }

    @Override
    @Test
    public void testSurfaceNormalGridForSmoothTerrainUsingHeightMap() {
        super.testSurfaceNormalGridForSmoothTerrainUsingHeightMap();
    }

    @Test
    public void testAllFlat() {
        double[][] xSlopePairs = new double[][]{{0.0, 0.0}};
        AlternatingSlopesGroundProfile profile = new AlternatingSlopesGroundProfile((double[][])xSlopePairs);
        double height = profile.heightAt(-100.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(0.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(1000.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
    }

    @Test
    public void testOne() {
        double[][] xSlopePairs = new double[][]{{1.0, 1.0}};
        AlternatingSlopesGroundProfile profile = new AlternatingSlopesGroundProfile((double[][])xSlopePairs);
        double[][] xzPairs = profile.getXZPairs();
        Assert.assertEquals(xzPairs.length, 3L);
        Assert.assertEquals(-10.0, xzPairs[0][0], 1.0E-7);
        Assert.assertEquals(0.0, xzPairs[0][1], 1.0E-7);
        Assert.assertEquals(1.0, xzPairs[1][0], 1.0E-7);
        Assert.assertEquals(0.0, xzPairs[1][1], 1.0E-7);
        Assert.assertEquals(10.0, xzPairs[2][0], 1.0E-7);
        Assert.assertEquals(9.0, xzPairs[2][1], 1.0E-7);
        double height = profile.heightAt(0.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(1.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(1.5, 0.0, 0.0);
        Assert.assertEquals(0.5, height, 1.0E-7);
        height = profile.heightAt(10.0, 0.0, 0.0);
        Assert.assertEquals(9.0, height, 1.0E-7);
        height = profile.heightAt(100.0, 0.0, 0.0);
        Assert.assertEquals(9.0, height, 1.0E-7);
        height = profile.heightAt(-100.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
    }

    @Test
    public void testTwo() {
        double[][] xSlopePairs = new double[][]{{0.0, 0.0}, {1.0, 1.0}, {2.0, 0.0}};
        AlternatingSlopesGroundProfile profile = new AlternatingSlopesGroundProfile((double[][])xSlopePairs);
        double height = profile.heightAt(0.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(1.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(1.5, 0.0, 0.0);
        Assert.assertEquals(0.5, height, 1.0E-7);
        height = profile.heightAt(2.0, 0.0, 0.0);
        Assert.assertEquals(1.0, height, 1.0E-7);
        height = profile.heightAt(3.0, 0.0, 0.0);
        Assert.assertEquals(1.0, height, 1.0E-7);
    }

    @Test
    public void testThree() {
        double[][] xSlopePairs = new double[][]{{-5.0, 1.0}, {0.0, -1.0}, {5.0, 1.0}};
        AlternatingSlopesGroundProfile profile = new AlternatingSlopesGroundProfile((double[][])xSlopePairs);
        double height = profile.heightAt(-6.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(-5.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(-4.0, 0.0, 0.0);
        Assert.assertEquals(1.0, height, 1.0E-7);
        height = profile.heightAt(0.0, 0.0, 0.0);
        Assert.assertEquals(5.0, height, 1.0E-7);
        height = profile.heightAt(1.0, 0.0, 0.0);
        Assert.assertEquals(4.0, height, 1.0E-7);
        height = profile.heightAt(5.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(6.0, 0.0, 0.0);
        Assert.assertEquals(1.0, height, 1.0E-7);
    }

    @Test
    public void testFour() {
        double xMin = -100.0;
        double xMax = 100.0;
        double yMin = -100.0;
        double yMax = 100.0;
        double[][] xSlopePairs = new double[][]{{-5.0, 1.0}, {0.0, -1.0}, {5.0, 1.0}};
        AlternatingSlopesGroundProfile profile = new AlternatingSlopesGroundProfile((double[][])xSlopePairs, xMin, xMax, yMin, yMax);
        double height = profile.heightAt(-6.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(-5.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(-4.0, 0.0, 0.0);
        Assert.assertEquals(1.0, height, 1.0E-7);
        height = profile.heightAt(0.0, 0.0, 0.0);
        Assert.assertEquals(5.0, height, 1.0E-7);
        height = profile.heightAt(1.0, 0.0, 0.0);
        Assert.assertEquals(4.0, height, 1.0E-7);
        height = profile.heightAt(5.0, 0.0, 0.0);
        Assert.assertEquals(0.0, height, 1.0E-7);
        height = profile.heightAt(6.0, 0.0, 0.0);
        Assert.assertEquals(1.0, height, 1.0E-7);
    }

    @Test
    public void testBadOrderingOne() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double[][] xSlopePairs = new double[][]{{0.0, -1.0}, {1.0E-10, 1.0}};
            new AlternatingSlopesGroundProfile((double[][])xSlopePairs);
        });
    }

    @Test
    public void testBadOrderingTwo() {
        Assertions.assertThrows(RuntimeException.class, () -> {
            double[][] xSlopePairs = new double[][]{{0.0, -1.0}, {1.0, 1.0}, {3.5, 1.0}, {3.0, 1.0}, {4.0, 1.0}};
            new AlternatingSlopesGroundProfile((double[][])xSlopePairs);
        });
    }
}

