/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.dataBuffer;

import java.util.List;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.dataBuffer.DataBufferTools;
import us.ihmc.simulationconstructionset.gui.config.VarGroup;
import us.ihmc.simulationconstructionset.gui.config.VarGroupList;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;
import us.ihmc.yoVariables.variable.YoVariable;

public class DataBufferToolsTest {
    private final int testBufferSize = 100;
    private YoRegistry registry;
    private YoBuffer dataBuffer = new YoBuffer(100);
    private YoDouble a;
    private YoDouble b;
    private YoDouble c;
    private YoBufferVariableEntry aBuffer;
    private YoBufferVariableEntry bBuffer;
    private YoBufferVariableEntry cBuffer;

    @BeforeEach
    public void setUp() {
        this.registry = new YoRegistry("testRegistry");
        this.a = new YoDouble("a_arm", this.registry);
        this.b = new YoDouble("b_arm", this.registry);
        this.c = new YoDouble("c_arm", this.registry);
        this.aBuffer = new YoBufferVariableEntry((YoVariable)this.a, 100);
        this.bBuffer = new YoBufferVariableEntry((YoVariable)this.b, 100);
        this.cBuffer = new YoBufferVariableEntry((YoVariable)this.c, 100);
    }

    @Test
    public void testGetVarsFromGroup() {
        this.dataBuffer.addEntry(this.aBuffer);
        this.dataBuffer.addEntry(this.bBuffer);
        this.dataBuffer.addEntry(this.cBuffer);
        VarGroup varGroupOne = new VarGroup("varGroupOne");
        VarGroup varGroupTwo = new VarGroup("varGroupTwo");
        VarGroup varGroupThree = new VarGroup("varGroupThree");
        varGroupOne.addVar("a_arm");
        varGroupOne.addVar("c_arm");
        String[] allRegularExpressions = new String[]{".*"};
        String[] cRegularExpressions = new String[]{"c.*"};
        varGroupTwo.addRegularExpressions(allRegularExpressions);
        varGroupThree.addRegularExpressions(cRegularExpressions);
        VarGroupList varGroupList = new VarGroupList();
        varGroupList.addVarGroup(varGroupOne);
        varGroupList.addVarGroup(varGroupTwo);
        varGroupList.addVarGroup(varGroupThree);
        List allVarsFromGroup = DataBufferTools.getVarsFromGroup((YoBuffer)this.dataBuffer, (String)"all", (VarGroupList)varGroupList);
        Assert.assertTrue(allVarsFromGroup.contains(this.a));
        Assert.assertTrue(allVarsFromGroup.contains(this.b));
        Assert.assertTrue(allVarsFromGroup.contains(this.c));
        List aVarsFromGroup = DataBufferTools.getVarsFromGroup((YoBuffer)this.dataBuffer, (String)"varGroupOne", (VarGroupList)varGroupList);
        Assert.assertTrue(aVarsFromGroup.contains(this.a));
        Assert.assertFalse(aVarsFromGroup.contains(this.b));
        Assert.assertTrue(aVarsFromGroup.contains(this.c));
        List regExpVarsFromGroup = DataBufferTools.getVarsFromGroup((YoBuffer)this.dataBuffer, (String)"varGroupTwo", (VarGroupList)varGroupList);
        Assert.assertTrue(regExpVarsFromGroup.contains(this.a));
        Assert.assertTrue(regExpVarsFromGroup.contains(this.b));
        Assert.assertTrue(regExpVarsFromGroup.contains(this.c));
        List cRegExpVarsFromGroup = DataBufferTools.getVarsFromGroup((YoBuffer)this.dataBuffer, (String)"varGroupThree", (VarGroupList)varGroupList);
        Assert.assertFalse(cRegExpVarsFromGroup.contains(this.a));
        Assert.assertFalse(cRegExpVarsFromGroup.contains(this.b));
        Assert.assertTrue(cRegExpVarsFromGroup.contains(this.c));
    }
}

