/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.featherstone;

import org.ejml.data.DMatrix1Row;
import org.ejml.data.DMatrixD1;
import org.ejml.data.DMatrixRMaj;
import org.ejml.dense.row.CommonOps_DDRM;
import us.ihmc.commons.MathTools;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.PinJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SliderJoint;
import us.ihmc.simulationconstructionset.physics.featherstone.RobotWithClosedFormDynamics;

public class CartPoleRobot
extends RobotWithClosedFormDynamics {
    private final double cartMass = 0.8;
    private final double poleMass = 1.2;
    private final double poleLength = 0.6;
    private final double cartDamping = 0.1;
    private final double poleDamping = 0.2;
    private final SliderJoint sliderJoint;
    private final PinJoint pinJoint;
    private final DMatrixRMaj H = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj C = new DMatrixRMaj(2, 2);
    private final DMatrixRMaj G = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj qd = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj qdd = new DMatrixRMaj(2, 1);
    private final DMatrixRMaj rightHandSide = new DMatrixRMaj(2, 1);

    public CartPoleRobot(String name, double initialCartVelocity, double initialPoleAngle, double initialPoleAngularVelocity) {
        super(name);
        this.sliderJoint = new SliderJoint(name + "CartJoint", (Tuple3DReadOnly)new Vector3D(), (Robot)this, (Vector3DReadOnly)Axis3D.X);
        this.sliderJoint.setDamping(0.1);
        Link cartLink = new Link(name + "CartLink");
        cartLink.setMass(0.8);
        this.sliderJoint.setLink(cartLink);
        this.pinJoint = new PinJoint(name + "PoleJoint", (Tuple3DReadOnly)new Vector3D(), (Robot)this, (Vector3DReadOnly)Axis3D.Y);
        this.pinJoint.setDamping(0.2);
        Link poleLink = new Link(name + "PoleLink");
        poleLink.setMass(1.2);
        poleLink.setComOffset(0.0, 0.0, -0.6);
        this.pinJoint.setLink(poleLink);
        this.sliderJoint.setQd(initialCartVelocity);
        this.pinJoint.setQ(initialPoleAngle);
        this.pinJoint.setQd(initialPoleAngularVelocity);
        this.sliderJoint.addJoint((Joint)this.pinJoint);
        this.addRootJoint((Joint)this.sliderJoint);
    }

    @Override
    public void assertStateIsCloseToClosedFormCalculation(double epsilon) {
        double H01;
        double xd = this.sliderJoint.getQD();
        double xdd = this.sliderJoint.getQDD();
        double theta = this.pinJoint.getQ();
        double thetaD = this.pinJoint.getQD();
        double thetaDD = this.pinJoint.getQDD();
        double g = Math.abs(this.gravityZ.getDoubleValue());
        double H00 = 2.0;
        double H10 = H01 = 0.72 * Math.cos(theta);
        double H11 = 1.2 * MathTools.square((double)0.6);
        double C00 = 0.0;
        double C01 = -0.72 * thetaD * Math.sin(theta);
        double C10 = 0.0;
        double C11 = 0.0;
        double G00 = 0.0;
        double G10 = 1.2 * g * 0.6 * Math.sin(theta);
        double cartForce = -0.1 * xd;
        double poleTorque = -0.2 * thetaD;
        this.H.set(0, 0, H00);
        this.H.set(0, 1, H01);
        this.H.set(1, 0, H10);
        this.H.set(1, 1, H11);
        this.C.set(0, 0, C00);
        this.C.set(0, 1, C01);
        this.C.set(1, 0, C10);
        this.C.set(1, 1, C11);
        this.G.set(0, 0, G00);
        this.G.set(1, 0, G10);
        this.rightHandSide.set(0, 0, -cartForce);
        this.rightHandSide.set(1, 0, -poleTorque);
        this.qd.set(0, 0, xd);
        this.qd.set(1, 0, thetaD);
        this.qdd.set(0, 0, xdd);
        this.qdd.set(1, 0, thetaDD);
        CommonOps_DDRM.add((DMatrixD1)this.rightHandSide, (DMatrixD1)this.G, (DMatrixD1)this.rightHandSide);
        CommonOps_DDRM.multAdd((DMatrix1Row)this.C, (DMatrix1Row)this.qd, (DMatrix1Row)this.rightHandSide);
        CommonOps_DDRM.scale((double)-1.0, (DMatrixD1)this.rightHandSide);
        CommonOps_DDRM.solve((DMatrixRMaj)this.H, (DMatrixRMaj)this.rightHandSide, (DMatrixRMaj)this.qdd);
        double xddLagrangian = -this.qdd.get(0, 0);
        double thetaDDLagrangian = this.qdd.get(1, 0);
        if (Math.abs(xdd - xddLagrangian) > epsilon || Math.abs(thetaDD - thetaDDLagrangian) > epsilon) {
            throw new AssertionError((Object)("Joint accelerations from simulation and lagrangian don't match. \nAt t=" + this.getTime() + "\nSimulated joint accelerations: (" + xdd + ", " + thetaDD + ")\nLagrangian accelerations: (" + xddLagrangian + ", " + thetaDDLagrangian + ")"));
        }
    }
}

