/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.ground;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.util.ground.CylinderTerrainObject;

public class CylinderTerrainObjectTest {
    private static final double errEpsilon = 1.0E-14;
    private static final double testDelta = 1.0E-4;

    @Test
    public void testSimpleCylinder() {
        double height = 1.3;
        double radius = 0.2;
        RigidBodyTransform location = new RigidBodyTransform();
        location.getTranslation().set((Tuple3DReadOnly)new Vector3D(0.0, 0.0, height / 2.0));
        CylinderTerrainObject cylinderTerrainObject = new CylinderTerrainObject(location, height, radius, YoAppearance.Red());
        Vector3D surfaceNormal = new Vector3D();
        double heightAt = cylinderTerrainObject.heightAndNormalAt(0.0, 0.0, 0.0, (Vector3DBasics)surfaceNormal);
        Assert.assertEquals(height, heightAt, 1.0E-7);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (Tuple3DReadOnly)surfaceNormal, (double)1.0E-7);
        heightAt = cylinderTerrainObject.heightAndNormalAt(0.0, radius - 1.0E-7, 0.0, (Vector3DBasics)surfaceNormal);
        Assert.assertEquals(height, heightAt, 1.0E-7);
        heightAt = cylinderTerrainObject.heightAndNormalAt(0.0, radius + 1.0E-7, 0.0, (Vector3DBasics)surfaceNormal);
        Assert.assertEquals(0.0, heightAt, 1.0E-7);
        heightAt = cylinderTerrainObject.heightAndNormalAt(radius + 1.0E-7, 0.0, 0.0, (Vector3DBasics)surfaceNormal);
        Assert.assertEquals(0.0, heightAt, 1.0E-7);
        Point3D intersection = new Point3D();
        boolean isInside = cylinderTerrainObject.checkIfInside(0.0, 0.0, height - 0.01, (Point3DBasics)intersection, (Vector3DBasics)surfaceNormal);
        Assert.assertTrue(isInside);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(0.0, 0.0, 1.0), (Tuple3DReadOnly)surfaceNormal, (double)1.0E-7);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Vector3D(0.0, 0.0, height), (Tuple3DReadOnly)intersection, (double)1.0E-7);
    }

    @Test
    public void testHeightAtTranslatedRot90TallHorizontalCylinderJustInsideAndOutside() {
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        Vector3D translatedCenter = new Vector3D(5.0, 3.0, 1.5);
        AppearanceDefinition app = YoAppearance.Red();
        slopeDegrees = 90.0;
        yawDegrees = 90.0;
        double tallHeight = 2.0 * height;
        CylinderTerrainObject translatedRot90TallHorizontalCylinder = new CylinderTerrainObject((Vector3DReadOnly)translatedCenter, slopeDegrees, yawDegrees, tallHeight, radius, app);
        double expectedHeight = radius + translatedCenter.getZ();
        double expectedMiss = 0.0;
        double[] signY = new double[]{0.0, -1.0, 1.0};
        boolean[] isEdge = new boolean[]{false, true, true};
        for (int i = 0; i < signY.length; ++i) {
            double testX = 0.0 + translatedCenter.getX();
            double testY = signY[i] * (tallHeight / 2.0 - 1.0E-4) + translatedCenter.getY();
            double testZ = expectedHeight + 1.0;
            Assert.assertEquals(expectedHeight, translatedRot90TallHorizontalCylinder.heightAt(testX, testY, testZ), 1.0E-14);
            if (!isEdge[i]) continue;
            testY = signY[i] * (tallHeight / 2.0 + 1.0E-4) + translatedCenter.getY();
            Assert.assertEquals(expectedMiss, translatedRot90TallHorizontalCylinder.heightAt(testX, testY, testZ), 1.0E-14);
        }
    }

    @Test
    public void testHeightAtRot90TallHorizontalCylinderJustInsideAndOutside() {
        Vector3D center = new Vector3D(0.0, 0.0, 0.0);
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        AppearanceDefinition app = YoAppearance.Red();
        slopeDegrees = 90.0;
        yawDegrees = 90.0;
        double tallHeight = 2.0 * height;
        CylinderTerrainObject rot90TallHorizontalCylinder = new CylinderTerrainObject((Vector3DReadOnly)center, slopeDegrees, yawDegrees, tallHeight, radius, app);
        double expectedHeight = radius;
        double expectedMiss = 0.0;
        double[] signY = new double[]{0.0, -1.0, 1.0};
        boolean[] isEdge = new boolean[]{false, true, true};
        for (int i = 0; i < signY.length; ++i) {
            double testX = 0.0;
            double testY = signY[i] * (tallHeight / 2.0 - 1.0E-4);
            double testZ = expectedHeight + 1.0;
            Assert.assertEquals(expectedHeight, rot90TallHorizontalCylinder.heightAt(testX, testY, testZ), 1.0E-14);
            if (!isEdge[i]) continue;
            testY = signY[i] * (tallHeight / 2.0 + 1.0E-4);
            Assert.assertEquals(expectedMiss, rot90TallHorizontalCylinder.heightAt(testX, testY, testZ), 1.0E-14);
        }
    }

    @Test
    public void testHeightAtTranslatedVerticalCylinderJustInside() {
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        Vector3D translatedCenter = new Vector3D(5.0, 3.0, 1.5);
        AppearanceDefinition app = YoAppearance.Red();
        CylinderTerrainObject translatedVerticalCylinder = new CylinderTerrainObject((Vector3DReadOnly)translatedCenter, slopeDegrees, yawDegrees, height, radius, app);
        double expectedHeight = translatedCenter.getZ() + height / 2.0;
        double[] signX = new double[]{-1.0, 0.0, 1.0, 0.0};
        double[] signY = new double[]{0.0, -1.0, 0.0, 1.0};
        for (int i = 0; i < signX.length; ++i) {
            double testX = signX[i] * (radius - 1.0E-4) + translatedCenter.getX();
            double testY = signY[i] * (radius - 1.0E-4) + translatedCenter.getY();
            double testZ = expectedHeight + 1.0;
            Assert.assertEquals(expectedHeight, translatedVerticalCylinder.heightAt(testX, testY, testZ), 1.0E-14);
        }
    }

    @Test
    public void testHeightAtTranslatedHorizontalCylinderJustInside() {
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        Vector3D translatedCenter = new Vector3D(5.0, 3.0, 1.5);
        AppearanceDefinition app = YoAppearance.Red();
        slopeDegrees = 90.0;
        CylinderTerrainObject translatedHorizontalCylinder = new CylinderTerrainObject((Vector3DReadOnly)translatedCenter, slopeDegrees, yawDegrees, height, radius, app);
        double expectedHeight = translatedCenter.getZ() + radius;
        double[] signX = new double[]{-1.0, 0.0, 1.0};
        for (int i = 0; i < signX.length; ++i) {
            double testX = signX[i] * (height / 2.0 - 1.0E-4) + translatedCenter.getX();
            double testY = translatedCenter.getY();
            double testZ = expectedHeight + 1.0;
            Assert.assertEquals(expectedHeight, translatedHorizontalCylinder.heightAt(testX, testY, testZ), 1.0E-14);
        }
    }

    @Test
    public void testHeightAtTranslatedVerticalCylinderJustOutside() {
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        Vector3D translatedCenter = new Vector3D(5.0, 3.0, 1.5);
        AppearanceDefinition app = YoAppearance.Red();
        CylinderTerrainObject translatedVerticalCylinder = new CylinderTerrainObject((Vector3DReadOnly)translatedCenter, slopeDegrees, yawDegrees, height, radius, app);
        double expectedHeight = 0.0;
        double[] signX = new double[]{-1.0, 0.0, 1.0, 0.0};
        double[] signY = new double[]{0.0, -1.0, 0.0, 1.0};
        for (int i = 0; i < signX.length; ++i) {
            double testX = signX[i] * (radius + 1.0E-4) + translatedCenter.getX();
            double testY = signY[i] * (radius + 1.0E-4) + translatedCenter.getY();
            double testZ = expectedHeight + 1.0;
            Assert.assertEquals(expectedHeight, translatedVerticalCylinder.heightAt(testX, testY, testZ), 1.0E-14);
        }
    }

    @Test
    public void testHeightAtTranslatedHorizontalCylinderJustOutside() {
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        Vector3D translatedCenter = new Vector3D(5.0, 3.0, 1.5);
        AppearanceDefinition app = YoAppearance.Red();
        slopeDegrees = 90.0;
        CylinderTerrainObject translatedHorizontalCylinder = new CylinderTerrainObject((Vector3DReadOnly)translatedCenter, slopeDegrees, yawDegrees, height, radius, app);
        double expectedHeight = 0.0;
        double[] signX = new double[]{-1.0, 1.0};
        for (int i = 0; i < signX.length; ++i) {
            double testX = signX[i] * (height / 2.0 + 1.0E-4) + translatedCenter.getX();
            double testY = translatedCenter.getY();
            double testZ = expectedHeight + 1.0;
            Assert.assertEquals(expectedHeight, translatedHorizontalCylinder.heightAt(testX, testY, testZ), 1.0E-14);
        }
    }

    @Test
    public void testHeightAtVerticalCylinderOutside() {
        Vector3D center = new Vector3D(0.0, 0.0, 0.0);
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        AppearanceDefinition app = YoAppearance.Red();
        CylinderTerrainObject verticalCylinder = new CylinderTerrainObject((Vector3DReadOnly)center, slopeDegrees, yawDegrees, height, radius, app);
        slopeDegrees = 90.0;
        CylinderTerrainObject horizontalCylinder = new CylinderTerrainObject((Vector3DReadOnly)center, slopeDegrees, yawDegrees, height, radius, app);
        Assert.assertEquals(0.0, verticalCylinder.heightAt(height / 2.0 * 1.5, 0.0, 0.0), 1.0E-14);
        Assert.assertEquals(0.0, verticalCylinder.heightAt(-height / 2.0 * 1.5, 0.0, 0.0), 1.0E-14);
        Assert.assertEquals(0.0, verticalCylinder.heightAt(0.0, -height / 2.0 * 1.5, 0.0), 1.0E-14);
        Assert.assertEquals(0.0, verticalCylinder.heightAt(0.0, height / 2.0 * 1.5, 0.0), 1.0E-14);
        Assert.assertEquals(0.0, horizontalCylinder.heightAt(height / 2.0 * 1.5, 0.0, 0.0), 1.0E-14);
        Assert.assertEquals(0.0, horizontalCylinder.heightAt(-height / 2.0 * 1.5, 0.0, 0.0), 1.0E-14);
        Assert.assertEquals(0.0, horizontalCylinder.heightAt(0.0, radius * 1.5, 0.0), 1.0E-14);
        Assert.assertEquals(0.0, horizontalCylinder.heightAt(0.0, -radius * 1.5, 0.0), 1.0E-14);
        Assert.assertEquals(height / 2.0, verticalCylinder.heightAt(0.0, 0.0, height / 2.0), 1.0E-14);
        Assert.assertEquals(-height / 2.0, verticalCylinder.heightAt(0.0, 0.0, -height / 2.0), 1.0E-14);
        Assert.assertEquals(height / 2.0, verticalCylinder.heightAt(radius / 2.0, 0.0, height / 2.0), 1.0E-14);
        Assert.assertEquals(height / 2.0, verticalCylinder.heightAt(-radius / 2.0, 0.0, height / 2.0), 1.0E-14);
        Assert.assertEquals(height / 2.0, verticalCylinder.heightAt(0.0, radius / 2.0, height / 2.0), 1.0E-14);
        Assert.assertEquals(height / 2.0, verticalCylinder.heightAt(0.0, -radius / 2.0, height / 2.0), 1.0E-14);
        Assert.assertEquals(radius, verticalCylinder.heightAt(0.0, 0.0, radius), 1.0E-14);
        Assert.assertEquals(-radius, verticalCylinder.heightAt(0.0, 0.0, -radius), 1.0E-14);
        Assert.assertEquals(radius, verticalCylinder.heightAt(height / 4.0, 0.0, radius), 1.0E-14);
        Assert.assertEquals(radius, verticalCylinder.heightAt(-height / 4.0, 0.0, radius), 1.0E-14);
        double expectedHeightOnCircle = Math.sqrt(radius * radius - radius / 2.0 * (radius / 2.0));
        Assert.assertEquals(expectedHeightOnCircle, horizontalCylinder.heightAt(height / 4.0, radius / 2.0, radius), 1.0E-14);
    }

    @Test
    public void testHeightAtSlopedRotatedTwoSidesTop() {
        Vector3D center = new Vector3D(0.0, 0.0, 0.0);
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        AppearanceDefinition app = YoAppearance.Red();
        slopeDegrees = 45.0;
        yawDegrees = 30.0;
        double angleAxisDownRadians = Math.toRadians(slopeDegrees);
        double angleAxisFromXRadians = Math.toRadians(yawDegrees);
        CylinderTerrainObject slopedRotatedCylinder = new CylinderTerrainObject((Vector3DReadOnly)center, slopeDegrees, yawDegrees, height, radius, app);
        double distanceAlongAxis = height / 2.0;
        double dCenterToContact = Math.sqrt(distanceAlongAxis * distanceAlongAxis + radius * radius);
        double angleFromAxisToD = Math.atan(radius / distanceAlongAxis);
        double dHorizontal = dCenterToContact * Math.cos(angleAxisDownRadians + angleFromAxisToD);
        double dVertical = dCenterToContact * Math.sin(angleAxisDownRadians + angleFromAxisToD);
        double x = dHorizontal * Math.cos(angleAxisFromXRadians);
        double y = dHorizontal * Math.sin(angleAxisFromXRadians);
        double z = dVertical;
        Assert.assertEquals(z, slopedRotatedCylinder.heightAt(x, y, z + 1.0), 1.0E-14);
    }

    @Test
    public void testHeightAtSlopedRotatedTwoSidesBottom() {
        Vector3D center = new Vector3D(0.0, 0.0, 0.0);
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        AppearanceDefinition app = YoAppearance.Red();
        slopeDegrees = 45.0;
        yawDegrees = 30.0;
        double angleAxisDownRadians = Math.toRadians(slopeDegrees);
        double angleAxisFromXRadians = Math.toRadians(yawDegrees);
        CylinderTerrainObject slopedRotatedCylinder = new CylinderTerrainObject((Vector3DReadOnly)center, slopeDegrees, yawDegrees, height, radius, app);
        double distanceAlongAxis = height / 2.0;
        double dCenterToContact = Math.sqrt(distanceAlongAxis * distanceAlongAxis + radius * radius);
        double angleFromAxisToD = Math.atan(radius / distanceAlongAxis);
        double dHorizontal = dCenterToContact * Math.cos(angleAxisDownRadians + angleFromAxisToD);
        double dVertical = dCenterToContact * Math.sin(angleAxisDownRadians + angleFromAxisToD);
        double x = dHorizontal * Math.cos(angleAxisFromXRadians);
        double y = dHorizontal * Math.sin(angleAxisFromXRadians);
        double z = dVertical;
        double expectedHeight = z - Math.sqrt(2.0 * (2.0 * radius) * (2.0 * radius));
        Assert.assertEquals(expectedHeight, slopedRotatedCylinder.heightAt(x, y, -1.0), 1.0E-14);
    }

    @Test
    public void testHeightAtSlopedRotatedEndAndSideTop() {
        double z;
        Vector3D center = new Vector3D(0.0, 0.0, 0.0);
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        AppearanceDefinition app = YoAppearance.Red();
        slopeDegrees = 45.0;
        yawDegrees = 30.0;
        double angleAxisDownRadians = Math.toRadians(slopeDegrees);
        double angleAxisFromXRadians = Math.toRadians(yawDegrees);
        CylinderTerrainObject slopedRotatedCylinder = new CylinderTerrainObject((Vector3DReadOnly)center, slopeDegrees, yawDegrees, height, radius, app);
        double distanceAlongAxis = height / 2.0;
        double dHorizontal = distanceAlongAxis * Math.cos(angleAxisDownRadians);
        double dVertical = distanceAlongAxis * Math.sin(angleAxisDownRadians);
        double x = dHorizontal * Math.cos(angleAxisFromXRadians);
        double y = dHorizontal * Math.sin(angleAxisFromXRadians);
        double expectedHeight = z = dVertical;
        Assert.assertEquals(expectedHeight, slopedRotatedCylinder.heightAt(x, y, 2.0), 1.0E-14);
    }

    @Test
    public void testHeightAtSlopedRotatedEndAndSideBottom() {
        Vector3D center = new Vector3D(0.0, 0.0, 0.0);
        double slopeDegrees = 0.0;
        double yawDegrees = 0.0;
        double height = 2.0;
        double radius = 1.0;
        AppearanceDefinition app = YoAppearance.Red();
        slopeDegrees = 45.0;
        yawDegrees = 30.0;
        double angleAxisDownRadians = Math.toRadians(slopeDegrees);
        double angleAxisFromXRadians = Math.toRadians(yawDegrees);
        CylinderTerrainObject slopedRotatedCylinder = new CylinderTerrainObject((Vector3DReadOnly)center, slopeDegrees, yawDegrees, height, radius, app);
        double distanceAlongAxis = height / 2.0;
        double dHorizontal = distanceAlongAxis * Math.cos(angleAxisDownRadians);
        double dVertical = distanceAlongAxis * Math.sin(angleAxisDownRadians);
        double x = dHorizontal * Math.cos(angleAxisFromXRadians);
        double y = dHorizontal * Math.sin(angleAxisFromXRadians);
        double z = dVertical;
        double expectedHeight = z - Math.sqrt(radius * radius * 2.0);
        Assert.assertEquals(expectedHeight, slopedRotatedCylinder.heightAt(x, y, -2.0), 1.0E-14);
    }
}

