/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset;

import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.Test;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.gui.SplashPanel;

@Tag(value="gui")
public class SimulationConstructionSetSetupTest {
    private static SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
    private static final int pauseTimeForGUIs = 5000;

    @Test
    public void testSplashScreen() throws Exception {
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                SplashPanel splashPanel = new SplashPanel();
                JWindow window = splashPanel.showSplashScreen();
                SimulationConstructionSetSetupTest.this.sleep(5000L);
                window.dispose();
            }
        });
    }

    @Test
    public void testSimulationConstructionSetWithoutARobot() {
        SimulationConstructionSet scs = new SimulationConstructionSet(parameters);
        Thread thread = new Thread((Runnable)scs);
        thread.start();
        this.sleep(5000L);
        scs.closeAndDispose();
    }

    @Test
    public void testSimulationConstructionSetWithARobot() {
        Robot robot = new Robot("NullRobot");
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        Thread thread = new Thread((Runnable)scs);
        thread.start();
        this.sleep(5000L);
        scs.closeAndDispose();
    }

    private void sleep(long sleepMillis) {
        try {
            Thread.sleep(sleepMillis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

