/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.util.simulationRunner;

import java.util.ArrayList;
import org.junit.jupiter.api.Test;
import us.ihmc.robotics.Assert;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.simulationconstructionset.util.simulationRunner.SimulationRewindabilityVerifier;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimulationRewindabilityVerifierTest {
    private static final boolean SHOW_GUI = false;
    private static final boolean VERBOSE = false;
    private final double DT = 0.01;

    @Test
    public void testRewindableSimulation() throws UnreasonableAccelerationException {
        SimulationConstructionSet scs1 = this.constructRewindableSimulationConstructionSet();
        SimulationConstructionSet scs2 = this.constructRewindableSimulationConstructionSet();
        ArrayList exceptions = new ArrayList();
        SimulationRewindabilityVerifier verifier = new SimulationRewindabilityVerifier(scs1, scs2, exceptions);
        int numTests = 5000;
        double maxDifferenceAllowed = 1.0E-12;
        ArrayList variableDifferences = verifier.checkRewindabilityWithSimpleMethod(numTests, maxDifferenceAllowed);
        Assert.assertTrue(variableDifferences.isEmpty());
        scs1.closeAndDispose();
        scs2.closeAndDispose();
    }

    @Test
    public void testEasilyDetectableNonRewindableSimulation() throws UnreasonableAccelerationException {
        SimulationConstructionSet scs1 = this.constructEasilyDetectableNonRewindableSimulationConstructionSet();
        SimulationConstructionSet scs2 = this.constructEasilyDetectableNonRewindableSimulationConstructionSet();
        ArrayList exceptions = new ArrayList();
        SimulationRewindabilityVerifier verifier = new SimulationRewindabilityVerifier(scs1, scs2, exceptions);
        int numTests = 5000;
        double maxDifferenceAllowed = 1.0E-12;
        ArrayList variableDifferences = verifier.checkRewindabilityWithSimpleMethod(numTests, maxDifferenceAllowed);
        Assert.assertEquals(2L, variableDifferences.size());
        scs1.closeAndDispose();
        scs2.closeAndDispose();
    }

    @Test
    public void testDifficultToDetectNonRewindableSimulation() throws UnreasonableAccelerationException {
        SimulationConstructionSet scs1 = this.constructDifficultToDetectNonRewindableSimulationConstructionSet();
        SimulationConstructionSet scs2 = this.constructDifficultToDetectNonRewindableSimulationConstructionSet();
        ArrayList exceptions = new ArrayList();
        SimulationRewindabilityVerifier verifier = new SimulationRewindabilityVerifier(scs1, scs2, exceptions);
        int numTests = 4000;
        int numTicksAhead = 800;
        double maxDifferenceAllowed = 1.0E-12;
        ArrayList variableDifferences = verifier.checkRewindabilityWithSimpleMethod(numTests, maxDifferenceAllowed);
        Assert.assertTrue(variableDifferences.isEmpty());
        scs1 = this.constructDifficultToDetectNonRewindableSimulationConstructionSet();
        scs2 = this.constructDifficultToDetectNonRewindableSimulationConstructionSet();
        verifier = new SimulationRewindabilityVerifier(scs1, scs2, exceptions);
        int numTicksToStartComparingAt = 1;
        variableDifferences = verifier.checkRewindabilityWithRigorousMethod(numTicksToStartComparingAt, numTests, numTicksAhead, maxDifferenceAllowed);
        Assert.assertEquals(2L, variableDifferences.size());
        scs1.closeAndDispose();
        scs2.closeAndDispose();
    }

    private SimulationConstructionSet constructRewindableSimulationConstructionSet() {
        Robot robot = new Robot("Test");
        RewindableController controller = new RewindableController(robot);
        robot.setController((RobotController)controller);
        return this.constructSimulationConstructionSet(robot, controller);
    }

    private SimulationConstructionSet constructEasilyDetectableNonRewindableSimulationConstructionSet() {
        Robot robot = new Robot("Test");
        EasilyDetectableNonRewindableController controller = new EasilyDetectableNonRewindableController(robot);
        robot.setController((RobotController)controller);
        return this.constructSimulationConstructionSet(robot, controller);
    }

    private SimulationConstructionSet constructDifficultToDetectNonRewindableSimulationConstructionSet() {
        Robot robot = new Robot("Test");
        DifficultToDetectNonRewindableController controller = new DifficultToDetectNonRewindableController(robot);
        robot.setController((RobotController)controller);
        return this.constructSimulationConstructionSet(robot, controller);
    }

    private SimulationConstructionSet constructSimulationConstructionSet(Robot robot, RobotController controller) {
        SimulationConstructionSetParameters parameters = SimulationConstructionSetParameters.createFromSystemProperties();
        parameters.setCreateGUI(false);
        SimulationConstructionSet scs = new SimulationConstructionSet(robot, parameters);
        scs.setDT(0.01, 1);
        Thread thread = new Thread((Runnable)scs);
        thread.start();
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return scs;
    }

    private static class DifficultToDetectNonRewindableController
    extends RewindableController {
        private double nonRegisteredVariable = 5.0;
        private double lastTimeChanged;
        private double timeBetweenChanges = 3.0;
        private YoDouble lastTimeUpdated = new YoDouble("lastTimeUpdated", this.registry);
        private double timeBetweenUpdates = 5.0;

        public DifficultToDetectNonRewindableController(Robot robot) {
            super(robot);
        }

        @Override
        public void doControl() {
            super.doControl();
            if (this.robot.getTime() > this.lastTimeChanged + this.timeBetweenChanges) {
                this.lastTimeChanged = this.robot.getTime();
                this.nonRegisteredVariable += 1.0;
            }
            if (this.robot.getTime() > this.lastTimeUpdated.getDoubleValue() + this.timeBetweenUpdates) {
                this.lastTimeUpdated.set(this.robot.getTime());
                this.variableTwo.set(this.nonRegisteredVariable);
                this.variableThree.set(3.0);
                this.variableFour.set(this.nonRegisteredVariable * 2.0);
            }
        }
    }

    private static class EasilyDetectableNonRewindableController
    extends RewindableController {
        private double nonRegisteredVariable;

        public EasilyDetectableNonRewindableController(Robot robot) {
            super(robot);
        }

        @Override
        public void doControl() {
            super.doControl();
            if (this.robot.getTime() >= 1.0) {
                this.nonRegisteredVariable += 1.0;
                this.variableTwo.set(this.nonRegisteredVariable);
                this.variableFour.set(this.nonRegisteredVariable * 2.0);
            }
        }
    }

    private static class RewindableController
    implements RobotController {
        protected final YoRegistry registry = new YoRegistry("controller");
        protected final YoDouble variableOne = new YoDouble("variableOne", this.registry);
        protected final YoDouble variableTwo = new YoDouble("variableTwo", this.registry);
        protected final YoDouble variableThree = new YoDouble("variableThree", this.registry);
        protected final YoDouble variableFour = new YoDouble("variableFour", this.registry);
        protected final Robot robot;

        public RewindableController(Robot robot) {
            this.robot = robot;
        }

        public void doControl() {
            this.variableOne.set(Math.cos(this.robot.getTime()));
            this.variableTwo.set(this.robot.getTime());
            this.variableThree.set(this.variableOne.getDoubleValue());
            this.variableFour.set(1.2);
        }

        public YoRegistry getYoRegistry() {
            return this.registry;
        }

        public String getName() {
            return "Test";
        }

        public void initialize() {
        }

        public String getDescription() {
            return this.getName();
        }
    }
}

