/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.simulationconstructionset.physics.collision.simple;

import org.junit.jupiter.api.Test;
import us.ihmc.euclid.geometry.BoundingBox3D;
import us.ihmc.euclid.tools.EuclidCoreTestTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.simulationconstructionset.physics.collision.simple.CapsuleShapeDescription;

public class CapsuleShapeDescriptionTest {
    @Test
    public void test() {
        double radius = 0.2;
        double height = 0.6;
        CapsuleShapeDescription capsule = new CapsuleShapeDescription(radius, height);
        BoundingBox3D boundingBox = new BoundingBox3D(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
        capsule.getBoundingBox(boundingBox);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(-0.2, -0.2, -0.3), (Tuple3DReadOnly)boundingBox.getMinPoint(), (double)1.0E-10);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(0.2, 0.2, 0.3), (Tuple3DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-10);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set(7.0, 8.0, 9.0);
        capsule.applyTransform(transform);
        capsule.getBoundingBox(boundingBox);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(6.8, 7.8, 8.7), (Tuple3DReadOnly)boundingBox.getMinPoint(), (double)1.0E-10);
        EuclidCoreTestTools.assertTuple3DEquals((Tuple3DReadOnly)new Point3D(7.2, 8.2, 9.3), (Tuple3DReadOnly)boundingBox.getMaxPoint(), (double)1.0E-10);
    }
}

