/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.robot.sensors;

import java.util.function.Function;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.SpatialImpulseReadOnly;
import us.ihmc.mecano.spatial.interfaces.SpatialVectorReadOnly;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.yoVariables.spatial.YoFixedFrameWrench;
import us.ihmc.scs2.definition.robot.WrenchSensorDefinition;
import us.ihmc.scs2.simulation.robot.RobotPhysicsOutput;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.sensors.SimSensor;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFrameVector3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class SimWrenchSensor
extends SimSensor {
    private final YoFixedFrameWrench wrench;
    private final YoDouble filterBreakFrequency;
    private final YoBoolean filterInitialized;
    private final YoFixedFrameWrench wrenchFiltered;
    private final Wrench intermediateWrench = new Wrench();

    public SimWrenchSensor(WrenchSensorDefinition definition, SimJointBasics parentJoint) {
        this(definition.getName(), parentJoint, (RigidBodyTransformReadOnly)definition.getTransformToJoint());
        this.setSamplingRate(SimWrenchSensor.toSamplingRate(definition.getUpdatePeriod()));
    }

    public SimWrenchSensor(String name, SimJointBasics parentJoint, RigidBodyTransformReadOnly transformToParent) {
        super(name, parentJoint, transformToParent);
        YoRegistry registry = parentJoint.getRegistry();
        this.wrench = new YoFixedFrameWrench((ReferenceFrame)parentJoint.getSuccessor().getBodyFixedFrame(), new YoFrameVector3D(name + "Moment", (ReferenceFrame)this.getFrame(), registry), new YoFrameVector3D(name + "Force", (ReferenceFrame)this.getFrame(), registry));
        this.filterBreakFrequency = new YoDouble(parentJoint.getName() + name + "FilterBreakFrequency", registry);
        this.filterBreakFrequency.set(Double.POSITIVE_INFINITY);
        this.getSamplingRate().addListener(v -> this.filterBreakFrequency.set(this.getSamplingRate().getValue() * 0.25));
        this.filterInitialized = new YoBoolean(parentJoint.getName() + name + "FilterInitialized", registry);
        this.wrenchFiltered = new YoFixedFrameWrench((ReferenceFrame)parentJoint.getSuccessor().getBodyFixedFrame(), new YoFrameVector3D(name + "MomentFiltered", (ReferenceFrame)this.getFrame(), registry), new YoFrameVector3D(name + "ForceFiltered", (ReferenceFrame)this.getFrame(), registry));
    }

    @Override
    public void update(RobotPhysicsOutput robotPhysicsOutput) {
        SpatialImpulseReadOnly externalImpulse;
        super.update(robotPhysicsOutput);
        SimRigidBodyBasics body = this.getParentJoint().getSuccessor();
        Function<RigidBodyReadOnly, WrenchReadOnly> externalWrenchProvider = robotPhysicsOutput.getExternalWrenchProvider();
        Function<RigidBodyReadOnly, SpatialImpulseReadOnly> externalImpulseProvider = robotPhysicsOutput.getExternalImpulseProvider();
        double dt = robotPhysicsOutput.getDT();
        WrenchReadOnly externalWrench = externalWrenchProvider == null ? null : externalWrenchProvider.apply(body);
        SpatialImpulseReadOnly spatialImpulseReadOnly = externalImpulse = externalImpulseProvider == null ? null : externalImpulseProvider.apply(body);
        if (dt != 0.0 && externalImpulse != null) {
            this.wrench.setMatchingFrame((SpatialVectorReadOnly)externalImpulse);
            this.wrench.scale(1.0 / dt);
            if (externalWrench != null) {
                this.intermediateWrench.setIncludingFrame(externalWrench);
                this.intermediateWrench.changeFrame((ReferenceFrame)this.getFrame());
                this.wrench.add((WrenchReadOnly)this.intermediateWrench);
            }
        } else if (externalWrench != null) {
            this.wrench.setMatchingFrame(externalWrench);
        } else {
            this.wrench.setToZero();
        }
        if (dt <= 0.0) {
            this.filterInitialized.set(false);
        }
        if (!this.filterInitialized.getValue()) {
            this.wrenchFiltered.set(this.wrench);
        } else {
            if (Double.isInfinite(this.filterBreakFrequency.getValue())) {
                this.filterBreakFrequency.set(0.25 / dt);
            }
            double alpha = 1.0 - SimWrenchSensor.computeLowPassFilterAlpha(this.filterBreakFrequency.getValue(), dt);
            this.wrenchFiltered.interpolate((SpatialVectorReadOnly)this.wrench, alpha);
        }
    }

    public void setFilterBreakFrequency(double breakFrequency) {
        this.filterBreakFrequency.set(breakFrequency);
    }

    public YoDouble getFilterBreakFrequency() {
        return this.filterBreakFrequency;
    }

    public YoBoolean getFilterInitialized() {
        return this.filterInitialized;
    }

    public YoFixedFrameWrench getWrench() {
        return this.wrench;
    }

    public YoFixedFrameWrench getWrenchFiltered() {
        return this.wrenchFiltered;
    }
}

