/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.scs2.simulation.physicsEngine.impulseBased;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.RigidBodyReadOnly;
import us.ihmc.mecano.spatial.Wrench;
import us.ihmc.mecano.spatial.interfaces.FixedFrameWrenchBasics;
import us.ihmc.mecano.spatial.interfaces.WrenchReadOnly;
import us.ihmc.mecano.tools.JointStateType;
import us.ihmc.scs2.definition.robot.RobotDefinition;
import us.ihmc.scs2.definition.robot.RobotStateDefinition;
import us.ihmc.scs2.definition.terrain.TerrainObjectDefinition;
import us.ihmc.scs2.session.YoTimer;
import us.ihmc.scs2.simulation.collision.Collidable;
import us.ihmc.scs2.simulation.collision.CollisionTools;
import us.ihmc.scs2.simulation.parameters.ConstraintParametersReadOnly;
import us.ihmc.scs2.simulation.parameters.ContactParametersReadOnly;
import us.ihmc.scs2.simulation.parameters.YoConstraintParameters;
import us.ihmc.scs2.simulation.parameters.YoContactParameters;
import us.ihmc.scs2.simulation.physicsEngine.MultiRobotCollisionGroup;
import us.ihmc.scs2.simulation.physicsEngine.PhysicsEngine;
import us.ihmc.scs2.simulation.physicsEngine.SimpleCollisionDetection;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.ImpulseBasedRobot;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.MultiContactImpulseCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.MultiContactImpulseCalculatorStepListener;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.RobotJointLimitImpulseBasedCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.YoMultiContactImpulseCalculator;
import us.ihmc.scs2.simulation.physicsEngine.impulseBased.YoMultiContactImpulseCalculatorPool;
import us.ihmc.scs2.simulation.robot.Robot;
import us.ihmc.scs2.simulation.robot.RobotExtension;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimJointBasics;
import us.ihmc.scs2.simulation.robot.multiBodySystem.interfaces.SimRigidBodyBasics;
import us.ihmc.scs2.simulation.robot.trackers.ExternalWrenchPoint;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoBoolean;
import us.ihmc.yoVariables.variable.YoDouble;

public class ImpulseBasedPhysicsEngine
implements PhysicsEngine {
    private final ReferenceFrame inertialFrame;
    private final YoRegistry rootRegistry;
    private final YoRegistry physicsEngineRegistry = new YoRegistry(this.getClass().getSimpleName());
    private final List<ImpulseBasedRobot> robotList = new ArrayList<ImpulseBasedRobot>();
    private final Map<RigidBodyBasics, ImpulseBasedRobot> robotMap = new HashMap<RigidBodyBasics, ImpulseBasedRobot>();
    private final YoMultiContactImpulseCalculatorPool multiContactImpulseCalculatorPool;
    private List<MultiRobotCollisionGroup> collisionGroups;
    private final List<TerrainObjectDefinition> terrainObjectDefinitions = new ArrayList<TerrainObjectDefinition>();
    private final List<Collidable> environmentCollidables = new ArrayList<Collidable>();
    private final SimpleCollisionDetection collisionDetectionPlugin;
    private final YoBoolean hasGlobalContactParameters;
    private final YoContactParameters globalContactParameters;
    private final YoBoolean hasGlobalConstraintParameters;
    private final YoConstraintParameters globalConstraintParameters;
    private final YoTimer physicsEngineTotalTimer = new YoTimer("physicsEngineTotalTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoDouble physicsEngineRealTimeRate = new YoDouble("physicsEngineRealTimeRate", this.physicsEngineRegistry);
    private boolean initialize = true;
    private MultiContactImpulseCalculatorStepListener multiContactCalculatorStepListener;
    private final YoTimer initialPhaseTimer = new YoTimer("initialPhaseTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer detectCollisionsTimer = new YoTimer("detectCollisionsTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer configureCollisionHandlersTimer = new YoTimer("configureCollisionHandlersTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer handleCollisionsTimer = new YoTimer("handleCollisionsTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final YoTimer finalPhaseTimer = new YoTimer("finalPhaseTimer", TimeUnit.MILLISECONDS, this.physicsEngineRegistry);
    private final Wrench tempWrench = new Wrench();

    public ImpulseBasedPhysicsEngine(ReferenceFrame inertialFrame, YoRegistry rootRegistry) {
        this.rootRegistry = rootRegistry;
        this.inertialFrame = inertialFrame;
        this.collisionDetectionPlugin = new SimpleCollisionDetection(inertialFrame);
        YoRegistry multiContactCalculatorRegistry = new YoRegistry(MultiContactImpulseCalculator.class.getSimpleName());
        this.physicsEngineRegistry.addChild(multiContactCalculatorRegistry);
        this.hasGlobalContactParameters = new YoBoolean("hasGlobalContactParameters", this.physicsEngineRegistry);
        this.globalContactParameters = new YoContactParameters("globalContact", this.physicsEngineRegistry);
        this.hasGlobalConstraintParameters = new YoBoolean("hasGlobalConstraintParameters", this.physicsEngineRegistry);
        this.globalConstraintParameters = new YoConstraintParameters("globalConstraint", this.physicsEngineRegistry);
        this.multiContactImpulseCalculatorPool = new YoMultiContactImpulseCalculatorPool(1, inertialFrame, multiContactCalculatorRegistry);
    }

    public void setMultiContactCalculatorStepListener(MultiContactImpulseCalculatorStepListener multiContactCalculatorStepListener) {
        this.multiContactCalculatorStepListener = multiContactCalculatorStepListener;
    }

    @Override
    public void addTerrainObject(TerrainObjectDefinition terrainObjectDefinition) {
        this.terrainObjectDefinitions.add(terrainObjectDefinition);
        this.environmentCollidables.addAll(CollisionTools.toCollisionShape(terrainObjectDefinition, this.inertialFrame));
    }

    @Override
    public void addRobot(Robot robot) {
        this.inertialFrame.checkReferenceFrameMatch(robot.getInertialFrame());
        ImpulseBasedRobot ibRobot = new ImpulseBasedRobot(robot, this.physicsEngineRegistry);
        this.robotMap.put(ibRobot.getRootBody(), ibRobot);
        this.rootRegistry.addChild(ibRobot.getRegistry());
        this.robotList.add(ibRobot);
    }

    public void setGlobalConstraintParameters(ConstraintParametersReadOnly parameters) {
        this.globalConstraintParameters.set(parameters);
        this.hasGlobalConstraintParameters.set(true);
    }

    public void setGlobalContactParameters(ContactParametersReadOnly parameters) {
        this.globalContactParameters.set(parameters);
        this.hasGlobalContactParameters.set(true);
    }

    @Override
    public boolean initialize(Vector3DReadOnly gravity) {
        if (!this.initialize) {
            return false;
        }
        for (ImpulseBasedRobot robot : this.robotList) {
            robot.initializeState();
            robot.resetCalculators();
            robot.doForwardDynamics(gravity);
            robot.updateSensors();
            robot.getControllerManager().initializeControllers();
        }
        this.initialize = false;
        return true;
    }

    @Override
    public void simulate(double currentTime, double dt, Vector3DReadOnly gravity) {
        if (this.initialize(gravity)) {
            return;
        }
        this.physicsEngineTotalTimer.start();
        this.initialPhaseTimer.start();
        for (ImpulseBasedRobot robot : this.robotList) {
            robot.resetCalculators();
            robot.getControllerManager().updateControllers(currentTime);
            robot.getControllerManager().writeControllerOutput(JointStateType.EFFORT);
            robot.getControllerManager().writeControllerOutputForJointsToIgnore(JointStateType.values());
            robot.saveRobotBeforePhysicsState();
        }
        for (ImpulseBasedRobot robot : this.robotList) {
            robot.updateCollidableBoundingBoxes();
            for (SimJointBasics simJointBasics : robot.getJointsToConsider()) {
                List<ExternalWrenchPoint> externalWrenchPoints = simJointBasics.getAuxiliaryData().getExternalWrenchPoints();
                if (externalWrenchPoints.isEmpty()) continue;
                SimRigidBodyBasics body = simJointBasics.getSuccessor();
                FixedFrameWrenchBasics externalWrench = robot.getForwardDynamicsCalculator().getExternalWrench((RigidBodyReadOnly)body);
                for (ExternalWrenchPoint efp : externalWrenchPoints) {
                    this.tempWrench.setIncludingFrame((WrenchReadOnly)efp.getWrench());
                    this.tempWrench.changeFrame(externalWrench.getReferenceFrame());
                    externalWrench.add((WrenchReadOnly)this.tempWrench);
                }
            }
            robot.doForwardDynamics(gravity);
        }
        this.environmentCollidables.forEach(collidable -> collidable.updateBoundingBox(this.inertialFrame));
        this.initialPhaseTimer.stop();
        this.detectCollisionsTimer.start();
        if (this.hasGlobalContactParameters.getValue()) {
            this.collisionDetectionPlugin.setMinimumPenetration(this.globalContactParameters.getMinimumPenetration());
        }
        this.collisionDetectionPlugin.evaluationCollisions(this.robotList, () -> this.environmentCollidables, dt);
        this.collisionGroups = MultiRobotCollisionGroup.toCollisionGroups(this.collisionDetectionPlugin.getAllCollisions());
        this.detectCollisionsTimer.stop();
        this.configureCollisionHandlersTimer.start();
        HashSet<RigidBodyBasics> uncoveredRobotsRootBody = new HashSet<RigidBodyBasics>(this.robotMap.keySet());
        ArrayList<YoMultiContactImpulseCalculator> impulseCalculators = new ArrayList<YoMultiContactImpulseCalculator>();
        this.multiContactImpulseCalculatorPool.clear();
        for (MultiRobotCollisionGroup multiRobotCollisionGroup : this.collisionGroups) {
            YoMultiContactImpulseCalculator calculator = this.multiContactImpulseCalculatorPool.nextAvailable();
            ((MultiContactImpulseCalculator)calculator).configure(this.robotMap, multiRobotCollisionGroup);
            if (this.hasGlobalConstraintParameters.getValue()) {
                calculator.setConstraintParameters(this.globalConstraintParameters);
            }
            if (this.hasGlobalContactParameters.getValue()) {
                calculator.setContactParameters(this.globalContactParameters);
            }
            if (this.multiContactCalculatorStepListener != null) {
                calculator.setListener(this.multiContactCalculatorStepListener);
            }
            impulseCalculators.add(calculator);
            uncoveredRobotsRootBody.removeAll(multiRobotCollisionGroup.getRootBodies());
        }
        this.configureCollisionHandlersTimer.stop();
        this.handleCollisionsTimer.start();
        for (RigidBodyBasics rigidBodyBasics : uncoveredRobotsRootBody) {
            ImpulseBasedRobot robot = this.robotMap.get(rigidBodyBasics);
            RobotJointLimitImpulseBasedCalculator jointLimitConstraintCalculator = robot.getJointLimitConstraintCalculator();
            jointLimitConstraintCalculator.initialize(dt);
            jointLimitConstraintCalculator.updateInertia(null, null);
            jointLimitConstraintCalculator.computeImpulse(dt);
            robot.addJointVelocityChange(jointLimitConstraintCalculator.getJointVelocityChange(0));
        }
        for (MultiContactImpulseCalculator multiContactImpulseCalculator : impulseCalculators) {
            multiContactImpulseCalculator.computeImpulses(currentTime, dt, false);
            multiContactImpulseCalculator.writeJointDeltaVelocities();
            multiContactImpulseCalculator.writeImpulses();
            multiContactImpulseCalculator.setListener(null);
        }
        this.handleCollisionsTimer.stop();
        this.finalPhaseTimer.start();
        for (ImpulseBasedRobot impulseBasedRobot : this.robotList) {
            impulseBasedRobot.writeJointAccelerations();
            impulseBasedRobot.writeJointDeltaVelocities();
            impulseBasedRobot.integrateState(dt);
            impulseBasedRobot.updateFrames();
            impulseBasedRobot.updateSensors();
        }
        this.finalPhaseTimer.stop();
        this.physicsEngineTotalTimer.stop();
        this.physicsEngineRealTimeRate.set(dt * 1000.0 / this.physicsEngineTotalTimer.getTimer().getValue());
    }

    @Override
    public void pause() {
        for (ImpulseBasedRobot robot : this.robotList) {
            robot.getControllerManager().pauseControllers();
        }
    }

    @Override
    public ReferenceFrame getInertialFrame() {
        return this.inertialFrame;
    }

    public List<Robot> getRobots() {
        return this.robotList.stream().map(RobotExtension::getRobot).collect(Collectors.toList());
    }

    @Override
    public List<RobotDefinition> getRobotDefinitions() {
        return this.robotList.stream().map(RobotExtension::getRobotDefinition).collect(Collectors.toList());
    }

    @Override
    public List<TerrainObjectDefinition> getTerrainObjectDefinitions() {
        return this.terrainObjectDefinitions;
    }

    @Override
    public List<RobotStateDefinition> getBeforePhysicsRobotStateDefinitions() {
        return this.robotList.stream().map(RobotExtension::getRobotBeforePhysicsStateDefinition).collect(Collectors.toList());
    }

    @Override
    public YoRegistry getPhysicsEngineRegistry() {
        return this.physicsEngineRegistry;
    }
}

